$(document).ready(function () {

    var pluginRate = {
        $plugin_rate: $('#plugin-rate'),
        init:         function () {
            this.$plugin_rate.find('a').on('click', function (e) {
                this.$plugin_rate.fadeOut();
                if ($(e.target).data('type') == 'disable') {
                    e.preventDefault();
                    this.disableRate();
                }
            }.bind(this));
            this.showMessage();
        },
        getRateInfo:  function () {
            var time = new Date().getTime();
            return JSON.parse(localStorage['plugin_rate_info'] || this.saveRateInfo({install: time, show: true, lastshow: -Infinity}));
        },
        saveRateInfo: function (obj) {
            return localStorage['plugin_rate_info'] = JSON.stringify(obj);
        },
        disableRate:  function () {
            var obj = this.getRateInfo();
            obj.show = false;
            this.saveRateInfo(obj);
        },
        showMessage:  function () {
            var obj = this.getRateInfo();
            var day = 24 * 60 * 60 * 1000;
            var now = Date.now();
            if (obj.show) {
                if (now > (+obj.install + 3 * day)) {
                    if (now > (+obj.lastshow + +day)) {
                        this.$plugin_rate.fadeIn();
                        this.saveRateInfo({install: obj.install, show: true, lastshow: now});
                    }
                }
            }
        }
    };
    pluginRate.init();

});