var tabs = require("sdk/tabs");
var buttons = require('sdk/ui/button/action');
var bookmarks = require("sdk/places/bookmarks");
var ss = require("sdk/simple-storage");
var {setTimeout, clearTimeout} = require("sdk/timers");

const {data} = require("sdk/self");
const {Cc,Ci} = require("chrome");
const {XMLHttpRequest} = require("sdk/net/xhr");
let {search} = require("sdk/places/bookmarks");

var worker;
var hssvc = Cc["@mozilla.org/browser/nav-history-service;1"].getService(Ci.nsINavHistoryService);
var bmsvc = Cc["@mozilla.org/browser/nav-bookmarks-service;1"].getService(Ci.nsINavBookmarksService);
var iosvc = Cc["@mozilla.org/network/io-service;1"].getService(Ci.nsIIOService);

var indexOfObject = function (array, property, value) {
    for (var i = 0, len = array.length; i < len; i++) {
        if (array[i][property] === value) return i;
    }
    return -1;
};
var isEqual = function (obj1, obj2) {
    if (obj1.id == obj2.id) return true;
    return false;
};
var contains = function (array, obj) {
    for (var i = 0; i < array.length; i++) {
        if (isEqual(array[i], obj)) return true;
    }
    return false;
};

var bookmark_checker = {
    whiteList: {
        save:   function (item) {
            var bookmarks_storage = ss.storage.white_list ? ss.storage.white_list : [];

            if (indexOfObject(bookmarks_storage, 'url', item.url) == -1) bookmarks_storage.push({url: item.url});
            ss.storage.white_list = bookmarks_storage;

//            console.log('bookmarks_storage save', bookmarks_storage);
        },
        remove: function (item) {
            var bookmarks_storage = ss.storage.white_list ? ss.storage.white_list : [];

            if (indexOfObject(bookmarks_storage, 'url', item.url) != -1) bookmarks_storage.splice(indexOfObject(bookmarks_storage, 'url', item.url), 1);
            ss.storage.white_list = bookmarks_storage;
        },
        get:    function () {
            return ss.storage.white_list ? ss.storage.white_list : [];
        }
    },

    check_start: false,

    stopCheckBookmark: function () {
        bookmark_checker.check_start = false;
        worker.port.emit('background_request', {action: 'bookmark_check_finish' });
    },

    checkBookmark: function (mode, timeout, max_check_feed) {
        if (!bookmark_checker.check_start) {
            bookmark_checker.check_start = true;
        } else {
            return;
        }

        console.log('checkBookmark', mode, timeout);

        var self_global = this;
        var bookmarks_count_error = 0;
        var bookmarks_white_list = ss.storage.white_list ? ss.storage.white_list : [];

        var checkUrl = function (index, callback) {
            var checked_bookmark = self_global.bookmarks_list[index];
            var req = new XMLHttpRequest();

            console.log('checked bookmark', checked_bookmark);

            req.timeout = timeout;
            req.ontimeout = function () {
                checked_bookmark.status = 408;
                checked_bookmark.message = 'Request Timeout';
//                console.log('ontimeout', index, checked_bookmark);
                return callback(checked_bookmark, index);
            };
            req.onload = function () {
                if (req.readyState != 4) return;
                checked_bookmark.status = req.status ? req.status : 434;
                checked_bookmark.message = req.statusText ? req.statusText : 'Requested host unavailable';
//                console.log('onload', index, checked_bookmark);
                return callback(checked_bookmark, index);
            };
            req.onerror = function () {
                checked_bookmark.status = req.status ? req.status : 400;
                checked_bookmark.message = req.statusText ? req.statusText : 'Bad Request';
//                console.log('onerror', index, checked_bookmark);
                return callback(checked_bookmark, index);
            };

            var protocol = checked_bookmark.url.match(/(.+?)[:\/\/]+/);
            if (protocol && !/http/.test(protocol[1])) {
                checked_bookmark.status = req.status ? req.status : 400;
                checked_bookmark.message = req.statusText ? req.statusText : 'Bad Request';
                console.log('no valid url', index, checked_bookmark);
                return callback(checked_bookmark, index);
            }

//            if (/^(chrome|opera|file|ftp)/.test(checked_bookmark.url)) {
//                checked_bookmark.status = req.status ? req.status : 400;
//                checked_bookmark.message = req.statusText ? req.statusText : 'Bad Request';
//                console.log('no valid url', index, checked_bookmark);
//                return callback(checked_bookmark, index);
//            }
            req.open("GET", checked_bookmark.url, true);
            req.send(null);
        };

        var checkListError = function () {
            var check_feed = 0;
            var check_index = -1;
            var bookmarks_list_length = self_global.bookmarks_list.length;

            var checkListErrorIndex = function () {
                if (!bookmark_checker.check_start) return;

                ++check_index;
                ++check_feed;

                worker.port.emit('background_request', {action: 'bookmark_check_progress', progress: check_index / (bookmarks_list_length - 1) * 100, title: self_global.bookmarks_list[check_index].title, url: self_global.bookmarks_list[check_index].url});
                worker.port.emit('background_request', {action: 'bookmark_check_status', index: check_index, bookmark_count: bookmarks_list_length, error_count: bookmarks_count_error});

                checkUrl(check_index, function (bookmark, current_index) {
                    if (!bookmark_checker.check_start) return;

//                    console.log('check error', bookmark, 'check_index', check_index, 'bookmarks_list_length', bookmarks_list_length, 'check_feed', check_feed);

                    if (bookmark.status != 200 && indexOfObject(bookmarks_white_list, 'url', bookmark.url) == -1) {
                        bookmarks_count_error++;
                        worker.port.emit('background_request', {action: 'bookmark_check', bookmark: bookmark });
                    }

                    worker.port.emit('background_request', {action: 'bookmark_check_status', index: check_index, bookmark_count: bookmarks_list_length, error_count: bookmarks_count_error});

                    --check_feed;

                    if (check_index < bookmarks_list_length - 1 && check_feed < max_check_feed) {
                        checkListErrorIndex();
                    }
                    if (check_index == bookmarks_list_length - 1 && check_feed == 1) {
                        worker.port.emit('background_request', {action: 'bookmark_check_finish' });
                        bookmark_checker.check_start = false;
                    }
                });

                if (check_feed < max_check_feed) {
                    checkListErrorIndex();
                }
            };
            checkListErrorIndex();
        };

        var checkListDuplicates = function () {
            var bookmarks_duplicates = [];

            var checkListDuplicatesIndex = function (i) {
//                console.log('check duplicate', self_global.bookmarks_list[i]);

                if (!bookmark_checker.check_start) return;

                worker.port.emit('background_request', {action: 'bookmark_check_progress', progress: i / (self_global.bookmarks_list.length - 1) * 100, title: self_global.bookmarks_list[i].title, url: self_global.bookmarks_list[i].url});

                if (indexOfObject(bookmarks_white_list, 'url', self_global.bookmarks_list[i].url) == -1) {
                    var b_url = self_global.bookmarks_list[i].url;
                    if (bookmarks_duplicates[b_url]) {
                        if (bookmarks_duplicates[b_url].length == 1) {
                            bookmarks_count_error++;
                            worker.port.emit('background_request', {action: 'bookmark_check', bookmark: bookmarks_duplicates[b_url][0] });
                        }

                        bookmarks_count_error++;
                        worker.port.emit('background_request', {action: 'bookmark_check', bookmark: self_global.bookmarks_list[i] });
                        bookmarks_duplicates[b_url].push(self_global.bookmarks_list[i]);
                    } else {
                        bookmarks_duplicates[b_url] = [self_global.bookmarks_list[i]];
                    }
                }

                worker.port.emit('background_request', {action: 'bookmark_check_status', index: i, bookmark_count: self_global.bookmarks_list.length, error_count: bookmarks_count_error});

                if (i == self_global.bookmarks_list.length - 1) {
                    worker.port.emit('background_request', {action: 'bookmark_check_finish' });
                    bookmark_checker.check_start = false;
                } else {
                    setTimeout(function () {
                        checkListDuplicatesIndex(++i);
                    }, 4);
                }
            };
            checkListDuplicatesIndex(0);
        };

        var checkListDuplicatesFolder = function () {
            var folders_duplicates = [];

            var checkListDuplicatesFolderIndex = function (i) {
//                console.log('check duplicate folders', self_global.bookmarks_folder_list[i]);

                if (!bookmark_checker.check_start) return;

                worker.port.emit('background_request', {action: 'bookmark_check_progress', progress: i / (self_global.bookmarks_folder_list.length - 1) * 100, title: self_global.bookmarks_folder_list[i].title, url: self_global.bookmarks_folder_list[i].url});

                var f_title = self_global.bookmarks_folder_list[i].title;
                if (folders_duplicates[f_title]) {
                    if (folders_duplicates[f_title].length == 1) {
                        bookmarks_count_error++;
                        worker.port.emit('background_request', {action: 'bookmark_check', bookmark: folders_duplicates[f_title][0] });
                    }

                    bookmarks_count_error++;
                    worker.port.emit('background_request', {action: 'bookmark_check', bookmark: self_global.bookmarks_folder_list[i] });
                    folders_duplicates[f_title].push(self_global.bookmarks_folder_list[i]);
                } else {
                    folders_duplicates[f_title] = [self_global.bookmarks_folder_list[i]];
                }

                worker.port.emit('background_request', {action: 'bookmark_check_status', index: i, bookmark_count: self_global.bookmarks_folder_list.length, error_count: bookmarks_count_error});

                if (i == self_global.bookmarks_folder_list.length - 1) {
                    worker.port.emit('background_request', {action: 'bookmark_check_finish' });
                    bookmark_checker.check_start = false;
                } else {
                    setTimeout(function () {
                        checkListDuplicatesFolderIndex(++i);
                    }, 4);
                }
            };
            checkListDuplicatesFolderIndex(0);
        };

        var checkListEmptyFolders = function () {
            var checkListEmptyFoldersIndex = function (i) {
//                console.log('check empty folders', self_global.bookmarks_folder_list[i]);

                if (!bookmark_checker.check_start) return;

                worker.port.emit('background_request', {action: 'bookmark_check_progress', progress: i / (self_global.bookmarks_folder_list.length - 1) * 100, title: self_global.bookmarks_folder_list[i].title, url: self_global.bookmarks_folder_list[i].url});

                if (!self_global.bookmarks_folder_list[i].children.length && self_global.bookmarks_folder_list[i].id > 20) {
                    bookmarks_count_error++;
                    worker.port.emit('background_request', {action: 'bookmark_check', bookmark: self_global.bookmarks_folder_list[i] });
                }

                worker.port.emit('background_request', {action: 'bookmark_check_status', index: i, bookmark_count: self_global.bookmarks_folder_list.length, error_count: bookmarks_count_error});

                if (i == self_global.bookmarks_folder_list.length - 1) {
                    worker.port.emit('background_request', {action: 'bookmark_check_finish' });
                    bookmark_checker.check_start = false;
                } else {
                    setTimeout(function () {
                        checkListEmptyFoldersIndex(++i);
                    }, 4);
                }
            };
            checkListEmptyFoldersIndex(0);
        };

        var checkListEmptyTitle = function () {
            var checkListEmptyTitleIndex = function (i) {
//                console.log('check empty title', self_global.bookmarks_list[i]);

                if (!bookmark_checker.check_start) return;

                worker.port.emit('background_request', {action: 'bookmark_check_progress', progress: i / (self_global.bookmarks_list.length - 1) * 100, title: self_global.bookmarks_list[i].title, url: self_global.bookmarks_list[i].url});

                if (self_global.bookmarks_list[i].title == '' && indexOfObject(bookmarks_white_list, 'url', self_global.bookmarks_list[i].url) == -1) {
                    bookmarks_count_error++;
                    worker.port.emit('background_request', {action: 'bookmark_check', bookmark: self_global.bookmarks_list[i] });
                }

                worker.port.emit('background_request', {action: 'bookmark_check_status', index: i, bookmark_count: self_global.bookmarks_list.length, error_count: bookmarks_count_error});

                if (i == self_global.bookmarks_list.length - 1) {
                    worker.port.emit('background_request', {action: 'bookmark_check_finish' });
                    bookmark_checker.check_start = false;
                } else {
                    setTimeout(function () {
                        checkListEmptyTitleIndex(++i);
                    }, 4);
                }
            };
            checkListEmptyTitleIndex(0);
        };

        if (mode == 'error_connect') {
            checkListError();
        } else if (mode == 'duplicates') {
            checkListDuplicates();
        } else if (mode == 'duplicates_folders') {
            checkListDuplicatesFolder();
        } else if (mode == 'empty_folders') {
            checkListEmptyFolders();
        } else if (mode == 'empty_title') {
            checkListEmptyTitle();
        }

    },

    checkInit: function () {
//        console.time('check init');

        this.bookmarks_list = [];
        this.bookmarks_folder_list = [];
        var self_global = this;
//        var bookmarks_count_error = 0;
//        var bookmarks_white_list = ss.storage.white_list ? ss.storage.white_list : [];

        var options = hssvc.getNewQueryOptions();
        var query = hssvc.getNewQuery();
        query.setFolders([bmsvc.placesRoot], 1);
        var result = hssvc.executeQuery(query, options);
        var rootNode = result.root;

        var browse_bookmark_node = function (bookmark_node, id_node) {
            for (var i = 0, len = bookmark_node.childCount; i < len; i++) {
                var node = bookmark_node.getChild(i);
                if (node.type == 0) {
                    self_global.bookmarks_list.push({id: node.itemId, title: node.title, url: node.uri, parentId: id_node});
                } else if (node.type == 6 && node instanceof Ci.nsINavHistoryContainerResultNode) {
                    var before_container_open = node.containerOpen;
                    node.containerOpen = true;
                    self_global.bookmarks_folder_list.push({id: node.itemId, title: node.title, children: [], parentId: id_node});
                    browse_bookmark_node(node, node.itemId);
                    node.containerOpen = before_container_open;
                }
            }
        };

        rootNode.containerOpen = true;
        browse_bookmark_node(rootNode, 0);
        rootNode.containerOpen = false;

        var main_id;
        for (var a = 0; a < self_global.bookmarks_folder_list.length; a++) {
            if (self_global.bookmarks_folder_list[a].title == '') {
                main_id = self_global.bookmarks_folder_list[a].id;
                self_global.bookmarks_folder_list.splice(a, 1);
            }
        }

        for (var i = 0; i < self_global.bookmarks_folder_list.length; i++) {
            if (main_id && self_global.bookmarks_folder_list[i].parentId == main_id) {
                self_global.bookmarks_folder_list[i].id = 0;
                self_global.bookmarks_folder_list[i].parentId = null;
            }
        }

        var set_child_to_node = function (folders) {
            for (var a = 0, alen = folders.length; a < alen; a++) {
                if (folders[a].url) continue;

                for (var c = 0, clen = self_global.bookmarks_folder_list.length; c < clen; c++) {
                    var folder = self_global.bookmarks_folder_list[c];

                    if (folders[a].id == folder.parentId && indexOfObject(folders[a].children, 'id', folder.id) == -1) {
                        if (folder.folders_patch) {
                            folder.folders_patch.push({id: folders[a].id, title: folders[a].title, parentId: folders[a].parentId});
                        } else {
                            folder.folders_patch = (folders[a].folders_patch || []).concat({id: folders[a].id, title: folders[a].title, parentId: folders[a].parentId});
                        }
                        folders[a].children.push(folder);
                    }
                }

                for (var b = 0, blen = self_global.bookmarks_list.length; b < blen; b++) {
                    var bookmark = self_global.bookmarks_list[b];
                    if (folders[a].id == bookmark.parentId && indexOfObject(folders[a].children, 'id', bookmark.id) == -1) {
                        if (bookmark.folders_patch) {
                            bookmark.folders_patch.push({id: folders[a].id, title: folders[a].title, parentId: folders[a].parentId});
                        } else {
                            bookmark.folders_patch = (folders[a].folders_patch || []).concat({id: folders[a].id, title: folders[a].title, parentId: folders[a].parentId});
                        }
                        folders[a].children.push(bookmark);
                    }
                }

                if (folders[a].children.length) {
                    set_child_to_node(folders[a].children);
                }

            }
        };

        set_child_to_node(self_global.bookmarks_folder_list);

//        console.log(self_global.bookmarks_folder_list);

//        console.time('bookmarks_count');
//        bookmarks.search().on("end", function (results) {
//            console.timeEnd('bookmarks_count');
        worker.port.emit('background_request', {action: 'bookmarks_count', bookmark_count: this.bookmarks_list.length });
//        });

//        console.timeEnd('check init');
    },

    getFolderTree: function (/*parentId, */item/*, folders*/) {
        var folders = [];
        var setListFolder = function (parentId) {
            if (!contains(folders, folder)) {
                folders.push(folder);
            }
            if (data.folder.parentId == 0) {
                data.folders.reverse();
                data.item, data.folders;
            } else {
                setListFolder(data.folder.parentId, data.item, data.folders);
            }
        };
        setListFolder(this.bookmarks_folder_list);

        var setListFolder = function (row) {
            for (var i = 0; i < row.length; i++) {

                if (!row[i].children.length) {

                } else {
                    setListFolder(row[i].children)
                }
            }
        };
        setListFolder(this.bookmarks_folder_list);

        for (var i = 0, len = this.bookmarks_folder_list.length; i < len; i++) {
            if (this.bookmarks_folder_list[i].id == parentId) {
//                console.log('bookmark_push_tree', {folder: this.bookmarks_folder_list[i], item: item, folders: folders});
                worker.port.emit('bookmark_push_tree', {folder: this.bookmarks_folder_list[i], item: item, folders: folders});
                break;
            }
        }
    },
    getFolder:     function (parentId) {

//        var parentFolderId = bmsvc.getFolderIdForItem(newBkmkId);
        for (var i = 0, len = this.bookmarks_folder_list.length; i < len; i++) {
            if (this.bookmarks_folder_list[i].id == parentId) {
//                console.log('bookmark_push', this.bookmarks_folder_list[i]);
                worker.port.emit('bookmark_push', this.bookmarks_folder_list[i]);
                break;
            }
        }
    }

};

var button = buttons.ActionButton({
    id:      "sessionBoxButton",
    label:   "Bookmark Checker",
    icon:    {
        "16": data.url('icons/16x16.png'),
        "32": data.url('icons/32x32.png'),
        "64": data.url('icons/64x64.png')
    },
    onClick: function () {
        tabs.open({
            url:     data.url("checker.html"),
            onReady: function (tab) {
                worker = tab.attach({
                    contentScriptFile: data.url('messages.js'),
                    contentScriptWhen: 'ready'
                });
                worker.port.on("bookmarks_start_check", function (req) {
//                    console.log('bookmarks_start_check', req);
                    bookmark_checker.checkBookmark(req.mode, req.timeout, req.feed);
                });
                worker.port.on("bookmarks_stop_check", function (req) {
//                    console.log('bookmarks_stop_check', req);
                    bookmark_checker.stopCheckBookmark();
                });
                worker.port.on("bookmarks_check_init", function (req) {
//                    console.log('bookmarks_check_init', req);
                    bookmark_checker.checkInit();
                });
                worker.port.on("bookmark_get_tree", function (reg) {
//                    console.log('bookmark_get_tree', reg);
                    bookmark_checker.getFolderTree(/*reg.parentId, */reg.item/*, reg.folders*/);
                });
                worker.port.on("bookmark_get", function (id) {
//                    console.log('bookmark_get', id);
                    bookmark_checker.getFolder(id);
                });
                worker.port.on("bookmark_update", function (req) {
//                    console.log('bookmark_update', req);
                    bmsvc.setItemTitle(req.id, req.title);
                    var uri = iosvc.newURI(req.url, null, null);
                    bmsvc.changeBookmarkURI(req.id, uri);

                    var bookmark = {
                        title: bmsvc.getItemTitle(req.id),
                        url:   bmsvc.getBookmarkURI(req.id).spec
                    }

//                    console.log('bookmark_push_update', bookmark);
                    worker.port.emit('bookmark_push_update', bookmark);
                });
                worker.port.on("bookmark_remove", function (id) {
//                    console.log('bookmark_remove', id);
                    bmsvc.removeItem(id);
                });
                worker.port.on("bookmark_search", function (url) {
//                    console.log('bookmark_search', url);

                    var uri = iosvc.newURI(url, null, null);
                    var bookmarksArrayId = bmsvc.getBookmarkIdsForURI(uri, {});
                    var bookmarksArray = [];
                    for (var i = 0; i < bookmarksArrayId.length; i++) {
                        bookmarksArray.push({
                            id:    bookmarksArrayId[i],
                            title: bmsvc.getItemTitle(bookmarksArrayId[i]),
                            url:   bmsvc.getBookmarkURI(bookmarksArrayId[i]).spec
                        })
                    }
//                    console.log('bookmark_search_push', bookmarksArray);
                    worker.port.emit('bookmark_search_push', bookmarksArray);
                });
                worker.port.on("bookmarks_whitelist_get", function (req) {
//                    console.log('bookmarks_whitelist_get');
//                    console.log('bookmarks_whitelist_push', bookmark_checker.whiteList.get());
                    worker.port.emit('bookmarks_whitelist_push', bookmark_checker.whiteList.get());
                });
                worker.port.on("bookmark_whitelist_save", function (item) {
//                    console.log('bookmark_whitelist_save', item);
                    bookmark_checker.whiteList.save(item);
                });
                worker.port.on("bookmark_whitelist_remove", function (item) {
//                    console.log('bookmark_whitelist_remove', item);
                    bookmark_checker.whiteList.remove(item);
                });
            }
        });
    }
});




