/**
 - author: hasesanches
 - date: 16.04.15
 - http://hase.su
 **/

(function () {
    'use strict';

//    var bookmark_checker = chrome.extension.getBackgroundPage().bookmark_checker;

    var bookmarksBeforeGetTree = {};

    Array.prototype.unique = function () {
        var a = this.concat();
        for (var i = 0; i < a.length; ++i) {
            for (var j = i + 1; j < a.length; ++j) {
                if (a[i].id === a[j].id)
                    a.splice(j--, 1);
            }
        }
        return a;
    };

    var clone = function (obj) {
        if (null == obj || "object" != typeof obj) return obj;
        var copy = obj.constructor();
        for (var attr in obj) {
            if (obj.hasOwnProperty(attr)) copy[attr] = obj[attr];
        }
        return copy;
    }

    var contains = function (array, obj) {
        for (var i = 0; i < array.length; i++) {
            if (isEqual(array[i], obj)) return true;
        }
        return false;
    }
    var isEqual = function (obj1, obj2) {
        if (obj1.id == obj2.id) return true;
        return false;
    }

    var clearItemTree = function (tree_row) {
        var remove;
        remove = function (row) {

            for (var i = 0; i < row.length; i++) {
                console.log(row[i]);
                if (!row[i].items) continue;

                if (!row[i].items.length) {
                    row.splice(i, 1);
                } else {
                    remove(row[i].items)
                }
            }

        };
        remove(tree_row);
    };

    var addItemTree = function (item, items, cb) {
//        var is_item_inset = false;

        var setToTree = function (row_tree, _item, _folders) {
//            if (is_item_inset) {
//                return cb && cb(items);
//            }
            /* if root folder */
            if (_folders[0] != undefined && _folders[0].parentId == 0) {
                var root_folder = _folders.shift();

                if (!contains(row_tree, root_folder)) {
                    row_tree.push(root_folder);
                }
                setToTree(row_tree, _item, _folders);

            } else {
                for (var i = 0; i < row_tree.length; i++) {
                    var row_tree_item = row_tree[i];

                    if (_folders[0] != undefined && +_folders[0].parentId == +row_tree_item.id) {
                        var children_folder = _folders.shift();

                        if (row_tree_item.items != undefined) {
                            if (!contains(row_tree_item.items, children_folder)) {
                                row_tree_item.items.push(children_folder);
                            }
                        } else {
                            row_tree_item.items = [children_folder];
                        }
                    }

                    if (+row_tree_item.id == +_item.parentId) {
                        if (row_tree_item.items != undefined) {
                            if (!contains(row_tree_item.items, _item)) {
                                row_tree_item.items.push(_item);
                            }
                        } else {
                            row_tree_item.items = [_item];
                        }
//                        is_item_inset = true;
                        return cb && cb();
                    }

                    if (row_tree_item.items != undefined) {
                        setToTree(row_tree_item.items, _item, _folders);
                    }
                }
            }
        };

        console.log(clone(item));
        setToTree(items, item, item.folders_patch);

//        var setListFolder = function (/*parentId, */_item/*, _folders*/) {

//            setToTree(items, _item, _item.patch_array);
//            bookmarksBeforeGetTree[_item.id] = function (event) {
//                var data = JSON.parse(event.detail);
//                console.log(data.item.id, bookmarksBeforeGetTree[data.item.id]);
//                removeEventListener('bookmark_push_tree', bookmarksBeforeGetTree[data.item.id]);
//                delete bookmarksBeforeGetTree[data.item.id];
//                console.log(data.item.id, bookmarksBeforeGetTree[data.item.id]);
//
//                if (!contains(data.folders, data.folder)) {
//                    data.folders.push(data.folder);
//                }
//                if (data.folder.parentId == 0) {
//                    data.folders.reverse();
//                    setToTree(items, data.item, data.folders);
//                }
//                else {
//                    console.log('setListFolder');
//                    setListFolder(data.folder.parentId, data.item, data.folders);
//                }
//            };
//            console.log(_item.id);
//            addEventListener('bookmark_push_tree', bookmarksBeforeGetTree[_item.id]);
//            dispatchEvent('bookmark_get_tree', {parentId: parentId, item: _item, folders: _folders});
//        };
//        setListFolder(/*item.parentId, */item/*, []*/);

    };

    app.factory('bookmark', function () {
            var items = [];
            var count = 0;
            var bookmarksService = {};
            var empty_folders = false;
            var dublicate_folders = false;

            var bookmarksCount = function () {
                count = 0;
                var check = function (items) {
                    for (var i in items) {
                        var item = items[i];
                        if (typeof item == 'object' && (item.url || ((empty_folders || dublicate_folders) && !item.items))) {
                            count++;
                        }
                        if (item.items) {
                            check(item.items);
                        }
                    }
                };
                check(items);
            };

            bookmarksService.getItems = function () {
                if (dublicate_folders) {
                    var last_title = null;
                    var color = false;
                    for (var i = 0, l = items.length; i < l; i++) {
                        var item = items[i];
                        if (item.title != last_title) {
                            color = !color;
                            last_title = item.title;
                        }
                        item.color = color;
                    }
                }
                return items;
            };

            bookmarksService.setItems = function (data) {
                items = data;
                bookmarksCount();
            };

            bookmarksService.addItem = function (item, cb, e_folders, d_folders) {
                console.log('addItem', item);
                item.selected = false;
                empty_folders = e_folders;
                dublicate_folders = d_folders;

                if (d_folders) {
//                    var list_patch_bookmark = [];
                    var count_find_bookmarks = 0;
                    var count_find_folders = 0;

                    var getCountFindItem = function (children) {
                        for (var i = 0, l = children.length; i < l; i++) {
                            var item = children[i];
                            if (item.url) {
                                ++count_find_bookmarks;
                            } else {
                                ++count_find_folders;
                            }
                            if (item.children) {
                                getCountFindItem(item.children);
                            }
                        }
                    };
//                    var getPathBookmark = function (parentId) {
//                        var bookmarksBeforeGet = function (event) {
//                            removeEventListener('bookmark_push', bookmarksBeforeGet);
//                            var parent_folder = JSON.parse(event.detail);
//
//                            if (+parent_folder.id == 0) return cb && cb(items);
//
//                            list_patch_bookmark.push(parent_folder.title);
//                            if (parent_folder.parentId != undefined && +parent_folder.parentId != 0) {
//                                getPathBookmark(parent_folder.parentId);
//                            } else {
//                                list_patch_bookmark.reverse();
//                                item.patch = list_patch_bookmark.join('/');
//                            }
//                        };
//
//                        addEventListener('bookmark_push', bookmarksBeforeGet);
//                        dispatchEvent('bookmark_get', parentId);
//                    };

                    getCountFindItem(item.children);
//                    getPathBookmark(item.parentId);
                    item.patch = [];
                    for (var key in item.folders_patch) {
                        item.patch.push(item.folders_patch[key].title);
                    }
                    item.patch = item.patch.join('/');

                    item.status = 'Bookmarks: ' + count_find_bookmarks + ' Folders: ' + count_find_folders;
                    items.push(item);
                    items.sort(function (a, b) {
                        if (a.title > b.title) {
                            return 1;
                        }
                        if (a.title < b.title) {
                            return -1;
                        }
                        return 0;
                    });
                    bookmarksCount();
                    cb && cb(items);
                } else {
                    addItemTree(item, items, function () {
                        bookmarksCount();
                        cb && cb(items);
                    });
                }
            };

            bookmarksService.removeItem = function (event, item) {
                if ($(event.target).length) {
                    if (dublicate_folders) {
                        if (!confirm('Some folder contain sub-folders and bookmarks. Are you sure you want to delete them?'))
                            return true;
                    } else {
                        if (!confirm('Do you want to remove ' + (item.url ? 'bookmark' : 'folder') + '?'))
                            return true;
                    }
                }

                console.log('remove item', item, event.type);

                var remove = function (tree_row) {
                    for (var i = tree_row.length; i--;) {
                        if (tree_row[i].id == item.id && event.type != 'whitelist-add') {
//                            if (dublicate_folders && tree_row[i].children.length) {
//                                chrome.bookmarks.removeTree(tree_row[i].id);
//                            } else {
//                                chrome.bookmarks.remove(tree_row[i].id);
//                            }

                            dispatchEvent('bookmark_remove', tree_row[i].id);

                            tree_row.splice(i, 1);
                            bookmarksCount();
                            clearItemTree(items);
                            break;
                        } else if (tree_row[i].url == item.url && event.type == 'whitelist-add') {
                            tree_row.splice(i, 1);
                            bookmarksCount();
                            clearItemTree(items);
                        }
                        if (tree_row[i] != undefined && tree_row[i].items != undefined) {
                            remove(tree_row[i].items);
                        }
                    }
                };
                remove(items);
            };

            bookmarksService.countItem = function () {
                return count;
            };

            return bookmarksService;
        }
    )

    app.factory('whitelist', function ($timeout, $interval, bookmark) {

        var items = [];
        var whiteListService = {};

        whiteListService.addItem = function (event, item) {
            if (event.type != 'whitelist-export' && event.type != 'whitelist-all') {
                if (!confirm('Do you want to add this bookmark to whitelist? It will be excluded from the results.')) return true;
            }

            dispatchEvent('bookmark_whitelist_save', item);

            if (event.type != 'whitelist-export') {
                bookmark.removeItem(new Event('whitelist-add'), item);
            }
        };

        whiteListService.removeItem = function (event, item) {
            if (event.type != 'remove-all') {
                if (!confirm('Do you want to remove bookmark from whitelist?')) return true;
            }

            dispatchEvent('bookmark_whitelist_remove', item);

            for (var i = items.length; i--;) {
                console.log(items[i], item);
                if (items[i].url == item.url) {
                    items.splice(i, 1);
                }
            }
        };

        whiteListService.init = function (cb) {
            var stop;
            var bookmarks_storage;
            var bookmark_added_whitelist = 0;
            var bookmarksStorageSet;
            var bookmarksSearchSet;

            bookmarksSearchSet = function (event) {
                console.log('addEventListener bookmark_search_push', event.detail);

                --bookmark_added_whitelist;
                if (bookmark_added_whitelist == 0) {
                    removeEventListener('bookmark_search_push', bookmarksSearchSet);
                }

                var reg = JSON.parse(event.detail);
                console.log(reg);
                if (reg.length) {
                    items = items.concat(reg).unique();
                } else {
                    var replace_url = bookmarks_storage[bookmark_added_whitelist].url.replace(/http:\/\/|www\.|\/$/, '');
                    items = items.concat({
                        id:    bookmark_added_whitelist + replace_url,
                        url:   bookmarks_storage[bookmark_added_whitelist].url,
                        title: replace_url
                    }).unique();
                }
            }
            addEventListener('bookmark_search_push', bookmarksSearchSet);

            bookmarksStorageSet = function (event) {
                removeEventListener('bookmarks_whitelist_push', bookmarksStorageSet);
                console.log('addEventListener bookmarks_whitelist_push', event.detail);
                bookmarks_storage = JSON.parse(event.detail);
                for (var i = 0; i < bookmarks_storage.length; i++) {
                    ++bookmark_added_whitelist;
                    dispatchEvent('bookmark_search', bookmarks_storage[i].url);
                }

                stop = $interval(function () {
                    if (bookmark_added_whitelist == 0) {
                        cb && cb(items);
                        if (angular.isDefined(stop)) {
                            $interval.cancel(stop);
                            stop = undefined;
                        }
                    }
                }, 100);
            }
            addEventListener('bookmarks_whitelist_push', bookmarksStorageSet);

            dispatchEvent('bookmarks_whitelist_get');
        };

        whiteListService.getItems = function () {
            return items;
        };

        return whiteListService;

    })

})
    ();