var indexOfObject = function (array, property, value) {
    for (var i = 0, len = array.length; i < len; i++) {
        if (array[i][property] === value) return i;
    }
    return -1;
};

var bookmark_checker = {

    whiteList: {
        save: function (item) {
            var bookmarks = localStorage['white_list'] ? JSON.parse(localStorage['white_list']) : [];
            var bookmark = {
                /*id: item.id/*,
                 title: item.title*/
            }
            /*if (item.url != undefined) */
            bookmark.url = item.url;
            if (indexOfObject(bookmarks, 'url', item.url) == -1) bookmarks.push(bookmark);

            localStorage['white_list'] = JSON.stringify(bookmarks);
        },
        remove: function (bookmark) {
            var bookmarks = localStorage['white_list'] ? JSON.parse(localStorage['white_list']) : [];

//            for (var i = 0; i < bookmarks.length; i++) {
//                if (bookmarks[i].id == item.id) {
//                    bookmarks.splice(i, 1);
//                    break;
//                }
//            }
            if (indexOfObject(bookmarks, 'url', bookmark.url) != -1) bookmarks.splice(indexOfObject(bookmarks, 'url', bookmark.url), 1);
            localStorage['white_list'] = JSON.stringify(bookmarks);
        },
        get: function () {
            return localStorage['white_list'] ? JSON.parse(localStorage['white_list']) : [];
        }
    },

    check_start: false,

    stopCheckBookmark: function () {

        bookmark_checker.check_start = false;
        chrome.extension.sendMessage({action: 'bookmark_check_finish' });

    },

    checkBookmark: function (mode, timeout, max_request) {

        console.log('checkBookmark', mode, timeout);

        if (!bookmark_checker.check_start) {
            bookmark_checker.check_start = true;
        }
        else {
            return;
        }

        chrome.bookmarks.getTree(function (bookmarks_tree) {
                console.log('bookmarks_tree', bookmarks_tree);

                var bookmarks_list = [];
                var bookmarks_folder_list = [];
                var bookmarks_count_error = 0;
                var bookmarks_white_list = localStorage['white_list'] ? JSON.parse(localStorage['white_list']) : [];

                var search = function (items) {
                    for (var i in items) {
                        var item = items[i];
                        if (!item.children) {
                            delete item.dateAdded;
                            bookmarks_list.push(item);
                        } else {
                            search(item.children);
//                        delete item.children;
                            delete item.dateAdded;
                            delete item.dateGroupModified;
                            bookmarks_folder_list.push(item);
                        }
                    }
                }
                search(bookmarks_tree[0].children);

                var checkUrl = function (index, callback) {
                    var bookmark = bookmarks_list[index];
                    var req = new XMLHttpRequest();

                    req.open("get", bookmark.url, true);
                    var timeout_id = setTimeout(function () {
                        req.onreadystatechange = null;
                        req.abort();
                        bookmark.status = -1;
                        bookmark.message = 'Connection timeout';
                        callback(bookmark, index);
                    }, timeout)

                    req.onreadystatechange = function () {
                        if (req.readyState == 4) {
                            clearTimeout(timeout_id);
                            bookmark.status = req.status ? req.status : -1;
                            bookmark.message = req.statusText ? req.statusText : 'Other Error';
                            callback(bookmark, index);
                        }
                    }
                    req.open("get", bookmark.url, true);
                    req.send(null);
                }

                var checkListError = function (index) {
                    index = index != undefined ? index : 0;

                    if (!bookmark_checker.check_start) return;

                    checkUrl(index, function (bookmark, index) {
                        console.log('check error', bookmark);

                        if (!bookmark_checker.check_start) return;

                        chrome.extension.sendMessage({action: 'bookmark_check_progress', progress: index / (bookmarks_list.length - 1) * 100, title: bookmark.title, url: bookmark.url});

                        if (bookmark.status != 200 && indexOfObject(bookmarks_white_list, 'url', bookmark.url) == -1) {
                            bookmarks_count_error++;
                            chrome.extension.sendMessage({action: 'bookmark_check', bookmark: bookmark });
                        }

                        chrome.extension.sendMessage({action: 'bookmark_check_status', index: index, bookmark_count: bookmarks_list.length, error_count: bookmarks_count_error});

                        if (index < bookmarks_list.length - 1) {
                            checkListError(++index);
                        } else {
                            chrome.extension.sendMessage({action: 'bookmark_check_finish' });
                            bookmark_checker.check_start = false;
                        }
                    })
                }

                var checkListDuplicates = function () {
                    var bookmarks_duplicates = [];

                    for (var key in bookmarks_list) {
                        console.log('check duplicate', bookmarks_list[key]);

                        if (!bookmark_checker.check_start) break;

                        chrome.extension.sendMessage({action: 'bookmark_check_progress', progress: key / (bookmarks_list.length - 1) * 100, title: bookmarks_list[key].title, url: bookmarks_list[key].url});

                        if (bookmarks_duplicates.indexOf(bookmarks_list[key].url) != -1 && indexOfObject(bookmarks_white_list, 'url', bookmarks_list[key].url) == -1) {
                            bookmarks_count_error++;
                            chrome.extension.sendMessage({action: 'bookmark_check', bookmark: bookmarks_list[key] });
                        } else {
                            bookmarks_duplicates.push(bookmarks_list[key].url);
                        }

                        chrome.extension.sendMessage({action: 'bookmark_check_status', index: key, bookmark_count: bookmarks_list.length, error_count: bookmarks_count_error});

                        if (key == bookmarks_list.length - 1) {
                            chrome.extension.sendMessage({action: 'bookmark_check_finish' });
                            bookmark_checker.check_start = false;
                        }
                    }
                }

                var checkListEmptyFolders = function () {
                    for (var key in bookmarks_folder_list) {
                        console.log('check empty folders', bookmarks_folder_list[key]);

                        if (!bookmark_checker.check_start) break;

                        chrome.extension.sendMessage({action: 'bookmark_check_progress', progress: key / (bookmarks_folder_list.length - 1) * 100, title: bookmarks_folder_list[key].title, url: bookmarks_folder_list[key].url});

                        if (bookmarks_folder_list[key].children.length == 0) {
                            bookmarks_count_error++;
                            chrome.extension.sendMessage({action: 'bookmark_check', bookmark: bookmarks_folder_list[key] });
                        }

                        chrome.extension.sendMessage({action: 'bookmark_check_status', index: key, bookmark_count: bookmarks_folder_list.length, error_count: bookmarks_count_error});

                        if (key == bookmarks_folder_list.length - 1) {
                            chrome.extension.sendMessage({action: 'bookmark_check_finish' });
                            bookmark_checker.check_start = false;
                        }
                    }
                }

                var checkListEmptyTitle = function () {
                    for (var key in bookmarks_list) {
                        console.log('check empty title', bookmarks_list[key]);

                        if (!bookmark_checker.check_start) break;

                        chrome.extension.sendMessage({action: 'bookmark_check_progress', progress: key / (bookmarks_list.length - 1) * 100, title: bookmarks_list[key].title, url: bookmarks_list[key].url});

                        if (bookmarks_list[key].title == '' && indexOfObject(bookmarks_white_list, 'url', bookmarks_list[key].url) == -1) {
                            bookmarks_count_error++;
                            chrome.extension.sendMessage({action: 'bookmark_check', bookmark: bookmarks_list[key] });
                        }

                        chrome.extension.sendMessage({action: 'bookmark_check_status', index: key, bookmark_count: bookmarks_list.length, error_count: bookmarks_count_error});

                        if (key == bookmarks_list.length - 1) {
                            chrome.extension.sendMessage({action: 'bookmark_check_finish' });
                            bookmark_checker.check_start = false;
                        }
                    }
                }

                if (mode == 'error_connect') {
                    checkListError();
                } else if (mode == 'duplicates') {
                    checkListDuplicates();
                } else if (mode == 'empty_folders') {
                    checkListEmptyFolders();
                } else if (mode == 'empty_title') {
                    checkListEmptyTitle();
                }

            }
        )
    },

    checkInit: function () {
        chrome.bookmarks.getTree(function (bookmarks) {
            var bookmark_count = 0;
            var search = function (items) {
                for (var i in items) {
                    var item = items[i];
                    if (!item.children) {
                        bookmark_count++;
                    } else {
                        search(item.children);
                    }
                }
            }
            search(bookmarks[0].children);
            chrome.extension.sendMessage({action: 'bookmarks_count', bookmark_count: bookmark_count });
        });
    }

}