/**
 - author: hasesanches
 - date: 15.04.15
 - http://hase.su
 **/

(function () {
    'use strict';

    app.controller('checkController', function ($scope, $location, $interval, extension, bookmark) {

        $scope.popup_text = null;
        $scope.bookmark_count = null;
        $scope.bookmark_check_title = null;
        $scope.bookmark_check_progress = 0;
        $scope.bookmark_check_mode = localStorage['bookmark_check_mode'] = (localStorage['bookmark_check_mode'] == undefined ? 'error_connect' : localStorage['bookmark_check_mode']);
        $scope.bookmark_check_timeout = localStorage['bookmark_check_timeout'] = (localStorage['bookmark_check_timeout'] == undefined ? '5000' : localStorage['bookmark_check_timeout']);
        $scope.bookmark_check_feed = localStorage['bookmark_check_feed'] = (localStorage['bookmark_check_feed'] == undefined ? '5' : localStorage['bookmark_check_feed']);
        $scope.bookmark_check_status = null;

        $scope.$watch('bookmark_check_mode', function (newValue, oldValue) {
            localStorage['bookmark_check_mode'] = newValue;
            window.setTimeout(function () {
                $('.selectpicker').selectpicker();
            }, 0)
        });

        $scope.$watch('bookmark_check_timeout', function (newValue, oldValue) {
            localStorage['bookmark_check_timeout'] = newValue;
        });

        $scope.$watch('bookmark_check_feed', function (newValue, oldValue) {
            localStorage['bookmark_check_feed'] = newValue;
        });

        $scope.$on('clearProgress', function (event, args) {
            $scope.bookmark_check_title = null;
            $scope.bookmark_check_progress = 0;
            $scope.bookmark_check_status = null;
            $scope.popup_text = null;
        });

        var bookmark_added_status = 0;
        var stop;

        $scope.$watch(function () {
            return extension.request;
        }, function (request, old_request) {

            if (request.action == 'bookmark_check') {
                ++bookmark_added_status;
                bookmark.addItem(request.bookmark, function (items) {
                    --bookmark_added_status;
                }, $scope.bookmark_check_mode == 'empty_folders', $scope.bookmark_check_mode == 'duplicates_folders');
            }

            if (request.action == 'bookmark_check_progress') {
                $scope.bookmark_check_title = request.title;
                $scope.bookmark_check_progress = Math.round(request.progress);
            }

            if (request.action == 'bookmark_check_status') {
                $scope.bookmark_check_status = "Total " + (localStorage['bookmark_check_mode'] == 'empty_folders' ? 'folders' : 'bookmarks') + " : " + (request.index + 1) + " of " + request.bookmark_count + " " + localStorage['bookmark_check_mode'].replace('_', ' ') + ": " + request.error_count;
            }

            if (request.action == 'bookmark_check_finish' && old_request.action != 'bookmark_check_finish') {

//                if (bookmark_added_status > 0) {
                $scope.popup_text = 'Generating report.. please wait...';
//                }

                var bookmark_added_status_last = 0;
                var bookmark_added_status_number_check = 0;

                stop = $interval(function () {
                    if (bookmark_added_status == bookmark_added_status_last) {
                        if (angular.isDefined(stop)) {
                            $interval.cancel(stop);
                            stop = undefined;
                        }

                        if (!bookmark.getItems().length) {
                            $scope.bookmark_check_title = null;
                            $scope.bookmark_check_progress = 0;
                            $scope.bookmark_check_status = null;
                            $scope.popup_text = null;

                            var no_result = {
                                error_connect:      'No error connect found',
                                duplicates:         'No duplicate bookmarks found',
                                duplicates_folders: 'No duplicate folders found',
                                empty_folders:      'No empty folders found',
                                empty_title:        'No empty titles bookmarks found'
                            };

                            alert(no_result[$scope.bookmark_check_mode]);
                        } else {
                            $location.path("/tree");
                        }
                    } else {
                        if (bookmark_added_status == bookmark_added_status_last) {
                            ++bookmark_added_status_number_check;
                        } else {
                            bookmark_added_status_number_check = 0;
                        }

                        bookmark_added_status = bookmark_added_status_last;
                    }
                }, $scope.bookmark_check_timeout);
            }

            if (request.action == 'bookmarks_count') {
                $scope.bookmark_count = request.bookmark_count;
            }
        });

        $scope.checkBookmark = function () {
            bookmark.setItems([]);
            dispatchEvent('bookmarks_start_check', {mode: $scope.bookmark_check_mode, timeout: $scope.bookmark_check_timeout, feed: $scope.bookmark_check_feed});
        };

        $scope.stopCheckBookmark = function () {
            dispatchEvent('bookmarks_stop_check');
        };

        window.setTimeout(function () {
            dispatchEvent('bookmarks_check_init');
        }, 0)
    });

    app.controller('treeController', function ($scope, $timeout, $interval, $location, bookmark, whitelist) {

        $scope.header = localStorage['bookmark_check_mode'] == 'empty_folders' ? 'folder' : 'bookmark';
        $scope.bookmark_check_mode = localStorage['bookmark_check_mode'];
        $scope.bookmark_check_mode_title = {
            error_connect:      'error connect found',
            duplicates:         'duplicates bookmarks found',
            duplicates_folders: 'duplicates folders found',
            empty_folders:      'empty folders found',
            empty_title:        'empty titles found'
        };
        $scope.bookmark = bookmark;
        $scope.whitelist = whitelist;
        $scope.selected_item = [];
        $scope.selected_all = false;

        var last_checked_index = null;

        if (!$scope.bookmark.getItems().length) {
            $location.path("/");
        }

        $scope.$emit('clearProgress');

        $scope.edit = function (item) {
            if ($scope.activeItem != item) $scope.activeItem = item;
            else $scope.activeItem = null;
        };

        $scope.update = function (item) {
            var bookmarksBeforeUpdate;
            bookmarksBeforeUpdate = function (event) {
                removeEventListener('bookmark_push_update', bookmarksBeforeUpdate);
                var bookmark = JSON.parse(event.detail);

                item.title = bookmark.title;
                item.url = bookmark.url;

                $scope.activeItem = null;

            };
            addEventListener('bookmark_push_update', bookmarksBeforeUpdate);
            dispatchEvent('bookmark_update', {id: item.id, title: item.title, url: item.url});

        };

        $scope.cancel = function () {
            $scope.activeItem = null;
        };

        $timeout(function () {
            if ($('.angular-ui-tree input').length == $('.angular-ui-tree input:checked').length) {
                $scope.selected_all = true;
            }
        }, 100);

        $interval(function () {
            $scope.selected_item = [];
            var is_select = function (tree_row) {
                angular.forEach(tree_row, function (item) {
                    if (item.selected && !item.items) {
                        $scope.selected_item.push(item);
                    }
                    if (item.items) is_select(item.items);
                })
            }
            is_select(bookmark.getItems());

            if (!$scope.$$phase) $scope.$apply();

        }, 500);

        $('.btn-select-all').on('click', function (e) {
            $scope.selected_all = !$scope.selected_all;
            var select_row = function (tree_row) {
                angular.forEach(tree_row, function (item) {
                    if (item.id > 5) {
                        item.selected = $scope.selected_all;
                    }
                    if (item.selected && !item.items) {
                        if ($scope.selected_item.indexOf(item) == -1) $scope.selected_item.push(item);
                    } else {
                        if ($scope.selected_item.indexOf(item) != -1) $scope.selected_item.splice($scope.selected_item.indexOf(item), 1);
                    }
                    if (item.items) select_row(item.items);
                });
            }
            select_row(bookmark.getItems());

            if (!$scope.$$phase) $scope.$apply();
        });

        $('.btn-remove-all').on('click', function (event) {
            var $input_checked = $('.angular-ui-tree input:checked');

            if ($input_checked.length && confirm('Do you want to remove the selected item' + ($input_checked.length > 1 ? 's' : '') + '?')) {
                console.log($input_checked);

                $input_checked.each(function (index, input) {
                    if ($(input).closest('.angular-ui-tree-handle').find('.tree-delete').length) {
                        var id = +input.outerHTML.match(/data-id="(\d+)/)[1]; //$(input).data('id')
                        bookmark.removeItem(new Event('remove-all'), {id: id});
                    }
                })
                if (!$scope.$$phase) $scope.$apply();
            }
        });

        $scope.whiteListAll = function ($event) {
            var $input_checked = $('.angular-ui-tree input:checked');

            if ($input_checked.length && confirm('Do you want to whitelist the selected item' + ($input_checked.length > 1 ? 's' : '') + '?')) {
                var remove = function (tree_row) {
                    for (var i = tree_row.length; i--;) {
                        if (tree_row[i].selected && tree_row[i].url) {
                            whitelist.addItem(new Event('whitelist-all'), tree_row[i])
                        }
                        if (tree_row[i] != undefined && tree_row[i].items != undefined) {
                            remove(tree_row[i].items);
                        }
                    }
                }
                remove(bookmark.getItems());
                if (!$scope.$$phase) $scope.$apply();
            }
        };

        $scope.checkboxClick = function ($event, item) {
            if ($event.target.localName == 'a' || /*item.id < 5 || */$($event.target).hasClass('tree-collapsed')) return true;

            item.selected = !item.selected;

            var select_folder = function (tree_row, select) {
                angular.forEach(tree_row, function (tree_row_item) {
                    if (tree_row_item.id == item.id || select) {
                        tree_row_item.selected = item.selected;

                        if (tree_row_item.selected && !tree_row_item.items) {
                            if ($scope.selected_item.indexOf(tree_row_item) == -1) $scope.selected_item.push(tree_row_item);
                        } else {
                            if ($scope.selected_item.indexOf(tree_row_item) != -1) $scope.selected_item.splice($scope.selected_item.indexOf(tree_row_item), 1);
                        }

                        if (tree_row_item.items) select_folder(tree_row_item.items, true);
                    } else {
                        if (tree_row_item.items) select_folder(tree_row_item.items, null);
                    }
                });
            };
            if (item.items) {
                select_folder(bookmark.getItems(), null);
            }

            var $checkbox = $($event.target).closest('.angular-ui-tree-handle').find('input[type=checkbox]');

            if ($($checkbox).data('index') == undefined) {
                $('.angular-ui-tree input').each(function (index, input) {
                    $(this).data('index', index).attr('data-index', index)
                });
            }

            if (item.selected && !item.items) {
                if ($event.shiftKey) {
                    $('.angular-ui-tree input').each(function (index, input) {
                        if (($(input).data('index') > last_checked_index && $(input).data('index') < $($checkbox).data('index'))
                            || ($(input).data('index') < last_checked_index && $(input).data('index') > $($checkbox).data('index'))) {
                            $timeout(function () {
                                $(input).closest('.angular-ui-tree-handle').trigger('click');
                            }, 0, false)
                        }
                    })
                }

                last_checked_index = $($checkbox).data('index');

                if ($scope.selected_item.indexOf(item) == -1) $scope.selected_item.push(item);
            } else {
                if ($scope.selected_item.indexOf(item) != -1) $scope.selected_item.splice($scope.selected_item.indexOf(item), 1);
            }
        }

    });

    app.controller('whiteListController', function ($scope, $timeout, $interval, whitelist) {

        $scope.header = "White List";
        $scope.whitelist = whitelist;
        $scope.selected_item = [];
        $scope.selected_all = false;

        var last_checked_index = null;

        $scope.whitelist.init(function (items) {
//            if (!$scope.$$phase) $scope.$apply();

            $timeout(function () {
                var is_select = function (tree_row) {
                    angular.forEach(tree_row, function (item) {
                        if (item.selected) {
                            $scope.selected_item.push(item);
                        }
                        if (item.items) is_select(item.items);
                    })
                }
                is_select(whitelist.getItems());
                if (!$scope.$$phase) $scope.$apply();

                if ($('.angular-ui-tree input').length == $('.angular-ui-tree input:checked').length) {
                    $scope.selected_all = true;
                }
            }, 0);
        });

        $interval(function () {
            $scope.selected_item = [];
            var is_select = function (tree_row) {
                angular.forEach(tree_row, function (item) {
                    if (item.selected) {
                        $scope.selected_item.push(item);
                    }
                    if (item.items) is_select(item.items);
                })
            }
            is_select(whitelist.getItems());
            if (!$scope.$$phase) $scope.$apply();

        }, 500);

        $('#button_export').on('click', function () {
            $('#input_export').click();
        });

        $('#input_export').on('change', function (event) {
            var reader = new FileReader();
            reader.onload = function (e) {

                if (!confirm('Do you want to add this bookmark list to whitelist? It will be excluded from the results.')) return true;//

                var rows = e.target.result.split(/\r\n/);
                for (var i = 0; i < rows.length; i++) {
                    whitelist.addItem(new Event('whitelist-export'), {url: rows[i]});
                }
                $scope.whitelist.init(function (items) {
                    if (!$scope.$$phase) $scope.$apply();
                });

            };
            reader.readAsText(event.target.files[0]);
        });

        $('.btn-select-all').on('click', function (e) {
            $scope.selected_all = !$scope.selected_all;
            var select_row = function (tree_row) {
                angular.forEach(tree_row, function (item) {
                    if (!item.items) {
                        item.selected = $scope.selected_all;
                    }
                    if (item.selected) {
                        if ($scope.selected_item.indexOf(item) == -1) $scope.selected_item.push(item);
                    } else {
                        if ($scope.selected_item.indexOf(item) != -1) $scope.selected_item.splice($scope.selected_item.indexOf(item), 1);
                    }
                    if (item.items) select_row(item.items);
                });
            }
            select_row(whitelist.getItems());
            if (!$scope.$$phase) $scope.$apply();
        });

        $('.btn-remove-all').on('click', function (event) {
            var whitelist_select = [];
            angular.forEach(whitelist.getItems(), function (item) {
                if (item.selected) {
                    whitelist_select.push(item.url);
                }
            });

            if (whitelist_select.length
                && confirm('Do you want to remove the selected item' + (whitelist_select.length > 1 ? 's' : '') + ' from whitelist?')) {
                angular.forEach(whitelist_select, function (url) {
                    whitelist.removeItem(new Event('remove-all'), {url: url});
                });
            }
        });

        $scope.checkboxClick = function ($event, item) {
            if ($event.target.localName == 'a' || item.id < 5 || $($event.target).hasClass('tree-collapsed')) return true;

            item.selected = !item.selected;

            var $checkbox = $($event.target).closest('.angular-ui-tree-handle').find('input[type=checkbox]');

            if ($($checkbox).data('index') == undefined) {
                $('.angular-ui-tree input').each(function (index, input) {
                    $(this).data('index', index).attr('data-index', index)
                });
            }

            if (item.selected) {
                if ($event.shiftKey) {
                    $('.angular-ui-tree input').each(function (index, input) {
                        console.log($(input).data('index'), last_checked_index, $($checkbox).data('index'))

                        if (($(input).data('index') > last_checked_index && $(input).data('index') < $($checkbox).data('index'))
                            || ($(input).data('index') < last_checked_index && $(input).data('index') > $($checkbox).data('index'))) {
                            $timeout(function () {
                                console.log($(input).data('index'));
                                $(input).closest('.angular-ui-tree-handle').trigger('click');
                            }, 0, false)
                        }
                    })
                }

                last_checked_index = $($checkbox).data('index');

                if ($scope.selected_item.indexOf(item) == -1) $scope.selected_item.push(item);
            } else {
                if ($scope.selected_item.indexOf(item) != -1) $scope.selected_item.splice($scope.selected_item.indexOf(item), 1);
            }
        }

    });

})();