#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Icon=BundleIcon.ico
#AutoIt3Wrapper_UseX64=y
#AutoIt3Wrapper_Res_Description=Initiates the copying process of firefox default profile to users profile directory
#AutoIt3Wrapper_Res_Fileversion=1.0.0.13
#AutoIt3Wrapper_Res_Fileversion_AutoIncrement=y
#AutoIt3Wrapper_Res_LegalCopyright=Jan Hansmeyer
#AutoIt3Wrapper_Res_Language=1031
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

; Note: Extra Icons are added by using Resource Hacker!

; declare variables
Global $DefaultProfilePath			=	@ScriptDir&"\browser\defaults\profile"
Global $UsersFirefoxAppDataPath		=	@AppDataDir&"\Mozilla\Firefox"
Global $UsersProfilesIniPath		=	$UsersFirefoxAppDataPath&"\profiles.ini"
Global $UsersProfilePath			=	$UsersFirefoxAppDataPath&"\Profiles"
Global $UsersProfileName			=	"company.default"
Global $firefoxexe					=	@ScriptDir&"\firefox-original.exe"

; create user profile
If UserProfileExists() = 0 Then	CopyDefaultProfile()

; run firefox.exe
RunFirefox()





Func CopyDefaultProfile()
	; create directories in user profile
	DirCreate($UsersProfilePath&"\"&$UsersProfileName)

	; create profiles.ini
	FileWrite($UsersProfilesIniPath,	"[General]" 									&@CRLF& _
										"StartWithLastProfile=1"						&@CRLF& _
										""												&@CRLF& _
										"[Profile0]"									&@CRLF& _
										"Name=default"									&@CRLF& _
										"IsRelative=1"									&@CRLF& _
										"Path=Profiles/"&$UsersProfileName				&@CRLF& _
										""												&@CRLF& _
										"")

	DirCopy($DefaultProfilePath, $UsersProfilePath&"\"&$UsersProfileName, 1)
EndFunc

Func UserProfileExists()
	If Not FileExists($UsersProfilesIniPath) Then
		Return 0
	Else
		Return 1
	EndIf
EndFunc

Func RunFirefox()
	local $parameters
	local $i

	If $CmdLine[0] > 0 Then
		For $i = 1 To $CmdLine[0]
			$parameters = $parameters & " " & $CmdLine[$i]
		Next
	EndIf

	Run($firefoxexe & $parameters)
EndFunc