
var prefPane = {
    pref: {},

    buildEngineList: function(){
        const kXULNS = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";
        let enginesExist = false;
        let engineWasFound = false;

        let searchService = Components.classes["@mozilla.org/browser/search-service;1"]
                                      .getService(Components.interfaces.nsIBrowserSearchService);
        let engines = searchService.getVisibleEngines({ });

        if(engines.length > 0)
        {
            enginesExist = true;
            for(let i=0; i < engines.length; i++)
            {
                let menuitem = document.createElementNS(kXULNS, "menuitem");
                menuitem.setAttribute("label", engines[i].name);
                menuitem.setAttribute("value", engines[i].name);
                menuitem.setAttribute("class", "menuitem-iconic engine-icon");
                if( engines[i].iconURI )
                    menuitem.setAttribute("image", engines[i].iconURI.spec);
                this.popup_searchengines.appendChild(menuitem);
                if(engines[i].name == this.pref.defaultengine.value)
                {
                    this.menulist_searchengines.selectedIndex = i;
                    engineWasFound = true;
                }
            }
        }

        if(enginesExist && !engineWasFound)
            this.pref.defaultengine.valueFromPreferences = engines[0].name;
    },//buildEngineList

    init: function(){
        this.pref.defaultengine                  = document.getElementById( "extensions.searchload.defaultengine");
        
        this.checkbox_clear_on_search_submission = document.getElementById("checkbox-clear-on-search-submission");
        this.checkbox_clear_on_searchbar_blur    = document.getElementById("checkbox-clear-on-searchbar-blur"   );
        this.label_clear_delay                   = document.getElementById( "label-clear-delay"      );
        this.textbox_clear_delay                 = document.getElementById( "textbox-clear-delay"    );
        this.label_clear_delay_units             = document.getElementById( "label-clear-delay-units");
        
        this.checkbox_reset_on_search_submission = document.getElementById("checkbox-reset-on-search-submission");
        this.checkbox_reset_on_searchbar_blur    = document.getElementById("checkbox-reset-on-searchbar-blur"   );
        this.label_reset_searchengine            = document.getElementById( "label-reset-searchengine");
        this.menulist_searchengines              = document.getElementById( "menulist-searchengines"  );
        this.popup_searchengines                 = document.getElementById( "popup-searchengines"     );
        
        this.label_reset_delay                   = document.getElementById( "label-reset-delay"      );
        this.textbox_reset_delay                 = document.getElementById( "textbox-reset-delay"    );
        this.label_reset_delay_units             = document.getElementById( "label-reset-delay-units");
        
        this.label_tab_exceptions                = document.getElementById( "label-tab-exceptions"        );
        this.checkbox_detect_blank_tab           = document.getElementById( "checkbox-detect-blank-tab"   );
        this.checkbox_detect_home_tab            = document.getElementById( "checkbox-detect-home-tab"    );
        this.checkbox_detect_new_tab_page        = document.getElementById( "checkbox-detect-new-tab-page");

        this.buildEngineList();
        
        this.updateClearStatus();
        this.updateResetStatus();
    },//init

    updateClearStatus: function(){
        if( !this.checkbox_clear_on_search_submission.checked && !this.checkbox_clear_on_searchbar_blur.checked )
        {
            this.label_clear_delay.disabled       = true;
            this.textbox_clear_delay.disabled     = true;
            this.label_clear_delay_units.disabled = true;
        }
        else
        {
            this.label_clear_delay.disabled       = false;
            this.textbox_clear_delay.disabled     = false;
            this.label_clear_delay_units.disabled = false;
        }
    },

    updateResetStatus: function(){
        if( !this.checkbox_reset_on_search_submission.checked && !this.checkbox_reset_on_searchbar_blur.checked )
        {
            this.label_reset_delay.disabled        = true;
            this.textbox_reset_delay.disabled      = true;
            this.label_reset_delay_units.disabled  = true;
        }
        else
        {
            this.label_reset_delay.disabled        = false;
            this.textbox_reset_delay.disabled      = false;
            this.label_reset_delay_units.disabled  = false;
        }
    },
    
    updateExceptions: function( index ){
        if(index===0)
        {   this.label_tab_exceptions.disabled         = true;
            this.checkbox_detect_blank_tab.disabled    = true;
            this.checkbox_detect_home_tab.disabled     = true;
            this.checkbox_detect_new_tab_page.disabled = true;
            
        }
        else
        {   this.label_tab_exceptions.disabled         = false;
            this.checkbox_detect_blank_tab.disabled    = false;
            this.checkbox_detect_home_tab.disabled     = false;
            this.checkbox_detect_new_tab_page.disabled = false;
        }
    }
};
