//    Block Autorefresh Whitelist
//    v. 0.13
//    for Fx 55

const {classes: Cc, interfaces: Ci, utils: Cu, results: Cr} = Components;

Cu.import('resource://gre/modules/Services.jsm');
Cu.import("resource://gre/modules/Timer.jsm");

const prefEN = 'extensions.block_autorefresh_whitelist.enabled';
const prefWL = 'extensions.block_autorefresh_whitelist.whitelist';
const prefCM = 'extensions.block_autorefresh_whitelist.contextmenuitems';
const prefND = 'extensions.block_autorefresh_whitelist.notification_duration';
const prefMM = 'extensions.block_autorefresh_whitelist.global_message_manager';

var origRefrFuncStr;

function getOrigRefrFuncStr(window) {
	origRefrFuncStr = window.RefreshBlocker.block.toString();
};

function setOrigRefrFunc(window) {
	window.eval('window.RefreshBlocker.block = ' + origRefrFuncStr);
};

function setNewRefrFunc(window) {
//  s.
//  https://dxr.mozilla.org/mozilla-release/source/browser/base/content/browser-refreshblocker.js

	window.getGroupMessageManager('browsers').removeDelayedFrameScript(
		"chrome://browser/content/tab-content.js");

	window.RefreshBlocker.block = function(browser, data) {
		let domain = data.domain;
		if (!domain)
			domain = '';
		let brandBundle = window.document.getElementById("bundle_brand");
		let brandShortName = brandBundle.getString("brandShortName");
		let refreshButtonText = window.gNavigatorBundle.getString("refreshBlocked.goButton");
		let refreshButtonAccesskey = window.gNavigatorBundle.getString(
			"refreshBlocked.goButton.accesskey");
		let message = window.gNavigatorBundle.getFormattedString(
			data.sameURI ? "refreshBlocked.refreshLabel" : "refreshBlocked.redirectLabel",
			[brandShortName]);
		let docfrag = window.document.createDocumentFragment();
		let div = window.document.createElement("div");
		div.textContent = message;
		docfrag.appendChild(div);
		div = window.document.createElement("div");
		div.textContent = "Domain: " + domain;
		div.style.display = "block";
		docfrag.appendChild(div);
		let buttons = [
			{	label: refreshButtonText,
				accessKey: refreshButtonAccesskey,
				callback: function() {
					if (browser.messageManager) {
						browser.messageManager.sendAsyncMessage("RefreshBlocker:Refresh", data);
					};
				}
			},
			{	label: "Freigeben",
				accessKey: "F",
				callback: function() {
					if (domain) {
						var wlDomains = Services.prefs.getCharPref(prefWL).split(',');
						if (wlDomains.indexOf(domain) == -1) {
							if (wlDomains[0] == '')
								//  preference value is empty string
								wlDomains[0] = domain
							else
								wlDomains.push(domain);
							Services.prefs.setCharPref(prefWL, wlDomains);
						};
					};
					if (browser.messageManager) {
						browser.messageManager.sendAsyncMessage("RefreshBlocker:Refresh", data);
					};
				}
			}
		];
		let notificationBox = window.gBrowser.getNotificationBox(browser);
		let notification = notificationBox.appendNotification(docfrag, "refresh-blocked",
			"chrome://browser/skin/Info.png", notificationBox.PRIORITY_INFO_MEDIUM, buttons);
		var duration = Services.prefs.getIntPref(prefND);
		if (duration > 0) {
			window.setTimeout(function() {
				try {
					notification.close();
				} catch(e) { };
			}, duration * 1000);
		};
	};
};

function doContextMenu(window) {
	var contextMenu = window.document.getElementById('contentAreaContextMenu');
	contextMenu.addEventListener('popupshowing', onContextMenuShow);
	contextMenu.addEventListener('popuphiding', onContextMenuHide);
};

function undoContextMenu(window) {
	var contextMenu = window.document.getElementById('contentAreaContextMenu');
	contextMenu.removeEventListener('popupshowing', onContextMenuShow);
	contextMenu.removeEventListener('popuphiding', onContextMenuHide);
};

function onContextMenuShow(event) {
	if (event.target.id != 'contentAreaContextMenu')
		return;
	var contextMenu = event.target;
	var window = contextMenu.ownerGlobal;
/*	onContextMenuHide(event);
*/	var itemDomains = [];
	var refItem = window.document.getElementById('spell-separator');

	function frameScript() {
		function doContentWindow(win) {
			var domain = win.document.domain;
			if (domain) {
				sendAsyncMessage("BlockAutorefreshWhitelist@abx:Domain", domain);
			};
			for (var i = 0; i < win.frames.length; i++) {
				doContentWindow(win.frames[i]);
			};
		};
		doContentWindow(content);
	};

	var frameScriptURI = 'data:,(' + frameScript.toString() + ')()';

	function msgListener(message) {
		var domain = message.data;
		if (itemDomains.indexOf(domain) == -1) {
			if (itemDomains.length == 0)
				addSeparator();
			itemDomains.push(domain);
			addItem(domain);
		}
	};

	function addSeparator() {
		var separator = window.document.createElement('menuseparator');
		separator.id = 'refresh-separator';
		refItem.parentNode.insertBefore(separator, refItem);
	};

	function addItem(domain) {	
		var item = window.document.createElement('menuitem');
/*		item.className = 'refresh-whitelist-item';
*/		item.domain = domain;
		if (Services.prefs.getCharPref(prefWL).split(',').indexOf(domain) == -1) {
			item.setAttribute ('label', 'Weiterleitung freigeben: ' + domain);
			item.setAttribute ('oncommand', '\
				const prefWL = "extensions.block_autorefresh_whitelist.whitelist";\
				var wlDomains = Services.prefs.getCharPref(prefWL).split(",");\
				if (wlDomains[0] == "") {\
					/* preference value is empty string */ \
					wlDomains[0] = this.domain\
				} else {\
					wlDomains.push(this.domain)\
				};\
				Services.prefs.setCharPref(prefWL, wlDomains);');
		} else {
			item.setAttribute ('label', 'Weiterleitung sperren: ' + domain);
			item.setAttribute ('oncommand', '\
				const prefWL = "extensions.block_autorefresh_whitelist.whitelist";\
				var wlDomains = Services.prefs.getCharPref(prefWL).split(",");\
				var ind = wlDomains.indexOf(this.domain);\
				wlDomains.splice(ind, 1);\
				Services.prefs.setCharPref(prefWL, wlDomains);');
		};
		refItem.parentNode.insertBefore(item, refItem);
	};

	var tabMM = window.gBrowser.selectedBrowser.messageManager;
	tabMM.addMessageListener("BlockAutorefreshWhitelist@abx:Domain", msgListener);
	tabMM.loadFrameScript(frameScriptURI, false);

	contextMenu.addEventListener('popuphiding', function onHide(event) {
		if (event.target == contextMenu) {
			tabMM.removeMessageListener("BlockAutorefreshWhitelist@abx:Domain", msgListener);
			contextMenu.removeEventListener('popuphiding', onHide);
		};
	});
};

function onContextMenuHide(event) {
	if (event.target.id != 'contentAreaContextMenu')
		return;
	var window = event.target.ownerGlobal;
	var separator = window.document.getElementById('refresh-separator');
	if (!separator)
		return;
	var parent = separator.parentNode;
	var refItem = window.document.getElementById('spell-separator');
	while (separator.nextSibling != refItem)
		parent.removeChild(separator.nextSibling);
/*	var items = window.document.getElementsByClassName('refresh-whitelist-item');
	for (var item of items)
		parent.removeChild(item);
*/	parent.removeChild(separator);
};

var listenOpen = {
	observe: function(aSubject, aTopic, aData) {
		if (aTopic != 'domwindowopened')
			return;
		var window = aSubject;
		window.addEventListener('load', function onLoad() {		
			window.setTimeout(function() {
				if (window.location == 'chrome://browser/content/browser.xul') {
					if (!origRefrFuncStr)
						getOrigRefrFuncStr(window);
					setNewRefrFunc(window);
					if (Services.prefs.getBoolPref(prefCM))
						doContextMenu(window);
				};
				window.removeEventListener('load', onLoad);
			}, 0);
		});
	}
};

var prefChange = {
	observe: function(aSubject, aTopic, aData) {
		var isCMItems = Services.prefs.getBoolPref(prefCM);
		var windows = Services.wm.getEnumerator('navigator:browser');
		while (windows.hasMoreElements()) {
			var window = windows.getNext();
			if (isCMItems)
				doContextMenu(window)
			else
				undoContextMenu(window);
		};
	}
};

function install(data, reason) {
	if (reason == ADDON_INSTALL) {
		Services.prefs.setCharPref(prefWL, '');
		Services.prefs.setBoolPref(prefCM, false);
		Services.prefs.setIntPref(prefND, 0);
		Services.prefs.setBoolPref(prefMM, false);
	};
};

function uninstall(data, reason) {
	if (reason == ADDON_UNINSTALL) {
		Services.prefs.clearUserPref(prefWL);
		Services.prefs.clearUserPref(prefCM);
		Services.prefs.clearUserPref(prefND);
		Services.prefs.clearUserPref(prefEN);
		Services.prefs.clearUserPref(prefMM);
	};
};

function startup(data, reason) {
	if (reason == APP_STARTUP) {
		Services.prefs.setBoolPref(prefMM, false);
		origRefrFuncStr = null;
	} else {
		var window = Services.wm.getMostRecentWindow('navigator:browser');
		getOrigRefrFuncStr(window);
		var isCMItems = Services.prefs.getBoolPref(prefCM);
		var windows = Services.wm.getEnumerator('navigator:browser');
		while (windows.hasMoreElements()) {
			window = windows.getNext();
			setNewRefrFunc(window);
			if (isCMItems)
				doContextMenu(window);
		};
	};
	Services.prefs.setBoolPref(prefEN, true);
	Services.ww.registerNotification(listenOpen);
	Services.prefs.addObserver(prefCM, prefChange, false);

	if (!Services.prefs.getBoolPref(prefMM)) {

		var globalMM = Cc['@mozilla.org/globalmessagemanager;1'].getService(
			Ci.nsIMessageListenerManager);
		globalMM.loadFrameScript(
			"chrome://blockautorefreshwhitelist/content/tab-content-mod.js", true);
//		globalMM.broadcastAsyncMessage('BlockAutorefreshWhitelist:DoNotTabContent');
//	
		setTimeout(function() {
			Services.prefs.setBoolPref(prefMM, true);
		}, 100);

		var observeQuit = {
			observe: function(aSubject, aTopic, aData) {
				Services.prefs.setBoolPref(prefMM, false);
			}
		};
		Services.obs.addObserver(observeQuit, 'quit-application', false);
	};
};

function shutdown(data, reason) {
	if (reason == APP_SHUTDOWN) {
		// do nothing
	} else {
		var isCMItems = Services.prefs.getBoolPref(prefCM);
		var windows = Services.wm.getEnumerator('navigator:browser');
		while (windows.hasMoreElements()) {
			var window = windows.getNext();
			setOrigRefrFunc(window);
			if (isCMItems)
				undoContextMenu(window);
		};
		Services.ww.unregisterNotification(listenOpen);
		Services.prefs.removeObserver(prefCM, prefChange);
	};
	Services.prefs.setBoolPref(prefEN, false);
};
