// ==UserScript==
// @name           setCurrentProfileNameToTitlebar
// @namespace      http://space.geocities.yahoo.co.jp/gl/alice0775
// @description    Profilbezeichnung in der Titelleiste angezeigen
// @include        main
// @compatibility  Firefox 19 - 38.*
// @author         Alice0775
// @version        2012/12/31 00:00 Bug 818800 Remove the global private browsing service
// ==/UserScript==
// @version        2015/06/06 fix
// @version        2012/08/06 08:00 remove hack privatebrowsingUI
// @version        2010/09/25 23:00 Bug 598221 - Page Title not shown in Title Bar on Session Restore
// @version        2009/07/25 18:00 Bug 506437 -  The titlebar of a tear off window is not updated correctly after having detached a tab
// @version        2008/03/06 15:00
// @Note           Offizielle Win32 Version, Start und andere Profil-Optionen, bei Verwendung des Standardpfades.
(function() {
  if (location != 'chrome://browser/content/browser.xul')
    return;

  function getCurrentProfileName(){
    function readFile(aFile){
      var stream = Cc["@mozilla.org/network/file-input-stream;1"].createInstance(Ci.nsIFileInputStream);    
      stream.init(aFile, 0x01, 0, 0);
      var cvstream = Cc["@mozilla.org/intl/converter-input-stream;1"].createInstance(Ci.nsIConverterInputStream);
      cvstream.init(stream, "UTF-8", 1024, Ci.nsIConverterInputStream.DEFAULT_REPLACEMENT_CHARACTER);
      var content = "", data = {};
      while (cvstream.readString(4096, data)) {
        content += data.value;
      }
      cvstream.close();
      return content.replace(/\r\n?/g, "\n");
    }
    var PrefD = Components.classes["@mozilla.org/file/directory_service;1"].getService(Components.interfaces.nsIProperties).get("PrefD", Components.interfaces.nsIFile);
    var ini = Components.classes["@mozilla.org/file/directory_service;1"].getService(Components.interfaces.nsIProperties).get("AppRegD", Components.interfaces.nsIFile);
    ini.append("profiles.ini");
    var ini = readFile(ini);
    var profiles = ini.match(/Name=.+/g);
    var profilesD = ini.match(/Path=.+/g);
    for ( var i = 0; i < profiles.length;i++) {
      if ((profilesD[i]+"$").indexOf(PrefD.leafName+"$") >= 0) {
        profiles[i].match(/Name=(.+)$/);
        return RegExp.$1;
      }
    }
    return null;
  };
  
  try {  
    CustomizableUI.createWidget({
      id: 'profile-name',
      type: 'custom',
      defaultArea: CustomizableUI.AREA_MENUBAR,
      onBuild: function(aDocument) {
        var toolbaritem = aDocument.createElementNS('http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul', 'toolbaritem');
        toolbaritem.id = 'profile-name';
        toolbaritem.className = 'chromeclass-toolbar-additional';
        toolbaritem.setAttribute('label', 'Profil-Name');
        var label = document.createElement('label');
        label.setAttribute('value', getCurrentProfileName());
        toolbaritem.appendChild(label);
        return toolbaritem;
      }
    });
  } catch(e) { };
  
  var css = '\
		@-moz-document url("chrome://browser/content/browser.xul") { \
			#profile-name {margin-top: 5px; margin-bottom: -4px !important; font-weight: bold; font-size: 22px;\
			} \
		}';
	var cssUri = Services.io.newURI('data:text/css,' + encodeURIComponent(css), null, null);
	var SSS = Cc['@mozilla.org/content/style-sheet-service;1'].getService(Ci.nsIStyleSheetService);
	SSS.loadAndRegisterSheet(cssUri, SSS.AUTHOR_SHEET);
  
})();
