// Additional toolbars
// Buttons to turn toolbar On/Off, or switch toolbar position

// Use filename starting with 00 for custom button functions !! =>
// 00_extra_toolbars_V13.uc.js

// Bug: Both buttons included in the script must not be moved out of either any toolbars or the overflow menu!!!
// If you do so by accident, move the button back using the customization window, and restart

// Based on: https://www.camp-firefox.de/forum/thema/137714-seitennavigation-fly-out-menue
// Aris: https://github.com/Aris-t2/CustomJSforFx/blob/master/scripts/addonbar_vertical.uc.js// Latest versions and icons =>
// Forum topic: https://www.camp-firefox.de/forum/thema/139927-eigene-zusatzleisten-ab-ff-143/
// Kudos to Aris and Mitleser

// ATTENTION: Some system buttons can still be moved to additional/custom toolbars, but they will have no function.
// There is a patch by @BrokenHeart: https://www.camp-firefox.de/forum/thema/138875-fix-toolbar-buttons-reagieren-nicht-mehr-ab-ff-134/
// Different patch re. the issue by Aris included in this script, experimental

// Version V13 TEST!!!!

(function() {
    if (location.href !== 'chrome://browser/content/browser.xhtml')
        return;

// User settings
// After script changes, restart with Clear StartUp Cache => about:support

   // Custom Icons, expected in profile-name/chrome/icons folder ("icons" folder needs to be created)
        let ProfilePath = PathUtils.toFileURI(PathUtils.join(PathUtils.profileDir));
        let IconPath = '/chrome/icons/';

        // On/Off Button
        // Custom icon file
        let Icon_tb = 'toolbar_4.svg';
        // Firefox icon
        let Icon_tb_Fx = 'chrome://browser/skin/sidebars-right.svg';
        // false = use Firefox Icon, true = Custom Icon
        let new_tb_icon  = false;
        let ImagePath = ProfilePath + IconPath + Icon_tb;

        // Position switch button
        // Custom icon file
        let Icon_sw = 'toolbar_switch_4.svg';
        // Firefox icon
        let Icon_sw_Fx = 'chrome://global/skin/icons/arrow-right.svg';
        // false: use Firefox Icon, true: Custom Icon
        let new_tb_icon_sw  = false;
        let ImagePathSW = ProfilePath + IconPath + Icon_sw;

   // Custom background color: false = Off ; true = On (overwrites themes)
        let new_tb_color = false;
        // background color if true
        let new_tb_bg_color = 'hsla(200, 45%, 87%, 1)';

   // Border width, 0px = off
        let new_tb_border_width = '1px';
        // Border color
        //let new_tb_border_color = 'red';                                              // Fixed color
        //let new_tb_border_color = 'var(--sidebar-border-color)';                      // Firefox default
        let new_tb_border_color = 'color-mix(in srgb, currentColor 30%, transparent)';  // Custom self-adjusting color

// Size of toolbar and buttons changes, must be px values, all 3 settings are related ==>

        // Change button sizes via padding, 8px default
        let new_tb_btn_size = '6px';

        // Distance between buttons, 2px default
        let new_tb_distance = '5px';

        // Width vertical toolbar / height horizontal toolbar, increased by this value on both sides
        // Increase distance of buttons to edges, 0px => toolbar size = button size
        let new_tb_size = '1px';

// Expert mode ===>>>
// Saving changes, initial states ==>

   // true = save states toolbar On/Off / position on quitting Firefox, false = don't save (prefs deleted)
        // 2x restart required once after change, to make the the option stick
        let new_tb_save = true;

   // Initial state toolbar visibility: 0 = On, 1 = Off, only if new_tb_save = false (not saved)
        let new_tb_off = 0;
   // Position initial state: 0 = right, 1 = left, 2 = bottom, only if new_tb_save = false (not saved), or new_tb_btn_sw = false
        let new_tb_loc = 0;

   // Position Switch button: true = Show, false = Hide
        let new_tb_btn_sw = true;

   // Extra: false = Button switches toolbar On/Off / changes Position for all open windows ; true = only active window
        let new_tb_uno = false;       // On/Off Button
        let new_tb_uno_sw = false;    // Position button

// Possible problem solutions, if required, experimental ==>

   // Fix #1 for themes with low/ tiling background images, true / false, best to only use one of both
        let theme_fix = true;
        // Fix #2, overwrites Fix #1
        let theme_fix_2 = false;

   // Adjustments for Restore 'Space & Separator' items script for Firefox 102+ by Aris, true / false
        // https://github.com/Aris-t2/CustomJSforFx/blob/master/scripts/space_and_separator_restorer.uc.js
        let separator_fix = true;

// End of user settings

        if (Services.prefs.getBoolPref('svg.context-properties.content.enabled') == false) {
        	Services.prefs.setBoolPref('svg.context-properties.content.enabled', true );
        }

        const pref_newtoolbar_state = "userchrome.newtoolbar.enabled";

        let ntb_box = document.createXULElement('toolbox');
        ntb_box.id = 'toolbox_new';
        ntb_box.setAttribute('orient','horizontal');

        let ntb = document.createXULElement('toolbar');
        ntb.id = 'newtoolbar';
        ntb.setAttribute('customizable', true);
        ntb.setAttribute("class","toolbar-primary chromeclass-toolbar browser-toolbar customization-target");
        ntb.setAttribute('mode', 'icons');
        ntb.setAttribute('context', 'toolbar-context-menu');
        ntb.setAttribute('toolbarname', 'New Toolbar');
        ntb.setAttribute('label', 'New Toolbar');
        ntb.setAttribute('orient', 'vertical');
        ntb.setAttribute("accesskey","");

        ntb_box.appendChild(ntb);
        document.getElementById('browser').parentNode.appendChild(ntb_box);

        CustomizableUI.registerArea('newtoolbar', {legacy: true});
        CustomizableUI.registerToolbarNode(ntb);

        let observer_custom = new MutationObserver(function(mutations) {
          for (let mutation of mutations) {
            try {
              const customContainer = document.getElementById('customization-container');
              if (!customContainer) return;
              const rect = customContainer.getBoundingClientRect();
              document.getElementById('toolbox_new').style.setProperty('--height_newbar_c', rect.top + 'px');
            } catch (e) { }
          }
        });
        observer_custom.observe(document.querySelector('#main-window'), {
          attributes: true,
          attributeFilter: ['customizing'],
        });

        let navbar_size = document.getElementById("browser");
        let observer = new ResizeObserver(() => {
        let rect = navbar_size.getBoundingClientRect();
        document.getElementById('toolbox_new').style.setProperty('--height_newbar', rect.height + 'px');
        document.getElementById('toolbox_new').style.setProperty('--height_newbar_top', rect.top + 'px');
        });
        observer.observe(navbar_size);

    //On/Off button
    try {
        CustomizableUI.createWidget({
          id: 'NewToolbar_button',
          defaultArea: CustomizableUI.AREA_NAVBAR,
          tooltiptext: 'Toolbar On',
          label: 'Toggle New Toolbar',
          onBuild(doc) {
            let ntb_btn = doc.createXULElement('toolbarbutton');
            return ntb_btn;
          }
        });
    } catch(e) { }

    // Button function
     NewToolbar_button.addEventListener('click', event => {
        if (event.button === 0 ) {
          if (!new_tb_uno) {
            tb_toggle();
          }
          else {
            tb_toggle_uno();
          };
          if (NewToolbar_button.classList.contains("off-mode_btn")) {
             NewToolbar_button.setAttribute("tooltiptext", "Toolbar Off");
            }
          else {
            NewToolbar_button.setAttribute("tooltiptext", "Toolbar On");
          };
        }
     });

    function tb_toggle() {
       for (let win of Services.wm.getEnumerator("navigator:browser")) {
         const toolbar = win.document.getElementById("newtoolbar");
         const browserArea = win.document.getElementById("browser");
         const button = win.document.getElementById("NewToolbar_button");
         toolbar.classList.toggle("off-mode");
         browserArea.classList.toggle("off-mode_b");
         button.classList.toggle("off-mode_btn");
         const ntb_visible = !toolbar.classList.contains("off-mode");
         Services.prefs.setBoolPref(pref_newtoolbar_state, ntb_visible);
         }
    };

    function tb_toggle_uno() {
         newtoolbar.classList.toggle("off-mode");
         browser.classList.toggle("off-mode_b");
         NewToolbar_button.classList.toggle("off-mode_btn");
         const ntb_visible = !newtoolbar.classList.contains("off-mode");
         Services.prefs.setBoolPref(pref_newtoolbar_state, ntb_visible);
    };

    // Position initial state
    if (new_tb_loc === 0) {
         toolbox_new.classList.add("right_mode");
         browser.classList.add("right_mode_b");
         NewToolbar_button.classList.add("right_mode_btn");
       }
    else if (new_tb_loc === 1) {
         toolbox_new.classList.add("left_mode");
         browser.classList.add("left_mode_b");
         NewToolbar_button.classList.add("left_mode_btn");
       }
    else if (new_tb_loc === 2) {
         toolbox_new.classList.add("bottom_mode");
         browser.classList.add("bottom_mode_b");
         NewToolbar_button.classList.add("bottom_mode_btn");
       }

    let toolbarEnabled = true;
    try {
        toolbarEnabled = Services.prefs.getBoolPref(pref_newtoolbar_state);
    } catch(e) {
        Services.prefs.setBoolPref(pref_newtoolbar_state, new_tb_off === 0);
        toolbarEnabled = new_tb_off === 0;
    }
    if (!toolbarEnabled) {
        newtoolbar.classList.add("off-mode");
        browser.classList.add("off-mode_b");
        NewToolbar_button.classList.add("off-mode_btn");
        NewToolbar_button.setAttribute("tooltiptext", "Toolbar Off");
    }

    // Icon
    if (new_tb_icon) {
         NewToolbar_button.classList.add("icon_mode");
       }
    // Background color
    if (new_tb_color) {
         newtoolbar.classList.add("ntb_bg_color");
       }

    // Code by Aris => Attach handlers for buttons moved outside #navigator-toolbox
    // Based on: https://searchfox.org/firefox-main/source/browser/base/content/navigator-toolbox.js
    const customHandlers = {
    	  "unified-extensions-button": (el, e) => gUnifiedExtensions.togglePanel(e),
    	  "fxa-toolbar-menu-button":   (el, e) => gSync.toggleAccountPanel(el, e),
    	  "firefox-view-button":       (el, e) => FirefoxViewHandler.openToolbarMouseEvent(e),
    	  "downloads-button":          (el, e) => DownloadsIndicatorView.onCommand(e),
    	  "pageActionButton":          (el, e) => BrowserPageActions.mainButtonClicked(e),
    	  "alltabs-button":            (el, e) => gTabsPanel.showAllTabsPanel(e, "alltabs-button"),
    	  "library-button":            (el, e) => PanelUI.showSubView("appMenu-libraryView", el, e),
    	  "import-button":             (el, e) => MigrationUtils.showMigrationWizard(window, {
  	  entrypoint: MigrationUtils.MIGRATION_ENTRYPOINTS.BOOKMARKS_TOOLBAR,
  	  }),
    };
		document.getElementById("newtoolbar").addEventListener("mousedown", (e) => {
		  const button = e.target.closest("toolbarbutton");
		  if (button?.id && customHandlers[button.id]) customHandlers[button.id](button, e);
		});

// Position switch button
    const pref_position = "userchrome.newtoolbar.position";
    function getPositionPref() {
        try {
            return Services.prefs.getCharPref(pref_position);
        } catch (e) {
            return "right"; // Standardwert
        }
    }
    function setPositionPref(value) {
        Services.prefs.setCharPref(pref_position, value);
    }

    try {
        CustomizableUI.createWidget({
          id: 'NewToolbar_position',
          defaultArea: CustomizableUI.AREA_NAVBAR,
	  	    removable: true,
	  	    label: "Position New Toolbar", // button title
	  	    tooltiptext: 'Position New toolbar', // tooltip title
          onBuild(docs) {
            let btnsw = docs.createXULElement('toolbarbutton');
            return btnsw;
          }
        });
     } catch(e) { };

      // Context menu menuitem
      let refItemSW = document.createXULElement("menuitem");
    	refItemSW.setAttribute('id', 'NewToolbar_position_Con');
    	refItemSW.setAttribute('label', 'Toolbar Position');
      refItemSW.classList.add('menuitem-iconic');

    	let refItemSW_A = document.getElementById('toolbar-context-menu');

    	let refItemSW_S = document.querySelector('.viewCustomizeToolbar');
    	refItemSW_A.insertBefore(refItemSW, refItemSW_S);

      let menuseparator_sw = document.createXULElement("menuseparator");
    	menuseparator_sw.setAttribute('id', 'sw_sep');
    	refItemSW_A.insertBefore(menuseparator_sw, refItemSW.nextSibling);

      NewToolbar_position_Con.addEventListener('click', event => {
         if (event.button === 0 ) {
           if (!new_tb_uno_sw) {
             poser();
           }
           else {
             poser_uno();
           };
         }
      });

     function applyPosition(pos) {
        toolbox_new.classList.remove("left_mode", "bottom_mode", "right_mode");
        browser.classList.remove("left_mode_b", "bottom_mode_b", "right_mode_b");
        NewToolbar_button.classList.remove("left_mode_btn", "bottom_mode_btn", "right_mode_btn");
        NewToolbar_position.classList.remove("left_mode_sw", "bottom_mode_sw", "right_mode_sw");
        NewToolbar_position_Con.classList.remove("left_mode_sw", "bottom_mode_sw", "right_mode_sw");
        if (pos === "left") {
            toolbox_new.classList.add("left_mode");
            browser.classList.add("left_mode_b");
            NewToolbar_button.classList.add("left_mode_btn");
            NewToolbar_position.classList.add("left_mode_sw");
            NewToolbar_position_Con.classList.add("left_mode_sw");
        } else if (pos === "bottom") {
            toolbox_new.classList.add("bottom_mode");
            browser.classList.add("bottom_mode_b");
            NewToolbar_button.classList.add("bottom_mode_btn");
            NewToolbar_position.classList.add("bottom_mode_sw");
            NewToolbar_position_Con.classList.add("bottom_mode_sw");
        } else if (pos === "right") {
            toolbox_new.classList.add("right_mode");
            browser.classList.add("right_mode_b");
            NewToolbar_button.classList.add("right_mode_btn");
            NewToolbar_position.classList.add("right_mode_sw");
            NewToolbar_position_Con.classList.add("right_mode_sw");
        }
     }
     let savedPos = getPositionPref();
     applyPosition(savedPos);

    // Button function
     NewToolbar_position.addEventListener('click', event => {
        if (event.button === 0 ) {
          if (!new_tb_uno_sw) {
            poser();
          }
          else {
            poser_uno();
          };
        }
     });

     function poser() {
			 for (let win of Services.wm.getEnumerator("navigator:browser")) {
           const toolbox = win.document.getElementById("toolbox_new");
           const browserArea = win.document.getElementById("browser");
           const button = win.document.getElementById("NewToolbar_button");
           const button_sw = win.document.getElementById("NewToolbar_position");
           const button_con = win.document.getElementById("NewToolbar_position_Con");
           if (toolbox.classList.contains("right_mode")) {
                toolbox.classList.replace("right_mode", "left_mode");
                browserArea.classList.replace("right_mode_b", "left_mode_b");
                button.classList.replace("right_mode_btn", "left_mode_btn");
                button_sw.classList.replace("right_mode_sw", "left_mode_sw");
                button_con.classList.replace("right_mode_sw", "left_mode_sw");
                setPositionPref("left");
               }
           else if (toolbox.classList.contains("left_mode")) {
                toolbox.classList.replace("left_mode", "bottom_mode");
                browserArea.classList.replace("left_mode_b", "bottom_mode_b");
                button.classList.replace("left_mode_btn", "bottom_mode_btn");
                button_sw.classList.replace("left_mode_sw", "bottom_mode_sw");
                button_con.classList.replace("left_mode_sw", "bottom_mode_sw");
                setPositionPref("bottom");
               }
           else if (toolbox.classList.contains("bottom_mode")) {
                toolbox.classList.replace("bottom_mode", "right_mode");
                browserArea.classList.replace("bottom_mode_b", "right_mode_b");
                button.classList.replace("bottom_mode_btn", "right_mode_btn");
                button_sw.classList.replace("bottom_mode_sw", "right_mode_sw");
                button_con.classList.replace("bottom_mode_sw", "right_mode_sw");
                setPositionPref("right");
               }
             }
           };

     function poser_uno() {
           if (toolbox_new.classList.contains("right_mode")) {
                toolbox_new.classList.replace("right_mode", "left_mode");
                browser.classList.replace("right_mode_b", "left_mode_b");
                NewToolbar_button.classList.replace("right_mode_btn", "left_mode_btn");
                NewToolbar_position.classList.replace("right_mode_sw", "left_mode_sw");
                NewToolbar_position_Con.classList.replace("right_mode_sw", "left_mode_sw");
                setPositionPref("left");
               }
           else if (toolbox_new.classList.contains("left_mode")) {
                toolbox_new.classList.replace("left_mode", "bottom_mode");
                browser.classList.replace("left_mode_b", "bottom_mode_b");
                NewToolbar_button.classList.replace("left_mode_btn", "bottom_mode_btn");
                NewToolbar_position.classList.replace("left_mode_sw", "bottom_mode_sw");
                NewToolbar_position_Con.classList.replace("left_mode_sw", "bottom_mode_sw");
                setPositionPref("bottom");
               }
           else if (toolbox_new.classList.contains("bottom_mode")) {
                toolbox_new.classList.replace("bottom_mode", "right_mode");
                browser.classList.replace("bottom_mode_b", "right_mode_b");
                NewToolbar_button.classList.replace("bottom_mode_btn", "right_mode_btn");
                NewToolbar_position.classList.replace("bottom_mode_sw", "right_mode_sw");
                NewToolbar_position_Con.classList.replace("bottom_mode_sw", "right_mode_sw");
                setPositionPref("right");
               }
           };

    // Icon
    if (new_tb_icon_sw) {
         NewToolbar_position.classList.add("icon_mode_sw");
         NewToolbar_position_Con.classList.add("icon_mode_sw");
       }

    // Hide switch button
    if (!new_tb_btn_sw) {
        NewToolbar_position.style.setProperty('display', 'none');
    }

    // On quitting Firefox: delete Prefs, if new_tb_save = false
    if (!new_tb_save) {
         Services.obs.addObserver(function observer(subject, topic, data) {
             if (topic === "quit-application-granted") {
                 try {
                     Services.prefs.clearUserPref(pref_newtoolbar_state);
                     Services.prefs.clearUserPref(pref_position);
                 } catch (e) { }
                 Services.obs.removeObserver(observer, "quit-application-granted");
             }
         }, "quit-application-granted");
      };

let css =`

#main-window {
    --ug-newbar_basewidth: calc(2 * ${new_tb_btn_size} + 16px);  /* Minimalgroesse = Groesse Buttons */
    --ug-newbar_width: calc(var(--ug-newbar_basewidth) + ${new_tb_border_width} + 2 * `+new_tb_size+`);
}

/*- Buttons -*/

/* Buttons sizes */
#newtoolbar {
    --toolbarbutton-inner-padding: ${new_tb_btn_size} !important;
	 	--toolbarbutton-outer-padding: 0px !important;
}
/*  On/Off Button  */
#NewToolbar_button .toolbarbutton-icon {
    list-style-image: url("${Icon_tb_Fx}");
}
#NewToolbar_button.icon_mode .toolbarbutton-icon {
    list-style-image: url("${ImagePath}");
}
#NewToolbar_button.off-mode_btn:not(:hover, :active) .toolbarbutton-icon {
    opacity: 0.4;
}
/*  Switch Button  */
#NewToolbar_position .toolbarbutton-icon {
    list-style-image: url("${Icon_sw_Fx}");
}
#NewToolbar_position.icon_mode_sw .toolbarbutton-icon {
    list-style-image: url("${ImagePathSW}");
}
/*  Button adjustments to Toolbar Position  */
:is(#NewToolbar_button.left_mode_btn, #NewToolbar_position.left_mode_sw) .toolbarbutton-icon,
#NewToolbar_position_Con.left_mode_sw :is(image, img) {
    transform: rotate(180deg);
}
:is(#NewToolbar_button.bottom_mode_btn, #NewToolbar_position.bottom_mode_sw) .toolbarbutton-icon,
#NewToolbar_position_Con.bottom_mode_sw :is(image, img) {
    transform: rotate(90deg);
}

#NewToolbar_position_Con {
    -moz-context-properties: fill, fill-opacity !important;
    fill: currentColor !important;
}

#NewToolbar_position_Con :is(image, img) {
    list-style-image: url("${Icon_sw_Fx}");
    content: url("${Icon_sw_Fx}") !important;
}
#NewToolbar_position_Con.icon_mode_sw :is(image, img) {
    list-style-image: url("${ImagePathSW}");
    content: url("${ImagePathSW}") !important;
}

#unified-extensions-button[hidden] {
    visibility: visible !important;
    display: flex !important;
}

/*--  Browser adjustments  --*/

#browser.right_mode_b {
    transition: padding-right 0.25s ease !important;
}
#browser.left_mode_b {
    transition: padding-left 0.25s ease !important;
}
#browser.bottom_mode_b {
    transition: padding-bottom 0.25s ease !important;
}
#browser:not(.off-mode_b).right_mode_b {
    padding-right: var(--ug-newbar_width) !important;
}
#browser:not(.off-mode_b).left_mode_b {
    padding-left: var(--ug-newbar_width) !important;
}
#browser:not(.off-mode_b).bottom_mode_b {
    padding-bottom: var(--ug-newbar_width) !important;
}

/*--  Basics / Right  --*/

#toolbox_new {
    position: fixed;
    z-index: 2 !important;
    display: flex;
    width: fit-content;
    top: var(--height_newbar_top);
    right: 0px;
}
#newtoolbar {
    display: flex;
    min-width: var(--ug-newbar_basewidth) !important;
    width: var(--ug-newbar_width) !important;
    min-height: var(--ug-newbar_basewidth) !important;
    height: var(--height_newbar) !important;
    align-items: center !important;
    overflow: hidden !important;
    padding-block: 8px;
    border-width: 0px;
    border-style: solid !important;
    border-color: ${new_tb_border_color} !important;
    border-left-width: ${new_tb_border_width};
    border-right-width: 0px;
    margin-inline: 0px;
}

#toolbox_new:not(.bottom_mode) #newtoolbar:not([customizing]) {
    max-width: var(--ug-newbar_width) !important;
    transition: width 0.25s ease, max-width 0.25s ease, min-width 0.25s ease, border-left-width 0.125s ease;
}

#toolbox_new #newtoolbar:not([customizing]).off-mode {
    min-width: 0px !important;
    width: 0px !important;
    max-width: 0px !important;
    min-height: unset !important;
    max-height: unset !important;
    border-width: 0px !important;
    box-shadow: none !important;
}

#newtoolbar:not([customizing]).off-mode > :is(.toolbarbutton-1, toolbaritem) {
    opacity: 0 !important;
}
#newtoolbar > :is(.toolbarbutton-1, toolbaritem),
#newtoolbar toolbarpaletteitem > :is(.toolbarbutton-1, toolbaritem) {
    margin-block: ${new_tb_distance} !important;
    margin-inline: var(--toolbarbutton-outer-padding) !important;
    transition: opacity 0.125s ease;
}

/*--  Left  --*/

#toolbox_new.left_mode {
    right: unset;
    left: 0px;
}
#toolbox_new.left_mode #newtoolbar:not([customizing]) {
    border-left-width: 0px;
    border-right-width: ${new_tb_border_width};
    transition: width 0.25s ease, max-width 0.25s ease, min-width 0.25s ease, border-right-width 0.125s ease;
}

/*--  Bottom  --*/

#toolbox_new.bottom_mode {
    top: unset;
    bottom: 0px;
}
#toolbox_new.bottom_mode #newtoolbar:not([customizing]) {
    flex-direction: row !important;
    min-height: 0px !important;
    height: var(--ug-newbar_width) !important;
    max-height: var(--ug-newbar_width) !important;
    min-width: 0px !important;
    width: 100vw !important;
    padding-block: 0px;
    padding-inline: 8px;
    border-inline-width: 0px;
    border-top-width: ${new_tb_border_width};
    /*justify-content: center !important;*/    /* Inhalt mittig, optional */
    transition: height 0.25s ease, max-height 0.25s ease, min-height 0.25s ease, border-top-width 0.125s ease !important;
}
#toolbox_new.bottom_mode #newtoolbar:not([customizing]).off-mode {
    min-height: 0px !important;
    height: 0px !important;
    max-height: 0px !important;
    max-width: unset !important;
}
#toolbox_new.bottom_mode #newtoolbar:not([customizing]) > :is(.toolbarbutton-1, toolbaritem),
#toolbox_new.bottom_mode #newtoolbar:not([customizing]) toolbarpaletteitem > :is(.toolbarbutton-1, toolbaritem) {
    margin-block: var(--toolbarbutton-outer-padding) !important;
    margin-inline: ${new_tb_distance} !important;
}

/*--  Fullscreen  --*/

/* Mac / nur Video Fullscreen */
#main-window[inDOMFullscreen]:not([customizing]) #toolbox_new {
    visibility: collapse !important;
}
#main-window[inDOMFullscreen]:not([customizing]) #browser {
    padding: 0 !important;
}
/* Windows Fullscreen Video + Normal */
@media (-moz-platform: windows) {
#main-window[inFullscreen]:not([customizing]) #toolbox_new {
    visibility: collapse !important;
}
#main-window[inFullscreen]:not([customizing]) #browser {
    padding: 0 !important;
}
}

/*--  customizing  --*/

#main-window[customizing] #toolbox_new {
    top: unset !important;
    bottom: 0 !important;
    right: 0 !important;
    left: unset !important;
}
#newtoolbar[customizing] {
    height: calc(100vh - var(--height_newbar_c)) !important;
    box-shadow: inset 0px 1px ${new_tb_border_color};
    transition: none !important;
}
#main-window:not([customizing]) #newtoolbar[customizing].off-mode {
    min-width: 0px !important;
    width: 0px !important;
    min-height: 0px !important;
    height: 0px !important;
    border-width: 0px !important;
}
#customization-container {
    margin-right: var(--ug-newbar_width) !important;
}

/*-  Background oolors themes  -*/

/* Custom toolbar background color if enabled */
#newtoolbar.ntb_bg_color {
    background-color: ${new_tb_bg_color} !important;
}

/*- Background themes, if background images are tiled, try theme_fix options above -*/

:root[lwtheme] #newtoolbar:not(.ntb_bg_color) {
    background-color: var(--lwt-accent-color, var(--toolbar-bgcolor)) !important;
}
:root[lwtheme][lwtheme-image] #newtoolbar:not(.ntb_bg_color) {
    background-image: var(--lwt-header-image) !important;
    background-position: right 0px top 0px !important;
}

/* Icon colors */
/*
.squareClass {
    fill: green;
}
.strichClass {
    fill: purple;
}
.strichClassW {
    fill: cyan;
}
.arrowClass {
    fill: orange;
}
*/

  `;

if (theme_fix) {
  css += `
/*-  Fix #1 for themes with tiled background images  -*/

:root[lwtheme][lwtheme-image] #newtoolbar:not(.ntb_bg_color) {
    background: var(--lwt-header-image) !important;
    background-repeat: no-repeat !important;
    background-size: cover !important;
    background-position: right 0px top 0px !important;
}
:root[lwtheme][lwtheme-image] #toolbox_new.bottom_mode #newtoolbar:not(.ntb_bg_color) {
    background-size: auto !important;
}
 `;
}

if (theme_fix_2) {
  css += `
/*-  Fix #2 for themes with tiled background images  -*/

:root[lwtheme][lwtheme-image] #toolbox_new #newtoolbar:not(.ntb_bg_color) {
     background: transparent !important;
}
:root[lwtheme][lwtheme-image] #newtoolbar:not(.ntb_bg_color)::before {
    content: "" ;
    position: absolute;
    top: 0;
    right: 0;
    width: var(--height_newbar) !important;
    height: var(--ug-newbar_width) !important;
    pointer-events: none;
    z-index: -1 !important;
    background: var(--lwt-header-image) !important;
    background-repeat: no-repeat !important;
    transform: rotate(-90deg) translateX(var(--ug-newbar_width)) !important;
    transform-origin: 100% 100% !important;
    transition: margin 0.25s ease;
}
:root[lwtheme][lwtheme-image] #toolbox_new.bottom_mode #newtoolbar:not(.ntb_bg_color, [customizing])::before {
    transform: scaleX(-1) !important;
    transform-origin: 50% 50% !important;
    width: 100% !important;
}
:root[lwtheme][lwtheme-image] #newtoolbar:not(.ntb_bg_color)[customizing]::before {
    width: calc(100vh - var(--height_newbar_c)) !important;
}
#newtoolbar:not([customizing]).off-mode::before {
    min-width: 0px !important;
    margin-inline: 0px calc(0px - var(--ug-newbar_width));
}
#toolbox_new.left_mode #newtoolbar:not([customizing]).off-mode::before {
    margin-inline: calc(0px - var(--ug-newbar_width)) 0;
}
#toolbox_new.bottom_mode #newtoolbar:not([customizing]).off-mode::before {
    min-height: 0px !important;
    margin-inline: 0px;
    margin-block: 0px calc(0px - var(--ug-newbar_width)) !important;
}
 `;
}

if (separator_fix) {
  css += `
/* Adjustments for Separator Scripts  */

#newtoolbar toolbarseparator {
    width: calc(var(--ug-newbar_width) - ${new_tb_border_width} - 6px) !important;
    margin: 5px 0px !important;
    border-block-color: hsl(0, 0%, 0%, 0.45) hsl(0, 0%, 100%, 0.55) !important;
    transition: width 0.125s ease !important;
}
#newtoolbar :is(toolbarspacer, toolbarspring, toolbarseparator) {
    min-width: 0px !important;
}
#newtoolbar:not([customizing]).off-mode toolbarseparator {
    width: 0px !important;
}
#toolbox_new.bottom_mode #newtoolbar:not([customizing]) toolbarseparator {
    transform: rotate(-90deg) !important;
    margin: 0px !important;
}
#newtoolbar[customizing] toolbarseparator {
    margin-block: 16px !important;
}
 `;
}

  const sss = Cc['@mozilla.org/content/style-sheet-service;1'].getService(Ci.nsIStyleSheetService);
  const uri = Services.io.newURI('data:text/css,' + encodeURIComponent(css));
  sss.loadAndRegisterSheet(uri, sss.AGENT_SHEET);

})();
