// Zusaetzliche Toolbars wahlweise rechts, links, unten

// Use filename starting with 00 for custom button functions !! =>
// 00_extra_toolbars_V11.uc.js

// Basiert auf: https://www.camp-firefox.de/forum/thema/137714-seitennavigation-fly-out-menue
// Aris: https://github.com/Aris-t2/CustomJSforFx/blob/master/scripts/addonbar_vertical.uc.js
// Forumthema: https://www.camp-firefox.de/forum/thema/139927-eigene-zusatzleisten-ab-ff-143/
// Kudos an Aris und Mitleser fuer Vorarbeit, Loesungen und Tips

// ACHTUNG: Einige Systembuttons lassen sich in zusaetzliche/eigene Tb's zwar noch verschieben, haben aber KEINE Funktion.
// Dazu gibt es einen Patch von @BrokenHeart:  https://www.camp-firefox.de/forum/thema/138875-fix-toolbar-buttons-reagieren-nicht-mehr-ab-ff-134/

// Version V11 / Release 6

(function() {
    if (location.href !== 'chrome://browser/content/browser.xhtml')
        return;

// User Einstellungen
// Nach Script Aenderungen Neustart mit Start-Cache loeschen => about:support
// Moegliche Problemloesungen (s. unten) muessen wo noetig manuell an/ausgeschaltet werden

        // Eigenes Icon, in Profilordner/chrome/icons Ordner
        let ProfilePath = PathUtils.toFileURI(PathUtils.join(PathUtils.profileDir));
        let IconPath = '/chrome/icons/';

        let Icon_tb = 'toolbar_n3.svg';        // on/off Button
        let ImagePath = ProfilePath + IconPath + Icon_tb;

        let Icon_sw = "flower-satt32.png"      // Position switch Button
        let ImagePathSW = ProfilePath + IconPath + Icon_sw;

        // 0 Firefox Icon, 1 eigenes Icon benutzen
        let new_tb_icon  = 0;        // on/off Button
        let new_tb_icon_sw  = 0;     // Position switch Button

        // Position Startzustand: 0 Rechts, 1 Links, 2 Bottom
        let new_tb_loc = 0;

        // 0 letzter Zustand Leiste On/Off beim Beenden merken, 1 nicht merken
        // 2x Neustart noetig, nur beim ersten Neuspeichern dieser Einstellung
        let new_tb_save = 0;

        // 0 Startzustand Leiste On, 1 Startzustand Off, bei new_tb_save = 1
        let new_tb_off = 0;

        // 0 Button schaltet Leiste fuer alle Fenster, 1 nur aktives Fenster
        let new_tb_uno = 0;

        // Eigene Hintergrundfarbe: 0 Off, 1 On
        let new_tb_color = 0;
        // Hintergrundfarbe bei On
        let new_tb_bg_color = 'lightblue';

        // Trennlinie Breite, 0px = off
        let new_tb_border_width = '1px';
        // Trennlinie Farbe
        //let new_tb_border_color = 'red';
        let new_tb_border_color = 'color-mix(in srgb, currentColor 30%, transparent)';

// Groessen von Leiste und Buttons aendern, muss px Wert sein, auch bei 0px, manuell

        // Groesse Buttons via padding aendern, 8px Standard; Abstand, Leistengroesse wird mit geaendert
        let new_tb_btn_size = '6px';

        // Abstand zwischen Buttons, 2px Standard
        let new_tb_distance = '5px';

        // Breite vertikale Leiste / Hoehe horizontale Leiste um diesen Wert erhoehen, bei 0px => Leistengroesse = Buttongroesse
        let new_tb_size = '1px';

// Moegliche Problemloesungen, nur falls noetig, experimentell

        // Fix #1 fuer Themes mit zu niedrigen/ gekachelten Hintergrund Bildern, true / false, besser nur eines benutzen
        let theme_fix = false;
        // Fix #2, ueberschreibt Fix #1
        let theme_fix_2 = false;

        // Anpassung fuer Restore 'Space & Separator' items script for Firefox 102+ by Aris, true / false
        // https://github.com/Aris-t2/CustomJSforFx/blob/master/scripts/space_and_separator_restorer.uc.js
        // Tip: Separator, Space etc. im Anpassenfenster nur mit Rechtsklick aus Leiste entfernen
        let separator_fix = false;

// User Einstellungen Ende

        if (Services.prefs.getBoolPref('svg.context-properties.content.enabled') == false) {
        	Services.prefs.setBoolPref('svg.context-properties.content.enabled', true );
        }

        const pref_newtoolbar_state = "userchrome.newtoolbar.enabled";

        let toolbox_new = document.createXULElement('toolbox');
        toolbox_new.setAttribute('id','toolbox_new');
        toolbox_new.setAttribute('orient','horizontal');

        let ntb = document.createXULElement('toolbar');
        ntb.id = 'newtoolbar';
        ntb.setAttribute('customizable', true);
        ntb.setAttribute("class","toolbar-primary chromeclass-toolbar browser-toolbar customization-target");
        ntb.setAttribute('mode', 'icons');
        ntb.setAttribute('context', 'toolbar-context-menu');
        ntb.setAttribute('toolbarname', 'Addon Bars');
	      ntb.setAttribute('label', 'Addon Bars');
        ntb.setAttribute('orient', 'vertical');
        ntb.setAttribute("accesskey","");

	      toolbox_new.appendChild(ntb);
        document.getElementById('browser').parentNode.appendChild(toolbox_new);

        let observer_custom = new MutationObserver(function(mutations) {
          for (let mutation of mutations) {
            try {
              const customContainer = document.getElementById('customization-container');
              if (!customContainer) return;
              const rect = customContainer.getBoundingClientRect();
              document.getElementById('toolbox_new').style.setProperty('--height_newbar_c', rect.height + 'px');
            } catch (e) { }
          }
        });
        observer_custom.observe(document.querySelector('#main-window'), {
          attributes: true,
          attributeFilter: ['customizing'],
        });

        let navbar_size = document.getElementById("browser");
        let observer = new ResizeObserver(() => {
        let rect = navbar_size.getBoundingClientRect();
        document.getElementById('toolbox_new').style.setProperty('--height_newbar', rect.height + 'px');
        document.getElementById('toolbox_new').style.setProperty('--height_newbar_top', rect.top + 'px');
        });
        observer.observe(navbar_size);

        CustomizableUI.registerArea('newtoolbar', {legacy: true});
        CustomizableUI.registerToolbarNode(ntb);

      //On/off button
      try {
          CustomizableUI.createWidget({
              id: 'NewToolbar_button',
              type: 'custom',
              defaultArea: CustomizableUI.AREA_NAVBAR,
                  onBuild: function(aDocument) {
                      let toolbaritem = aDocument.createXULElement('toolbarbutton');
                      let props = {
                          id: 'NewToolbar_button',
                          class: 'toolbarbutton-1 chromeclass-toolbar-additional',
                          removable: true,
                          label: 'Toggle New Toolbar',
                          tooltiptext: 'Toggle New toolbar',
                      };
                      for(let p in props)
                          toolbaritem.setAttribute(p, props[p]);
                      return toolbaritem;
                  }
           });
       } catch(e) { }

    // Button Funktion
    if (new_tb_uno === 0) {
      document.getElementById('NewToolbar_button').addEventListener('click', tb_toggle );
      }
    else if (new_tb_uno === 1) {
      document.getElementById('NewToolbar_button').addEventListener('click', tb_toggle_uno );
    }

    function tb_toggle() {
      // let windows = Services.wm.getEnumerator(null);
		  //  while (windows.hasMoreElements()) {
      // 		  let win = windows.getNext();
			 for (let win of Services.wm.getEnumerator("navigator:browser")) {
       if (event.button === 0) {
         const toolbar = win.document.getElementById("newtoolbar");
         const browserArea = win.document.getElementById("browser");
         const button = win.document.getElementById("NewToolbar_button");

         toolbar.classList.toggle("off-mode");
         browserArea.classList.toggle("off-mode_b");
         button.classList.toggle("off-mode_btn");
         //browserArea.classList.remove("switch_mode");

         const ntb_visible = !toolbar.classList.contains("off-mode");
         Services.prefs.setBoolPref(pref_newtoolbar_state, ntb_visible);
         }
       }
    };

    function tb_toggle_uno() {
      if (event.button === 0) {
           const toolbar = document.getElementById("newtoolbar");
           const browserArea = document.getElementById("browser");
           const button = document.getElementById("NewToolbar_button");

           toolbar.classList.toggle("off-mode");
           browserArea.classList.toggle("off-mode_b");
           button.classList.toggle("off-mode_btn");
           //browserArea.classList.remove("switch_mode");

           const ntb_visible = !toolbar.classList.contains("off-mode");
           Services.prefs.setBoolPref(pref_newtoolbar_state, ntb_visible);
           }
    };

		// Attach handlers for buttons moved outside #navigator-toolbox
	    // https://searchfox.org/firefox-main/source/browser/base/content/navigator-toolbox.js
	  //   const customHandlers = {
	  // 	  "unified-extensions-button": (el, e) => gUnifiedExtensions.togglePanel(e),
	  // 	  "fxa-toolbar-menu-button":   (el, e) => gSync.toggleAccountPanel(el, e),
	  // 	  "firefox-view-button":       (el, e) => FirefoxViewHandler.openToolbarMouseEvent(e),
	  // 	  "downloads-button":          (el, e) => DownloadsIndicatorView.onCommand(e),
	  // 	  "pageActionButton":          (el, e) => BrowserPageActions.mainButtonClicked(e),
	  // 	  "alltabs-button":            (el, e) => gTabsPanel.showAllTabsPanel(e, "alltabs-button"),
	  // 	  "library-button":            (el, e) => PanelUI.showSubView("appMenu-libraryView", el, e),
	  // 	  "import-button":             (el, e) => MigrationUtils.showMigrationWizard(window, {
	  // 	    entrypoint: MigrationUtils.MIGRATION_ENTRYPOINTS.BOOKMARKS_TOOLBAR,
	  // 	  }),
	  //   };
    //
		// document.getElementById("newtoolbar").addEventListener("mousedown", (e) => {
		//   const button = e.target.closest("toolbarbutton");
		//   if (button?.id && customHandlers[button.id]) customHandlers[button.id](button, e);
		// });

    // Position Startzustand
    if (new_tb_loc === 1) {
         toolbox_new.classList.add("left_mode");
         browser.classList.add("left_mode_b");
         NewToolbar_button.classList.add("left_mode_btn");
         //NewToolbar_position.classList.add("left_mode_sw");
       }
    else if (new_tb_loc === 2) {
         toolbox_new.classList.add("bottom_mode");
         browser.classList.add("bottom_mode_b");
         NewToolbar_button.classList.add("bottom_mode_btn");
         //NewToolbar_position.classList.add("bottom_mode_sw");
       }

    let toolbarEnabled = true;
    try {
        toolbarEnabled = Services.prefs.getBoolPref(pref_newtoolbar_state);
    } catch(e) {
        Services.prefs.setBoolPref(pref_newtoolbar_state, new_tb_off === 0);
        toolbarEnabled = new_tb_off === 0;
    }

    if (!toolbarEnabled) {
        newtoolbar.classList.add("off-mode");
        browser.classList.add("off-mode_b");
        NewToolbar_button.classList.add("off-mode_btn");
    }


// ///////////// Position Switch button, Funktion nur in aktivem Fenster, wird gespeichert /////////////////////////////

    const pref_position = "userchrome.newtoolbar.position";

    function getPositionPref() {
        try {
            return Services.prefs.getCharPref(pref_position);
        } catch (e) {
            //return "left"; // Standardwert
            return "right"; // Standardwert
        }
    }

    function setPositionPref(value) {
        Services.prefs.setCharPref(pref_position, value);
    }

    try {
         CustomizableUI.createWidget({
             id: 'NewToolbar_position',
             type: 'custom',
             defaultArea: CustomizableUI.AREA_NAVBAR,
                 onBuild: function(aDocument) {
                     let toolbaritem = aDocument.createXULElement('toolbarbutton');
                     let props = {
                         id: 'NewToolbar_position',
                         class: 'toolbarbutton-1 chromeclass-toolbar-additional',
                         removable: true,
                         label: 'Position New Toolbar',
                         tooltiptext: 'Position New toolbar',
                     };
                     for(let p in props)
                         toolbaritem.setAttribute(p, props[p]);
                     return toolbaritem;
                 }
         });

     } catch(e) { };

    function applyPosition(pos) {
        toolbox_new.classList.remove("left_mode", "bottom_mode", "right_mode");
        browser.classList.remove("left_mode_b", "bottom_mode_b", "right_mode_b");
        NewToolbar_button.classList.remove("left_mode_btn", "bottom_mode_btn", "right_mode_btn");
        NewToolbar_button.classList.remove("left_mode_sw", "bottom_mode_sw", "right_mode_sw");

        if (pos === "left") {
            toolbox_new.classList.add("left_mode");
            browser.classList.add("left_mode_b");
            NewToolbar_button.classList.add("left_mode_btn");
            NewToolbar_position.classList.add("left_mode_sw");
        } else if (pos === "bottom") {
            toolbox_new.classList.add("bottom_mode");
            browser.classList.add("bottom_mode_b");
            NewToolbar_button.classList.add("bottom_mode_btn");
            NewToolbar_position.classList.add("bottom_mode_sw");
        } else if (pos === "right") {
            toolbox_new.classList.add("right_mode");
            browser.classList.add("right_mode_b");
            NewToolbar_button.classList.add("right_mode_btn");
            NewToolbar_position.classList.add("right_mode_sw");
        }
    }

    let savedPos = getPositionPref();
    applyPosition(savedPos);

     document.getElementById('NewToolbar_position').addEventListener('click', event => {
      if (event.button === 0 ) {
          poser();
          browser.classList.add("switch_mode");
          toolbox_new.classList.add("switch_mode");
          setTimeout(() => {
             browser.classList.remove("switch_mode");
             toolbox_new.classList.remove("switch_mode");
          },100);
        }
      });

     function poser() {
           if (toolbox_new.classList.contains("left_mode")) {
                toolbox_new.classList.replace("left_mode", "bottom_mode");
                browser.classList.replace("left_mode_b", "bottom_mode_b");
                NewToolbar_button.classList.replace("left_mode_btn", "bottom_mode_btn");
                NewToolbar_position.classList.replace("left_mode_sw", "bottom_mode_sw");
                setPositionPref("bottom");
               }
           else if (toolbox_new.classList.contains("bottom_mode")) {
                toolbox_new.classList.remove("bottom_mode");
                browser.classList.remove("bottom_mode_b");
                NewToolbar_button.classList.remove("bottom_mode_btn");
                NewToolbar_position.classList.remove("bottom_mode_sw");
                setPositionPref("right");
               }
           else {
                toolbox_new.classList.add("left_mode");
                browser.classList.add("left_mode_b");
                NewToolbar_button.classList.add("left_mode_btn");
                NewToolbar_position.classList.add("left_mode_sw");
                setPositionPref("left");
               }
           };

       // Positions button automatisch in toolbar, optional
	     // newtoolbar.appendChild(NewToolbar_position);
       // NewToolbar_position.style.setProperty('order', '-1');
       //
       // let separator_2 = document.createElement("switch_separator");
	     // separator_2.setAttribute('id', 'switch_separator');
	     //separator_2.setAttribute('style', 'order: -1; margin-block: var(--ug-newbar_btnspace); background-color: color-mix(in srgb, currentColor 50%, transparent); width: calc(var(--ug-newbar_width) - var(--ug-newbar_borderwidth) - 6px); height: 1px;');

       // let refItem_sep = document.getElementById('NewToolbar_position');
	     // refItem_sep.parentNode.insertBefore(separator_2, refItem_sep.nextSibling);

       //let separator_2 = document.createXULElement("toolbarseparator");
	     // separator_2.setAttribute('id', 'position_sep');
	     // separator_2.setAttribute('style', 'order: -1; appearance: none; background-color: color-mix(in srgb, currentColor 50%, transparent); width: calc(var(--ug-newbar_width) - var(--ug-newbar_borderwidth) - 6px); height: 1px;');
       //
       // let refItem_sep = document.getElementById('NewToolbar_position');
	     // refItem_sep.parentNode.insertBefore(separator_2, refItem_sep.nextSibling);

    // Icons
    if (new_tb_icon === 1) {
         NewToolbar_button.classList.add("icon_mode");
       }
    if (new_tb_icon_sw === 1) {
         NewToolbar_position.classList.add("icon_mode_sw");
       }
    // Hintergrundfarbe
    if (new_tb_color === 1) {
         newtoolbar.classList.add("ntb_bg_color");
       }

    // #1 Beim Beenden von Firefox: Prefs loeschen, falls new_tb_save === 1
     if (new_tb_save === 1) {
         Services.obs.addObserver(function observer(subject, topic, data) {
             if (topic === "quit-application-granted") {
                 try {
                     Services.prefs.clearUserPref(pref_newtoolbar_state);
                     Services.prefs.clearUserPref(pref_position);
                 } catch (e) { }
                 Services.obs.removeObserver(observer, "quit-application-granted");
             }
         }, "quit-application-granted");
      }

let css =`

:root {
    --ug-newbar_basewidth: calc(2 * var(--ug-newbar-button_inner_padding) + 16px);
    --ug-newbar_width: calc(var(--ug-newbar_basewidth) + var(--ug-newbar_borderwidth) + 2 * var(--ug-newbar_add_width));

    --ug-newbar-button_inner_padding: ${new_tb_btn_size};         /* Groesse Buttons */
    --ug-newbar_add_width: `+new_tb_size+`;                       /* Breite / Hoehe erhoehen */
    --ug-newbar_btnspace: ${new_tb_distance};                     /* Abstand zw. Buttons */
    --ug-newbar_borderwidth: ${new_tb_border_width};              /* Breite / Hoehe Trennlinie */
}

/*- Buttons Groesse -*/
#newtoolbar {
    --toolbarbutton-inner-padding: var(--ug-newbar-button_inner_padding) !important;
	 	--toolbarbutton-outer-padding: 0px !important;
}

/*
#switch_separator {
    order: -1;
    margin-block: var(--ug-newbar_btnspace);
    background-color: color-mix(in srgb, currentColor 50%, transparent);
    width: calc(var(--ug-newbar_width) - var(--ug-newbar_borderwidth) - 6px);
    height: 1px;
}
.bottom_mode #newtoolbar:not([customizing]) #switch_separator {
    transform: rotate(-90deg) !important;
}
*/

/*-  On/Off Button  -*/
#NewToolbar_button .toolbarbutton-icon {
    list-style-image: url("chrome://browser/skin/sidebars-right.svg");
}
#NewToolbar_button.icon_mode .toolbarbutton-icon {
    list-style-image: url("${ImagePath}");
}
/*-  Switch Button  -*/
#NewToolbar_position .toolbarbutton-icon {
    list-style-image: url("chrome://global/skin/icons/chevron.svg");
}
#NewToolbar_position.icon_mode_sw .toolbarbutton-icon {
    list-style-image: url("${ImagePathSW}");
}

#NewToolbar_button.off-mode_btn:not(:hover, :active) .toolbarbutton-icon {
    opacity: 0.4;
}
#NewToolbar_button.left_mode_btn .toolbarbutton-icon,
#NewToolbar_position.left_mode_sw .toolbarbutton-icon {
    transform: rotate(180deg);
}
#NewToolbar_button.bottom_mode_btn .toolbarbutton-icon,
#NewToolbar_position.bottom_mode_sw .toolbarbutton-icon {
    transform: rotate(90deg);
}

/*--  Basis / Right  --*/

#browser:not(.switch_mode) {
    transition: padding 0.25s ease !important;
}
#browser:not(.off-mode_b) {
    padding-right: var(--ug-newbar_width) !important;
}

#toolbox_new.switch_mode #newtoolbar {
    transition: none !important;
}

#toolbox_new {
    position: fixed;
    z-index: 4 !important;
    display: flex;
    width: fit-content;
    top: var(--height_newbar_top);
    right: 0;
}
#newtoolbar {
    display: flex;
    min-width: var(--ug-newbar_basewidth) !important;
    width: var(--ug-newbar_width);
    min-height: var(--ug-newbar_basewidth) !important;
    height: var(--height_newbar) !important;
    align-items: center !important;
    padding-block: 8px;
    border: 0px solid ${new_tb_border_color};
    border-inline-width: var(--ug-newbar_borderwidth) 0px;
    transition: width 0.25s ease, min-width 0.25s ease, border-width 0.125s ease;
    box-shadow: none !important;
}
#newtoolbar:not([customizing]).off-mode {
    min-width: 0px !important;
    width: 0px !important;
    overflow: hidden !important;
    border-width: 0px !important;
}

#newtoolbar:not([customizing]).off-mode > :is(.toolbarbutton-1, toolbaritem) {
    opacity: 0 !important;
}

#newtoolbar > :is(.toolbarbutton-1, toolbaritem),
#newtoolbar toolbarpaletteitem > :is(.toolbarbutton-1, toolbaritem) {
    margin-block: var(--ug-newbar_btnspace) !important;
    transition: opacity 0.125s ease;
}

/*--  Left  --*/

#browser:not(.off-mode_b).left_mode_b {
    padding-inline: var(--ug-newbar_width) 0 !important;
}
#toolbox_new.left_mode {
    left: 0;
}
.left_mode #newtoolbar:not([customizing]) {
    border-inline-width: 0px var(--ug-newbar_borderwidth);
}

/*--  Bottom  --*/

#browser:not(.off-mode_b).bottom_mode_b {
    padding-inline: 0 !important;
    padding-bottom: var(--ug-newbar_width) !important;
}

#toolbox_new.bottom_mode {
    top: unset;
    bottom: 0;
}
.bottom_mode #newtoolbar:not([customizing]) {
    flex-direction: row !important;
    min-height: 0px !important;
    height: var(--ug-newbar_width) !important;
    min-width: 0px !important;
    width: 100vw !important;
    padding-block: 0;
    padding-inline: 8px;
    border-inline-width: 0px;
    border-top-width: var(--ug-newbar_borderwidth);
    /*justify-content: center !important;*/    /* Inhalt mittig, optional */
    transition: height 0.25s ease, min-height 0.25s ease, border-width 0.125s ease !important;
}
.bottom_mode #newtoolbar:not([customizing]).off-mode {
    min-height: 0px !important;
    height: 0px !important;
}

#toolbox_new.bottom_mode #newtoolbar > :is(.toolbarbutton-1, toolbaritem),
#toolbox_new.bottom_mode #newtoolbar toolbarpaletteitem > :is(.toolbarbutton-1, toolbaritem) {
    margin-block: var(--toolbarbutton-outer-padding) !important;
    margin-inline: var(--ug-newbar_btnspace) !important;
}

/*--  Fullscreen  --*/

/* Mac / nur Video Fullscreen */
#main-window[inDOMFullscreen]:not([customizing]) #toolbox_new {
    visibility: collapse !important;
}
#main-window[inDOMFullscreen]:not([customizing]) #browser {
    padding: 0 !important;
}

/* Windows Fullscreen Video + Normal */
@media (-moz-platform: windows) {
#main-window[inFullscreen]:not([customizing]) #toolbox_new {
    visibility: collapse !important;
}
#main-window[inFullscreen]:not([customizing]) #browser {
    padding: 0 !important;
}
}

/*--  customizing  --*/

:root[customizing] #toolbox_new {
    top: unset !important;
    bottom: 0 !important;
    right: 0 !important;
    left: unset !important;
}
#newtoolbar[customizing] {
    height: var(--height_newbar_c) !important;
}
#customization-container {
    margin-right: var(--ug-newbar_width) !important;
}

/*-  Farben Themes  -*/

/* Eigene HG Farbe falls eingeschaltet */
#newtoolbar.ntb_bg_color {
    background-color: ${new_tb_bg_color} !important;
}

/*- Farben Themes, falls Hintergrundbilder gekachelt, oben theme_fix versuchen -*/

:root[lwtheme] #newtoolbar:not(.ntb_bg_color) {
    background-color: var(--lwt-accent-color, var(--toolbar-bgcolor)) !important;
}
:root[lwtheme][lwtheme-image] #newtoolbar:not(.ntb_bg_color) {
    background-image: var(--lwt-header-image) !important;
    background-position: right 0px top 0px !important;
}

/*--  Testfarben  --*/
/*
#newtoolbar {
    border-block: 8px solid orange;
}
#newtoolbar > :is(.toolbarbutton-1, toolbaritem),
#newtoolbar toolbarpaletteitem > :is(.toolbarbutton-1, toolbaritem) {
    outline: 1px solid red;
    outline-offset: -1px;
}
*/

`;

if (theme_fix) {
  css += `

/*-  Fix #1 Hintergrundbilder fuer Themes mit gekachelten Bildern, falls eingeschaltet -*/
:root[lwtheme][lwtheme-image] #newtoolbar:not(.ntb_bg_color) {
    background: var(--lwt-header-image) !important;
    background-repeat: no-repeat !important;
    background-size: cover !important;
    background-position: right 0px top 0px !important;
}
:root[lwtheme][lwtheme-image] #toolbox_new.bottom_mode #newtoolbar:not(.ntb_bg_color) {
    background-size: auto !important;
}
 `;
}

if (theme_fix_2) {
  css += `
/*-  Fix #2 Hintergrundbilder fuer Themes mit gekachelten Bildern, falls eingeschaltet -*/
:root[lwtheme][lwtheme-image] #toolbox_new #newtoolbar:not(.ntb_bg_color) {
     background: transparent !important;
}
:root[lwtheme][lwtheme-image] #newtoolbar:not(.ntb_bg_color)::before {
    content: "" ;
    position: absolute;
    top: 0;
    right: 0;
    width: var(--height_newbar) !important;
    height: var(--ug-newbar_width) !important;
    pointer-events: none;
    z-index: -1 !important;
    background: var(--lwt-header-image) !important;
    background-repeat: no-repeat !important;
    /*background-position: left 0px top 100% !important;*/
    transform: rotate(-90deg) translateX(var(--ug-newbar_width)) !important;
    transform-origin: 100% 100% !important;
    /*transition: margin 0.25s ease;*/
    transition: width 0.25s ease, min-width 0.25s ease !important;
}
:root[lwtheme][lwtheme-image] #toolbox_new.bottom_mode #newtoolbar:not(.ntb_bg_color, [customizing])::before {
    transform: scaleX(-1) !important;
    transform-origin:  50% 50% !important;
    width: 100% !important;
}
/*
:root[lwtheme][lwtheme-image] #toolbox_new.left_mode #newtoolbar:not(.ntb_bg_color, [customizing])::before {
    transform: rotate(-90deg) translateY(calc(0px - var(--ug-newbar_width))) translateX(var(--ug-newbar_width)) scaleY(-1) !important;
}
*/

:root[lwtheme][lwtheme-image] #newtoolbar:not(.ntb_bg_color)[customizing]::before {
    width: var(--height_newbar_c) !important;
}

:root[lwtheme][lwtheme-image] #newtoolbar:not([customizing]).off-mode::before {
    min-width: 0px !important;
    width: 0px !important;
    min-height: 0px !important;
    height: 0px !important;
    /*margin-inline: 0 calc(0px - var(--ug-newbar_width));*/
}
.left_mode #newtoolbar:not([customizing]).off-mode::before {
    /*margin-inline: calc(0px - var(--ug-newbar_width)) 0;*/
}
.bottom_mode #newtoolbar:not([customizing]).off-mode::before {
    min-height: 0px !important;
    height: 0px !important;
    /*margin-inline: 0;
    margin-block: 0 calc(0px - var(--ug-newbar_width)) !important;*/
}
 `;
}

if (separator_fix) {
  css += `
/* Anpassung fuer Separator Scripts, falls eingeschaltet */
#newtoolbar toolbarseparator {
    margin: 6px 0 !important;
    width: calc(var(--ug-newbar_width) - var(--ug-newbar_borderwidth) - 6px) !important;
    max-width: var(--ug-newbar_width) !important;
    border-block-color: hsl(0, 0%, 0%, 0.55) hsl(0, 0%, 100%, 0.55) !important;
    /*background-color: color-mix(in srgb, currentColor 70%, transparent) !important;
    border: none !important;*/
}
#newtoolbar :is(toolbarspacer, toolbarspring, toolbarseparator) {
    min-width: 1px !important;
}
.bottom_mode #newtoolbar:not([customizing]) toolbarseparator {
    transform: rotate(-90deg) !important;
}
#newtoolbar[customizing] toolbarseparator {
    margin-block: 16px !important;
}
 `;
}

  const sss = Cc['@mozilla.org/content/style-sheet-service;1'].getService(Ci.nsIStyleSheetService);
  const uri = Services.io.newURI('data:text/css,' + encodeURIComponent(css));
  //const uri = Services.io.newURI('data:text/css,' + encodeURIComponent(''+ css + theme_fix_code + theme_fix_code_2 + separator_fix_code));
  sss.loadAndRegisterSheet(uri, sss.AGENT_SHEET);

})();
