// Zusaetzliche Toolbars wahlweise rechts, links, unten

// Use filename starting with 00 !! =>
// 00_extra_toolbars_V8.uc.js

// Basiert auf: https://www.camp-firefox.de/forum/thema/137714-seitennavigation-fly-out-menue
// Aris: https://github.com/Aris-t2/CustomJSforFx/blob/master/scripts/addonbar_vertical.uc.js
// Forum: https://www.camp-firefox.de/forum/thema/139927-eigene-zusatzleisten-ab-ff-143/

// ACHTUNG: Einige Systembuttons lassen sich in zusaetzliche/eigene Tb's zwar noch verschieben, haben aber KEINE Funktion.
// Dazu gibt es einen Patch von @BrokenHeart:  https://www.camp-firefox.de/forum/thema/138875-fix-toolbar-buttons-reagieren-nicht-mehr-ab-ff-134/
// Kudos an Mitleser fuer Vorarbeit, Loesungen und Tips
// ToDo: Themes Kompatibiltaet

// Nach Script Aenderungen Neustart mit Start-Cache loeschen => about:support

// Version V8 / Release 3

(function() {

    if (location.href !== 'chrome://browser/content/browser.xhtml')
        return;

// User Einstellungen

        // Eigenes Icon in Profilordner/chrome/icons Ordner
        let ProfilePath = PathUtils.toFileURI(PathUtils.join(PathUtils.profileDir));
        let IconPath = '/chrome/icons/';
        let Icon_tb = 'toolbar_n3.svg';
        let ImagePath = ProfilePath + IconPath + Icon_tb;

        // 0 Firefox Icon , 1 eigenes Icon benutzen
        let new_tb_icon  = 0;

        // Position Startzustand: 0 Rechts , 1 Links , 2 Bottom
        let new_tb_loc = 0;

        // 0 letzter Zustand Leiste On/Off beim Beenden merken , 1 nicht merken
        // 2x Neustart noetig, nur beim ersten Neuspeichern dieser Einstellung
        let new_tb_save = 0;

        // 0 Startzustand Leiste On , 1 Startzustand Off , falls nicht beim Beenden gespeichert
        let new_tb_off = 0;

        // 0 Button schaltet Leiste fuer alle Fenster , 1 nur aktives Fenster
        let new_tb_uno = 0;

        // Eigene Hintergrundfarbe: 0 Off , 1 On
        let new_tb_color = 0;
        // Hintergrundfarbe bei On
        let new_tb_bg_color = 'lightblue';

// Groessen von Leiste und Buttons aendern, muss px Wert sein, auch bei 0px

        // Groesse Buttons via padding aendern, 8px standard
        let new_tb_btn_size = '8px';

        // Abstand zw. Buttons
        let new_tb_distance = '2px';

        // Breite vertikale Leiste / Hoehe horizontale Leiste erhoehen, bei 0px Leistengroesse = Buttongroesse
        let new_tb_size = '0px';

        // Trennlinie Breite, 0px = off
        let new_tb_border_width = '1px';
        // Trennlinie Farbe
        let new_tb_border_color = 'var(--chrome-content-separator-color)';

// User Einstellungen Ende

        if (Services.prefs.getBoolPref('svg.context-properties.content.enabled') == false) {
        	Services.prefs.setBoolPref('svg.context-properties.content.enabled', true );
        }

        const pref_newtoolbar_state = "userchrome.newtoolbar.enabled";

        let toolbox_new = document.createXULElement('toolbox');
        toolbox_new.setAttribute('id','toolbox_new');

        let ntb = document.createXULElement('toolbar');
        ntb.id = 'newtoolbar';
        ntb.setAttribute('customizable', true);
        ntb.setAttribute("class","toolbar-primary chromeclass-toolbar browser-toolbar customization-target");
        ntb.setAttribute('mode', 'icons');
        ntb.setAttribute('context', 'toolbar-context-menu');

	      toolbox_new.appendChild(ntb);
        document.getElementById('browser').parentNode.appendChild(toolbox_new);

        let observer_custom = new MutationObserver(function(mutations) {
          for (let mutation of mutations) {
            try {
              const customContainer = document.getElementById('customization-container');
              if (!customContainer) return;
              const rect = customContainer.getBoundingClientRect();
              document.getElementById('toolbox_new').style.setProperty('--height_newbar_c', rect.height + 'px');
            } catch (e) {
              console.error("Fehler beim Setzen von --height_newbar_c:", e);
            }
          }
        });
        observer_custom.observe(document.querySelector('#main-window'), {
          attributes: true,
          attributeFilter: ['customizing'],
        });

        let navbar_size = document.getElementById("browser");
        let observer = new ResizeObserver(() => {
        let rect = navbar_size.getBoundingClientRect();
        document.getElementById('toolbox_new').style.setProperty('--height_newbar', rect.height + 'px');
        document.getElementById('toolbox_new').style.setProperty('--height_newbar_top', rect.top + 'px');
        });
        observer.observe(navbar_size);

        CustomizableUI.registerArea('newtoolbar', {legacy: true});

    	  setTimeout(function(){
    		CustomizableUI.registerArea('newtoolbar', {legacy: true});
    	  },2000);

        CustomizableUI.registerToolbarNode(ntb);

      //On/off button
      try {
          CustomizableUI.createWidget({
              id: 'NewToolbar_button',
              type: 'custom',
              defaultArea: CustomizableUI.AREA_NAVBAR,
                  onBuild: function(aDocument) {
                      let toolbaritem = aDocument.createXULElement('toolbarbutton');
                      let props = {
                          id: 'NewToolbar_button',
                          class: 'toolbarbutton-1 chromeclass-toolbar-additional',
                          removable: true,
                          label: 'Toggle New Toolbar',
                          tooltiptext: 'Toggle New toolbar',
                      };
                      for(let p in props)
                          toolbaritem.setAttribute(p, props[p]);
                      return toolbaritem;
                  }
           });
       } catch(e) { }

    // Button Funktions
    if (new_tb_uno === 0) {
      document.getElementById('NewToolbar_button').addEventListener('click', tb_toggle );
      }
    else if (new_tb_uno === 1) {
      document.getElementById('NewToolbar_button').addEventListener('click', tb_toggle_uno );
     }

    function tb_toggle() {
      let windows = Services.wm.getEnumerator(null);
		   while (windows.hasMoreElements()) {
      		  let win = windows.getNext();
       if (event.button === 0) {
         const toolbar = win.document.getElementById("newtoolbar");
         const browserArea = win.document.getElementById("browser");
         const button = win.document.getElementById("NewToolbar_button");

         toolbar.classList.toggle("off-mode");
         browserArea.classList.toggle("off-mode_b");
         button.classList.toggle("off-mode_btn");

         const ntb_visible = !toolbar.classList.contains("off-mode");
         Services.prefs.setBoolPref(pref_newtoolbar_state, ntb_visible);
         }
       }
    };

    function tb_toggle_uno() {
      if (event.button === 0) {
           const toolbar = document.getElementById("newtoolbar");
           const browserArea = document.getElementById("browser");
           const button = document.getElementById("NewToolbar_button");

           toolbar.classList.toggle("off-mode");
           browserArea.classList.toggle("off-mode_b");
           button.classList.toggle("off-mode_btn");

           const ntb_visible = !toolbar.classList.contains("off-mode");
           Services.prefs.setBoolPref(pref_newtoolbar_state, ntb_visible);
           }
    };

    // Positions Startzustand
    if (new_tb_loc === 1) {
         toolbox_new.classList.add("left_mode");
         browser.classList.add("left_mode_b");
         NewToolbar_button.classList.add("left_mode_btn");
       }
    else if (new_tb_loc === 2) {
         toolbox_new.classList.add("bottom_mode");
         browser.classList.add("bottom_mode_b");
         NewToolbar_button.classList.add("bottom_mode_btn");
       }

    let toolbarEnabled = true;
    try {
        toolbarEnabled = Services.prefs.getBoolPref(pref_newtoolbar_state);
    } catch(e) {
        Services.prefs.setBoolPref(pref_newtoolbar_state, new_tb_off === 0); // Initialwert setzen
        toolbarEnabled = new_tb_off === 0;
    }

    if (!toolbarEnabled) {
        newtoolbar.classList.add("off-mode");
        browser.classList.add("off-mode_b");
        NewToolbar_button.classList.add("off-mode_btn");
    }

    // #1 Beim Beenden von Firefox: Pref löschen, falls new_tb_save === 1
    if (new_tb_save === 1) {
        Services.obs.addObserver(function observer(subject, topic, data) {
            if (topic === "quit-application-granted") {
                try {
                    Services.prefs.clearUserPref(pref_newtoolbar_state);
                } catch (e) { }
                Services.obs.removeObserver(observer, "quit-application-granted");
            }
        }, "quit-application-granted");
     }

    // Icon
    if (new_tb_icon === 1) {
         NewToolbar_button.classList.add("icon_mode");
       }

    // Hintergrundfarbe
    // if (new_tb_color === 1) {
    //      newtoolbar.style.backgroundColor = new_tb_bg_color;
    //    }
    if (new_tb_color === 1) {
         newtoolbar.classList.add("ntb_bg_color");
       }

const css =`

:root {
    /*--ug-newbar_basewidth: 32px;*/
    /*--ug-newbar_basewidth: calc(2 * var(--toolbarbutton-inner-padding) + 16px);*/

    --ug-newbar-button-inner-padding: ${new_tb_btn_size};

    --ug-newbar_basewidth: calc(2 * var(--ug-newbar-button-inner-padding) + 16px);

    --ug-newbar_width: calc(var(--ug-newbar_basewidth) + 2*var(--ug-newbar_add_width));

    --ug-newbar_borderwidth: ${new_tb_border_width};             /* Breite / Hoehe Trennlinie */
    --ug-newbar_add_width: `+new_tb_size+`;                       /* Breite / Hoehe erhoehen */
    --ug-newbar_btnspace: ${new_tb_distance};                    /* Abstand zw. Buttons */
}

/*- Buttons kleiner -*/
#newtoolbar {
  	/*--toolbarbutton-inner-padding: 6px !important;*/
    --toolbarbutton-inner-padding: var(--ug-newbar-button-inner-padding) !important;
	 	--toolbarbutton-outer-padding: 0px !important;
}

/*-  Trennlinie  -*/
#newtoolbar {
   --trenn-color: ${new_tb_border_color};
}

/*-  Button  -*/
#NewToolbar_button .toolbarbutton-icon {
    list-style-image: url("chrome://browser/skin/sidebars-right.svg");
}
#NewToolbar_button.icon_mode .toolbarbutton-icon {
    list-style-image: url("${ImagePath}");
}
#NewToolbar_button.off-mode_btn:not(:hover, :active) .toolbarbutton-icon {
    opacity: 0.45;
}
#NewToolbar_button.left_mode_btn .toolbarbutton-icon {
    transform: rotate(180deg);
}
#NewToolbar_button.bottom_mode_btn .toolbarbutton-icon {
    transform: rotate(90deg);
}

/*--  Basis / Right  --*/

#browser {
    transition: padding 0.25s ease !important;
}

#browser:not(.off-mode_b) {
    padding-right: calc(var(--ug-newbar_width) + var(--ug-newbar_borderwidth)) !important;
}

#toolbox_new {
    position: fixed;
    z-index: 4 !important;
    display: flex;
    width: fit-content;
    top: var(--height_newbar_top);
    right: 0;
}
#newtoolbar {
    display: flex;
    flex-direction: column;
    min-width: var(--ug-newbar_basewidth) !important;
    width: var(--ug-newbar_width);
    min-height: var(--ug-newbar_basewidth) !important;
    height: var(--height_newbar) !important;
    padding-block: 8px;
    box-shadow: calc(0px - var(--ug-newbar_borderwidth)) 0 var(--trenn-color);
    transition: width 0.25s ease, margin 0.25s ease /*,height 0.5s ease*/ ;
    align-items: center !important;
}
#newtoolbar:not([customizing]).off-mode {
    min-width: 0px !important;
    margin-inline: 0 calc(0px - var(--ug-newbar_width));
    box-shadow: none !important;
}

#newtoolbar > :is(.toolbarbutton-1, toolbaritem),
#newtoolbar toolbarpaletteitem > :is(.toolbarbutton-1, toolbaritem) {
    margin-block: var(--ug-newbar_btnspace) !important;
}

/*--  Left  --*/

#browser:not(.off-mode_b).left_mode_b {
    padding-inline: calc(var(--ug-newbar_width) + var(--ug-newbar_borderwidth)) 0 !important;
}
#toolbox_new.left_mode {
    left: 0;
}
.left_mode #newtoolbar:not([customizing]) {
    box-shadow: var(--ug-newbar_borderwidth) 0 var(--trenn-color);
}
.left_mode #newtoolbar:not([customizing]).off-mode {
    margin-inline: calc(0px - var(--ug-newbar_width)) 0;
}

/*--  Bottom  --*/

#browser:not(.off-mode_b).bottom_mode_b {
    padding-inline: 0 !important;
    padding-bottom: calc(var(--ug-newbar_width) + var(--ug-newbar_borderwidth)) !important;
}

#toolbox_new.bottom_mode {
    top: unset;
    bottom: 0;
    flex-direction: row;
    width: fit-content;
}
.bottom_mode #newtoolbar:not([customizing]) {
    flex-direction: row !important;
    height: var(--ug-newbar_width) !important;
    width: 100vw;
    padding-block: 0;
    padding-inline: 8px;
    box-shadow: 0 calc(0px - var(--ug-newbar_borderwidth)) var(--trenn-color);
    border: none;
    /*justify-content: center !important;*/    /* Inhalt mittig, optional */
}
.bottom_mode #newtoolbar:not([customizing]).off-mode {
    min-height: 0px !important;
    margin-inline: 0;
    margin-block: 0 calc(0px - var(--ug-newbar_width)) !important;
}

#toolbox_new.bottom_mode #newtoolbar > :is(.toolbarbutton-1, toolbaritem),
#toolbox_new.bottom_mode #newtoolbar toolbarpaletteitem > :is(.toolbarbutton-1, toolbaritem) {
    margin-block: var(--toolbarbutton-outer-padding) !important;
    margin-inline: var(--ug-newbar_btnspace) !important;
}

/*--  Fullscreen  --*/

/* Mac / nur Video Fullscreen */
#main-window[inDOMFullscreen]:not([customizing]) #toolbox_new {
    visibility: collapse !important;
}
#main-window[inDOMFullscreen]:not([customizing]) #browser {
    padding: 0 !important;
}

/* Windows Fullscreen Video + Normal */
@media (-moz-platform: windows) {
#main-window[inFullscreen]:not([customizing]) #toolbox_new {
    visibility: collapse !important;
}
#main-window[inFullscreen]:not([customizing]) #browser {
    padding: 0 !important;
}
}

/*--  customizing  --*/

:root[customizing] #toolbox_new {
    top: unset !important;
    bottom: 0 !important;
    right: 0 !important;
    left: unset !important;
}
#newtoolbar[customizing] {
    height: var(--height_newbar_c) !important;
}
#customization-container {
    margin-right: var(--ug-newbar_width) !important;
}

/*-  Farben Themes  -*/

/* Eigene HG Farbe */
#newtoolbar.ntb_bg_color {
    background-color: ${new_tb_bg_color} !important;
}

:root[lwtheme] #newtoolbar:not(.ntb_bg_color) {
    background-color: var(--lwt-accent-color, var(--toolbar-bgcolor)) !important;
}

/*-  Hintergundbilder Themes, geht nur für Themes mit grossen Bildern, optional -*/
/*
:root[lwtheme][lwtheme-image] #newtoolbar:not(.ntb_bg_color) {
    background-image: var(--lwt-header-image) !important;
    background-position: right 0px top calc(0px - var(--height_newbar_top)) !important;
}
*/


    /*
    background-position: right 0px top calc(0px - var(--height_newbar_top)) !important;
        background-attachment: fixed !important;
    width: 60vw;
        */


/*-  Hintergundbilder fuer Themes mit niedrigen Bildern, optional -*/

:root[lwtheme][lwtheme-image] #newtoolbar:not(.ntb_bg_color) {
    background: var(--lwt-header-image) !important;
    background-repeat: no-repeat !important;

    background-size: cover !important;
    background-position: right 0px top 0px !important;

    /*background-size: auto calc(100vh + var(--height_newbar_top)) !important;
    background-position: right 0px top calc(0px - var(--height_newbar_top)) !important;
    background-attachment: fixed !important;*/
}

:root[lwtheme][lwtheme-image] #toolbox_new.bottom_mode #newtoolbar:not(.ntb_bg_color) {
    background-size: auto !important;
}

/*
:root[lwtheme][lwtheme-image] #newtoolbar:not(.ntb_bg_color) {
    background-image: linear-gradient(to bottom, var(--lwt-accent-color), var(--lwt-accent-color)) !important;
}
*/


/*--  Testfarben  --*/
/*
#newtoolbar {
    border-block: 8px solid orange;
}
#newtoolbar > :is(.toolbarbutton-1, toolbaritem),
#newtoolbar toolbarpaletteitem > :is(.toolbarbutton-1, toolbaritem) {
    outline: 1px solid red;
    outline-offset: -1px;
}
*/
        `;

        const sss = Cc['@mozilla.org/content/style-sheet-service;1'].getService(Ci.nsIStyleSheetService);
        const uri = Services.io.newURI('data:text/css,' + encodeURIComponent(css));
        sss.loadAndRegisterSheet(uri, sss.AGENT_SHEET);
})();
