// userChromeShadow.uc.js by aborix
// 28.07.2022 FF104+ Fix: using PathUtils.join (Sören Hentzschel)

(async function() {

   if (location != 'chrome://browser/content/browser.xhtml') return;
       
    try {
          let path = PathUtils.join(PathUtils.profileDir, 'chrome', 'userChromeShadow.css');
          let cssIn = await IOUtils.readUTF8(path);

          let sss = Cc['@mozilla.org/content/style-sheet-service;1'].getService(Ci.nsIStyleSheetService);
          let uri = makeURI('data:text/css;charset=UTF=8,' + encodeURIComponent(cssIn));
          sss.loadAndRegisterSheet(uri, sss.AUTHOR_SHEET);
    
       } catch(e) { 
        
         console.log("UserChromeShadow-Error: " + e.name + ': ' + e.message );
 
       };        
   
})();
