// Button_PersonalToolbar.uc.js
// Source file https://www.camp-firefox.de/forum/thema/134920/?postID=1213680#post1213680
// Source file https://www.camp-firefox.de/forum/thema/134920/?postID=1215809#post1215809
// Source file https://www.camp-firefox.de/forum/thema/134920/?postID=1232103#post1232103
// PersonalToolbar_ausblenden
// basierend auf den Ideen von BrokenHeart und visoer, Verbesserungen von Horstmann, Korrekturen von Sören und Anpassungen von Mira_Belle
(function ptbut() {              
    if (location.href !== 'chrome://browser/content/browser.xhtml') return;
       
    let startHeight = '0px';                // '24px' oder '0px' Der Startzustand wird definiert: '24px' startet mit sichtbarer Leiste
    let collapse = '0px';                   // Leiste nicht sichtbar
    let visible = '24px';                   // Leiste sichtbar
    let autoCloseTime = 5000;               // 0 = kein Auto-Close / >0 Zeit in Millisekunden /5000 => 5sec  
    let intervalID = 0;
    let persToolbar = document.getElementById('PersonalToolbar');
    try {
        CustomizableUI.createWidget({
            id: 'PersonalToolbar-button',
            type: 'custom',
            defaultArea: CustomizableUI.AREA_NAVBAR,
                onBuild: function(aDocument) {
                    let toolbaritem = aDocument.createXULElement('toolbarbutton');
                    let currentProfileDirectory = Services.dirsvc.get("ProfD", Ci.nsIFile).path.replace(/\\/g, "/"); // Pfadangabe zum Profilordner
                    //let buttonicon = "bookmark-hollow.svg";  // Name & Dateiendung des anzuzeigenden Symbols
                    let props = {
                        id: 'PersonalToolbar-button',
                        class: 'toolbarbutton-1 chromeclass-toolbar-additional',
                        removable: true,
                        label: 'Toggle',
                        tooltiptext: 'Lesezeichenleiste ein-/ausblenden',
                        style: 'list-style-image: url("chrome://browser/skin/fullscreen.svg");',
                       
                    };                  
                    for(var p in props)
                        toolbaritem.setAttribute(p, props[p]);
                    return toolbaritem;                
                }
        });
    } catch(e) { };
    //----------BEGINN----------------------
    // Funktion zum Abfragen der Tastatur ("belauscht" Eingaben)
    // Hinweis: Tasten, die anderweitig bereits "abgefangen" werden, ergeben keinen Event
    document.addEventListener('keydown', (event) => {
        let keyName = event.key;
            if (event.altKey && keyName == 'q') {   // Funktion wird ausgeführt, wenn "Alt & q gedrückt werden
//                onClick(event);
                onClick(event,true);  // ----geändert----
            }
        }, false
    );
    //----------ENDE------------------------
    // Anmerkungen und beispiele am Ende des Scriptes
    document.getElementById('PersonalToolbar').style.minHeight = '0';
    document.getElementById('PersonalToolbar').style.transition = 'all 0.3s steps(6, end)';
    if( startHeight === visible || startHeight === collapse ) {
        document.getElementById('PersonalToolbar').style.height = startHeight;
    }
    else {
        document.getElementById('PersonalToolbar').style.height = visible;
    }
    document.getElementById('PersonalToolbar-button').addEventListener( "click", onClick );
//    function onClick(aEvent) {
    function onClick(aEvent, keyEvent=false) {
        if(!keyEvent && aEvent.button != 0) {
            return;    
        }
        if (persToolbar.style.height == '') {
                persToolbar.style.height = collapse;
        }
        else if (persToolbar.style.height == visible) {
                persToolbar.style.height = collapse;
        }
        else if(persToolbar.style.height == collapse) {
            persToolbar.style.height = visible;
            if(!intervalID && autoCloseTime) {
                intervalID =  aEvent.target.ownerGlobal.setInterval( autoClose, autoCloseTime );
            }
        }
    }
    function autoClose() {
        if( intervalID ) {
            if( persToolbar.style.height == visible) {
                persToolbar.style.height = collapse;
                clearInterval(intervalID);
                intervalID=0;
            }
        }
    }
})();
// Funktion wird ausgeführt, wenn STRG + Alt + l gedrückt wird
//  if (event.ctrlKey && event.altKey && keyName == 'l') {      
// Funktion wird ausgeführt, wenn STRG + w gedrückt werden
    //if (event.ctrlKey && keyName == 'w') {
// PersonalToolbar.style.setProperty('min-height', '0', 'important' );
// PersonalToolbar.style.setProperty('transition', 'all 0.3s steps(6, end)', 'important' );