

//profile-button tester icons separates CSS

  (function() {

   if (location.href !== 'chrome://browser/content/browser.xhtml')
    return;

    try {
        CustomizableUI.createWidget({
            id: 'Profiles_button',
            type: 'custom',
            defaultArea: CustomizableUI.AREA_NAVBAR,
            onBuild: function(aDocument) {
                let toolbaritem = aDocument.createElementNS('http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul', 'toolbarbutton');
                    let props = {
                    id: 'Profiles_button',
                    class: 'toolbarbutton-1 chromeclass-toolbar-additional',
                    label: 'Profiles',
                    tooltiptext: 'about:profiles',
                };
                for (var p in props)
                    toolbaritem.setAttribute(p, props[p]);
                return toolbaritem;
            }
        });
    } catch(e) { }

      document.getElementById('Profiles_button').addEventListener('click', event => {
        if (event.button === 0) {
          openTrustedLinkIn("about:profiles", "tab");
        }
      });

      // Create references to APIs we'll use
      let ss = Cc["@mozilla.org/content/style-sheet-service;1"].getService(Ci.nsIStyleSheetService);
      let io = Cc["@mozilla.org/network/io-service;1"].getService(Ci.nsIIOService);
      let ds = Cc["@mozilla.org/file/directory_service;1"].getService(Ci.nsIProperties);

      // Get the chrome directory in the current profile
      let chromepath = ds.get("UChrm", Ci.nsIFile);

      // Specific file: userChrome.css or userContent.css
      chromepath.append("profilesbutton_style");
      chromepath.append("profilesbutton_external.css");

      // Morph to a file URI
      let chromefile = io.newFileURI(chromepath);

      // Load the sheet
      ss.loadAndRegisterSheet(chromefile, ss.USER_SHEET);

})();
