//==UserScript==
// @name            Mousegestures.uc.js
// @description  Mouse gestures
// @include      main
// @sandbox      true
// @include      chrome://browser/content/browser.xhtml
// @charset      UTF-8
//==/UserScript==
  
(() => {
    'use strict';

    let ucjsMouseGestures = {
        lastX: 0,
        lastY: 0,
        directionChain: '',
        isMouseDownL: false,
        isMouseDownR: false,
        hideFireContext: false,
        shouldFireContext: false,
        GESTURES: {
            'L': {name: '后退', cmd: () => gBrowser.webNavigation.canGoBack && gBrowser.webNavigation.goBack()},
            'R': {name: '前进', cmd: () => gBrowser.webNavigation.canGoForward && gBrowser.webNavigation.goForward()},
            'U': {name: '向上滚动', cmd: function(){ goDoCommand('cmd_scrollPageUp')  }},
            'D': {name: '向下滚动', cmd: function(){ goDoCommand('cmd_scrollPageDown')  }},
            //'UDUD': {name: '跳过缓存刷新当前页面', cmd: function() {document.getElementById("Browser:ReloadSkipCache").doCommand();}},
            'RL': {name: '打开新标签', cmd: function() {BrowserCommands.openTab(); }},
            //'RLRL': {name: '重启浏览器', cmd: function() {Services.startup.quit(Services.startup.eRestart | Services.startup.eAttemptQuit); }},
            'DR': {name: '关闭当前标签', cmd: function() {if (gBrowser.selectedTab.getAttribute("pinned") !== "true") { gBrowser.removeCurrentTab();}}},
            'DL': {name: '恢复关闭的标签', cmd: function() { try { document.getElementById('History:UndoCloseTab').doCommand(); } catch (ex) { if ('undoRemoveTab' in gBrowser) gBrowser.undoRemoveTab(); else throw "Session Restore feature is disabled."}} },
            'RU': {name: '转到页面顶部', cmd: function(){ goDoCommand('cmd_scrollTop'); }  },
            'RD': {name: '转到页面底部', cmd: function(){ goDoCommand("cmd_scrollBottom"); }  },
            'UR': {name: '页面内查找', cmd: function(){
                if (gFindBarInitialized) {
                gFindBar.hidden? gFindBar.onFindCommand(): gFindBar.close();
            } else {
              gLazyFindCommand("onFindCommand");
            }
          }},
        },

        init: async function() {
            let self = this;
            await this.loadFrameScript();

            ['mousedown', 'mousemove', 'mouseup', 'contextmenu', 'DOMMouseScroll'].forEach(type => {
                gBrowser.tabpanels.addEventListener(type, self, true);
            });

            gBrowser.tabpanels.addEventListener('unload', () => {
                ['mousedown', 'mousemove', 'mouseup', 'contextmenu', 'DOMMouseScroll'].forEach(type => {
                    gBrowser.tabpanels.removeEventListener(type, self, true);
                });
            }, false);
        },

        loadFrameScript: async function() {
            return new Promise((resolve, reject) => {
                try {
                    Services.mm.loadFrameScript(this.frameScript, true);
                    Services.mm.addMessageListener('contentToChrome', this.chromeListener);
                    resolve();
                } catch (error) {
                    reject(error);
                }
            });
        },

        chromeListener: function(message) {
            const { document, gBrowser } = message.target.ownerGlobal;
            const { cmd, url } = message.data;

            switch (cmd) {
                case 'newTab-focus':
                    if (url) {
                        let nuevoTab = gBrowser.addTab(url, { owner: gBrowser.selectedTab, relatedToCurrent: true, triggeringPrincipal: gBrowser.selectedBrowser.contentPrincipal });
                        gBrowser.selectedTab = nuevoTab;
                    }
                    break;
            }
        },

        frameScript: 'data:application/javascript;charset=UTF-8,' +
            encodeURIComponent('(' + (function () {
                let clickedElement;
                var GetLink = function (e) {
                    ImgSrc = undefined;
                    LnkSrc = undefined;
                    clickedElement = e.target;
                    switch (clickedElement.tagName) {
                        case 'IMG':
                            ImgSrc = clickedElement.src || clickedElement.currentSrc;
                            LnkSrc = clickedElement.parentElement.href || clickedElement.currentSrc;
                            break;
                        case 'AREA':
                            let uM = clickedElement.ownerDocument.querySelector('[usemap]');
                            if (uM && uM.useMap == '#' + clickedElement.parentElement.name) ImgSrc = uM.src;
                            break;
                        default:
                            try {
                                let Elmnt = clickedElement;
                                LnkSrc = Elmnt.href;
                                if (!LnkSrc) {
                                    for (let pb = 0; pb < 6; pb++) {
                                        Elmnt = Elmnt.parentNode;
                                        LnkSrc = Elmnt.href;
                                        if (LnkSrc) break;
                                    }
                                }
                            } catch (e) { LnkSrc = undefined; }
                            break;
                    }
                }
                addEventListener('mousedown', GetLink, true);
                contentListener = function (msg) {
                    switch (msg.data) {
                        case 'open-link':
                            if (typeof LnkSrc != 'undefined') sendAsyncMessage('contentToChrome', {cmd: 'newTab-focus', url: LnkSrc});
                            break;
                    }
                }
                addMessageListener('chromeToContent', contentListener);
            }).toString() + ')();'),

        handleEvent: function(event) {
            switch (event.type) {
                case 'mousedown':
                    if (event.button == 2) {
                        (gBrowser.mPanelContainer || gBrowser.tabpanels).addEventListener("mousemove", this, false);
                        this.isMouseDownR = true;
                        this.hideFireContext = false;
                        [this.lastX, this.lastY, this.directionChain] = [event.screenX, event.screenY, ''];
                    }
                    if (event.button == 0) {
                        this.isMouseDownR = false;
                        this.stopGesture();
                    }
                    break;
                case 'mousemove':
                    if (this.isMouseDownR) {
                        let [subX, subY] = [event.screenX - this.lastX, event.screenY - this.lastY];
                        let [distX, distY] = [(subX > 0 ? subX : (-subX)), (subY > 0 ? subY : (-subY))];
                        let direction;
                        if (distX < 10 && distY < 10) return;
                        if (distX > distY) direction = subX < 0 ? 'L' : 'R';
                        else direction = subY < 0 ? 'U' : 'D';
                        if (!this.xdTrailArea) {
                            this.xdTrailArea = document.createXULElement('hbox');
                            let canvas = document.createElementNS('http://www.w3.org/1999/xhtml', 'canvas');
                            canvas.setAttribute('width', window.screen.width);
                            canvas.setAttribute('height', window.screen.height);
                            this.xdTrailAreaContext = canvas.getContext('2d');
                            this.xdTrailArea.style.cssText = '-moz-user-focus: none !important;-moz-user-select: none !important;display: -moz-box !important;box-sizing: border-box !important;pointer-events: none !important;margin: 0 !important;padding: 0 !important;width: 100% !important;height: 100% !important;border: none !important;box-shadow: none !important;overflow: hidden !important;background: none !important;opacity: 0.9 !important;position: fixed !important;z-index: 2147483647 !important; display: inline !important;';
                            this.xdTrailArea.appendChild(canvas);
                            gBrowser.selectedBrowser.parentNode.insertBefore(this.xdTrailArea, gBrowser.selectedBrowser.nextSibling);
                        }
                        if (this.xdTrailAreaContext) {
                            this.hideFireContext = true;
                            this.xdTrailAreaContext.strokeStyle = '#0065FF';
                            this.xdTrailAreaContext.lineJoin = 'round';
                            this.xdTrailAreaContext.lineCap = 'round';
                            this.xdTrailAreaContext.lineWidth = 2;
                            this.xdTrailAreaContext.beginPath();
                            this.xdTrailAreaContext.moveTo(this.lastX - gBrowser.selectedBrowser.screenX, this.lastY - gBrowser.selectedBrowser.screenY);
                            this.xdTrailAreaContext.lineTo(event.screenX - gBrowser.selectedBrowser.screenX, event.screenY - gBrowser.selectedBrowser.screenY);
                            this.xdTrailAreaContext.closePath();
                            this.xdTrailAreaContext.stroke();
                            this.lastX = event.screenX;
                            this.lastY = event.screenY;
                        }
                        if (direction != this.directionChain.charAt(this.directionChain.length - 1)) {
                            this.directionChain += direction;
                            StatusPanel._label = this.GESTURES[this.directionChain] ? '手势: ' + this.directionChain + ' ' + this.GESTURES[this.directionChain].name : '未知手势:' + this.directionChain;
                        }
                    }
                    break;
                case 'mouseup':
                    if (this.isMouseDownR && event.button == 2) {
                        if (this.directionChain) this.shouldFireContext = false;
                        this.isMouseDownR = false;
                        this.directionChain && this.stopGesture();
                    }
                    break;
                case 'contextmenu':
                    if (this.isMouseDownR || this.hideFireContext) {
                        this.shouldFireContext = true;
                        this.hideFireContext = false;
                        event.preventDefault();
                        event.stopPropagation();
                    }
                    break;
                case 'DOMMouseScroll':
                    if (this.isMouseDownR) {
                        this.shouldFireContext = false;
                        this.hideFireContext = true;
                        this.directionChain = 'W' + (event.detail > 0 ? '+' : '-');
                        this.stopGesture();
                    }
                    break;
            }
        },

        stopGesture: function() {
            if (this.GESTURES[this.directionChain]) this.GESTURES[this.directionChain].cmd();
            if (this.xdTrailArea) {
                this.xdTrailArea.parentNode.removeChild(this.xdTrailArea);
                this.xdTrailArea = null;
                this.xdTrailAreaContext = null;
            }
            this.directionChain = '';
            setTimeout(() => StatusPanel._label = '', 2000);
            this.hideFireContext = true;
        }
    };

    ucjsMouseGestures.init();
})();


//加入命令
//将当前窗口置顶
 function TabStickOnTop() {
(function(){if(document.getElementById('main-window').hasAttribute('ontop'))onTop=false;else onTop=true;try{ChromeUtils.importESModule("resource://gre/modules/ctypes.sys.mjs");var lib=ctypes.open("user32.dll");var funcActiveWindow=0;try{funcActiveWindow=lib.declare("GetActiveWindow",ctypes.winapi_abi,ctypes.int32_t)}catch(ex){funcActiveWindow=lib.declare("GetActiveWindow",ctypes.stdcall_abi,ctypes.int32_t)}if(funcActiveWindow!=0){var activeWindow=funcActiveWindow();var funcSetWindowPos=0;try{funcSetWindowPos=lib.declare("SetWindowPos",ctypes.winapi_abi,ctypes.bool,ctypes.int32_t,ctypes.int32_t,ctypes.int32_t,ctypes.int32_t,ctypes.int32_t,ctypes.int32_t,ctypes.uint32_t)}catch(ex){funcSetWindowPos=lib.declare("SetWindowPos",ctypes.stdcall_abi,ctypes.bool,ctypes.int32_t,ctypes.int32_t,ctypes.int32_t,ctypes.int32_t,ctypes.int32_t,ctypes.int32_t,ctypes.uint32_t)}var hwndAfter=-2;if(onTop){hwndAfter=-1;document.getElementById('main-window').setAttribute('ontop','true')}else document.getElementById('main-window').removeAttribute('ontop');funcSetWindowPos(activeWindow,hwndAfter,0,0,0,0,19)}lib.close()}catch(ex){alwaysontop_log(ex)}})()
};