﻿# ==UserScript==
# @name           Firefox-JavaScript_install
# @description    Firefox-JavaScript_install.ps1
# @include        ~ coming soon
# @author         TK87 @ camp-firefox.de
# @version        2025/04/30 v.1.3
# ==/UserScript==


#region    SETTINGS
  Using NameSpace System.Management.Automation
  Using NameSpace System.Security.Principal
  Using NameSpace System.Windows.Forms
  [CmdletBinding()]Param([string]$User,[parameter(ValueFromRemainingArguments)][string[]]$installs)
  Add-Type -AssemblyName System.Windows.Forms
  if (!$User) {$User = $Env:UserName}
  $ErrorActionPreference = 'stop'
#endregion SETTINGS

Class FF_install {
  [string]$name
  [string]$path
  [string]$id
  FF_install ([string]$stringdata){$this.name,$this.path,$this.id=$stringdata.Split(';')}
  FF_install ([string]$name,[string]$path,[string]$id){$this.name,$this.path,$this.id=$name,$path,$id}
}

function CloseFirefoxMessage {
  $Form    = [Form]@{StartPosition='CenterScreen'; AutoSize=$true; Padding='10,10,10,10'; BackColor='White'; ControlBox=$false; Size="10,10"; Text='Firefox beenden'; FormBorderStyle='FixedSingle'}
  $TLP     = [TableLayoutPanel]@{Dock='Fill'; AutoSize=$true}
  $FLP     = [FlowLayoutPanel]@{AutoSize=$true; Anchor="Bottom"}
  $Label   = [Label]@{Text= "Firefox läuft derzeit. Bitte schließen Sie Firefox, bevor Sie fortfahren."; Font="Verdana,12"; AutoSize=$true; MaximumSize="400,300"}
  $Buttons = @(
    [Button]@{Text="Ok";      Size="80,30"; Font="Microsoft Sans Serif,10"; Margin="10,10,10,10"}
    [Button]@{Text="Abbruch"; Size="80,30"; Font="Microsoft Sans Serif,10"; Margin="10,10,10,10"}
  )
  $Buttons.Add_Click({
    $this.TopLevelControl.Hide()
    $this.TopLevelControl.Tag = $this.Text
  })
  $FLP.Controls.AddRange($Buttons)
  $TLP.Controls.Add($Label)
  $TLP.Controls.Add($FLP)
  $Form.Controls.Add($TLP)
  return $Form
}

Function FF-Chooser {
  Param([Array]$items)
 
  $Form = [Form]@{StartPosition='CenterScreen'; Font='Verdana,12'; AutoSize=$true; Padding='10,10,10,10'; Size='1,1'; ControlBox=$false; BackColor='white'; FormBorderStyle='FixedSingle'}
  $TLP  = [TableLayoutPanel]@{Dock='Fill'; AutoSize=$true}
  $Label = [Label]@{Text="Für welchen Firefox sollen die Anpassungen vorgenommen werden?"; AutoSize=$true; MaximumSize='500,500'; Font='Verdana, 14'; Margin='10,10,10,10'}
  $FLP = [FlowLayoutPanel]@{AutoSize=$true; Anchor='Bottom'}
 
  $TLP.SetColumnSpan($Label,3)
  $TLP.Controls.Add($Label,0,0)
 
  $i=1
  foreach ($item in $items) {
    $checkbox = [CheckBox]@{Name=$item.Name; AutoSize=$true; Size='1,1'; Anchor='Left'; Margin='40,10,10,10'}
    $icon = [Drawing.Icon]::ExtractAssociatedIcon(('{0}\Firefox.exe' -f $item.path))
    $panel = [Panel]@{Size='25,25'; Anchor='Left'; BackgroundImage=$icon; BackgroundImageLayout='zoom'}
    $Label = [Label]@{Text=$item.Name; Anchor='Left'; AutoSize=$true}
    $TLP.Controls.Add($checkbox,0,$i)
    $TLP.Controls.Add($panel,1,$i)
    $TLP.Controls.Add($label,2,$i)
    $i++
  }
 
  $Buttons = @(
    [Button]@{Text='Ok';      Size='100,40'; Margin='10,10,10,10'; Font='Microsoft Sans Serif,11'}
    [Button]@{Text='Abbruch'; Size='100,40'; Margin='10,10,10,10'; Font='Microsoft Sans Serif,11'}
  )
  $Buttons.Add_Click({$this.ToplevelControl.Hide(); $this.ToplevelControl.Tag = $this.Text})
 
  $TLP.SetColumnSpan($FLP,3)
  $FLP.Controls.AddRange($Buttons)
  $TLP.Controls.Add($FLP,0,$i)
  $Form.Controls.Add($TLP)
  return $Form
}

function Get-InstalledVersions {
  [CmdletBinding()]Param()

  $installed = foreach ($dir in '','Wow6432Node\'){
    gp -EA SilentlyContinue "HKLM:\Software\${dir}Microsoft\Windows\CurrentVersion\Uninstall\*" | ?{$_.Publisher -eq 'Mozilla' -and $_.DisplayName -match 'Firefox|Nightly'} |%{
      $id = gpv -EA SilentlyContinue "HKLM:\Software\${dir}Mozilla\Firefox\TaskBarIDs" $_.InstallLocation
      if ($id){[FF_Install]::new($_.DisplayName,$_.InstallLocation,$id)}
    }
  }
  if (!$installed) {
    $PSCmdlet.ThrowTerminatingError([ErrorRecord]::new([NotSupportedException]::new('Firefox ist nicht installiert oder wurde noch nicht initialisiert.'),99,'NotInstalled',$null))
  }
  return $installed
}

try {
  
  if (!$installs) {
    # 1. Prüfen, ob Firefox installiert ist
    $FFs = Get-InstalledVersions

    # 2. Prüfen, ob mehrere Installationen vorhanden
    $selected = If ($FFs.Count){
      $Form = FF-Chooser $FFs
      [void]$Form.ShowDialog()
      $Checkbox = $Form.Controls[0].Controls|?{$_ -is 'checkbox' -and $_.Checked}
      if ($Form.Tag -eq 'Abbruch' -or !$Checkbox) {return}
      Foreach ($item in $Checkbox.Name) {$FFs | ? Name -eq $item}
    } else {$FFs}
  
    # 3. Prüfen, ob Schreibrechte im Programmordner vorhanden...
    try {foreach ($ff in $selected) {$tmpfile = New-Item "$($FF.path)\~tmp"; rm $tmpfile}}
    catch {
      try {
        $selected_string = $selected.Foreach({'"{0};{1};{2}"' -f $_.Name,$_.Path,$_.Id}) -join " "
        # Bei Ausführung unter Powershell...
        if ($MyInvocation.MyCommand.CommandType -eq "ExternalScript"){Start -Verb RunAs Powershell -ArgumentList ('-NoLogo -NoExit -File "{0}" "{1}" {2}' -f $MyInvocation.MyCommand.Definition,$User,$selected_string)}
        # Bei Ausführung als EXE umgewandelt...
        else {Start -Verb RunAs ([Environment]::GetCommandLineArgs()[0]) -ArgumentList ('"{0}" {1}' -f $User,$selectionstring)}
      } catch {}
      return
    }
  } else {
    $Selected = $installs|%{[FF_install]::new($_)}
  }

  # 4. Prüfen, ob Firefox läuft
  try {
    Get-Process Firefox | Out-Null
    $Form = CloseFirefoxMessage
    do {
      [void]$Form.ShowDialog()
      if ($Form.Tag -eq "Abbruch") {return}
    } until (!(Get-Process FireFox))
  } catch {}

  # 5. ZIP herunterladen und entpacken
  $tempDir = "$ENV:Temp\{0}" -f (New-Guid).Guid
  md $tempDir | Out-Null
  $zipUrl = "https://raw.githubusercontent.com/Endor8/userChrome.js/master/userChrome/Dateien/firefox-anpassungen.zip"
  $zipPath = "$tempDir\firefox-anpassungen.zip"
  Write-Host -NoNewLine "Firefox-Anpassungen werden heruntergeladen... "
  [System.Net.WebClient]::new().DownloadFile($zipUrl,$zipPath)
  Write-Host -ForegroundColor Green "ok."
  Write-Host -NoNewLine "Archiv wird entpackt... "
  Expand-Archive -Path $zipPath -DestinationPath $tempDir -Force
  Write-Host -ForegroundColor Green "ok."

  # Install-Ini lesen
  $ini = @{}
  foreach ($line in Get-Content "C:\Users\$user\Appdata\Roaming\Mozilla\Firefox\installs.ini") {
    switch -RegEx ($line) {
      '^\[(.+)\]$' {$section=$Matches[1]; $ini.$section=@{}}
      '^(.+)=(.*)' {$key,$value=$Matches[1,2]; $ini.$section.$key=$value}
    }
  }

  # Datei kopieren
  foreach ($item in $selected) {
    ""
    Write-Host ('Beginne Kopiervorgang für: {0}' -f $item.Name)
    $FF_location = $item.path
   
    Write-Host -NoNewLine "Datei 'config-prefs.js' wird ins Firefox-Verzeichnis kopiert... "
    Copy-Item -Path "$tempDir\config-prefs.js" -Destination "$FF_location\defaults\pref"
    Write-Host -ForegroundColor Green 'ok.'

    # Zielordner userChromeJS erstellen, falls nicht vorhanden
    if (!(Test-Path "$FF_location\userChromeJS")) {
      Write-Host -NoNewLine "Zielordner 'userChromeJS' wird erstellt... "
      md "$FF_location\userChromeJS" | Out-Null
      Write-Host -ForegroundColor Green 'ok.'
    }

    # Dateien einzeln kopieren
    foreach ($file in "main.js","Readme.txt","utilities.js") {
      if (Test-Path "$tempDir\userChromeJS\$file") {
        Write-Host -NoNewLine "Datei '$file' wird kopiert... "
        Copy-Item -Path "$tempDir\userChromeJS\$file" -Destination "$FF_location\userChromeJS"
        Write-Host -ForegroundColor Green "ok."
      } else {
        Write-Warning "Datei '$file' wurde nicht gefunden und wird übersprungen."
      }
    }

    # Datei kopieren
    Write-Host -NoNewLine "Datei 'config.js' wird ins Firefox-Verzeichnis kopiert... "
    Copy-Item -Path "$tempDir\config.js" -Destination $FF_location
    Write-Host -ForegroundColor Green "ok."

    # Profilordner finden
    $profilePath = $ini.GetEnumerator() |? Key -eq $item.id|%{
      if ([System.IO.Path]::IsPathRooted($_.Value.Default)){$_.Value.Default} 
      else {"C:\Users\$user\Appdata\Roaming\Mozilla\Firefox\"+$_.Value.Default}
      Write-Host ("Standardprofilordner: {0}" -f $_.Value.Default)
    }
    if (!$profilePath) {
      Write-Warning ("Das Standardprofil für '{0}' konnte nicht gefunden werden und wird übersprungen" -f $item.Name)
      continue
    }

    # chrome-Ordner erstellen, falls nicht vorhanden
    if (!(Test-Path "$profilePath\chrome")) {
      Write-Host -NoNewLine "Ordner 'chrome' wird erstellt..."
      md "$profilePath\chrome" | Out-Null
      Write-Host -ForegroundColor green "ok."
    }

    # userChrome.js kopieren
    Write-Host -NoNewLine "Datei 'userChrome.js' wird kopiert... "
    Copy-Item -Path "$tempDir\chrome\userChrome.js" -Destination "$profilePath\chrome"
    Write-Host -ForegroundColor Green "ok."
  }

  Write-Host -ForegroundColor Green "Der Vorgang wurde erfolgreich abgeschlossen."
} catch [NotSupportedException] {
  Write-Warning $_.Exception.Message
} catch {
  Write-Host -ForegroundColor Red $_.Exception.Message
}

if ($tempDir -and (Test-Path $tempDir)) {remove-item -force -recurse $tempDir}
Write-Host -NoNewLine -ForegroundColor Yellow "`n---   Beliebige Taste zum Beenden   ---"
[void][console]::ReadKey($true)

# MIT License
#
# Copyright (c) 2025 TK87 @ camp-firefox.de
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is furnished to do so.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.