(function() {

  if(location.href != 'chrome://browser/content/browser.xhtml') return;

   try {
      CustomizableUI.createWidget({
         id: 'menu-button',
         type: 'custom',
         defaultArea: CustomizableUI.AREA_NAVBAR,
         onBuild: function(aDocument) {
            var button = aDocument.createXULElement('toolbarbutton');
            var attributes = {
               id: 'menu-button',
               class: 'toolbarbutton-1 chromeclass-toolbar-additional',
               removable: 'true',
               label: 'Videos aufnehmen können',
               tooltiptext: Services.prefs.getBoolPref('media.mediasource.enabled') ?
                  'Videos webm' : 'Videos mp4'
            };
            for (var a in attributes) {
               button.setAttribute(a, attributes[a]);
            };
            return button;
         }
      });
   } catch(e) { };
  
   document.getElementById('menu-button').addEventListener('command', function(event) {
	   var isEnabled = !Services.prefs.getBoolPref('media.mediasource.enabled');
	   Services.prefs.setBoolPref('media.mediasource.enabled', isEnabled);
	   event.target.ownerGlobal.BrowserCommands.reload(); 
	   var windows = Services.wm.getEnumerator('navigator:browser');
	   while (windows.hasMoreElements()) {
		  let button = windows.getNext().document.getElementById('menu-button');
		  if (isEnabled)
			 button.setAttribute('tooltiptext', 'Videos webm')
		  else
			 button.setAttribute('tooltiptext', 'Videos mp4');
	   };
   }, true);
		  
   if (document.documentElement.hasAttribute('privatebrowsingmode') &&
       !Services.prefs.getBoolPref('media.mediasource.enabled'))
   {
      let button = document.getElementById('menu-button');
      button.click();
      window.addEventListener('unload', function() {
         button.click();
      });
   };

   var css =
   '#menu-button[tooltiptext="Videos webm"] {list-style-image: url("file:///E:/Firefox/Icons/webm.svg")}' +
   '#menu-button[tooltiptext="Videos mp4"] {list-style-image: url("file:///E:/Firefox/Icons/mp4.svg")}';
   var stylesheet = document.createProcessingInstruction('xml-stylesheet', 'type="text/css" href="data:text/css;utf-8,' + encodeURIComponent(css) + '"');
   document.insertBefore(stylesheet, document.documentElement);

})();