// ViewImage.uc.js
// Grafik über Kontextmenü im selben Tab (statt in einem neuen) anzeigen
// Author: aborix

(function() {

  if (!window.gBrowser)
    return;

  function viewMedia(event) {
    let where = BrowserUtils.whereToOpenLink(event, false, false);
    let referrerInfo = gContextMenu.contentData.referrerInfo;
    let systemPrincipal = Services.scriptSecurityManager.getSystemPrincipal();
    if (gContextMenu.onCanvas) {
      gContextMenu._canvasToBlobURL(gContextMenu.targetIdentifier).then(function(blobURL) {
        openTrustedLinke(blobURL, where, {
          referrerInfo,
          triggeringPrincipal: systemPrincipal,
        });
      }, Cu.reportError);
    } else {
      urlSecurityCheck(
        gContextMenu.mediaURL,
        gContextMenu.principal,
        Ci.nsIScriptSecurityManager.DISALLOW_SCRIPT
      );
      openTrustedLinkIn(gContextMenu.mediaURL, where, {
        referrerInfo,
        forceAllowDataURI: true,
        triggeringPrincipal: gContextMenu.principal,
        csp: gContextMenu.csp,
      });
    }
  }

  let item = document.getElementById('context-viewimage');
  let strCommand = '(' + viewMedia.toString() + ')(event);';
   item.addEventListener('command', function(event) {
		Function("return " + strCommand)();
		event.preventDefault();
		event.stopPropagation();    
		return
  }, false);
 
  item.label = 'Grafik anzeigen';
})();