// JavaScript Document
// B_UserPrefMediaSource.uc.js

// Das Script erstellt einen Button, der in about:config boolsche Werte ändert. In der UserConfiguration unter 'const boolPref' kann die zu ändernde Einstellung festgelegt werden. Das icon/label/tooltiptext kann in der UserConfiguration dem jeweiligen Zustand angepasst werden (true/false).
// Für das mitgelieferte Icon als .svg-Datei mit [moz-context-properties] ändert das Script die Einstellung [svg.context-properties.content.enabled] in about:config auf 'true'.
// In einem neuen Profil ist die Einstellung in about:config 'media.mediasource.enabled, true' gesetzt. Allerdings werden einige Menuitems im Mediendropdown nicht angezeigt z.B.:'Video speichern unter'. Dieses Script toggelt 'media.mediasource.enabled, true'/'media.mediasource.enabled, false'. Die Einstellung 'media.mediasource.enabled, false' könnte z.B.: auf 'youtube.com' interessant sein ( =>'Video speichern unter'). Bei Livestreams (z.b.: 'ardmediathek.de/live/') kann es bei der Einstellung 'media.mediasource.enabled, false' zu Fehlermeldungen der Seite (Wiedergabefehler) kommen. Beim Umschalten wird der Seiteninhalt des AKTIVEN Tabs neu geladen.

(function() {
  if (!window.gBrowser)
	return;
// ■■ START UserConfiguration ■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
const id = 'UserPref-msE-button'; // Id des neuen Buttons
const boolPref = 'media.mediasource.enabled'; // Einstellung in about:config deren boolesche Variable geschaltet werden soll (Wichtig: Beim Umschalten wird der Seiteninhalt des aktiven Tabs neu geladen)
const labelT = 'Mediendropdown ohne DownloadItem (Livestream)'; // Bezeichnung des neuen Buttons bei boolPref=true
const labelF = 'Mediendropdown mit DownloadItem (Youtube)'; // Bezeichnung des neuen Buttons bei boolPref=false
const tooltiptextT = 'Mediendropdown ohne DownloadItem (Livestream)';
const tooltiptextF = 'Mediendropdown mit DownloadItem (Youtube)';
// Icon-------------------------------------------------------
const iconT = '16-control-panel-18_moz.svg';  // [Name.Dateiendung] des anzuzeigenden Symbols für boolPref=true
const iconF = '16-control-panel-20_moz.svg';  // [Name.Dateiendung] des anzuzeigenden Symbols für boolPref=false
const bgImage = 'magenta'; // Farbe des Indikators (zur Unterscheidung mehrerer UserPref-buttons;)
const iconPath = '/chrome/icons/'; // Pfad zum Ordner der das Icon beinhaltet
const iconColorT = 'firebrick';  // Farbe des Icons (nur .svg-Datei mit [moz-context-properties] für boolPref=true, bei anderen Icons hat const iconColorT keine Funktion)
const iconColorF = 'forestgreen';  // Farbe des Icons (nur .svg-Datei mit [moz-context-properties] für boolPref=false, bei anderen Icons hat const iconColorF keine Funktion)
// ■■ END UserConfiguration ■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
const curProfDir = PathUtils.toFileURI(PathUtils.join(PathUtils.profileDir));
//----
	if (Services.prefs.getBoolPref('svg.context-properties.content.enabled') == false) {
		Services.prefs.setBoolPref('svg.context-properties.content.enabled', true );
	}
//----  
CustomizableUI.createWidget({
    id: id,
	type: 'button',
    defaultArea: CustomizableUI.AREA_NAVBAR,
 
    onCreated: (button) => {
		button.style.MozContextProperties = 'fill, stroke, fill-opacity';
//bgImage
		button.style = 'background-image:linear-gradient('+bgImage+','+bgImage+'); background-repeat: no-repeat; background-size: 4px 4px; background-position: left 2px top calc(50% - 8px);';
//start
if (Services.prefs.getBoolPref(boolPref) == false ) {
		button.style.fill = iconColorF;
		button.style.listStyleImage = 'url("' + curProfDir + iconPath + iconF + '")';
    	button.setAttribute('label', labelF);
    	button.setAttribute('tooltiptext', tooltiptextF);
}
else
if (Services.prefs.getBoolPref(boolPref) == true ) {
		button.style.fill = iconColorT;
		button.style.listStyleImage = 'url("' + curProfDir + iconPath + iconT + '")';
    	button.setAttribute('label', labelT);
    	button.setAttribute('tooltiptext', tooltiptextT);
}
//click
button.addEventListener('click', () => {
if (event.button == 0) {
  BrowserCommands.reloadSkipCache();
	if (Services.prefs.getBoolPref(boolPref) == false ) {
		button.style.fill = iconColorT;
		Services.prefs.setBoolPref(boolPref, true);
		button.style.listStyleImage = 'url("' + curProfDir + iconPath + iconT + '")';
    	button.setAttribute('label', labelT);
    	button.setAttribute('tooltiptext', tooltiptextT);
	}
	else
	if (Services.prefs.getBoolPref(boolPref) == true ) {
		button.style.fill = iconColorF;
		Services.prefs.setBoolPref(boolPref, false);
		button.style.listStyleImage = 'url("' + curProfDir + iconPath + iconF + '")';
    	button.setAttribute('label', labelF);
    	button.setAttribute('tooltiptext', tooltiptextF);
	}
}
});
//----
	}
});
//----
})();
