// JavaScript Document
// B_UserPrefBrowserStartupPage.uc.js

// Das Script erstellt einen Button, der in about:config integer Variablen ändert. In der UserConfiguration unter 'const intPref' kann die zu ändernde Einstellung festgelegt werden. Das icon/label/tooltiptext kann in der UserConfiguration dem jeweiligen Zustand angepasst werden (1/3).
// Für das mitgelieferte Icon als .svg-Datei mit [moz-context-properties] ändert das Script die Einstellung [svg.context-properties.content.enabled] in about:config auf 'true'.

(function() {
  if (!window.gBrowser)
	return;
// ■■ START UserConfiguration ■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
const id = 'UserPref-bSP-button'; // Id des neuen Buttons
const intPref = 'browser.startup.page'; // Einstellung in about:config deren integer Variablen geschaltet werden soll
const labelT = 'Tabs beim Start wiederherstellen'; // Bezeichnung des neuen Buttons bei intPref=3
const labelF = 'Tabs beim Start nicht wiederherstellen'; // Bezeichnung des neuen Buttons bei intPref=1
const tooltiptextT = 'Einstellungen > Allgemein > Start:\n"Vorhandene Fenster und Tabs öffnen"\naktiviert';
const tooltiptextF = 'Einstellungen > Allgemein > Start:\n"Vorhandene Fenster und Tabs öffnen"\ndeaktiviert';
// Icon-------------------------------------------------------
const iconT = '16-control-panel-20_moz.svg';  // [Name.Dateiendung] des anzuzeigenden Symbols für intPref=3
const iconF = '16-control-panel-18_moz.svg';  // [Name.Dateiendung] des anzuzeigenden Symbols für intPref=1
const bgImage = 'yellow'; // Farbe des Indikators (zur Unterscheidung mehrerer UserPref-buttons;)
const iconPath = '/chrome/icons/'; // Pfad zum Ordner der das Icon beinhaltet
const iconColorT = 'forestgreen';  // Farbe des Icons (nur .svg-Datei mit [moz-context-properties] für intPref=3, bei anderen Icons hat const iconColorT keine Funktion)
const iconColorF = 'firebrick';  // Farbe des Icons (nur .svg-Datei mit [moz-context-properties] für intPref=1, bei anderen Icons hat const iconColorF keine Funktion)
// ■■ END UserConfiguration ■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
const curProfDir = PathUtils.toFileURI(PathUtils.join(PathUtils.profileDir));
//----
	if (Services.prefs.getBoolPref('svg.context-properties.content.enabled') == false) {
		Services.prefs.setBoolPref('svg.context-properties.content.enabled', true );
	}
//----  
CustomizableUI.createWidget({
    id: id,
	type: 'button',
    defaultArea: CustomizableUI.AREA_NAVBAR,
 
    onCreated: (button) => {
		button.style.MozContextProperties = 'fill, stroke, fill-opacity';
//bgImage
		button.style = 'background-image:linear-gradient('+bgImage+','+bgImage+'); background-repeat: no-repeat; background-size: 4px 4px; background-position: left 2px top calc(50% - 8px);';
//start
if (Services.prefs.getIntPref(intPref) == 1 ) {
		button.style.fill = iconColorF;
		button.style.listStyleImage = 'url("' + curProfDir + iconPath + iconF + '")';
    	button.setAttribute('label', labelF);
    	button.setAttribute('tooltiptext', tooltiptextF);
}
else
if (Services.prefs.getIntPref(intPref) == 3 ) {
		button.style.fill = iconColorT;
		button.style.listStyleImage = 'url("' + curProfDir + iconPath + iconT + '")';
    	button.setAttribute('label', labelT);
    	button.setAttribute('tooltiptext', tooltiptextT);
}
//click
button.addEventListener('click', () => {
if (event.button == 0) {
	if (Services.prefs.getIntPref(intPref) == 1 ) {
		button.style.fill = iconColorT;
		Services.prefs.setIntPref(intPref, 3);
		button.style.listStyleImage = 'url("' + curProfDir + iconPath + iconT + '")';
    	button.setAttribute('label', labelT);
    	button.setAttribute('tooltiptext', tooltiptextT);
	}
	else
	if (Services.prefs.getIntPref(intPref) == 3 ) {
		button.style.fill = iconColorF;
		Services.prefs.setIntPref(intPref, 1);
		button.style.listStyleImage = 'url("' + curProfDir + iconPath + iconF + '")';
    	button.setAttribute('label', labelF);
    	button.setAttribute('tooltiptext', tooltiptextF);
	}
}
});
//----
	}
});
//----
})();
