// JavaScript Document
// B_UserPrefAnimationMode.uc.js

// Das Script erstellt einen Button, der in about:config character/string-Variablen ändert. In der UserConfiguration unter 'const charPref' kann die zu ändernde Einstellung festgelegt werden. Das icon/label/tooltiptext kann in der UserConfiguration dem jeweiligen Zustand angepasst werden (normal/once/none).
// Für das mitgelieferte Icon als .svg-Datei mit [moz-context-properties] ändert das Script die Einstellung [svg.context-properties.content.enabled] in about:config auf 'true'.
// In einem neuen Profil ist die Einstellung in about:config 'image.animation_mode, normal' gesetzt. Der Button schaltet per Linksklick einen Zustand weiter (von 'image.animation_mode, normal' auf 'once', von 'once' auf 'none' und von 'none' auf 'normal'. Beim Umschalten wird der Seiteninhalt des AKTIVEN Tabs neu geladen.

(function() {
  if (!window.gBrowser)
	return;
// ■■ START UserConfiguration ■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
const id = 'UserPref-iA_m-button'; // Id des neuen Buttons
const charPref = 'image.animation_mode'; // Einstellung in about:config deren character-Variable geschaltet werden soll
const labelNorm = 'Normale Gifanimation (Schleife)'; // Bezeichnung des neuen Buttons bei charPref=normal
const labelOnce = 'Einmalige Gifanimation'; // Bezeichnung des neuen Buttons bei charPref=once
const labelNone = 'Keine Gifanimation'; // Bezeichnung des neuen Buttons bei charPref=none
const ttTextNorm = 'Normale Gifanimation (Schleife)'; // Tooltiptext
const ttTextOnce = 'Einmalige Gifanimation';
const ttTextNone = 'Keine Gifanimation';
// Icon-------------------------------------------------------
const iconNorm = '16-control-panel-20_moz.svg';  // [Name.Dateiendung] des anzuzeigenden Symbols für charPref=normal
const iconOnce = '16-control-panel-19_moz.svg';  // [Name.Dateiendung] des anzuzeigenden Symbols charPref=once
const iconNone = '16-control-panel-18_moz.svg';  // [Name.Dateiendung] des anzuzeigenden Symbols für charPref=none
const bgImage = '#f9f9f9'; // Farbe des Indikators (zur Unterscheidung mehrerer UserPref-buttons)
const iconPath = '/chrome/icons/'; // Pfad zum Ordner der das Icon beinhaltet
const iconColNorm = 'forestgreen';  // Farbe des Icons (nur .svg-Datei mit [moz-context-properties] für charPref=normal, bei anderen Icons hat const iconColNorm keine Funktion)
const iconColOnce = 'goldenrod';  // Farbe des Icons (nur .svg-Datei mit [moz-context-properties] für charPref=once, bei anderen Icons hat const iconColOnce keine Funktion)
const iconColNone = 'firebrick';  // Farbe des Icons (nur .svg-Datei mit [moz-context-properties] für charPref=none, bei anderen Icons hat const iconColNone keine Funktion)
// ■■ END UserConfiguration ■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
const curProfDir = PathUtils.toFileURI(PathUtils.join(PathUtils.profileDir));
//----
	if (Services.prefs.getBoolPref('svg.context-properties.content.enabled') == false) {
		Services.prefs.setBoolPref('svg.context-properties.content.enabled', true );
	}
//----  
CustomizableUI.createWidget({
    id: id,
	type: 'button',
    defaultArea: CustomizableUI.AREA_NAVBAR,
 
    onCreated: (button) => {
		button.style.MozContextProperties = 'fill, stroke, fill-opacity';
//bgImage
		button.style = 'background-image:linear-gradient('+bgImage+','+bgImage+'); background-repeat: no-repeat; background-size: 4px 4px; background-position: left 2px top calc(50% - 8px);';
//start
if (Services.prefs.getCharPref(charPref) == 'normal' ) {
		button.style.fill = iconColNorm;
		button.style.listStyleImage = 'url("' + curProfDir + iconPath + iconNorm + '")';
    	button.setAttribute('label', labelNorm);
    	button.setAttribute('tooltiptext', ttTextNorm);
}
else
if (Services.prefs.getCharPref(charPref) == 'once' ) {
		button.style.fill = iconColOnce;
		button.style.listStyleImage = 'url("' + curProfDir + iconPath + iconOnce + '")';
    	button.setAttribute('label', labelOnce);
    	button.setAttribute('tooltiptext', ttTextOnce);
}
else
if (Services.prefs.getCharPref(charPref) == 'none' ) {
		button.style.fill = iconColNone;
		button.style.listStyleImage = 'url("' + curProfDir + iconPath + iconNone + '")';
    	button.setAttribute('label', labelNone);
    	button.setAttribute('tooltiptext', ttTextNone);
}
//click
button.addEventListener('click', () => {
if (event.button == 0) {
  BrowserCommands.reloadSkipCache();
	if (Services.prefs.getCharPref(charPref) == 'normal' ) {
		Services.prefs.setCharPref(charPref, 'once');
		button.style.fill = iconColOnce;
		button.style.listStyleImage = 'url("' + curProfDir + iconPath + iconOnce + '")';
    	button.setAttribute('label', labelOnce);
    	button.setAttribute('tooltiptext', ttTextOnce);
	}
	else
	if (Services.prefs.getCharPref(charPref) == 'once' ) {
		Services.prefs.setCharPref(charPref, 'none');
		button.style.fill = iconColNone;
		button.style.listStyleImage = 'url("' + curProfDir + iconPath + iconNone + '")';
    	button.setAttribute('label', labelNone);
    	button.setAttribute('tooltiptext', ttTextNone);
	}
	else
	if (Services.prefs.getCharPref(charPref) == 'none' ) {
		Services.prefs.setCharPref(charPref, 'normal');
		button.style.fill = iconColNorm;
		button.style.listStyleImage = 'url("' + curProfDir + iconPath + iconNorm + '")';
    	button.setAttribute('label', labelNorm);
    	button.setAttribute('tooltiptext', ttTextNorm);
	}
}
});
//----
	}
});
//----
})();
