// JavaScript Document
// B_UserPrefAutoScroll.uc.js

// Das Script erstellt einen Button, der in about:config boolsche Werte ändert. In der UserConfiguration unter 'const boolPref' kann die zu ändernde Einstellung festgelegt werden. Das icon/label/tooltiptext kann in der UserConfiguration dem jeweiligen Zustand angepasst werden (true/false).
// Für das mitgelieferte Icon als .svg-Datei mit [moz-context-properties] ändert das Script die Einstellung [svg.context-properties.content.enabled] in about:config auf 'true'.

(function() {
  if (!window.gBrowser)
	return;
// ■■ START UserConfiguration ■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
const id = 'UserPref-aS-button'; // Id des neuen Buttons
const boolPref = 'general.autoScroll'; // Einstellung in about:config deren boolesche Variable geschaltet werden soll
const labelT = 'Autom. Bildlauf aktiviert'; // Bezeichnung des neuen Buttons bei boolPref=true
const labelF = 'Autom. Bildlauf deaktiviert'; // Bezeichnung des neuen Buttons bei boolPref=false
const tooltiptextT = 'Autom. Bildlauf aktiviert';
const tooltiptextF = 'Autom. Bildlauf deaktiviert';
// Icon-------------------------------------------------------
const iconT = '16-control-panel-20_moz.svg';  // [Name.Dateiendung] des anzuzeigenden Symbols für boolPref=true
const iconF = '16-control-panel-18_moz.svg';  // [Name.Dateiendung] des anzuzeigenden Symbols für boolPref=false
const bgImage = 'cyan'; // Farbe des Indikators (zur Unterscheidung mehrerer UserPref-buttons;)
const iconPath = '/chrome/icons/'; // Pfad zum Ordner der das Icon beinhaltet
const iconColorT = 'forestgreen';  // Farbe des Icons (nur .svg-Datei mit [moz-context-properties] für boolPref=true, bei anderen Icons hat const iconColorT keine Funktion)
const iconColorF = 'firebrick';  // Farbe des Icons (nur .svg-Datei mit [moz-context-properties] für boolPref=false, bei anderen Icons hat const iconColorF keine Funktion)
// ■■ END UserConfiguration ■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
const curProfDir = PathUtils.toFileURI(PathUtils.join(PathUtils.profileDir));
//----
	if (Services.prefs.getBoolPref('svg.context-properties.content.enabled') == false) {
		Services.prefs.setBoolPref('svg.context-properties.content.enabled', true );
	}
//----  
CustomizableUI.createWidget({
    id: id,
	type: 'button',
    defaultArea: CustomizableUI.AREA_NAVBAR,
 
    onCreated: (button) => {
		button.style.MozContextProperties = 'fill, stroke, fill-opacity';
//bgImage
		button.style = 'background-image:linear-gradient('+bgImage+','+bgImage+'); background-repeat: no-repeat; background-size: 4px 4px; background-position: left 2px top calc(50% - 8px);';
//start
if (Services.prefs.getBoolPref(boolPref) == false ) {
		button.style.fill = iconColorF;
		button.style.listStyleImage = 'url("' + curProfDir + iconPath + iconF + '")';
    	button.setAttribute('label', labelF);
    	button.setAttribute('tooltiptext', tooltiptextF);
}
else
if (Services.prefs.getBoolPref(boolPref) == true ) {
		button.style.fill = iconColorT;
		button.style.listStyleImage = 'url("' + curProfDir + iconPath + iconT + '")';
    	button.setAttribute('label', labelT);
    	button.setAttribute('tooltiptext', tooltiptextT);
}
//click
button.addEventListener('click', () => {
if (event.button == 0) {
	if (Services.prefs.getBoolPref(boolPref) == false ) {
		button.style.fill = iconColorT;
		Services.prefs.setBoolPref(boolPref, true);
		button.style.listStyleImage = 'url("' + curProfDir + iconPath + iconT + '")';
    	button.setAttribute('label', labelT);
    	button.setAttribute('tooltiptext', tooltiptextT);
	}
	else
	if (Services.prefs.getBoolPref(boolPref) == true ) {
		button.style.fill = iconColorF;
		Services.prefs.setBoolPref(boolPref, false);
		button.style.listStyleImage = 'url("' + curProfDir + iconPath + iconF + '")';
    	button.setAttribute('label', labelF);
    	button.setAttribute('tooltiptext', tooltiptextF);
	}
}
});
//----
	}
});
//----
})();
