
(function() {

  /* Customize Bookmarks treeView interface */
  
  /* Copy and overlay method PTV_getCellProperties(aRow,aColumn) in FF treeView.js */
  /* Called for bookmarks trees as treeView.getCellProperties(aRow,aColumn) - (integer, nsITreeColumn obj) */
  
  /* "this" refers to the caller's treeView object */
  
  const sidebarURI = "chrome://browser/content/bookmarks/bookmarksPanel.xul";
  const libraryURI = "chrome://browser/content/places/places.xul";
  
  var docURI = window.document.documentURI;
  if ( (docURI != sidebarURI) && (docURI != libraryURI) ) { return; }
  
  Components.utils.import("chrome://laaBookmarksTitleStyles/content/laaBookmarksTitleStyles_modx1.jsm");
  var modx1 = laaBookmarksTitleStyles_modx1;
  
  if (docURI == sidebarURI) { modx1.sidebarWindow = window; }
  if (docURI == libraryURI) { modx1.libraryWindow = window; }
      
  var minUserFolderLevel = 1;   /* Sidebar */
  if (docURI == libraryURI) { minUserFolderLevel = 2; }   /* Library Tree Window */

  var original_getCellProperties = PlacesTreeView.prototype.getCellProperties;
  
  PlacesTreeView.prototype.getCellProperties = function(aRow,aColumn) {
  
    var properties = original_getCellProperties.apply(this,arguments);
    
    try {
      
      if (aColumn.primary) {
        let level = this.getLevel(aRow);
        /* If column is Library Content Window, level will be 0 */
        if ( (level >= minUserFolderLevel) || (aColumn.id == "placesContentTitle") ) {
          let node = this._rows[aRow];
          let itemId = node.itemId;
          
          /* If a user setting for a title style is specified for this item, add properties */
          let ns = (modx1.namespace || null);
          
          if ( (ns) && (ns.ColorStyleList) ) {
            let colorname = "";
            
            if (ns.ColorStyleList[itemId]) { colorname = ns.ColorStyleList[itemId]; }
            else {
              if (this.isContainer(aRow)) {
                colorname = ns.ColorStyleList["laafolders"] || "";
              }
              else { colorname = ns.ColorStyleList["laabookmarks"] || ""; }
            }
            
            if (colorname) {
              let prop = "laacolor-" + colorname;
              if (properties.indexOf(" " + prop + " ") == -1) { properties = properties + " " + prop + " "; }
            }
          }
          
          if ( (ns) && (ns.TextStyleList) && (ns.TextStyleList[itemId]) ) {
            let textstyle = ns.TextStyleList[itemId];
            if (textstyle & ns.BOLD) {
              let prop = "laabold";
              if (properties.indexOf(" " + prop + " ") == -1) { properties = properties + " " + prop + " "; }
            }
            if (textstyle & ns.ITALIC) {
              let prop = "laaitalic";
              if (properties.indexOf(" " + prop + " ") == -1) { properties = properties + " " + prop + " "; }
            }
            if (textstyle & ns.UNDERLINE) {
              let prop = "laaunderline";
              if (properties.indexOf(" " + prop + " ") == -1) { properties = properties + " " + prop + " "; }
            }
          }
        }
      }
      
    }
    catch(e) { console.log("laaBookmarksTitleStyles: " + e.toString()); }
        
    return properties;
  }

})();
