
(function() {

  const ns = laaBookmarksTitleStyles;   /* namespace */
  
  ns.m70 = {

    /* When a Places menu is opened, iterate bookmark items. */
    /* A Places menu can be a top-level popup, or any of the subfolder popups. */
    PlacesMenuOpened : function(aEvent) {
      //ns.log("event: " + aEvent.type + " - " + aEvent.target.nodeName + " - " + aEvent.target.id);
      
      var items = aEvent.target.querySelectorAll("menu.bookmark-item,menuitem.bookmark-item");
      
      for (let i = 0; i < items.length; i++) {
        let item = items[i];
        let label = item.getAttribute("label") || "";
        if (!item._placesNode) { continue; }
        let pnode = item._placesNode;
        if (!pnode.itemId) { continue; }
        let itemId = pnode.itemId;
        
        /* If a user setting for an alternate color is specified for this item, add a color name attribute. */
        /* Else delete any attribute that's present. */
        
        let colorname = "";
        
        if (ns.ColorStyleList[itemId]) { colorname = ns.ColorStyleList[itemId]; }
        else {
          if (pnode.type == Ci.nsINavHistoryResultNode.RESULT_TYPE_FOLDER) {
            colorname = ns.ColorStyleList["laafolders"] || "";
          }
          else { colorname = ns.ColorStyleList["laabookmarks"] || ""; }
        }
        
        if (colorname) {
          let colorprop = colorname;
          item.setAttributeNS(ns.name,"laacolor",colorprop);
        }
        else {
          if (item.hasAttributeNS(ns.name,"laacolor")) {
            item.removeAttributeNS(ns.name,"laacolor");
          }
        }
        
        /* If a user setting for a text style is specified for this item, add a style attribute. */
        /* Else delete any attribute that's present. */
        
        let textstyle = ns.TextStyleList[itemId] || "0";
      
        if (textstyle & ns.BOLD) { item.setAttributeNS(ns.name,"laabold","true"); }
        else { item.removeAttributeNS(ns.name,"laabold"); }
        
        if (textstyle & ns.ITALIC) { item.setAttributeNS(ns.name,"laaitalic","true"); }
        else { item.removeAttributeNS(ns.name,"laaitalic"); }

        if (textstyle & ns.UNDERLINE) { item.setAttributeNS(ns.name,"laaunderline","true"); }
        else { item.removeAttributeNS(ns.name,"laaunderline"); }
      }
    },

    /* Called during toolbar load to put style properties on each top-level Bookmarks Toolbar item */
    InitBookmarksToolbar : function(aEvent) {
      var bookmarksToolbar = document.getElementById("PlacesToolbarItems");   /* scrollbox - B. Toolbar */
      var items = bookmarksToolbar.querySelectorAll("toolbarbutton.bookmark-item");
      
      for (let i = 0; i < items.length; i++) {
        let item = items[i];
        let label = item.getAttribute("label") || "";
        if (!item._placesNode) { continue; }
        let pnode = item._placesNode;
        if (!pnode.itemId) { continue; }
        let itemId = pnode.itemId;
        
        /* If a user setting for an alternate color is specified for this item, add a color name attribute. */
        /* Else delete any attribute that's present. */
        
        let colorname = "";
        
        if (ns.ColorStyleList[itemId]) { colorname = ns.ColorStyleList[itemId]; }
        else {
          if (pnode.type == Ci.nsINavHistoryResultNode.RESULT_TYPE_FOLDER) {
            colorname = ns.ColorStyleList["laafolders"] || "";
          }
          else { colorname = ns.ColorStyleList["laabookmarks"] || ""; }
        }
        
        if (colorname) {
          let colorprop = colorname;
          item.setAttributeNS(ns.name,"laacolor",colorprop);
        }
        else {
          if (item.hasAttributeNS(ns.name,"laacolor")) {
            item.removeAttributeNS(ns.name,"laacolor");
          }
        }
        
        /* If a user setting for a text style is specified for this item, add a style attribute. */
        /* Else delete any attribute that's present. */
        
        let textstyle = ns.TextStyleList[itemId] || "0";
      
        if (textstyle & ns.BOLD) { item.setAttributeNS(ns.name,"laabold","true"); }
        else { item.removeAttributeNS(ns.name,"laabold"); }
        
        if (textstyle & ns.ITALIC) { item.setAttributeNS(ns.name,"laaitalic","true"); }
        else { item.removeAttributeNS(ns.name,"laaitalic"); }

        if (textstyle & ns.UNDERLINE) { item.setAttributeNS(ns.name,"laaunderline","true"); }
        else { item.removeAttributeNS(ns.name,"laaunderline"); }
      }
    }

  }

})();
