
(function() {

  const ns = laaBookmarksTitleStyles;   /* namespace */
  
  var colorPickerWindow = null;
  
  var doc = {}
  var documentElement = {}
  
  var notifybox = {}
  var labelNotify = {}
  var display_Image = {}
  var display_NewImage = {}
  var display_ItemLabel = {}
  var display_NewItemLabel = {}
  var display_Colorname = {}
  var display_NewColorname = {}
  var colorsTree = {}
  var paleColors = false;
  var assignButton = {}
  var paleButton = {}
  var templates = {}
  
  var item_favicon = "";
  var item_label = "";
  var item_colorname = "";
  var item_textstyle = "";
  
  var new_colorname = "";
  var return_colorname = "";

  ns.m21 = {

    /* Show dialog to pick Bookmarks title colors */
    PickTextColor : function(aItemfavicon,aItemlabel,aItemColorname,aTextstyle) {
      item_favicon = aItemfavicon;
      item_label = aItemlabel.substr(0,40);
      if (item_label != aItemlabel) { item_label += "..." }
      item_colorname = aItemColorname;
      item_textstyle = aTextstyle;
      
      new_colorname = "";
      return_colorname = "";
        
      ns.getFocusedWindow(window).openDialog(
                 "chrome://laaBookmarksTitleStyles/content/dialogColorPicker.xul", "_blank",
                 "modal,chrome,alwaysRaised,centerscreen,titlebar,close,resizable,scrollbars",
                  ns).focus();
         
      return return_colorname.trim();
    },

    /* Load Bookmarks title colors into tree */
    LoadColorPicker : function(aDocument) {
    
      doc = aDocument;
      colorPickerWindow = doc.defaultView;
      documentElement = doc.documentElement;
      
      notifybox = doc.getElementById("laaBookmarksTitleStyles-colors-notifybox");
      labelNotify = doc.getElementById("laaBookmarksTitleStyles-colors-labelNotify");
      display_Image = doc.getElementById("laaBookmarksTitleStyles-colors-item-image");
      display_NewImage = doc.getElementById("laaBookmarksTitleStyles-colors-new-image");
      display_ItemLabel = doc.getElementById("laaBookmarksTitleStyles-colors-item-label");
      display_NewItemLabel = doc.getElementById("laaBookmarksTitleStyles-colors-new-label");
      display_Colorname = doc.getElementById("laaBookmarksTitleStyles-colors-color-label");
      display_NewColorname = doc.getElementById("laaBookmarksTitleStyles-colors-new-color-label");
      colorsTree = doc.getElementById("laaBookmarksTitleStyles-colors-tree");
      assignButton = doc.getElementById("laaBookmarksTitleStyles-colors-button-assign");
      paleButton = doc.getElementById("laaBookmarksTitleStyles-colors-button-pale");
      templates = doc.getElementById("laaBookmarksTitleStyles-colors-templates");
      
      documentElement.minWidth = Math.min(0.95 * screen.width, 1.30 * screen.height);
      documentElement.maxWidth = 0.95 * screen.width;
      
      documentElement.minHeight = 0.30 * screen.height;
      documentElement.maxHeight = 0.92 * screen.height;
      
      if (item_favicon) {
        if (item_favicon == "laafolder") {
          display_Image.setAttributeNS(ns.name,"laafolder","true");
          display_NewImage.setAttributeNS(ns.name,"laafolder","true");
        }
        else {
          display_Image.setAttribute("src",item_favicon);
          display_NewImage.setAttribute("src",item_favicon);
        }
      }
      
      display_ItemLabel.setAttribute("value",item_label);
      display_NewItemLabel.setAttribute("value",item_label);
      
      if (item_colorname) { display_Colorname.setAttribute("value", item_colorname); }
      else { display_Colorname.setAttribute("value", " ".repeat(8) + "\u2014"); }   /* em dash */
      
      /* If no color is specifically assigned to this item, get any default color that has been set for its type */
      if (!item_colorname) {
        if (item_favicon == "laafolder") { item_colorname = ns.ColorStyleList["laafolders"] || ""; }
        else                             { item_colorname = ns.ColorStyleList["laabookmarks"] || ""; }
      }
      
      if (item_colorname) {
        let colorprop = item_colorname;
        display_ItemLabel.setAttributeNS(ns.name,"laacolor",colorprop);
        display_NewItemLabel.setAttributeNS(ns.name,"laacolor",colorprop);
      }
      
      if (item_textstyle & ns.BOLD) {
        display_ItemLabel.setAttributeNS(ns.name,"laabold","true");
        display_NewItemLabel.setAttributeNS(ns.name,"laabold","true");
      }
      if (item_textstyle & ns.ITALIC) {
        display_ItemLabel.setAttributeNS(ns.name,"laaitalic","true");
        display_NewItemLabel.setAttributeNS(ns.name,"laaitalic","true");
      }
      if (item_textstyle & ns.UNDERLINE) {
        display_ItemLabel.setAttributeNS(ns.name,"laaunderline","true");
        display_NewItemLabel.setAttributeNS(ns.name,"laaunderline","true");
      }
      
      paleColors = false;
      ns.m21.LoadColorTree();
    },

    /* Load tree with the color list */
    LoadColorTree : function() {
      var modelitem = templates.querySelector(".laaBookmarksTitleStyles-colors-treeitem");
      var modelcell = modelitem.querySelector("treecell");
      
      var children = colorsTree.querySelector("treechildren");
      
      while (children.childNodes.length > 0) { children.removeChild(children.lastChild); }
      
      var colors = new Array;
      
      for (let i = 0; i < ns.ColorArray.length; i++) {
        if (paleColors) {
          if (ns.ColorArray[i].shadelev != 1) { continue; }   /* Only show pale colors */
          colors.push(ns.ColorArray[i])
        }
        else {
          if (ns.ColorArray[i].shadelev == 1) { continue; }   /* Skip pale colors */
          colors.push(ns.ColorArray[i])
        }
      }
      
      var numcolumns = colorsTree.querySelectorAll("treecol").length;
      var numrows = Math.ceil(colors.length / numcolumns);
      
      for (let r = 0; r < numrows; r++) {
        let item = modelitem.cloneNode(true);   /* true copies all child elements */
        children.appendChild(item);
        
        for (let c = 0; c < numcolumns; c++) {
          let i = r + (c * numrows);   /* Index of next array element, so as to arrange in columns */
          
          if (i < colors.length) {   /* Larger values of "i" correspond to any empty cells at the end of the table */
            let cell = null;
            
            if (c == 0) {
              cell = item.querySelector("treecell");   /* Cloned row contains one cell */
            }
            else {
              cell = modelcell.cloneNode(true);   /* true copies all child elements */
              item.querySelector("treerow").appendChild(cell);
            }
            
            let color = colors[i];
            let colorname = color.name;
            let colorprop = "laacolor-" + colorname;
            let shadelevprop = "laashadelev" + color.shadelev   /* 1-3, light to dark colors */
            cell.colorname = colorname;
            cell.setAttribute("label", colorname);
            let cellproperties = cell.getAttribute("properties");
            cellproperties = cellproperties + " " + colorprop + " ";
            cellproperties = cellproperties + " " + shadelevprop + " ";
            cell.setAttribute("properties", cellproperties);
          }
        }
      }
    },
    
    /* Display a message for a time interval */ 
    DisplayTimedMessage : function(aText,aInt) {
      labelNotify.value = aText;   /* Display message in dialog window */
      notifybox.collapsed = false;
      setTimeout((function() {
        labelNotify.value = "";
        notifybox.collapsed = true;
      }), aInt);
    },
    
    /* Callback from dialog window onload */
    WindowOnLoad : function(aEvent) {
      colorsTree.currentIndex = 0;   /* Move focus to first cell */
      colorsTree.view.selection.select(0);   /* Select first cell (set highlight) */
      
      assignButton.focus();
      assignButton.disabled = true;
      
      /* Adjust the size of some elements displayed above the tree */
      var box1 = doc.getElementById("laaBookmarksTitleStyles-colors-firstcol1");
      var box2 = doc.getElementById("laaBookmarksTitleStyles-colors-firstcol2");
      var boxwidth = Math.ceil(Math.max(box1.getBoundingClientRect().width,box2.getBoundingClientRect().width));
      
      box1.width = boxwidth;
      box2.width = boxwidth;
      
      /* Setting the "rows" attribute to include the current view.rowCount will force visibility of all content,
         but it prevents scrolling from working properly. In the CSS the tree can be styled to overflow:auto,
         which gets the scroll bar back. But even then, the mouse scroll wheel will not work. To make scrolling
         work correctly, leave "rows" set to 0, and then set a height for the tree that is based on view.rowCount
         and the row height.
         (In other trees I've just set a fixed/minimum height for the tree or the dialog, to keep the tree
         from collapsing vertically. I've used a different method here, so as to make the window - and hence
         the tree - resizable by the user.) */
         
      colorsTree.setAttribute("rows", 1);   /* This sets tree content box height to one row */
      var rowHeight = colorsTree.querySelector("treechildren").getBoundingClientRect().height;
      colorsTree.setAttribute("rows", 0);   /* Prevent scrolling anomalies */
      
      /* Set target for displayed row count to all content + any desired padding rows at the end */
      var rowCount = colorsTree.view.rowCount + 0;
      
      /* Tree box height - colorsTree.getBoundingClientRect().height - has been returning, apparently,
         only the header and border height, with no content, even if "rows" is set. The methods below
         attempt to get the precise tree height. */
      
      var colHeight = colorsTree.querySelector("treecol").getBoundingClientRect().height;
      var treeHeight = colHeight + 2;   /* header, borders - all except content */
      treeHeight = treeHeight + (rowCount * rowHeight);
      colorsTree.height = treeHeight;   /* Try to display all content unless it overflows dialog maxHeight */
    },
    
    /* Callback from dialog window onunload */
    WindowOnUnload : function(aEvent) {
    },
    
    /* Called when the tree item focus changes.
       In FF37, the onfocus event is fired only when the tree receives focus from another element,
       but not when a new item is focused and selected. Therefore, the onmouseup and onkeyup events
       are also coded to call this function, so that it is invoked each time the focus/selection
       may have changed.
       In FF37, the onselect event should be fired whenever the item selection changes, and so might
       have been used for this purpose. But for a tree with multiple columns and seltype="cell",
       it doesn't work right. (1) It is not called if another cell in the current row is clicked.
       (2) Apparently due to timing, when a cell in a different row & column is clicked, when the
       onselect event is called, the tree has not yet processed the change of column, and so the
       old column is returned, along with the new, correct row.
       */
    TreeItemFocus : function(aEvent) {
      assignButton.disabled = true;
      var row = colorsTree.currentIndex;
      var column = colorsTree.view.selection.currentColumn;   /* nsITreeColumn object */
      
      new_colorname = "";
      try {
        let xulItem = colorsTree.contentView.getItemAtIndex(row);
        let xulCell = xulItem.querySelectorAll("treecell")[column.index];
        new_colorname = xulCell.colorname;
      } catch(e) {}
      if (!new_colorname) { new_colorname = ""; }
      
      if (!new_colorname.trim()) {
        display_NewColorname.setAttribute("value", "");
        if (item_colorname) {
          let colorprop = item_colorname;
          display_NewItemLabel.setAttributeNS(ns.name,"laacolor",colorprop);
        }
        else {
          display_NewItemLabel.removeAttributeNS(ns.name,"laacolor");
        }
        return;
      }
      
      assignButton.disabled = false;
      display_NewColorname.setAttribute("value", new_colorname);
      let colorprop = new_colorname;
      display_NewItemLabel.setAttributeNS(ns.name,"laacolor",colorprop);
    },
    
    /* Button callback to toggle pale colors */
    TogglePaleColors : function() {
      paleColors = (!paleColors);
      if (paleColors) { paleButton.setAttributeNS(ns.name,"set","true"); }
      else { paleButton.removeAttributeNS(ns.name,"set"); }
      ns.m21.LoadColorTree();
    },
    
    /* Button callback to cancel the dialog */
    Cancel : function() {
      colorPickerWindow.close();
    },
    
    /* Button callback to assign the selected favicon image */
    Assign : function() {
      if (!new_colorname.trim()) { return; }
      return_colorname = new_colorname;
      colorPickerWindow.close();
    }
    
  }

})();
