
var laaBookmarksTitleStyles = {};   /* extension namespace */

(function() {

  const ns = laaBookmarksTitleStyles;   /* namespace */
  ns.name = "laaBookmarksTitleStyles";
  
  /* This function works just like pref() in an extension defaults/preferences/xxx.js file, but returns
     the key name so it can be assigned to a variable or property at the same time. This avoids having
     to define the keys in a preferences module, as well as in an initialization module. */
  ns.pref = function(aKey,aValue) {
    var DefaultPrefs = Services.prefs.getDefaultBranch("");   /* nsIPrefBranch */
    var numeric = /^[0-9]+$/;   /* Returns true if string consists of one or more numerals */
    var goodvalue = false;   /* Must be string, boolean, or integer */
    if (typeof(aValue) == "string")  { DefaultPrefs.setCharPref(aKey,aValue); goodvalue = true; }
    if (typeof(aValue) == "boolean") { DefaultPrefs.setBoolPref(aKey,aValue); goodvalue = true; }
    if (numeric.test(aValue))         { DefaultPrefs.setIntPref(aKey,aValue); goodvalue = true; }
    if (goodvalue) { return aKey; }
    throw "Invalid default value - " + aValue + " - specified for key '" + aKey + "'";
  }
  
  /* Log function that may be called to debug scripts in XUL dialog windows,
     where console.log is usually inoperative. */
  ns.log = function(aText) { console.log(aText); }

  /* Informational, warning, and critical, notificationbox messages. If optional non-zero interval
     in milliseconds is specified, notification will be removed after that interval elapses.
     Icon images and other aesthetics may be supplied via CSS. */
  
  ns.notify = function(aText,aInt) {
    ns.notifyFcn(aText, aInt, "laaBookmarksTitleStyles-info", null, gBrowser.getNotificationBox().PRIORITY_INFO_MEDIUM);
  }

  ns.notifyWarning = function(aText) {
    ns.notifyFcn(aText, null, "laaBookmarksTitleStyles-warning", null, gBrowser.getNotificationBox().PRIORITY_WARNING_MEDIUM);
  }

  ns.notifyCritical = function(aText) {
    ns.notifyFcn(aText, null, "laaBookmarksTitleStyles-critical", null, gBrowser.getNotificationBox().PRIORITY_CRITICAL_MEDIUM);
  }

  /* Internal function for above notify functions */
  ns.notifyFcn = function(aText, aInt, aValue, aImage, aPriority) {
    var notification = gBrowser.getNotificationBox().appendNotification(aText, aValue, aImage, aPriority);   /* Post notification */
    
    if (aInt) { setTimeout((function() {   /* Remove notification after interval, if one is specified */
      if (gBrowser.getNotificationBox().currentNotification == notification) { notification.close(); }  /* Remove only if not hidden */
    }), aInt); }
  }
  
  /* Informational message OK box */
  ns.alert = function(aText,aTitle) {
    if (typeof(aTitle) == "undefined") { aTitle = null; }
    ns.alertDialog(aText,aTitle,"message-icon");
  }
  
  /* Warning (alert) message OK box */
  ns.alertW = function(aText,aTitle) {
    if (typeof(aTitle) == "undefined") { aTitle = null; }
    ns.alertDialog(aText,aTitle,"alert-icon");
  }
  
  /* Error message OK box */
  ns.alertE = function(aText,aTitle) {
    if (typeof(aTitle) == "undefined") { aTitle = null; }
    ns.alertDialog(aText,aTitle,"error-icon");
  }
  
  /* Provides an "OK" dialog box similar to js alert, but title is controlled by extension. */
  ns.alertDialog = function(aText,aTitle,aIcon) {
    ns.getFocusedWindow(window).openDialog(
       "chrome://laaBookmarksTitleStyles/content/dialogAlert.xul", "_blank",
       "modal,chrome,alwaysRaised,centerscreen,titlebar,close,scrollbars",
       ns, aText, aTitle, aIcon).focus();
  }
      
  /* Callbacks from dialogAlert.xul. */
  ns.dialogAlert1 = {
  
    process: function(aDocument,aText,aTitle,aIcon) {
      if ( (typeof(aText) != "undefined") && (aText != null) )
         { aDocument.getElementById("laaBookmarksTitleStyles-AlertBoxText").textContent = aText.toString(); }
      if ( (typeof(aTitle) != "undefined") && (aTitle != null) )
         { aDocument.getElementById("laaBookmarksTitleStyles-AlertBox").setAttribute("title", aTitle.toString()); }
      var iconClass = "spaced " + aIcon;
      aDocument.getElementById("laaBookmarksTitleStyles-AlertBoxIcon").className = iconClass;
      aDocument.getElementById("laaBookmarksTitleStyles-AlertBoxText").maxWidth = 0.50 * screen.width;
    },
  
    onload : function(aEvent,aDocument) {
      /* Make padding on right the same width as icon column on left */
      aDocument.getElementById("laaBookmarksTitleStyles-AlertBox-rightcolumn").width =
        aDocument.getElementById("laaBookmarksTitleStyles-AlertBox-iconcolumn").getBoundingClientRect().width;
    }      
  }

  /* Get the window that currently has focus. If none, return the optional default object, or null. */
  ns.getFocusedWindow = function(aDefault) {
    if ( typeof(aDefault) == "undefined" ) { aDefault = null; }
    return Cc["@mozilla.org/focus-manager;1"].getService(Ci.nsIFocusManager).focusedWindow || aDefault;   
  }
  
  /* Return true if the referenced xul element currently has focus, else false */
  ns.elementHasFocus = function(aElement) {
    var win = ns.getFocusedWindow();
    if (win == null) { return false; }
    var doc = win.document;
    return ( (aElement == doc.activeElement) || (aElement == doc.getBindingParent(doc.activeElement)) );
  }
  
  /* Copy text string to clipboard */
  ns.copyText = function(text) {
    Cc["@mozilla.org/widget/clipboardhelper;1"].getService(Ci.nsIClipboardHelper).copyString(text);
  }
  
  /* Returns nsIXULRuntime object, with information about the host platform (e.g., Windows). */
  ns.xulRuntime = Cc["@mozilla.org/xre/app-info;1"].getService(Ci.nsIXULRuntime);  
  
  /* Returns nsIXULAppInfo object, with information about the host application (e.g., Firefox). */
  ns.xulAppInfo = Cc["@mozilla.org/xre/app-info;1"].getService(Ci.nsIXULAppInfo);  
  
  /* Returns identifier of selected language, e.g., "en-US". */
  ns.locale = Cc["@mozilla.org/chrome/chrome-registry;1"].getService(Ci.nsIXULChromeRegistry)
              .getSelectedLocale("global");

  /* Unstring error info from a catch(e) error object */
  ns.parseError = function(e) {
    var text = e.toString();
    if (text == "Error") { text = ""; }
    
    if (e.description) {
      if (text != "") { text = text + "\n\n"; }
      text = text + e.description.toString();
    }
  
    if ( typeof(e.number) != "undefined" ) {
      let fcode = (e.number>>16 & 0x1FFF);
      let ecode = (e.number & 0xFFFF);
      if ( (fcode != 0) || (ecode != 0) ) {
        if (text != "") { text = text + "\n\n"; }
        text = text + "[ facility code " + fcode.toString() + ", error code " + ecode.toString() + " ]";
      }
    }
    if (text == "") { text = "[ Error object contains no information ]"; }
    return text;
  }
    
})();
