
(function() {

  const ns = laaBookmarksTitleStyles;   /* namespace */
  
  var helpBrowseWindow = null;
  var doc = {}
  
  /* Browser selects right locale subfolder for language */
  const helpChromeURI = "chrome://laaBookmarksTitleStyles/locale/Help.txt";
      
  var tempPath = "";
  var helpText = "";
  var helpTextbox = {}
  
  var textboxInitialWidth = 0.60 * screen.width;   /* Initial width at which to word-wrap Help text */
  var textboxInitialHeight = 0.80 * screen.height;   /* Initial height of textbox */
      
  const ios = Cc['@mozilla.org/network/io-service;1'].getService(Ci["nsIIOService"]);
  const cr = Cc['@mozilla.org/chrome/chrome-registry;1'].getService(Ci["nsIChromeRegistry"]);
  const zr = Cc["@mozilla.org/libjar/zip-reader;1"].createInstance(Ci.nsIZipReader);
  const { TextDecoder, OS } = Cu.import("resource://gre/modules/osfile.jsm", {});
  const decoder = new TextDecoder();
      
  ns.m50 = {
  
/****************************************************************************************************/
  
    /* Called from main button menu to browse Help */
    LoadHelp : function() {
    
      /* Make this dialog single-instance. If already open, restore and bring to front. */
      if (helpBrowseWindow != null) {
        helpBrowseWindow.restore();
        helpBrowseWindow.focus();
        return;
      }
      
      if (helpText) { ns.m50.ShowHelp(); return; }   /* If Help text already loaded, go straight to dialog */
      
      /******** Proceed to load the Help text from an extension chrome file on the first call ********/
      
      var uriObj = ios.newURI(helpChromeURI, "UTF-8", null);   /* nsIURI object with .spec = "chrome://..." path */
      
      /* For the Help file, in the locale folder, this method expands to the correct localized locale subfolder. */
      uriObj = cr.convertChromeURL(uriObj);   /* nsIURI object with .spec = localized jar or file path  */
      
      var path = uriObj.spec;   /* "jar:///C:/..." path  (or "file:///C:/..." when extension installed unpacked ) */
      
      if (path.indexOf("!/") > -1) {   /* Detect jar path when extension installed as packed xpi */
        let xpiPath = OS.Path.join(OS.Constants.Path.profileDir, "extensions", ns.Addon.id + ".xpi");
        var xpiFile = new FileUtils.File(xpiPath);   /* nsIFile object for reading the packed extension.xpi file */
        
        let folderPath = OS.Path.join(OS.Constants.Path.profileDir, "laaBookmarksTitleStyles");   /* Extension data folder */
        tempPath = OS.Path.join(folderPath, "Help~.txt");   /* Path for temporary extracted copy of Help text file */
        var tempFile = new FileUtils.File(tempPath);   /* nsIFile object for Help output file */
        
        OS.File.makeDir(folderPath).then(   /* Ensure data folder exists. No error should occur either way. */
          function onSuccess() {
            OS.File.remove(tempPath).then(   /* Must delete any previous temp file. Extract will not overwrite. */
              function onSuccess() { extract(); },
              function onError() { extract(); }   /* Error just means no file to delete */
            );
          }
        );
      }
      
      else {   /* Use file path when extension is installed unpacked. Read chrome Help file directly. */
        path = OS.Path.fromFileURI(path);   /* Get native path - "C:\..." */
        ReadHelp();
      }
      
      return;
        
      function extract() {   /* Extract an unpacked copy of the Help text file to the extension data folder */
        zr.open(xpiFile);   /* Open the extension's packed .xpi file */
        
        let entryPointer = path.split("!/")[1];   /* "chrome/locale/en-US/Help.txt", or other language */
        
        try {
          zr.extract(entryPointer, tempFile);   /* Extract packed chrome file to temp */
        }
        
        catch(e) {
          let helpOpenErrorCode = ns.parseError(e).toString();
          let msg = ns.stringBundle.getFormattedString("laaBookmarksTitleStyles.BrowseHelp.msg.HelpOpenErrorCode",
                    new Array(ns.Addon.name.toString(),ns.locale.toString(),helpOpenErrorCode.toString()));
          ns.notifyCritical(msg);
          return;
        }
        
        finally { zr.close(); }
        
        path = tempPath;   /* Point to temp copy of Help file */
        ReadHelp();
      }
        
      function ReadHelp() {
        
        var promise = OS.File.read(path);   /* Start asynchronous read of file into byte array */
        
        promise.then(   /* Listen for completion of file read */
          function onSuccess(aArray) {
            if (tempPath) { OS.File.remove(tempPath); }   /* If reading extracted temp copy, delete it */
            helpText = decoder.decode(aArray);   /* Decode file byte array to text string */
            ns.m50.ShowHelp();
          },
          function onError(aError) {
            let helpOpenErrorCode = aError.toString();
            helpOpenErrorCode = helpOpenErrorCode.replace("\n\)","\)");   /* Remove quirk newline character in msg */
            let msg = ns.stringBundle.getFormattedString("laaBookmarksTitleStyles.BrowseHelp.msg.HelpOpenErrorCode",
                      new Array(ns.Addon.name.toString(),ns.locale.toString(),helpOpenErrorCode.toString()));
            ns.notifyCritical(msg);
          }
        );
      }
      
    },
  
/****************************************************************************************************/
  
    /* Display Help Dialog */
    ShowHelp : function() {
        
      helpBrowseWindow = window.openDialog(
                 "chrome://laaBookmarksTitleStyles/content/dialogHelpBrowse.xul", "_blank",
                 "chrome,centerscreen,titlebar,close,minimizable,resizable,scrollbars",
                  ns);
  
      helpBrowseWindow.focus();
    },
  
    /* Called from Help browse dialog to load Help text */
    LoadHelpText : function() {
      doc = helpBrowseWindow.document;
      
      helpTextbox = doc.getElementById("laaBookmarksTitleStyles-help-textbox");
      helpTextbox.width = textboxInitialWidth;
      helpTextbox.height = textboxInitialHeight;
      
      var locale_msg = ns.stringBundle.getFormattedString("laaBookmarksTitleStyles.BrowseHelp.label.footer.locale",
                       new Array(ns.locale.toString()));
      doc.getElementById("laaBookmarksTitleStyles-help-footer-label-locale").value = locale_msg;
      
    /******** Style Class Definitions ********/
    
      var textclasses = {}    /* Style classes for text paragraphs */
      textclasses[".text"] = ns.name + "-help-text";   /* "namespace-help-text" is default style class */
      
      var headclasses ={}    /* Style classes for main title and headings */
      headclasses[".title"]                = ns.name + "-help-title";         /* Centered main title - special font */
      headclasses[".title-plain"]          = ns.name + "-help-title-plain";   /* Centered main title - plain font */
      headclasses[".heading-center"]       = ns.name + "-help-heading-center";       /* Centered primary headings */
      headclasses[".subheading"]           = ns.name + "-help-subheading";           /* Justified subheadings */
      headclasses[".subheading-underline"] = ns.name + "-help-subheading-underline"; /* Underlined just. subheadings */
      
      blanklineclass = ns.name + "-help-blankline";   /* Style class for all blank lines */
      
    /*****************************************/
      
      var linesep = "\r\n";   /* CRLF characters - Windows */
      if (helpText.indexOf(linesep) == -1) { linesep = "\n" }   /* LF - Mac OS X & Linux */
      if (helpText.indexOf(linesep) == -1) { linesep = "\r" }   /* CR - older Mac OS */
      var helpArray = helpText.split(linesep);   /* Get array of Help file records */
      
      var styleClassText = textclasses[".text"];   /* Default paragraph style class */
      var styleClassHeading ="";
      
      for (let i = 0; i < helpArray.length; i++) {   /* Iterate file records */
        let rec = helpArray[i];
        let txt ="";
        
        if (rec.substr(0,1) == "#") { continue; }   /* Skip embedded "#..." comments */
        
        /* Look for embedded style class keywords */
        if (rec.substr(0,1) == ".") {   /* Period is first character of line */
          txt = rec.split(" ",2)[0];   /* Text up to first space (if any) */
          
          /* Activate this code block only if multiple text style classes are defined.
             Otherwise, explicit use of the only text class is unnecessary, and will be treated as an error.
          */
          //if (textclasses[txt]) {   /* If this is a valid text class keyword... */
            //styleClassText = textclasses[txt];   /* Remember current text style class */
            //styleClassHeading ="";   /* Next paragraph is not a heading */
            //continue;
          //}
          
          if (headclasses[txt]) {   /* If this is a valid heading class keyword... */
            styleClassHeading = headclasses[txt];   /* Use this heading style class for next line */
            continue;
          }
        }
        
        txt = rec.substr(0,1);   /* Save first character for reference */
        
        rec = rec.trim() + "\n";   /* Mozilla js String object method that removes leading and trailing whitespace */
        
        if ( (rec.substr(0,1) == ".") && (txt != ".") ) { rec = "  " + rec;   /* Improperly indented style keyword */ }
        
        let description = doc.createElement("description");
        description.textContent = rec;
        
        /* Look for blank lines. Use special style class. */
        if (rec.search(/\S/) == -1) {   /* If no non-whitespace characters present, treat as blank line */
          description.setAttribute("class", blanklineclass + " " + description.getAttribute("class"));
          helpTextbox.appendChild(description);
          continue;
        }

        let useclass = styleClassText;   /* Use this class if record is paragraph text */
        if (styleClassHeading) { useclass = styleClassHeading; }   /* This record is a heading, so use this class */
        description.setAttribute("class", useclass + " " + description.getAttribute("class"));
        
        helpTextbox.appendChild(description);
        styleClassHeading = "";   /* Reset heading style class. Subsequent records are paragraph text. */
      }
    },
    
    /* Callback from dialog window onload */
    WindowOnLoad : function(aEvent) {
    },
    
    /* Callback from dialog window onunload */
    WindowOnUnload : function(aEvent) {
      helpBrowseWindow = null;
    }
    
  }

})();
