
(function() {

  const ns = laaBookmarksTitleStyles;   /* namespace */
    
  const bookmarkService = Cc["@mozilla.org/browser/nav-bookmarks-service;1"].getService(Ci.nsINavBookmarksService);
  const historyService = Cc["@mozilla.org/browser/nav-history-service;1"].getService(Ci.nsINavHistoryService);
  const xulStore = Cc["@mozilla.org/xul/xulstore;1"].getService(Ci.nsIXULStore);

  ns.m40 = {

    /* Take checkpoint before json restore */
    CheckpointBeforeRestore : function() {
      ns.log("BTS - Checkpoint Before JSON Restore");
      
      var options = historyService.getNewQueryOptions();   /* nsINavHistoryQueryOptions */
      options.queryType = options.QUERY_TYPE_BOOKMARKS;
      options.excludeItems = false;
      options.excludeQueries = true;   /* "smart" folders */
      
      getBookmarksTreeItems(bookmarkService.toolbarFolder,"");   /* title = "Bookmarks Toolbar" */
      getBookmarksTreeItems(bookmarkService.bookmarksMenuFolder,"");   /* title = "Bookmarks Menu" */
      getBookmarksTreeItems(bookmarkService.unfiledBookmarksFolder,"");   /* title = "Unsorted Bookmarks" */
      
      ns.StyleListPath = new Object;
      
      for (let x = xulStore.getIDsEnumerator(ns.StyleURI); x.hasMore();) {
        let itemId = x.getNext();   /* The places itemId */
        if (!ns.PathList[itemId]) { continue; }
        let colorname = xulStore.getValue(ns.StyleURI, itemId, "ColorName") || "";
        let textstyle = xulStore.getValue(ns.StyleURI, itemId, "TextStyle") || "";
        var path = ns.PathList[itemId];
        ns.StyleListPath[path] = { colorname : colorname, textstyle : textstyle }
      }
      
      return;
      
      function getBookmarksTreeItems(aItemId,aPath) {
        var itemTitle = bookmarkService.getItemTitle(aItemId);
        aPath = aPath + ns.PathSep + itemTitle;
        ns.PathList[aItemId] = aPath;
        
        /* Query descendant folders */
        var query = historyService.getNewQuery();   /* nsINavHistoryQuery */
        query.setFolders([aItemId], 1);
        var result = historyService.executeQuery(query,options);   /* nsINavHistoryResult - wrapper - a few controls */
        result.suppressNotifications = true;
        var rootnode = result.root;   /* nsINavHistoryContainerResultNode - folder containing child items */
        rootnode.containerOpen = true;
        for (let i = 0; i < rootnode.childCount; i++) {
          let item = rootnode.getChild(i);   /* nsINavHistoryResultNode - itemId, title, uri, and other properties */
          ns.PathList[item.itemId] = aPath + ns.PathSep + item.title;
          if (item.type == item.RESULT_TYPE_URI) { continue; }
          getBookmarksTreeItems(item.itemId,aPath);   /* Recurse to get all descendant items */
        }
        rootnode.containerOpen = false;
      }
    },
    
    /* Recover text style properties after json restore */
    RecoverAfterRestore : function() {
      ns.log("BTS - Recover After JSON Restore");
      
      /* Clear the old style records */
      for (let x = xulStore.getIDsEnumerator(ns.StyleURI); x.hasMore();) {
        let itemId = x.getNext();   /* The places itemId */
        xulStore.removeValue(ns.StyleURI, itemId, "ColorName");   /* Remove record */
        xulStore.removeValue(ns.StyleURI, itemId, "TextStyle");   /* Remove record */
      }
      
      ns.ColorStyleList = new Object;
      ns.TextStyleList = new Object;
      
      var options = historyService.getNewQueryOptions();   /* nsINavHistoryQueryOptions */
      options.queryType = options.QUERY_TYPE_BOOKMARKS;
      options.excludeItems = false;
      options.excludeQueries = true;   /* "smart" folders */
      
      getBookmarksTreeItems("laafolders","laafolders");   /* Default for Folder Text */
      getBookmarksTreeItems("laabookmarks","laabookmarks");   /* Default for Bookmarks Text */
      getBookmarksTreeItems(bookmarkService.toolbarFolder,"");   /* title = "Bookmarks Toolbar" */
      getBookmarksTreeItems(bookmarkService.bookmarksMenuFolder,"");   /* title = "Bookmarks Menu" */
      getBookmarksTreeItems(bookmarkService.unfiledBookmarksFolder,"");   /* title = "Unsorted Bookmarks" */
      
      ns.m20.ManageButtons();
      ns.m70.InitBookmarksToolbar();
      ns.m20.RefreshBookmarksTreeView();
      
      return;
      
      function getBookmarksTreeItems(aItemId,aPath) {
        var itemType = "";
      
        if (aItemId.toString().indexOf("laa") == 0) {   /* Default item */
          itemType = null;
        }
        else {
          itemType = bookmarkService.getItemType(aItemId);
          let itemTitle = bookmarkService.getItemTitle(aItemId);
          aPath = aPath + ns.PathSep + itemTitle;
        }
        
        ns.PathList[aItemId] = aPath;
        
        /* Restore text color/style assignments based on item title/path */
        if (ns.StyleListPath[aPath]) {
          let colorname = ns.StyleListPath[aPath].colorname;
          let textstyle = ns.StyleListPath[aPath].textstyle;
          
          if (colorname) {
            xulStore.setValue(ns.StyleURI, aItemId, "ColorName", colorname);
            ns.ColorStyleList[aItemId] = colorname;
          }
          
          if (textstyle) {
            xulStore.setValue(ns.StyleURI, aItemId, "TextStyle", textstyle);
            ns.TextStyleList[aItemId] = textstyle;
          }
        }
        
        if (itemType != bookmarkService.TYPE_FOLDER) { return; }
        
        /* Query descendant folders */
        var query = historyService.getNewQuery();   /* nsINavHistoryQuery */
        query.setFolders([aItemId], 1);
        var result = historyService.executeQuery(query,options);   /* nsINavHistoryResult - wrapper - a few controls */
        result.suppressNotifications = true;
        var rootnode = result.root;   /* nsINavHistoryContainerResultNode - folder containing child items */
        rootnode.containerOpen = true;
        for (let i = 0; i < rootnode.childCount; i++) {
          let item = rootnode.getChild(i);   /* nsINavHistoryResultNode - itemId, title, uri, and other properties */
          getBookmarksTreeItems(item.itemId,aPath);   /* Recurse to get all descendant items, and process URIs */
        }
        rootnode.containerOpen = false;
      }
    }
    
  }

})();
