
(function() {

  const ns = laaBookmarksTitleStyles;   /* namespace */
      
  const folderPath = OS.Path.join(OS.Constants.Path.profileDir, "laaBookmarksTitleStyles"); /* Extension data folder */
  const CSSNativePath = OS.Path.join(folderPath, "TitleColors.css");   /* Title Colors generated CSS file */
  
  const ios = Cc['@mozilla.org/network/io-service;1'].getService(Ci["nsIIOService"]);
  const sss = Cc["@mozilla.org/content/style-sheet-service;1"].getService(Ci.nsIStyleSheetService);
  
  ns.m30 = {
  
    /* Called during init to build color list object from array */
    BuildColorList : function() {
    
      for (let i = (ns.ColorArray.length - 1); i >= 0; i--) {
        let color = ns.ColorArray[i];
        if (color.alpha != 255) { ns.ColorArray.splice(i,1); }   /* Discard transparencies */
      }
    
      ns.ColorList = new Object;
      for (let i = 0; i < ns.ColorArray.length; i++) {
        let color = ns.ColorArray[i];
        ns.ColorList[color.name] = 1;
      }
    
      ns.ColorArraySorted = ns.ColorArray.slice(0)   /* Copy array */
      ns.ColorArraySorted.sort(colornamecompare)   /* Sort new array in color name order */
      
      function colornamecompare(color1,color2) {
        var a = color1.name.toString();
        var b = color2.name.toString();
        return ( Number(a > b) - Number(a < b) );
      }
      
      /* The TitleColors.css and TitleStyles.css stylesheets are static sheets in the chrome, which allows them
         to be applied to the dialogs as quickly as possible on initialization. However, there is evidence that
         they are not working on the systems of some users (possibly extension conflicts), even though BFI works
         OK on the same systems. Therefore, it seems advisable to also load and register them as User style sheets,
         as BFI does.
      */
      var CSSFilePath1 = "chrome://laaBookmarksTitleStyles-os/skin/TitleColors.css";
      var uriObj1 = ios.newURI(CSSFilePath1, "UTF-8", null);   /* nsIURI object with .spec = CSS file path */
      sss.loadAndRegisterSheet(uriObj1, sss.USER_SHEET);
      
      var CSSFilePath2 = "chrome://laaBookmarksTitleStyles-os/skin/TitleStyles.css";
      var uriObj2 = ios.newURI(CSSFilePath2, "UTF-8", null);   /* nsIURI object with .spec = CSS file path */
      sss.loadAndRegisterSheet(uriObj2, sss.USER_SHEET);
      
      ns.m20.RefreshBookmarksTreeView();
      
    },
    
  
/****************************************************************************************************/
  
    /* Called from button function to regenerate title colors stylesheet */
    GenerateColorCSS : function() {
                         
      var outputbuffer = BuildCSSFileText();   /* Build CSS records in output buffer */
      
      /* Start asynchronous write of output data into file */
      var promise = OS.File.writeAtomic(CSSNativePath, outputbuffer,
                    { encoding: "UTF-8", tmpPath: CSSNativePath + "~" });
      
      promise.then(   /* Listen for completion of file write */
      
        function onSuccess() {
          ns.alert("Color Stylesheet written to extension profile folder");
        },
        
        function onError(aReason) {
          var fileOpenErrorCode = aReason.toString();
          fileOpenErrorCode = fileOpenErrorCode.replace("\n\)","\)");   /* Remove quirk newline character in msg */
          var msg = ns.stringBundle.getString("laaBookmarksTitleStyles.ColorProcesses.msg.ErrorDuringProcessing.cn");
          ns.alertE(msg + "  " + CSSNativePath + "\n\n" + fileOpenErrorCode);
        }
        
      );

      function BuildCSSFileText() {
  
        const linesep = "\r\n";   /* CRLF characters */
        
        var filetext =  ' ' + linesep
                      + '@namespace x url(laaBookmarksTitleStyles);' + linesep
                      + ' ' + linesep;
      
        const itemlines = [
          '/***********************************************************************************************/',
          ' ',
          'menupopup#BMB_bookmarksPopup     menu.bookmark-item[x|laacolor="$colorname"] > label,',
          'menupopup#BMB_bookmarksPopup menuitem.bookmark-item[x|laacolor="$colorname"] > label,',
          'menupopup#bookmarksMenuPopup     menu.bookmark-item:not(:hover)[x|laacolor="$colorname"] > label,',
          'menupopup#bookmarksMenuPopup menuitem.bookmark-item:not(:hover)[x|laacolor="$colorname"] > label,',
          ' ',
          'toolbaritem#personal-bookmarks     menu.bookmark-item:not(:hover)[x|laacolor="$colorname"] > label,',
          'toolbaritem#personal-bookmarks menuitem.bookmark-item:not(:hover)[x|laacolor="$colorname"] > label,',
          ' ',
          'tree#bookmarks-view treechildren::-moz-tree-cell-text(primary,laacolor-$colorname),',
          '#placesView tree    treechildren::-moz-tree-cell-text(primary,laacolor-$colorname),',
          ' ',
          'tree#laaBookmarksTitleStyles-places-tree',
          '                treechildren::-moz-tree-cell-text(primary,laacolor-$colorname),',
          ' ',
          '#laaBookmarksTitleStyles-colors-item-label[x|laacolor="$colorname"],',
          '#laaBookmarksTitleStyles-colors-new-label[x|laacolor="$colorname"]',
          ' ',
          '  { color:$colorhex !important; /* $colorname */ }',
          ' ',
          'tree#bookmarks-view:focus treechildren::-moz-tree-cell-text(primary,selected,laacolor-$colorname),',
          '#placesView tree:focus    treechildren::-moz-tree-cell-text(primary,selected,laacolor-$colorname)',
          ' ',
          '  { color:white !important; }',
          ' ',
          'tree#laaBookmarksTitleStyles-colors-tree',
          '                treechildren::-moz-tree-cell(laacolor-$colorname)',
          ' ',
          '  { background-color:$colorhex !important; /* $colorname */ }',
          ' '
        ]
              
        for (let i = 0; i < ns.ColorArraySorted.length; i++) {
          let colorname = ns.ColorArraySorted[i].name;
          let colorhex = ns.ColorArraySorted[i].hex;
          let newOutputRecords = "";
          
          for (let n = 0; n < itemlines.length; n++) {
          
            let line = itemlines[n]
                       .replace("$colorname",colorname)
                       .replace("$colorhex",colorhex)
                       + linesep;
                       
            newOutputRecords = newOutputRecords + line;
          }
          
          filetext = filetext + newOutputRecords;
        }
        
        return filetext;
      }
    }
    
  }

})();
