
(function() {

  const ns = laaBookmarksTitleStyles;   /* namespace */
  
  const CUI = CustomizableUI;

  ns.m2 = {
    
    /* When toolbar button is pressed, display main menu popup */
    ButtonPressed : function(aEvent,button) {
      var anchor = button;
      var areaType = CUI.getWidget(button.id).areaType;
      var mainmenu = document.getElementById("laaBookmarksTitleStyles-button-menu-popup");
      
      if (areaType == CUI.TYPE_TOOLBAR) {
        mainmenu.openPopup(anchor,"bottomcenter topright");
      }
      else {
        let anchor = document.getElementById("PanelUI-menu-button");   /* FF button that opens tools menu-panel */
        if (anchor) { mainmenu.openPopup(anchor,"bottomcenter topright"); }
        else { mainmenu.openPopupAtScreen(window.screenX + window.outerWidth/2, window.screenY + screen.height/7); }
      }
    },
    
    /* Set listeners for Places menu opens */
    ObserveMenuOpens : function(aStart) {   /* true = start; false = stop */
      
      ns.m2.ObserveToolbarLoads(aStart);
    
      var BMB_bookmarksPopup = document.getElementById("BMB_bookmarksPopup");   /* menupopup - B. Popup in nav-bar */
      var bookmarksMenuPopup = document.getElementById("bookmarksMenuPopup");   /* menupopup - B. Menu in menu-bar */
      var bookmarksToolbar = document.getElementById("personal-bookmarks");   /* toolbaritem - B. Toolbar */
      
      if (aStart) {
        BMB_bookmarksPopup.addEventListener("popupshowing", function(aEvent)
          { ns.m70.PlacesMenuOpened(aEvent); }, false);
        bookmarksMenuPopup.addEventListener("popupshowing", function(aEvent)
          { ns.m70.PlacesMenuOpened(aEvent); }, false);
        bookmarksToolbar.addEventListener("popupshowing", function(aEvent)
          { ns.m70.PlacesMenuOpened(aEvent); }, false);
      }
      
      else {
        BMB_bookmarksPopup.removeEventListener("popupshowing", function(aEvent)
          { ns.m70.PlacesMenuOpened(aEvent); }, false);
        bookmarksMenuPopup.removeEventListener("popupshowing", function(aEvent)
          { ns.m70.PlacesMenuOpened(aEvent); }, false);
        bookmarksToolbar.removeEventListener("popupshowing", function(aEvent)
          { ns.m70.PlacesMenuOpened(aEvent); }, false);
      }
    },
    
    /* Set mutation observer for Bookmarks Toolbar */
    ObserveToolbarLoads : function(aStart) {   /* true = start; false = stop */
      var bookmarksToolbar = document.getElementById("PlacesToolbarItems");   /* scrollbox - B. Toolbar */
       
      var observer = new MutationObserver(function(mutations) {
        mutations.forEach(function(mutation) {
          ns.m70.InitBookmarksToolbar();
        });    
      });
      
      if (aStart) { observer.observe(bookmarksToolbar, { childList: true }); }
      else { observer.disconnect(); }
    },
    
    /* Set listeners for json restore */
    ObserveRestore : function(aStart) {   /* true = start; false = stop */
      obsRestoreStart = {
        observe : function(aSubject, aTopic, aData) {
          if (aData == "json") { ns.m40.CheckpointBeforeRestore(); }
        }
      }    
      obsRestoreEnd = {
        observe : function(aSubject, aTopic, aData) {
          if (aData == "json") { ns.m40.RecoverAfterRestore(); }
        }
      }    
    
      if (aStart) {
        Services.obs.addObserver(obsRestoreStart, "bookmarks-restore-begin", false);
        Services.obs.addObserver(obsRestoreEnd, "bookmarks-restore-success", false);
      }
      else {
        try { Services.obs.removeObserver(obsRestoreStart, "bookmarks-restore-begin"); } catch(e) {};
        try { Services.obs.removeObserver(obsRestoreEnd, "bookmarks-restore-success"); } catch(e) {};
      }
    },
    
    /* Open the extension's About page in a tab */
    ShowAbout : function(aEvent) {
    
      /* Programming hook: If Ctrl and Alt keys were down when menuitem clicked, generate
         color stylesheet to extension profile folder. It can be moved to chrome skin folder.  */
      if (aEvent.ctrlKey && aEvent.altKey) {
        ns.m30.GenerateColorCSS();
        return;
      }
    
      var aboutURL = "https://addons.mozilla.org/addon/bookmarks-title-styles/";
      var currentURL = gBrowser.currentURI.spec;
      
      if ( (currentURL == "about:blank") || (currentURL == "about:home") ) {   /* New Tab or Start Page */
        gBrowser.loadURI(aboutURL);   /* Reuse current tab */
      }
      else {
        gBrowser.selectedTab = gBrowser.addTab(aboutURL);   /* Open in new tab */
      }
    },
    
    /* Open the Add-ons by Wizardgoat page in a tab */
    ShowCollection : function(aEvent) {
    
      var collectionURL = "https://addons.mozilla.org/firefox/collections/Wizardgoat/add-on/";
      var currentURL = gBrowser.currentURI.spec;
      
      if ( (currentURL == "about:blank") || (currentURL == "about:home") ) {   /* New Tab or Start Page */
        gBrowser.loadURI(collectionURL);   /* Reuse current tab */
      }
      else {
        gBrowser.selectedTab = gBrowser.addTab(collectionURL);   /* Open in new tab */
      }
    }
    
  }

})();
