
(function() {

  const ns = laaBookmarksTitleStyles;   /* namespace */
  
  Components.utils.import("chrome://laaBookmarksTitleStyles/content/laaBookmarksTitleStyles_modx1.jsm");
  var modx1 = laaBookmarksTitleStyles_modx1;
  
  var placesListWindow = null;
  
  var LastWindowState = 3;
  const WIN_STATE_MINIMIZED = 2;
  const WIN_STATE_NORMAL = 3;
  
  var doc = {}
  var dialogcontainer = {}
  
  /* The width formula below will get overall best results on screens with different aspect ratios.
     The width number based on screen height will help with older, narrower screens.
  */
  var dialogWidth = Math.max((0.55 * screen.width),(0.80 * screen.height));   /* Fixed width of dialog */
      dialogWidth = Math.min((dialogWidth),(0.60 * screen.width));   /* Set upper limit for safety */
  
  var dialogHeight = 0.85 * screen.height;   /* Fixed height of dialog */
  
  var notifybox = {}
  var labelNotify = {}
  var placesTree = {}
  var templates = {}
  var lastpanelopened = null;
  var StyleCount = 0;
    
  const bookmarkService = Cc["@mozilla.org/browser/nav-bookmarks-service;1"].getService(Ci.nsINavBookmarksService);
  const historyService = Cc["@mozilla.org/browser/nav-history-service;1"].getService(Ci.nsINavHistoryService);
  const xulStore = Cc["@mozilla.org/xul/xulstore;1"].getService(Ci.nsIXULStore);

  ns.m20 = {
    
    /* Show dialog to edit Places List */
    EditPlacesList : function() {
    
      /* Make this dialog single-instance */
      if (placesListWindow != null) {
        placesListWindow.restore();
        placesListWindow.focus();
        return;
      }
        
      placesListWindow = window.openDialog(
                 "chrome://laaBookmarksTitleStyles/content/dialogPlacesList.xul", "_blank",
                 "chrome,centerscreen,titlebar,close,minimizable,scrollbars",
                  ns);
  
      placesListWindow.focus();
      
      placesListWindow.addEventListener("sizemodechange", function(aEvent)
        { ns.m20.WindowSizeModeChange(aEvent); }, false);

    },

    /* Load Bookmarks heirarchy into tree */
    LoadPlacesList : function() {
    
      doc = placesListWindow.document;
      dialogcontainer = doc.getElementById("laaBookmarksTitleStyles-places-dialog-container");
      notifybox = doc.getElementById("laaBookmarksTitleStyles-places-notifybox");
      labelNotify = doc.getElementById("laaBookmarksTitleStyles-places-labelNotify");
      placesTree = doc.getElementById("laaBookmarksTitleStyles-places-tree");
      templates = doc.getElementById("laaBookmarksTitleStyles-places-templates");
      
      dialogcontainer.minWidth = dialogWidth;
      dialogcontainer.maxWidth = dialogWidth;
      
      dialogcontainer.minHeight = dialogHeight;
      dialogcontainer.maxHeight = dialogHeight;
      
  /* *************************************************************************/

      /* Load tree with the bookmarks structure */
      
      StyleCount = 0;
      
      var options = historyService.getNewQueryOptions();   /* nsINavHistoryQueryOptions */
      options.queryType = options.QUERY_TYPE_BOOKMARKS;
      options.excludeItems = false;
      options.excludeQueries = true ;   /* "smart" folders */
      
      var itemFoldersDefault = doc.getElementById("laaBookmarksTitleStyles-places-itemFoldersDefault");
      var itemURLDefault = doc.getElementById("laaBookmarksTitleStyles-places-itemURLDefault");
      var itemToolbar = doc.getElementById("laaBookmarksTitleStyles-places-itemToolbar");
      var itemMenu = doc.getElementById("laaBookmarksTitleStyles-places-itemMenu");
      var itemUnsorted = doc.getElementById("laaBookmarksTitleStyles-places-itemUnsorted");
      
      //itemToolbar.placesItemId = "TOOLBAR";
      //itemMenu.placesItemId = "BOOKMARKS_MENU";
      //itemUnsorted.placesItemId = "UNFILED_BOOKMARKS";
      
      /* Add the main Bookmarks folders to the tree. Iterate their subfolders and items, and add them as well. */
      iterateBookmarksFolderTree("laafolders",itemFoldersDefault);   /* Default Color for Folder Titles */
      iterateBookmarksFolderTree("laabookmarks",itemURLDefault);   /* Default Color for Bookmarks Titles */
      iterateBookmarksFolderTree(bookmarkService.toolbarFolder,itemToolbar);   /* title = "Bookmarks Toolbar" */
      iterateBookmarksFolderTree(bookmarkService.bookmarksMenuFolder,itemMenu);   /* title = "Bookmarks Menu" */
      iterateBookmarksFolderTree(bookmarkService.unfiledBookmarksFolder,itemUnsorted); /* title = "Unsorted Bookmarks" */
      
      return;
      
      function iterateBookmarksFolderTree(aItemId,aXULItem) {
        aXULItem.placesItemId = aItemId;
        if (!aXULItem.defaultId) { aXULItem.defaultId = "none"; }
        
        var itemType = "";
        var cells = aXULItem.querySelectorAll("treecell");
        
        if (aItemId.toString().indexOf("laa") == 0) {   /* Default item */
          itemType = null;
        }
        else {
          itemType = bookmarkService.getItemType(aItemId);
          let itemTitle = bookmarkService.getItemTitle(aItemId);
          cells[0].setAttribute("label", itemTitle);
        }
        
        if (aXULItem.favicon) {
          cells[0].setAttribute("src", aXULItem.favicon);   /* Show favicon on this tree item */
        }
        
        aXULItem.colors = [""];
        aXULItem.colorx = 0;
        
        if ( (ns.ColorStyleList[aItemId]) || (ns.TextStyleList[aItemId]) ) { ++StyleCount; }
        
        /* Add style properties if colors are assigned via this extension */
        var colorname = (ns.ColorStyleList[aItemId] || ns.ColorStyleList[aXULItem.defaultId] || "");
        
        if (colorname) {
          let colorprop = "laacolor-" + colorname;
          let cellproperties = cells[0].getAttribute("properties");
          if (cellproperties.indexOf(" " + colorprop + " ") == -1) {   /* Property not already set */
            cells[0].setAttribute("properties", cellproperties + " " + colorprop + " ");
          }
          if (ns.ColorStyleList[aItemId]) {   /* Color is styled for this specific item */
            aXULItem.colors[0] = colorname;
            cells[1].setAttribute("label", colorname);
          }
        }
        
        /* Add style properties if text is styled via this extension */
        if (ns.TextStyleList[aItemId]) {
          let textstyle = ns.TextStyleList[aItemId];
          let properties = cells[0].getAttribute("properties");
          if (textstyle & ns.BOLD) {
            let prop = "laabold";
            if (properties.indexOf(" " + prop + " ") == -1) { properties = properties + " " + prop + " "; }
          }
          if (textstyle & ns.ITALIC) {
            let prop = "laaitalic";
            if (properties.indexOf(" " + prop + " ") == -1) { properties = properties + " " + prop + " "; }
          }
          if (textstyle & ns.UNDERLINE) {
            let prop = "laaunderline";
            if (properties.indexOf(" " + prop + " ") == -1) { properties = properties + " " + prop + " "; }
          }
          cells[0].setAttribute("properties", properties);
        }
        
        if (itemType != bookmarkService.TYPE_FOLDER) { return; }
        
        /* Query descendant items */
        var children = aXULItem.querySelector("treechildren");
        var query = historyService.getNewQuery();   /* nsINavHistoryQuery */
        query.setFolders([aItemId], 1);
        var result = historyService.executeQuery(query,options);   /* nsINavHistoryResult - wrapper - a few controls */
        result.suppressNotifications = true;
        var rootnode = result.root;   /* nsINavHistoryContainerResultNode - folder containing child items */
        rootnode.containerOpen = true;
        for (let i = 0; i < rootnode.childCount; i++) {
          let item = rootnode.getChild(i);   /* nsINavHistoryResultNode - itemId, title, uri, and other properties */
          if ( (item.type != item.RESULT_TYPE_FOLDER) && (item.type != item.RESULT_TYPE_URI) ) { continue; }
          let modelItem = null;
          
          if (item.type == item.RESULT_TYPE_URI) {
            modelItem = templates.querySelector(".laaBookmarksTitleStyles-places-itemBookmark");
          }
          else {   /* Bookmark Subfolder item */
            modelItem = templates.querySelector(".laaBookmarksTitleStyles-places-itemSubfolder");
          }
          
          let newXULItem = modelItem.cloneNode(true);   /* true copies all child elements */
          newXULItem.subitem = true;
          if (item.type == item.RESULT_TYPE_URI) { newXULItem.favicon = item.icon; }
        
          if (item.type == item.RESULT_TYPE_FOLDER) { newXULItem.defaultId = "laafolders"; }
          else { newXULItem.defaultId = "laabookmarks"; }
          
          children.appendChild(newXULItem);
          iterateBookmarksFolderTree(item.itemId,newXULItem);   /* Recurse to get descendant items & process URIs */
        }
        if (rootnode.childCount == 0) { aXULItem.setAttribute("empty", "true"); }
        rootnode.containerOpen = false;
      }
      
  /* *************************************************************************/

    },
  
    /* Display a message for a time interval */ 
    DisplayTimedMessage : function(aText,aInt) {
      labelNotify.value = aText;   /* Display message in dialog window */
      notifybox.collapsed = false;
      setTimeout((function() {
        labelNotify.value = "";
        notifybox.collapsed = true;
      }), aInt);
    },
    
    /* Callback from dialog window onload */
    WindowOnLoad : function(aEvent) {
      placesTree.currentIndex = 0;   /* Move focus to first row */
      placesTree.view.selection.select(0);   /* Select first row (set highlight) */
      ns.m20.ManageButtons();
    },
    
    /* Callback from dialog window onunload */
    WindowOnUnload : function(aEvent) {
      placesListWindow = null;
    },
    
    /* Callback from each panel's popupshown event */
    PopupShown : function(aEvent,aPanel) {
      lastpanelopened = aPanel;
    },
    
    /* Callback from dialog window sizemodechange event */
    WindowSizeModeChange : function(aEvent) {
      /* A bug in FF will cause a panel popup to "freeze" visible, and not get collapsed on click or on script calls,
         if the dialog window is minimized and restored while the popup is open. This is because FF changes the
         panel's status to "closed", and will not try to close it again, even though the graphic is still displayed.
         Opening and hiding the popup after restore will clear the problem.
      */
      if ( (lastpanelopened != null) && (LastWindowState == WIN_STATE_MINIMIZED)
        && (LastWindowState != placesListWindow.windowState) )  /* On window restore */  {
        
        lastpanelopened.openPopup();
        
        setTimeout((function() {
          lastpanelopened.hidePopup();
          lastpanelopened = null;
        }), 500);
        
      }
      LastWindowState = placesListWindow.windowState;   /* Remember last window state */
    },
    
    /* Invalidate Sidebar and/or Library trees, if open, so that new styles are applied immediately. */
    RefreshBookmarksTreeView : function() {
    
      try {   /* Check for null elements, as dialog may never have been opened, or may have been closed */
        if (modx1.sidebarWindow) {
          let tree = modx1.sidebarWindow.document.querySelector("tree#bookmarks-view");   /* Sidebar */
          if (!tree) { tree = modx1.sidebarWindow.document.querySelector("tree"); }
          if (tree) {
            let tbo = tree.treeBoxObject;   /* nsITreeBoxObject */
            if (tbo) { tbo.invalidate(); }   /* Cause properties to be refetched */
          }
        }
      } catch(e) { ns.log("Sidebar: " + ns.parseError(e)); }
      
      try {   /* Check for null elements, as dialog may never have been opened, or may have been closed */
        if (modx1.libraryWindow) {
          let tree = modx1.libraryWindow.document.querySelector("tree#placesList");   /* Library Tree Pane */
          if (tree) {
            let tbo = tree.treeBoxObject;   /* nsITreeBoxObject */
            if (tbo) { tbo.invalidate(); }   /* Cause properties to be refetched */
          }
        }
      } catch(e) { ns.log("Library Tree: " + ns.parseError(e)); }
      
      try {   /* Check for null elements, as dialog may never have been opened, or may have been closed */
        if (modx1.libraryWindow) {
          let tree = modx1.libraryWindow.document.querySelector("tree#placeContent");   /* Library Content Pane */
          if (tree) {
            let tbo = tree.treeBoxObject;   /* nsITreeBoxObject */
            if (tbo) { tbo.invalidate(); }   /* Cause properties to be refetched */
          }
        }
      } catch(e) { ns.log("Library Content: " + ns.parseError(e)); }
      
    },
    
    /* Enable or Disable the Style and Reset buttons */
    ManageButtons : function() {
      if (placesListWindow == null) { return; }
      doc.getElementById("laaBookmarksTitleStyles-places-count").value = StyleCount;
      
      var rowindex = placesTree.currentIndex;   /* Index of currently focused and selected item */
      var itemNode = placesTree.contentView.getItemAtIndex(rowindex);
      var cells = itemNode.querySelectorAll("treecell");
      var cellNodePrimary = cells[0];
      var cellproperties = cellNodePrimary.getAttribute("properties");
      
      var editable = (cellproperties.indexOf("laanonedit") == -1);   /* If not flagged, is editable */
      
      var colorstyled = (typeof ns.ColorStyleList[itemNode.placesItemId] != "undefined");
      
      var bold = (cellproperties.indexOf(" laabold ") != -1);   /* If property set, text is bold */
      var italic = (cellproperties.indexOf(" laaitalic ") != -1);   /* If property set, text is italic */
      var underline = (cellproperties.indexOf(" laaunderline ") != -1);   /* If property set, text is underlined */
      
      var styleButton = doc.getElementById("laaBookmarksTitleStyles-places-button-style-item");
      var resetButton = doc.getElementById("laaBookmarksTitleStyles-places-button-reset-item");
      var undoButton = doc.getElementById("laaBookmarksTitleStyles-places-button-undo-item");
      var redoButton = doc.getElementById("laaBookmarksTitleStyles-places-button-redo-item");
      var boldButton = doc.getElementById("laaBookmarksTitleStyles-places-button-bold");
      var italicButton = doc.getElementById("laaBookmarksTitleStyles-places-button-italic");
      var underlineButton = doc.getElementById("laaBookmarksTitleStyles-places-button-underline");
      
      styleButton.disabled = true;
      resetButton.disabled = true;
      undoButton.disabled = true;
      redoButton.disabled = true;
      
      boldButton.disabled = true;
      italicButton.disabled = true;
      underlineButton.disabled = true;
      boldButton.removeAttributeNS(ns.name,"set");
      italicButton.removeAttributeNS(ns.name,"set");
      underlineButton.removeAttributeNS(ns.name,"set");
      
      if (!editable) { return; }
      
      styleButton.disabled = false;
      if (colorstyled) { resetButton.disabled = false; }
      if (itemNode.colorx > 0) { undoButton.disabled = false; }
      if (itemNode.colorx < itemNode.colors.length - 1) { redoButton.disabled = false; }
      
      if (itemNode.placesItemId.toString().indexOf("laa") == 0) { return; }    /* Default Color item */
      
      boldButton.disabled = false;
      italicButton.disabled = false;
      underlineButton.disabled = false;
      if (bold) { boldButton.setAttributeNS(ns.name,"set","true"); }
      if (italic) { italicButton.setAttributeNS(ns.name,"set","true"); }
      if (underline) { underlineButton.setAttributeNS(ns.name,"set","true"); }
    },
    
    /* Called when the tree item selection changes */
    TreeSelect : function(aEvent) {
      ns.m20.ManageButtons();
    },
    
    /* When a default color has been changed, reset all non-styled items of the corresponding type */
    ApplyDefaultColor : function(aDefaultId) {
      var itemNodes = placesTree.querySelectorAll("treeitem");
      
      for (let i = 0; i < itemNodes.length; i++) {
        let itemNode = itemNodes[i];
        let itemId = itemNode.placesItemId;
        if (!itemNode.subitem) { continue; }   /* Skip top-level tree items */
        if (itemNode.defaultId != aDefaultId) { continue; }   /* Skip folders or URIs, if not resetting that type */
        if (ns.ColorStyleList[itemId]) { continue; }   /* Skip items that are individually styled */
        
        let cells = itemNode.querySelectorAll("treecell");
        let cellNodePrimary = cells[0];
        let cellproperties = cellNodePrimary.getAttribute("properties");
        
        let ndx = cellproperties.indexOf(" laacolor-");   /* Index of leading space before property */
        let len = cellproperties.substr(ndx + 1).indexOf(" ") + 2;   /* Length of property with 2 spaces */
        
        if ( (ndx != -1) && (len > 2) ) {   /* A (default) color is currently assigned */
          let prop = cellproperties.substr(ndx,len);
          cellproperties = cellproperties.replace(prop,"");
        }
        
        if (ns.ColorStyleList[aDefaultId]) {
          let newprop = "laacolor-" + ns.ColorStyleList[aDefaultId];
          cellproperties = cellproperties + " " + newprop + " ";
        }
        
        cellNodePrimary.setAttribute("properties", cellproperties);
      }
    },
    
    /* Button callback to undo selected item color change */
    UndoSelectedItem : function(aEvent) {
      var rowindex = placesTree.currentIndex;   /* Index of currently focused and selected item */
      var itemNode = placesTree.contentView.getItemAtIndex(rowindex);
      
      if (itemNode.colorx == 0) { return; }   /* Already at start of list */
      itemNode.colorx = itemNode.colorx - 1;   /* Point to previous color */
      var colorname = itemNode.colors[itemNode.colorx];
      
      if (colorname == "") {
        ns.m20.ResetSelectedItem(aEvent,true);
      }
      else {
        ns.m20.StyleSelectedItem(aEvent,true);
      }
    },
    
    /* Button callback to redo selected item color change */
    RedoSelectedItem : function(aEvent) {
      var rowindex = placesTree.currentIndex;   /* Index of currently focused and selected item */
      var itemNode = placesTree.contentView.getItemAtIndex(rowindex);
      
      if (itemNode.colorx == itemNode.colors.length - 1) { return; }   /* Already at end of list */
      itemNode.colorx = itemNode.colorx + 1;   /* Point to next color */
      var colorname = itemNode.colors[itemNode.colorx];
      
      if (colorname == "") {
        ns.m20.ResetSelectedItem(aEvent,true);
      }
      else {
        ns.m20.StyleSelectedItem(aEvent,true);
      }
    },
    
    /* Button callback to reset color of selected item to default */
    ResetSelectedItem : function(aEvent,undoredo) {
    
      /* For safety, in case Style URI not set */
      if (ns.StyleURI.indexOf("laaBookmarksTitleStyles") == -1) { return; }
      
      var rowindex = placesTree.currentIndex;   /* Index of currently focused and selected item */
      var itemNode = placesTree.contentView.getItemAtIndex(rowindex);
      var itemId = itemNode.placesItemId;
      var cells = itemNode.querySelectorAll("treecell");
      var cellNodePrimary = cells[0];
      var cellproperties = cellNodePrimary.getAttribute("properties");
      
      var ndx = cellproperties.indexOf(" laacolor-");   /* Index of leading space before property */
      var len = cellproperties.substr(ndx + 1).indexOf(" ") + 2;   /* Length of property with 2 spaces */
      
      if ( (ndx != -1) && (len > 2) ) {   /* A color is currently assigned */
        let prop = cellproperties.substr(ndx,len);
        let newprop = (ns.ColorStyleList[itemNode.defaultId] || "");   /* Default color name, if set */
        if (newprop) { newprop = " laacolor-" + newprop + " "; }
        if (itemId.toString().indexOf("laa") == 0) { newprop = ""; }   /* Resetting default item */
        cellNodePrimary.setAttribute("properties", cellproperties.replace(prop,newprop));
      }
      
      if (undoredo) {
        cells[1].setAttribute("label", "");
      }
      else {
        let oldcolorname = cells[1].getAttribute("label");
        cells[1].setAttribute("label", "(was " + oldcolorname + ")");
      }
      
      xulStore.removeValue(ns.StyleURI, itemId, "ColorName");
      delete ns.ColorStyleList[itemId];
      if (!ns.TextStyleList[itemId]) { --StyleCount; }
      
      if (!undoredo) {
        let x = itemNode.colorx;
        
        if ( (x < itemNode.colors.length - 1) && (itemNode.colors[x + 1] == "") ) {   /* Next color is default */
          itemNode.colorx = x + 1;   /* Bump forward to default color */
        }
        else {
          let priorcolors = itemNode.colors.slice(0, x + 1);
          let latercolors = itemNode.colors.slice(x + 1);
          itemNode.colors = priorcolors.concat("",latercolors);
          itemNode.colorx = x + 1;
        }
      }
      
      if (itemId.toString().indexOf("laa") == 0) { ns.m20.ApplyDefaultColor(itemId); }   /* Default item has changed */
      
      ns.m20.ManageButtons();
      ns.m70.InitBookmarksToolbar();
      ns.m20.RefreshBookmarksTreeView();
    },
    
    /* Button callback to style the color of the selected item */
    StyleSelectedItem : function(aEvent,undoredo) {
    
      /* For safety, in case Style URI not set */
      if (ns.StyleURI.indexOf("laaBookmarksTitleStyles") == -1) { return; }
      
      var rowindex = placesTree.currentIndex;   /* Index of currently focused and selected item */
      var itemNode = placesTree.contentView.getItemAtIndex(rowindex);
      var itemId = itemNode.placesItemId;
      var cells = itemNode.querySelectorAll("treecell");
      var cellNodePrimary = cells[0];
      var cellproperties = cellNodePrimary.getAttribute("properties");
      
      var editable = (cellproperties.indexOf("laanonedit") == -1);   /* If not flagged, is editable */
      if (!editable) { return; }
      
      var colorname = "";
      
      if (undoredo) {
        colorname = itemNode.colors[itemNode.colorx];
      }
      else {
        let itemfavicon = itemNode.favicon;
        if ( (itemNode.hasAttribute("container")) && (itemNode.getAttribute("container") == "true") ) {
          itemfavicon = "laafolder";
        }
        let itemlabel = cellNodePrimary.getAttribute("label");
        let itemcolorname = itemNode.colors[itemNode.colorx];
        let itemtextstyle = ns.TextStyleList[itemId] || "0";
        colorname = ns.m21.PickTextColor(itemfavicon,itemlabel,itemcolorname,itemtextstyle);   /* Open Color Picker */
        if (!colorname) { return; }   /* No color selected */
      }      
      
      cells[1].setAttribute("label", colorname);
      
      if (!undoredo) {
        if (colorname == itemNode.colors[itemNode.colorx]) { return; }   /* Picked color is same as current */
      }
      
      var colorprop = "laacolor-" + colorname;
      
      var ndx = cellproperties.indexOf(" laacolor-");   /* Index of leading space before property */
      var len = cellproperties.substr(ndx + 1).indexOf(" ") + 2;   /* Length of property with 2 spaces */
      
      if ( (ndx != -1) && (len > 2) ) {   /* A color is currently assigned */
        let prop = cellproperties.substr(ndx,len);
        cellproperties = cellproperties.replace(prop,"");
      }
      
      if (cellproperties.indexOf(" " + colorprop + " ") == -1) {   /* Property not already set */
        cellproperties = cellproperties + " " + colorprop + " ";
      }
      
      cellNodePrimary.setAttribute("properties", cellproperties);
      
      xulStore.setValue(ns.StyleURI, itemId, "ColorName", colorname);
      if ( (!ns.ColorStyleList[itemId]) && (!ns.TextStyleList[itemId]) ) { ++StyleCount; }
      ns.ColorStyleList[itemId] = colorname;
      
      if (!undoredo) {
        var x = itemNode.colorx;
        
        if ( (x < itemNode.colors.length - 1) && (itemNode.colors[x + 1] == colorname) ) {   /* Next color is new one */
          itemNode.colorx = x + 1;   /* Bump forward to new color */
        }
        else {
          var priorcolors = itemNode.colors.slice(0, x + 1);
          var latercolors = itemNode.colors.slice(x + 1);
          itemNode.colors = priorcolors.concat(colorname,latercolors);
          itemNode.colorx = x + 1;
        }
      }
      
      if (itemId.toString().indexOf("laa") == 0) { ns.m20.ApplyDefaultColor(itemId); }   /* Default item has changed */
      
      ns.m20.ManageButtons();
      ns.m70.InitBookmarksToolbar();
      ns.m20.RefreshBookmarksTreeView();
    },
    
    /* Button callback to toggle the text style of the selected item */
    ToggleTextStyles : function(aEvent,button,styleprop) {
    
      /* For safety, in case Style URI not set */
      if (ns.StyleURI.indexOf("laaBookmarksTitleStyles") == -1) { return; }
      
      var rowindex = placesTree.currentIndex;   /* Index of currently focused and selected item */
      var itemNode = placesTree.contentView.getItemAtIndex(rowindex);
      var itemId = itemNode.placesItemId;
      var cells = itemNode.querySelectorAll("treecell");
      var cellNodePrimary = cells[0];
      var cellproperties = cellNodePrimary.getAttribute("properties");
      
      var editable = (cellproperties.indexOf("laanonedit") == -1);   /* If not flagged, is editable */
      if (!editable) { return; }
      
      let textstyle = ns.TextStyleList[itemId] || "0";
      
      var stylenum = 0;
      if (styleprop == "laabold") { stylenum = ns.BOLD; }
      if (styleprop == "laaitalic") { stylenum = ns.ITALIC; }
      if (styleprop == "laaunderline") { stylenum = ns.UNDERLINE; }
      
      if (cellproperties.indexOf(" " + styleprop + " ") == -1) {   /* Property not set, so toggle it on */
        cellproperties = cellproperties + " " + styleprop + " ";
        textstyle = textstyle | stylenum;
      }
      else {   /* Property is set, so toggle it off */
        cellproperties = cellproperties.replace(" " + styleprop + " ","");
        textstyle = textstyle ^ stylenum;
      }
      
      cellNodePrimary.setAttribute("properties", cellproperties);
      
      if (textstyle == "0") {   /* No text style attributes set */
        xulStore.removeValue(ns.StyleURI, itemId, "TextStyle");
        delete ns.TextStyleList[itemId];
        if (!ns.ColorStyleList[itemId]) { --StyleCount; }
      }
      else {   /* One or more text style attributes are set */
        xulStore.setValue(ns.StyleURI, itemId, "TextStyle", textstyle);
        if ( (!ns.TextStyleList[itemId]) && (!ns.ColorStyleList[itemId]) ) { ++StyleCount; }
        ns.TextStyleList[itemId] = textstyle;
      }
      
      ns.m20.ManageButtons();
      ns.m70.InitBookmarksToolbar();
      ns.m20.RefreshBookmarksTreeView();
    },
    
  /* *************************************************************************/
  /* *************************************************************************/
  /* *************************************************************************/
    
    /* Called during extension initialization. */
    /* Delete Title Style records left over from non-existent items. */
    CleanupStyleRecords : function() {
      ns.PathSep = "$/$";
    
      /* For safety, in case Styles URI not set */
      if (ns.StyleURI.indexOf("laaBookmarksTitleStyles") == -1) { return; }
      
      var options = historyService.getNewQueryOptions();   /* nsINavHistoryQueryOptions */
      options.queryType = options.QUERY_TYPE_BOOKMARKS;
      options.excludeItems = false;
      options.excludeQueries = true;   /* "smart" folders */
      
      var CurrentItemIds = new Object;
      ns.PathList = new Object;
      
      CurrentItemIds["laafolders"] = 1;   /* Default for Folder Text */
      ns.PathList["laafolders"] = "laafolders";
      
      CurrentItemIds["laabookmarks"] = 1;   /* Default for Bookmarks Text */
      ns.PathList["laabookmarks"] = "laabookmarks";
      
      getBookmarksTreeItems(bookmarkService.toolbarFolder,"");   /* Iterate Bookmarks Toolbar */
      getBookmarksTreeItems(bookmarkService.bookmarksMenuFolder,"");   /* Iterate Bookmarks Menu */
      getBookmarksTreeItems(bookmarkService.unfiledBookmarksFolder,"");   /* Iterate Unsorted Bookmarks */
      
      function getBookmarksTreeItems(aItemId,aPath) {
        CurrentItemIds[aItemId] = 1;   /* Add places item id to list */
        var itemType = bookmarkService.getItemType(aItemId);
        var itemTitle = bookmarkService.getItemTitle(aItemId);
        aPath = aPath + ns.PathSep + itemTitle;
        ns.PathList[aItemId] = aPath;
        
        if (itemType != bookmarkService.TYPE_FOLDER) { return; }
      
        var query = historyService.getNewQuery();   /* nsINavHistoryQuery */
        query.setFolders([aItemId], 1);
        var result = historyService.executeQuery(query,options);   /* nsINavHistoryResult - wrapper - a few controls */
        result.suppressNotifications = true;
        var rootnode = result.root;   /* nsINavHistoryContainerResultNode - folder containing child items */
        rootnode.containerOpen = true;
        for (let i = 0; i < rootnode.childCount; i++) {
          let item = rootnode.getChild(i);   /* nsINavHistoryResultNode - itemId, title, uri, and other properties */
          getBookmarksTreeItems(item.itemId,aPath);   /* Recurse to get all descendant items, and process URIs */
        }
        rootnode.containerOpen = false;
      }
      
      /* Clear xulStore items left over from deleted bookmark items, or referring to deleted colors */
      for (let x = xulStore.getIDsEnumerator(ns.StyleURI); x.hasMore();) {
        let itemId = x.getNext();   /* The places itemId */
        if (!CurrentItemIds[itemId]) {
          xulStore.removeValue(ns.StyleURI, itemId, "ColorName");   /* Remove record */
          xulStore.removeValue(ns.StyleURI, itemId, "TextStyle");   /* Remove record */
          continue;
        }
        if (ns.ColorArray.length == 0) { continue; }   /* Color array empty, skip out */
        if (xulStore.hasValue(ns.StyleURI, itemId, "ColorName")) {
          let colorname = xulStore.getValue(ns.StyleURI, itemId, "ColorName");
          if (!ns.ColorList[colorname]) {
            xulStore.removeValue(ns.StyleURI, itemId, "ColorName");   /* Remove record */
          }
        }
      }
    },
    
    /* Called during extension initialization. */
    /* Build Style List */
    BuildStyleList : function() {
      ns.ColorStyleList = new Object;
      ns.TextStyleList = new Object;
      for (let x = xulStore.getIDsEnumerator(ns.StyleURI); x.hasMore();) {
        let itemId = x.getNext();   /* The places itemId */
        
        if (xulStore.hasValue(ns.StyleURI, itemId, "ColorName")) {
          let colorname = xulStore.getValue(ns.StyleURI, itemId, "ColorName");
          ns.ColorStyleList[itemId] = colorname;
        }
        
        if (xulStore.hasValue(ns.StyleURI, itemId, "TextStyle")) {
          let textstyle = xulStore.getValue(ns.StyleURI, itemId, "TextStyle");
          ns.TextStyleList[itemId] = textstyle;
        }
        
      }
      ns.m20.RefreshBookmarksTreeView();   /* Sidebar may already be open on browser restart, so refresh tree */
    }
    
  }
    
})();
