
(function() {

  const ns = laaBookmarksTitleStyles;   /* namespace */
  
  Components.utils.import("chrome://laaBookmarksTitleStyles/content/laaBookmarksTitleStyles_modx1.jsm");
  var modx1 = laaBookmarksTitleStyles_modx1;
  modx1.namespace = ns;
  
  const extID = "BookmarksTitleStyles@LarrysComputer";   /* extension ID, same as in RDF file */
  
  const CUI = CustomizableUI;
  const xulStore = Cc["@mozilla.org/xul/xulstore;1"].getService(Ci.nsIXULStore);
  
  var obsWindowCreate = {}

  window.addEventListener("load", function(aEvent) { browserInit(aEvent); }, false);
  
  /**************************************************************************************/
  
  /* Runs on window load */
  function browserInit(aEvent) {
    window.removeEventListener("load", function(aEvent) { browserInit(); }, false);
  
    ns.StyleURI = "laaBookmarksTitleStyles.Style.URI";   /* URI for xulStore records */
    
    ns.BOLD = 1;
    ns.ITALIC = 2;
    ns.UNDERLINE = 4;
    
    /**** Support for language localization *********************************************/
    
    ns.stringBundle = document.getElementById("laaBookmarksTitleStyles-string-bundle"); /* Text strings for messages and UI */
    ns.pluralRuleNumber = ns.stringBundle.getString("laaBookmarksTitleStyles.pluralRuleNumber"); /* Get number for language */
    ns.PluralFormGet = PluralForm.makeGetter(ns.pluralRuleNumber)[0];   /* Get PluralForm.get method for language */
    getPluralString_create();   /* Create ns.getPluralString function, per routine below *.
    
    /**** Set default Preferences Key values ********************************************/
    
    ns.prefsStatusKey =           ns.pref("extensions.laaBookmarksTitleStyles.status", "");
    ns.prefsLastUpdateDateKey =   ns.pref("extensions.laaBookmarksTitleStyles.lastUpdateDate", "");
    
    /**** Support for Addon management **************************************************/
    
    AddonManager.getAddonByID(extID, getAddonCallback);   /* Asynchronous process */
    
    return;
    
    function getAddonCallback(aAddon) {
      ns.Addon = aAddon;
      ns.previousUpdateDate = Services.prefs.getCharPref(ns.prefsLastUpdateDateKey);
      ns.lastUpdateDate = ns.Addon.updateDate.toString();
      Services.prefs.setCharPref(ns.prefsLastUpdateDateKey, ns.lastUpdateDate);
      
      /* Do stuff on new install or upgrade */
      if (ns.lastUpdateDate != ns.previousUpdateDate) {
        install();
      }
      
      Services.prefs.setCharPref(ns.prefsStatusKey, "installed");
      finishInitAfterInstall();
    }
    
    /**** Finish initializing ***********************************************************/
    
    function finishInitAfterInstall() {
      ns.ColorList = new Object;
      ns.m30.BuildColorList();   /* Build a color list object to match the ColorArray */
    
      ns.PathList = new Object;
      ns.m20.CleanupStyleRecords();
      
      ns.ColorStyleList = new Object;
      ns.TextStyleList = new Object;
      ns.m20.BuildStyleList();
    
      /* There is some evidence that the mutation observers are not working on a few systems - perhaps due to
         extension conflicts. This delayed call to refresh toolbar styling may circumvent the problem.
      */
      setTimeout((function() {
        ns.m70.InitBookmarksToolbar();
      }), 3000);
    
      ns.m2.ObserveMenuOpens(true);   /* Listen for Places menu opens */
      ns.m2.ObserveRestore(true);   /* Listen for json restore */
      
      /* Put style properties on top-level Bookmarks Toolbar items. */
      /* This is also called from a mutation observer each time the toolbar items are loaded. */
      /* In practice, this may or may not find any items at this init call. */
      ns.m70.InitBookmarksToolbar();
      
      setTerminationObserver();   /* Listen for browser termination */
    }
    
    /* Extension is now initialized */
  
    /**** Support routines **************************************************************/
  
    /* Runs on new install or upgrade */
    function install() {
      var status = Services.prefs.getCharPref(ns.prefsStatusKey);
    
      if (status != "installed") {   /* New install, or reinstall after uninstall */
        var buttonId = "laaBookmarksTitleStyles-button";
        var areaType = CUI.getWidget(buttonId).areaType;

        /* If button is not in a toolbar or a menu-panel, install it.
           This will be the case if it was moved to the customization palette in the previous install.
           Install targets: AREA_NAVBAR - navigation toolbar; AREA_PANEL - menu-panel.
        */
        if ( (areaType != CUI.TYPE_TOOLBAR) && (areaType != CUI.TYPE_MENU_PANEL) ) {
        CUI.addWidgetToArea(buttonId,CUI.AREA_PANEL);
        }
      }
      
    }
    
    /* Set listener for browser termination */
    function setTerminationObserver() {
      var obsQuitting = {
        /* Runs if browser is terminating */
        observe : function(aSubject, aTopic, aData) {
          Services.obs.removeObserver(obsQuitting, "quit-application");
          browserTerminate();
        }
      }
      Services.obs.addObserver(obsQuitting, "quit-application", false);
    }
    
    /* Finish cleanup on browser termination */
    function browserTerminate() {
      ns.m2.ObserveMenuOpens(false);
      ns.m2.ObserveRestore(false);
      if (ns.Addon.pendingOperations & (AddonManager.PENDING_UNINSTALL | AddonManager.PENDING_DISABLE)) {
        Services.prefs.setCharPref(ns.prefsStatusKey, "disable/uninstall");
      }
      Components.utils.unload("chrome://laaBookmarksTitleStyles/content/laaBookmarksTitleStyles_modx1.jsm");
    }
    
    function getPluralString_create() {
    
      /* ns.getPluralString(aNumber,aPropertykey) */
      /* ns.getPluralString(aNumber,aPropertykey,aStringlist) */
      
      /* Function to get formatted string from a plural string key in the string-bundle properties file. */
      /* This basically combines the getFormattedString method that substitutes variables into a text string */
      /*   with PluralForm methods that select the correct plural-form text string from a <;>-separated list. */
      
      /* Arguments: */
      /* aNumber is used to select the correct string from the key's plural-form string list, */
      /*   e.g., "0 things are...", "1 thing is...", "nnn things are...", etc. */
      /* aPropertykey is the key of the plural-form <;>-separated string list. */
      
      /* aStringlist is optional, for variables to substitute, and is processed as follows: */
      /* - If aStringlist is omitted, aNumber is used as the only variable to substitute. */
      /*   (Also omit aStringlist if nothing is to be substituted. For example, aNumber could be used to */
      /*    select "The item has been deleted" vs "All items have been deleted".) */
      /* - If aStringlist is a string, number, Boolean, etc., it is used as the only variable to substitute. */
      /* - If aStringlist is an array, it contains the full list of variables or constants to substitute. */
      
      /* example: */
      /*   for property.key1 = %1$S apple is in the box for %2$S;%1$S apples are in the box for %2$S */
      /*   ns.getPluralString(1,"property.key1",new Array(1,"Alice"); returns "1 apple is in the box for Alice" */
      
      /* Note: With new Array constructor, use new Array(n.toString()) for a single numeric variable value, */
      /*       or use quotes with a constant such as new Array("5"). */
      /* Expression new Array(n) will be interpreted as a new array of length n+1, with no values assigned. */
      
      ns.getPluralString = function(aNumber,aPropertykey,aStringlist) {
        if ( typeof(aStringlist) == "undefined" ) { var stringsOut = new Array(aNumber.toString()); }
        else if ( Array.isArray(aStringlist) ) { var stringsOut = aStringlist; }
        else { var stringsOut = new Array(aStringlist.toString()); }
        return ns.PluralFormGet(aNumber, ns.stringBundle.getFormattedString(aPropertykey,stringsOut));
      }
    }
    
  }
})();
