// ==UserScript==
// @name           Jizzmenu.uc.js
// @namespace      Appmenu@gmail.com
// @description    Basiert auf dem Script externalFuncButtonM.uc.js, Wiederherstellung der Orangenen FF-Menü Schaltfläche
// @include        main
// @version        update for Firefox 68+ by aborix
// @author         defpt
// @charset        UTF-8
// @version        2019.08.04
// @version        2020.05.27
// @version        2020.07.13 Weitere Menüs und Funktionen ergänzt by bege
// @version        2024.08.10 alle Einstellungen im Abschnitt Konfiguration vornehmen
// @version        2024.08.18 einige Veränderungen am Skript, Symbole, Funktionen & Menüs by Mira Bellenbaum
// ==/UserScript==

    // Definiere den Profilpfad
    let ProfilePath = PathUtils.toFileURI(PathUtils.join(PathUtils.profileDir, 'chrome', 'icons'));

var Appmenu = {
    // Beginn der Konfiguration ------------------
    
    // Editor mit angegebenem Pfad verwenden
    // editor: 'C:\\Program Files\\Notepad++\\notepad++.exe',
    editor: 'C:\\Program Files\\Microsoft VS Code\\Code.exe',
    // oder
    // in 'view_source.editor.path' eingetragenen Editor verwenden
    editor: Services.prefs.getCharPref('view_source.editor.path'),
    // Dateimanager mit angegebenem Pfad verwenden oder leer ('') wenn System-Dateimanager verwenden
    //fileManager: 'C:\\Program files\\FreeCommander XE\\FreeCommander.exe',
    fileManager: '',
    // Parameter für Dateimanager oder leer ('')
    //FMParameter: '/T',
    FMParameter: '',
    // Submenüs ohne Inhalt im Hauptmenü automatisch ausblenden
    autohideEmptySubDirs: true,
    // Submenüs im Hauptmenü nach unten verschieben
    moveSubDirstoBottom: false,
    // Ort und Aussehen des Menü-Buttons einstellen
 //   isUrlbar: 1,  // 0： TabsToolbar； 1： navbar,
    isUrlbar: 2,  // 0: TabsToolbar; 1: navbar; 2: toolbar-menubar
    isButton: 0,  // 0: Hamburger,klein; 1: Firefox,groß,
    // Hotkey zum Öffnen des Appmenüs oder leer ('')
    hotkey: 'x',
    hotkeyModifier: 'alt', 
    
    // Ende der Konfiguration --------------------

    // Submenüs im Hauptmenü nach unten verschieben
    subdirPopupHash: [],
    subdirMenuHash: [],

    toolbar: {
        // Submenüs des Hauptmenüs definieren; Separator einfügen mit {name: 'separator'}
        subdirs: [
            {
            name: 'Firefox Verzeichnisse',
            image: `${ProfilePath}/folder_currentColor.svg`, // Der Pfad wird direkt verwendet, ohne `url()`           
            },
            {
            name: 'Firefox Funktionen',
            image: `${ProfilePath}/settings_currentColor.svg`, // Der Pfad wird direkt verwendet, ohne `url()`
            },  
            {
                name: 'separator',
            }, 
        ],

    apps: [  /*  Directories  */

        // Untermenü Firefox Verzeichnisse
        {
        name: 'Profil-Verzeichniss',
        id: 'AMProfil',
        root: 'ProfD',
        path: '\\',
        subdir: 'Firefox Verzeichnisse',
        },
        {
        name: 'Chrome-Ordner',
        id: 'AMchrome',
        root: 'ProfD',
        path: '\\chrome',
        subdir: 'Firefox Verzeichnisse',
        },
        {
        name: 'CSS-Ordner',
        id: 'AMCSS',
        root: 'ProfD',
        path: '\\chrome\\css',
        subdir: 'Firefox Verzeichnisse',
        },
        {
        name: 'JS-Ordner',
        id: 'AMJS',
        root: 'ProfD',
        path: '\\chrome\\scripts',
        subdir: 'Firefox Verzeichnisse',
        },
        {
        name: 'Addon-Verzeichniss',
        id: 'AMAddons',
        root: 'ProfD',
        path: '\\extensions',
        subdir: 'Firefox Verzeichnisse',
        },
        {
        name: 'Programm-Verzeichniss',
        id: 'AMProgramm',
        root: 'CurProcD',
        path: '\\',
        subdir: 'Firefox Verzeichnisse',
        },
        {
        name: 'Startup-Cache',
        id: 'AMCache',
        root: 'ProfLD',
        path: '\\startupCache',
        subdir: 'Firefox Verzeichnisse',
        },
    ],

    configs: [

        // Untermenü Firefox Funktionen
        {
        name: 'Anpassen',
        id: 'AMAnpassen',
        command: "gCustomizeMode.enter()",
        subdir: 'Firefox Funktionen',
        },
        {
        name: 'Neustart im abgesicherten Modus',
        id: 'AMModus',
        command: "safeModeRestart();",
        subdir: 'Firefox Funktionen',
        },
        {
        name: 'Browser-Konsole',
        id: 'AMKonsole',
        command: "var { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                var { BrowserConsoleManager } = require('resource://devtools/client/webconsole/browser-console-manager');\
                BrowserConsoleManager.openBrowserConsoleOrFocus();",
        subdir: 'Firefox Funktionen',
        },
        {
        name: 'Browser-Werkzeuge',
        id: 'AMWerkzeuge',
        command: "var { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                var { BrowserToolboxLauncher } = require('resource://devtools/client/framework/browser-toolbox/Launcher.sys.mjs');\
                BrowserToolboxLauncher.init();",
        subdir: 'Firefox Funktionen',
        },
        {
        name: 'Web-Entwickler',
        id: 'AMEntwickler',
        command: "var { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                var { gDevToolsBrowser } = require('resource://devtools/client/framework/devtools-browser');\
                gDevToolsBrowser.toggleToolboxCommand(window.gBrowser, Cu.now());",    
        subdir: 'Firefox Funktionen',
        },
        {
        name: 'Firefox synchronisieren',
        id: 'AMsynchron',
        command: "gSync.openPrefs('menubar');",
        subdir: 'Firefox Funktionen',
        },
        {
        name: 'Zugangsdaten und Passwörter',
        id: 'AMdaten',
        command: "LoginHelper.openPasswordManager(window, { entryPoint: 'mainmenu' })",
        tooltiptext: 'about:logins',
        subdir: 'Firefox Funktionen',
        },
        {
        name: 'Task Manager',
        id: 'AMManager',
        command: "switchToTabHavingURI('about:processes', true)",
        tooltiptext: 'about:processes',
        subdir: 'Firefox Funktionen',
        },
        {
        name: 'Offline arbeiten',
        id: 'AMOffline',
        command: "BrowserOffline.toggleOfflineStatus();",
        subdir: 'Firefox Funktionen',
        },
        /*
        {
        name: 'separator',
        },
        */
        {
        name: 'Neustart',
        id: 'AMreboot',
        tooltiptext: 'userChrome.js-Cache wird geleert',
		command: 'Services.appinfo.invalidateCachesOnRestart(); \
                Services.startup.quit(Ci.nsIAppStartup.eRestart | Ci.nsIAppStartup.eAttemptQuit);',
        },
        {
        name: 'Beenden',
        id: 'AMquit',
        command: "goQuitApplication(event);",
        },
    ]
    },

    _externalAppPopup: null,
    _isready: false,

    init: function() {

        this.handleRelativePath(this.toolbar.apps);
        const XULNS = 'http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul';

        var ExternalAppBtn = document.createElementNS(XULNS, 'toolbarbutton');

        ExternalAppBtn.id = "AppMenuButton";
        ExternalAppBtn.setAttribute("label", "AppButton");
        ExternalAppBtn.setAttribute("onclick", "event.preventDefault();event.stopPropagation();");
        ExternalAppBtn.setAttribute("tooltiptext", "Firefox Menü");
        ExternalAppBtn.setAttribute("type", "menu");
        ExternalAppBtn.setAttribute("removable", "true");

        // Definiere den Profilpfad
        let ProfilePath = PathUtils.toFileURI(PathUtils.join(PathUtils.profileDir, 'chrome', 'image'));

        // Symbole
        let DefaultIcon = "Button_groß.png";
        let AlternateIcon = "Button_klein-plus.png";






        // Wenn Appmenu.isButton true ist, benutze das große Symbol, sonst das kleine
        if (Appmenu.isButton) {
            ExternalAppBtn.style.listStyleImage = `url('${ProfilePath}/${DefaultIcon}')`;  // Großes Symbol
            ExternalAppBtn.style.width = "94px";  // Feste Breite für großes Symbol
            ExternalAppBtn.style.height = "24px";  // Feste Höhe für großes Symbol
        } else {
            ExternalAppBtn.style.listStyleImage = `url('${ProfilePath}/${AlternateIcon}')`;  // Kleines Symbol
            ExternalAppBtn.style.width = "16px";  // Feste Breite für kleines Symbol
            ExternalAppBtn.style.height = "21px";  // Feste Höhe für kleines Symbol
        }
          
        // Button in die richtige Toolbar einfügen          
        if (Appmenu.isUrlbar === 1) {
            var navBar = document.getElementById("nav-bar-customization-target");
            navBar.insertBefore(ExternalAppBtn, navBar.firstChild);
        } else if (Appmenu.isUrlbar === 2) {
            var menubar = document.getElementById("toolbar-menubar");
            menubar.insertBefore(ExternalAppBtn, menubar.firstChild);
        } else {
            var TabsToolbar = document.getElementById("TabsToolbar");
            TabsToolbar.insertBefore(ExternalAppBtn, TabsToolbar.firstChild);
            
        }
        

    var ExternalAppPopup = document.createElementNS(XULNS, 'menupopup');
    //ExternalAppPopup.setAttribute('onpopupshowing', 'event.stopPropagation(); Appmenu.onpopupshowing();');
    ExternalAppPopup.setAttribute('id', 'AMpopup');
    this._externalAppPopup = ExternalAppPopup;
    ExternalAppBtn.appendChild(ExternalAppPopup);
    Appmenu.onpopupshowing();
    
      // Menü mit Tastaturkürzel öffnen
    let key = document.createXULElement('key');
    key.id = 'key_AppMenuPopup';
 //   key.setAttribute('key', 'X');
    key.setAttribute('key', Appmenu.hotkey);
        if (Appmenu.hotkeyModifier)
 //   key.setAttribute('modifiers', 'alt');
    key.setAttribute('modifiers', Appmenu.hotkeyModifier);
    key.setAttribute('oncommand', 'document.getElementById("AMpopup").openPopup();');
    document.getElementById('mainKeyset').appendChild(key);
    },


        /* ****** NEU ****** */     

    onpopupshowing: function() {
        if (this._isready)
            return;
        if (this._externalAppPopup === null)
            return;
        var ExternalAppPopup = this._externalAppPopup;

        // Funktion zum Erstellen eines Menüs mit Untermenüs
        function createMenuItem(parentPopup, item) {
            var menuItem;
            if (item.name == 'separator') {
                menuItem = document.createXULElement('menuseparator');
                parentPopup.appendChild(menuItem);
            } else if (item.submenu && item.submenu.length > 0) {
                menuItem = document.createXULElement('menu');
                var subMenuPopup = document.createXULElement('menupopup');
                menuItem.appendChild(subMenuPopup);
                menuItem.setAttribute('class', 'menu-iconic');
                menuItem.setAttribute('label', item.name);
                menuItem.setAttribute('image', item.image);
                parentPopup.appendChild(menuItem);
                for (let subItem of item.submenu) {
                    createMenuItem(subMenuPopup, subItem);
                }
            } else {
                menuItem = document.createXULElement('menuitem');
                menuItem.setAttribute('class', 'menuitem-iconic');
                menuItem.setAttribute('label', item.name);
                menuItem.setAttribute('image', item.image);
                if (item.command) {
                    menuItem.setAttribute('oncommand', item.command);
                } else if (item.path) {
                    menuItem.setAttribute('oncommand', "Appmenu.exec(this.path, this.args);");
                    menuItem.path = item.path;
                    menuItem.args = item.args;
                }
                menuItem.setAttribute('tooltiptext', item.tooltiptext || item.name);
                menuItem.setAttribute('id', item.id || "");
                parentPopup.appendChild(menuItem);
            }
        }

        // Verarbeitung der Subdirs
        for (let subdir of this.toolbar.subdirs) {
            if (subdir.name == 'separator') {
                ExternalAppPopup.appendChild(document.createXULElement('menuseparator'));
            } else {
                var subdirItem = ExternalAppPopup.appendChild(document.createXULElement('menu'));
                var subdirItemPopup = subdirItem.appendChild(document.createXULElement('menupopup'));
                subdirItem.setAttribute('class', 'menu-iconic');
                subdirItem.setAttribute('label', subdir.name);
                subdirItem.setAttribute('image', subdir.image);
                Appmenu.subdirPopupHash[subdir.name] = subdirItemPopup;
                Appmenu.subdirMenuHash[subdir.name] = subdirItem;
            }
        }

        // Verarbeitung der Apps
        for (let app of this.toolbar.apps) {
            if (app.subdir && Appmenu.subdirPopupHash[app.subdir]) {
                createMenuItem(Appmenu.subdirPopupHash[app.subdir], app);
            } else {
                createMenuItem(ExternalAppPopup, app);
            }
        }

        // Verarbeitung der Configs
        for (let config of this.toolbar.configs) {
            if (config.subdir && Appmenu.subdirPopupHash[config.subdir]) {
                createMenuItem(Appmenu.subdirPopupHash[config.subdir], config);
            } else {
                createMenuItem(ExternalAppPopup, config);
            }
        }

        if (this.autohideEmptySubDirs) {
            for (let key in Appmenu.subdirPopupHash) {
                if (Appmenu.subdirPopupHash[key].hasChildNodes()) {
                    continue;
                } else {
                    Appmenu.subdirMenuHash[key].setAttribute("hidden", "true");
                }
            }
        }

        if (this.moveSubDirstoBottom) {
            let i = ExternalAppPopup.childNodes.length;
            while (ExternalAppPopup.firstChild.getAttribute('class') != 'menuitem-iconic' && i-- != 0) {
                ExternalAppPopup.appendChild(ExternalAppPopup.firstChild);
            }
        }

        this._isready = true;
    },


    handleRelativePath: function(apps) {
        for (let app of apps) {
            if (app.path) {
                app.path = app.path.replace(/\//g, '\\');
                var ffdir = Cc['@mozilla.org/file/directory_service;1'].getService(Ci.nsIProperties).get(app.root, Ci.nsIFile).path;
                if (/^(\\)/.test(app.path)) {
                    app.path = ffdir + app.path;
                }
            }
        }
    },

    exec: function(path, args) {
        args = args || [];
        var args_t = args.slice(0);
        for (let arg of args_t) {
            arg = arg.replace(/%u/g, gBrowser.currentURI.spec);
        }
        var file = Cc['@mozilla.org/file/local;1'].createInstance(Ci.nsIFile);
        file.initWithPath(path);
        if (!file.exists()) {
            alert('Datei nicht gefunden: ' + path);
            return;
        }
        if (file.isExecutable() && !path.endsWith('.js')) {
            var process = Cc['@mozilla.org/process/util;1'].createInstance(Ci.nsIProcess);
            process.init(file);
            process.run(false, args_t, args_t.length);
        } else if (file.isFile()) {
            if (this.editor) {
                let UI = Cc["@mozilla.org/intl/scriptableunicodeconverter"].createInstance(Ci.nsIScriptableUnicodeConverter);
                UI.charset = window.navigator.platform.toLowerCase().includes('win') ? 'Shift_JIS' : 'UTF-8';
                let path = UI.ConvertFromUnicode(file.path);
                let app = Cc['@mozilla.org/file/local;1'].createInstance(Ci.nsIFile);
                app.initWithPath(this.editor);
                let process = Cc['@mozilla.org/process/util;1'].createInstance(Ci.nsIProcess);
                process.init(app);
                process.run(false, [path], 1);
            } else {
                file.launch();
            }
        } else if (file.isDirectory()) {
            if (this.fileManager) {
                let args=[this.FMParameter,path];
                let app = Cc['@mozilla.org/file/local;1'].createInstance(Ci.nsIFile);
                app.initWithPath(this.fileManager);
                let process = Cc['@mozilla.org/process/util;1'].createInstance(Ci.nsIProcess);
                process.init(app);
                process.run(false, args, args.length);
            } else {
                file.launch();
            }
        }
    },
};


(function() {

    // Definiere den Profilpfad für die Symbole
    let ProfilePath = PathUtils.toFileURI(PathUtils.join(PathUtils.profileDir, 'chrome', 'icons'));

    // Standard-Symbol-Dateiname
    let ButtonIcon01 = "restart.svg";
    let ButtonIcon02 = "quit.svg";

    let Icon01 = "profile.svg";
    let Icon02 = "chrome.svg";
    let Icon03 = "css3.svg";
    let Icon04 = "js.svg";
    let Icon05 = "addons.svg";
    let Icon06 = "folder.svg";
    let Icon07 = "folder-1.svg";

    let Icon11 = "Themes.svg";
    let Icon12 = "debugging-workers.svg";
    let Icon13 = "command-console.svg";
    let Icon14 = "window-dev-tools.svg";
    let Icon15 = "developer.svg";
    let Icon16 = "sync.svg";
    let Icon17 = "passwords.svg";
    let Icon18 = "performance.svg";
    let Icon19 = "plug-disconnected.svg";


    // StyleSheetService zum Hinzufügen der CSS-Regeln
    let sss = Components.classes["@mozilla.org/content/style-sheet-service;1"].getService(Components.interfaces.nsIStyleSheetService);       
    let uri = Services.io.newURI("data:text/css;charset=utf-8," + encodeURIComponent(`


        #AMProfil   { background-image: url('${ProfilePath}/${Icon01}'); 
                      background-repeat: no-repeat !important; 
                      background-position: 11px 3px !important; 
                      background-size: 16px 16px !important; /* Größe des Symbols anpassen */ 
                      -moz-context-properties: fill, fill-opacity;
			          fill: currentColor;
                      }
        #AMchrome   { background-image: url('${ProfilePath}/${Icon02}'); 
                      background-repeat: no-repeat !important; 
                      background-position: 11px 3px !important; 
                      background-size: 16px 16px !important; /* Größe des Symbols anpassen */
                      -moz-context-properties: fill, fill-opacity;
			          fill: currentColor; 
                      }
        #AMCSS      { background-image: url('${ProfilePath}/${Icon03}'); 
                      background-repeat: no-repeat !important; 
                      background-position: 11px 3px !important; 
                      background-size: 16px 16px !important; /* Größe des Symbols anpassen */
                      -moz-context-properties: fill, fill-opacity;
			          fill: currentColor;                       
                      }
        #AMJS       { background-image: url('${ProfilePath}/${Icon04}'); 
                      background-repeat: no-repeat !important; 
                      background-position: 11px 3px !important; 
                      background-size: 16px 16px !important; /* Größe des Symbols anpassen */
                      -moz-context-properties: fill, fill-opacity;
			          fill: currentColor;                       
                      }
        #AMAddons   { background-image: url('${ProfilePath}/${Icon05}');
                      background-repeat: no-repeat !important; 
                      background-position: 11px 3px !important; 
                      background-size: 16px 16pxx !important; /* Größe des Symbols anpassen */
                      -moz-context-properties: fill, fill-opacity;
			          fill: currentColor;                       
                      }
        #AMProgramm { background-image: url('${ProfilePath}/${Icon06}'); 
                      background-repeat: no-repeat !important; 
                      background-position: 11px 3px !important; 
                      background-size: 16px 16px !important; /* Größe des Symbols anpassen */
                      -moz-context-properties: fill, fill-opacity;
			          fill: currentColor;                       
                      }
        #AMCache    { background-image: url('${ProfilePath}/${Icon07}');
                      background-repeat: no-repeat !important; 
                      background-position: 11px 3px !important; 
                      background-size: 16px 16px !important; /* Größe des Symbols anpassen */
                      -moz-context-properties: fill, fill-opacity;
			          fill: currentColor;                       
                      }

        #AMAnpassen     { background-image: url('${ProfilePath}/${Icon11}');
                          background-repeat: no-repeat !important; 
                          background-position: 11px 3px !important;
                          background-size: 16px 16px !important;
                          -moz-context-properties: fill, fill-opacity;
			              fill: currentColor;                          
                        }
        #AMModus        { background-image: url('${ProfilePath}/${Icon12}');
                          background-repeat: no-repeat !important; 
                          background-position: 11px 3px !important;
                          background-size: 16px 16px !important;
                          -moz-context-properties: fill, fill-opacity;
			              fill: currentColor;
                        }
        #AMKonsole      { background-image: url('${ProfilePath}/${Icon13}');
                          background-repeat: no-repeat !important; 
                          background-position: 11px 3px !important;
                          background-size: 16px 16px !important;
                          -moz-context-properties: fill, fill-opacity;
			              fill: currentColor;
                        }
        #AMWerkzeuge    { background-image: url('${ProfilePath}/${Icon14}');
                          background-repeat: no-repeat !important; 
                          background-position: 11px 3px !important; 
                          background-size: 16px 16px !important;
                          -moz-context-properties: fill, fill-opacity;
			              fill: currentColor;
                        }
        #AMEntwickler   { background-image: url('${ProfilePath}/${Icon15}');
                          background-repeat: no-repeat !important; 
                          background-position: 11px 3px !important;
                          background-size: 16px 16px !important;
                          -moz-context-properties: fill, fill-opacity;
			              fill: currentColor;
                        }
        #AMsynchron     { background-image: url('${ProfilePath}/${Icon16}');
                          background-repeat: no-repeat !important; 
                          background-position: 11px 3px !important; 
                          background-size: 16px 16px !important;
                          -moz-context-properties: fill, fill-opacity;
			              fill: currentColor;
                        }
        #AMdaten        { background-image: url('${ProfilePath}/${Icon17}');
                          background-repeat: no-repeat !important; 
                          background-position: 11px 3px !important; 
                          background-size: 16px 16px !important;
                          -moz-context-properties: fill, fill-opacity;
			              fill: currentColor;
                        }        
        #AMManager      { background-image: url('${ProfilePath}/${Icon18}');
                          background-repeat: no-repeat !important; 
                          background-position: 11px 3px !important; 
                          background-size: 16px 16px !important;
                          -moz-context-properties: fill, fill-opacity;
			              fill: currentColor;
                        }
        #AMOffline      { background-image: url('${ProfilePath}/${Icon19}');
                          background-repeat: no-repeat !important; 
                          background-position: 11px 3px !important;
                          background-size: 16px 16px !important;
                          -moz-context-properties: fill, fill-opacity;
			              fill: currentColor;
                        }


        /* Neustart-Button */
        #AMreboot { 
            background-image: url('${ProfilePath}/${ButtonIcon01}');
            background-repeat: no-repeat !important;
            background-position: 10px 2px !important;
            background-size: 20px 20px !important; /* Größe des Symbols anpassen */
            padding-left: 10px !important; /* Platz für das Symbol lassen */
            -moz-context-properties: fill, fill-opacity !important;
            fill: #fbc96e !important;
        }

        /* Beenden-Button */
        #AMquit { 
            background-image: url('${ProfilePath}/${ButtonIcon02}');
            background-repeat: no-repeat !important;
            background-position: 12px 3px !important;
            background-size: 16px 16px !important; /* Größe des Symbols anpassen */
            padding-left: 10px !important; /* Platz für das Symbol lassen */
            -moz-context-properties: fill, fill-opacity !important;
            fill: red !important;
        }

    //    /* Menüleiste ausblenden */
    //    #main-menubar > menu { 
    //        display: none !important; 
    //    }

    `), null, null);

    // CSS-Regeln registrieren
    sss.loadAndRegisterSheet(uri, sss.AUTHOR_SHEET);

})();

if (window.gBrowser)
Appmenu.init();