// ==UserScript==
// @name           Appmenu.uc.js
// @namespace      Appmenu@gmail.com
// @description    Basiert auf dem Script externalFuncButtonM.uc.js, Wiederherstellung der Orangenen FF-Menü Schaltfläche
// @include        main
// @version        update for Firefox 68+ by aborix
// @author         defpt
// @charset        UTF-8
// @version        2019.08.04
// @version        2020.05.27
// @version        2020.07.13 Weitere Menüs und Funktionen ergänzt by bege
// @version        2024.08.10 alle Einstellungen im Abschnitt Konfiguration vornehmen
// @version        2024.08.18 einige Veränderungen am Skript, Symbole, Funktionen & Menüs by Mira Bellenbaum
// ==/UserScript==


        // Pfad und Dateiname für das Symbol ermitteln
       let ProfilePath = Services.dirsvc.get("ProfD", Ci.nsIFile).path.replace(/\\/g, "/");




        let ButtonIcon01 = "arrow-rotate-left_red.svg";
        let ButtonIcon02 = "quit_red.svg";
        let ButtonIcon03 = "settings.svg";
        let ButtonIcon04 = "privateBrowsing.svg";
        let ButtonIcon05 = "firefox.svg";

//        let fullPath = "file://" + ProfilePath + "/chrome/icons/" + ButtonIcon;

        // Dynamisches Hinzufügen von CSS-Stilen zum Dokument
        let style = document.createElement('style');
        style.type = 'text/css';
        style.innerHTML = `
            #AMreboot   { list-style-image: url('file://${ProfilePath}/chrome/icons/${ButtonIcon01}'); }
            #AMquit     { list-style-image: url('file://${ProfilePath}/chrome/icons/${ButtonIcon02}'); }
            #AMsettings { list-style-image: url('file://${ProfilePath}/chrome/icons/${ButtonIcon03}'); }
            #AMprivate  { list-style-image: url('file://${ProfilePath}/chrome/icons/${ButtonIcon04}'); }
            #AMabout    { list-style-image: url('file://${ProfilePath}/chrome/icons/${ButtonIcon05}'); }
        `;
document.head.appendChild(style);





var Appmenu = {
    // Beginn der Konfiguration ------------------
    
    // Editor mit angegebenem Pfad verwenden
    // editor: 'C:\\Program Files\\Notepad++\\notepad++.exe',
    editor: 'C:\\Program Files\\NMicrosoft VS Code\\Code.exe',
    // oder
    // in 'view_source.editor.path' eingetragenen Editor verwenden
    editor: Services.prefs.getCharPref('view_source.editor.path'),
    // Dateimanager mit angegebenem Pfad verwenden oder leer ('') wenn System-Dateimanager verwenden
    //fileManager: 'C:\\Program files\\FreeCommander XE\\FreeCommander.exe',
    fileManager: '',
    // Parameter für Dateimanager oder leer ('')
    //FMParameter: '/T',
    FMParameter: '',
    // Submenüs ohne Inhalt im Hauptmenü automatisch ausblenden
    autohideEmptySubDirs: true,
    // Submenüs im Hauptmenü nach unten verschieben
    moveSubDirstoBottom: false,
    // Ort und Aussehen des Menü-Buttons einstellen
 //   isUrlbar: 1,  // 0： TabsToolbar； 1： navbar,
    isUrlbar: 2,  // 0: TabsToolbar; 1: navbar; 2: toolbar-menubar
    isButton: 1,  // 0: Hamburger,klein; 1: Firefox,groß,
    // Hotkey zum Öffnen des Appmenüs oder leer ('')
    hotkey: 'x',
    hotkeyModifier: 'alt',
    
    // Ende der Konfiguration --------------------
    
    subdirPopupHash: [],
    subdirMenuHash: [],
    toolbar: {
        // Submenüs des Hauptmenüs definieren; Separator einfügen mit {name: 'separator'}
        subdirs: [
            {
            name: 'Datei',
            image: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxNiIgaGVpZ2h0PSIxNiIgdmlld0JveD0iMCAwIDE2IDE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPgogIDxwYXRoIGQ9Ik0zLjIwOC41aDkuNTg0YTIuNzA5IDIuNzA5IDAgMCAxIDIuNzA0IDIuNTU1bC4wMDQuMTUzdjkuNTg0YTIuNzA5IDIuNzA5IDAgMCAxLTIuNTU1IDIuNzA0bC0uMTUzLjAwNEgzLjIwOGEyLjcwOSAyLjcwOSAwIDAgMS0yLjcwNC0yLjU1NUwuNSAxMi43OTJWMy4yMDhBMi43MDkgMi43MDkgMCAwIDEgMy4wNTUuNTA0TDMuMjA4LjVabTEuNzMgOS41ODNIMS43NXYyLjcwOWMwIC43NjUuNTg5IDEuMzkyIDEuMzM5IDEuNDUzbC4xMTkuMDA1aDkuNTg0Yy43NjUgMCAxLjM5Mi0uNTg5IDEuNDUzLTEuMzM5bC4wMDUtLjExOXYtMi43MDloLTMuMTg4YTMuMTI1IDMuMTI1IDAgMCAxLTIuODk1IDIuNDk2TDggMTIuNTgzYTMuMTI1IDMuMTI1IDAgMCAxLTMuMDI2LTIuMzQzbC0uMDM2LS4xNTdabTcuODU0LTguMzMzSDMuMjA4Yy0uNzY1IDAtMS4zOTIuNTg5LTEuNDUzIDEuMzM5bC0uMDA1LjExOXY1LjYyNUg1LjVjLjMxNiAwIC41NzguMjM1LjYxOS41NGwuMDA2LjA4NWExLjg3NCAxLjg3NCAwIDAgMCAzLjc0Ni4xMjlsLjAwNC0uMTI5YzAtLjMxNi4yMzUtLjU3OC41NC0uNjE5bC4wODUtLjAwNmgzLjc1VjMuMjA4YzAtLjc2NS0uNTg5LTEuMzkyLTEuMzM5LTEuNDUzbC0uMTE5LS4wMDVaTTMuNjI1IDUuOTE3aDguNzVhLjYyNS42MjUgMCAwIDEgLjA4NSAxLjI0NGwtLjA4NS4wMDZoLTguNzVhLjYyNS42MjUgMCAwIDEtLjA4NS0xLjI0NWwuMDg1LS4wMDVoOC43NS04Ljc1Wm0wLTIuNWg4Ljc1YS42MjUuNjI1IDAgMCAxIC4wODUgMS4yNDRsLS4wODUuMDA2aC04Ljc1YS42MjUuNjI1IDAgMCAxLS4wODUtMS4yNDVsLjA4NS0uMDA1aDguNzUtOC43NVoiLz4KPC9zdmc+Cg=="
            },
            {
            name: 'Bearbeiten',
            image: "data:image/svg+xml;base64,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"
            },
            {
            name: 'Extras',
            image: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxNiIgaGVpZ2h0PSIxNiIgdmlld0JveD0iMCAwIDE2IDE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPgogIDxwYXRoIGQ9Ik00IDIuOTY5di42NTVIMS44Yy0uOTk0IDAtMS44Ljg4MS0xLjggMS45Njl2Ny40MzhDMCAxNC4xMTguODA2IDE1IDEuOCAxNWgxMi40Yy45OTQgMCAxLjgtLjg4MiAxLjgtMS45NjlWNS41OTNjMC0xLjA4OC0uODA2LTEuOTY5LTEuOC0xLjk2OUgxMnYtLjY1NUMxMiAxLjg4MiAxMS4xOTQgMSAxMC4yIDFINS44QzQuODA2IDEgNCAxLjg4MiA0IDIuOTY5Wm0xLjgtLjY1Nmg0LjRjLjMzMSAwIC42LjI5NC42LjY1NnYuNjU1SDUuMnYtLjY1NWMwLS4zNjIuMjY5LS42NTYuNi0uNjU2Wk00IDQuOTM5aDEuMnYtLjAwMmg1LjZ2LjAwMkgxMnYtLjAwMmgyLjJjLjMzMSAwIC42LjI5NC42LjY1NnYxLjk3aC0yLjR2LS42NTdjMC0uMzYyLS4yNjktLjY1Ni0uNi0uNjU2LS4zMzEgMC0uNi4yOTQtLjYuNjU2di42NTdINC44di0uNjU3YzAtLjM2Mi0uMjY5LS42NTYtLjYtLjY1Ni0uMzMxIDAtLjYuMjk0LS42LjY1NnYuNjU3SDEuMnYtMS45N2MwLS4zNjIuMjY5LS42NTYuNi0uNjU2SDR2LjAwMlptNy4yIDMuOTM3VjkuOTdjMCAuMzYyLjI2OS42NTYuNi42NTYuMzMxIDAgLjYtLjI5NC42LS42NTZWOC44NzZoMi40djQuMTU1YzAgLjM2Mi0uMjY5LjY1Ni0uNi42NTZIMS44Yy0uMzMxIDAtLjYtLjI5NC0uNi0uNjU2VjguODc2aDIuNFY5Ljk3YzAgLjM2Mi4yNjkuNjU2LjYuNjU2LjMzMSAwIC42LS4yOTQuNi0uNjU2VjguODc2aDYuNFoiLz4KPC9zdmc+"
            },        
            {
            name: 'Hilfe',
            image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmlld0JveD0iMCAwIDE2IDE2IiB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+DQogIDxwYXRoIGQ9Ik03LjYyNSAxLjc1YzMuNDQ2IDAgNi4yNSAyLjgwNCA2LjI1IDYuMjVzLTIuODA0IDYuMjUtNi4yNSA2LjI1LTYuMjUtMi44MDQtNi4yNS02LjI1IDIuODA0LTYuMjUgNi4yNS02LjI1bTAtMS4yNWE3LjUgNy41IDAgMSAwIDAgMTUgNy41IDcuNSAwIDAgMCAwLTE1eiIvPg0KICA8cGF0aCBkPSJNNy42MjUgOS43MDlBLjYyNS42MjUgMCAwIDEgNyA5LjA4NGwwLS43NjdjMC0uNTI3LjM3LS45ODcuODc5LTEuMDkyLjU3Ny0uMTIuOTk2LS42MzUuOTk2LTEuMjI1YTEuMjUyIDEuMjUyIDAgMCAwLTIuNDMyLS40MDkuNjI2LjYyNiAwIDAgMS0xLjE4MS0uNDA4QTIuNSAyLjUgMCAxIDEgOC4yNSA4LjQyMWwwIC42NjNjMCAuMzQ1LS4yOC42MjUtLjYyNS42MjV6Ii8+DQogIDxwYXRoIGQ9Im04IDEyLS43NSAwLS4yNS0uMjVMNyAxMWwuMjUtLjI1Ljc1IDAgLjI1LjI1IDAgLjc1eiIvPg0KPC9zdmc+"
            },
            {
            name: 'Firefox Verzeichnisse',
            image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljCiAgIC0gTGljZW5zZSwgdi4gMi4wLiBJZiBhIGNvcHkgb2YgdGhlIE1QTCB3YXMgbm90IGRpc3RyaWJ1dGVkIHdpdGggdGhpcwogICAtIGZpbGUsIFlvdSBjYW4gb2J0YWluIG9uZSBhdCBodHRwOi8vbW96aWxsYS5vcmcvTVBMLzIuMC8uIC0tPgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmlld0JveD0iMCAwIDE2IDE2IiBmaWxsPSJjb250ZXh0LWZpbGwgIzBiMGIwYiI+CiAgPHBhdGggZD0iTTE0IDNIOC4xNUw2LjU4IDEuNTRBMiAyIDAgMCAwIDUuMjIgMUgyYTIgMiAwIDAgMC0yIDJ2MTBhMiAyIDAgMCAwIDIgMmgxMmEyIDIgMCAwIDAgMi0yVjVhMiAyIDAgMCAwLTItMnpNNS4yMiAzbDEuMDcgMUgyVjN6TTE0IDEzSDJWNWg2di0uMDFsLjE1LjAxSDE0eiIvPgo8L3N2Zz4K"
            },
            {
            name: 'Firefox Profil-Dateien',
            image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjE2IiBoZWlnaHQ9IjE2IiB2aWV3Qm94PSIwIDAgMTYgMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+DQogIDxwYXRoIGQ9Ik0xNC44NTkgMy4yYTEuMzM1IDEuMzM1IDAgMCAxLTEuMjE3LjhIMTN2MWgxdjhIMlY1aDhWNGgtLjY0MmExLjM2NSAxLjM2NSAwIDAgMS0xLjMyNS0xLjExTDYuNTg0IDEuNTM4QTIgMiAwIDAgMCA1LjIxOSAxSDJhMiAyIDAgMCAwLTIgMnYxMGEyIDIgMCAwIDAgMiAyaDEyYTIgMiAwIDAgMCAyLTJWNWEyIDIgMCAwIDAtMS4xNDEtMS44ek0yIDNoMy4yMTlsMS4wNzIgMUgyem03Ljg1NC0uMTQ2TDExIDEuNzA3VjguNWEuNS41IDAgMCAwIDEgMFYxLjcwN2wxLjE0NiAxLjE0NmEuNS41IDAgMSAwIC43MDctLjcwN2wtMi0yYS41LjUgMCAwIDAtLjcwNyAwbC0yIDJhLjUuNSAwIDAgMCAuNzA3LjcwN3oiLz4NCjwvc3ZnPg=="
            },
            {
            name: 'Firefox Funktionen',
            image: "data:image/svg+xml;base64,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"
            },            
            {
            name: 'about:',
            image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=="
            }
        ],

    apps: [  /*  Directories  */

        // Untermenü Firefox Verzeichnisse
        {
        name: 'Profil',
        root: 'ProfD',
        path: '\\',
        subdir: 'Firefox Verzeichnisse',
        image: 'data:image/png;base64,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'
        },
        {
        name: 'chrome',
        root: 'ProfD',
        path: '\\chrome',
        subdir: 'Firefox Verzeichnisse',
        image: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAACnElEQVR4Xm2RzYtbZRSHn/fr3pvJzTB3qiNM2k2pMBUGhEHaqsUqdeFGQalCobgREaFu/B/cqCtxVSjoQhBEQRBmIfWDKgNGJUPt0Nhah9JJ4iSd5E6+bu5972tAO4SS5/DjXZ1znsMrNiq1eikMQqYYJCmjxNH5+zdW777L0J5KKl9VPmnf+ut9KWkwhbheuzNcOVYOmGKc5iRO0r1ykeXCx0h7kt4fC3z5wfqbQnAJwQHa5S7jAZSRuJ0mkf81cheobhBXZa+ri1uptQjHAZoZCEC1PiPgDuwxCfwerBU7b73zXn//3usCcdt4HkZ7SGZg431U51NUCgwlO3cV/bVXhR/6p9ut+nP9QYeNn7/n8qUPZxvQ/Q6VVWHk4ZqWRvlJjpx9hcGfW2wO95N2q8m3618A2WwDt/0RplSAXsBed57eyossHl5GYdHacG3zGpADM06wjQ1UUIN+CLHPvfAxojPnKLiE+bDE1R9+5GatAmgPeGCAteQ7l5GBhGSyuROyd/gFouUyWkqEErR2mwXAAA8BRS0AgMQBjSra30ZkEeDzz9Dn4ZcvMO51SMcJcTdGChmA0ABA6cAgzyG3I8jLEBylV4fWoaeIc0V7t0Uv7pFbC+CA+28mp/8+SwXKnMVmz1O9HpE+eobMZdjcoY1GIHD/NwIdoH1fBaNguzlg88pVyoUi4vTbFI8eJxsNAIfSkrliESllH/L0v0jktNNomFGv1TFrL3Fo9QSMR3jaEEXzLC09gjaKp595No0WjyCEB4zRclICUMDxtRMce/wJ1MIi2SglXShhfI/cOjxPoZRmbq4gXzt/gVrtBrdvbiG+Wf+p/mvll1BpiVAGhCDPxuAUDotz4HKHlIJON6bRbL4hhPjcMx5mkn8BBLEUrsVZbq0AAAAASUVORK5CYII='
        },
        {
        name: 'CSS',
        root: 'ProfD',
        path: '\\chrome\\css',
        subdir: 'Firefox Verzeichnisse',
        image: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAatJREFUeNqkU7tKA0EUPbM7boISNKhBsLRQ9AMECx8EEQstgqVgL1iYyg+w1UbwC6ziA1TyA7FKjCKiYCGihSAIikiIJptZ7527amIjmmWHnXNn7jn3tSoIAjTzOGjy0cerI2umZtKB+VskylFwXGdds/Pw/AzgG8ByKHrV901OUYV2i41stYP81mFaW+X3MnC5IZctgabkaBmfbDWWo9VCe18WKw0tgX21dfJfgbE9IJEUlccjIJcKbWNi200Ao3X4fNkKasvml8R5p5OUSSn1IPXly9txCreNoCc40wG0tAJ9czZV6UJQEVavHYh2A9lB2sfENr4PuKTjeoInDmhPIqZS30Y/7EkkXFEhyA6QigvM3oo920+XGN8RQcmm4NiicWVtoSkd8wZMnRK1K0T5BTnjCBgXQmyqoilVp91zEZi+ksPnEyIg7skzwU9FiSBZCM+LX63VtkWc48UKfalY1Rdpo0fFyyXDvruNmKOL9dj2ap4oRIgkiMscRLuk759DZIXUDwzrw7765rG8icz1YuMoq18GObDO7Ms3KRb0/vNfulfN/s4fAgwAwWWMUVTgPhoAAAAASUVORK5CYII='
        },
        {
        name: 'JS',
        root: 'ProfD',
        path: '\\chrome\\scripts',
        subdir: 'Firefox Verzeichnisse',
        image: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAAC4gAAAuIAeWOKUkAAAEZSURBVDhP7ZMxLENRFIa/c2l5ESrFI+KpoUQTRoOYTJp0NBgsFpP5xSAxWNgkNlYJo72L3SIhMRiaaCxdRKIRkfQet+81FhUPsTnLvfnPzfefc3Ku6MW08oswrfPH8Q/4c8DohjKyFt+7AmVix5I/ULIlG4tfAfoXlb75eE+mDiGzIBgPctuG9HCkJ2tBOpTunPB4DrfrwvWS8lqTZioZQBvCQ9nirwqFU6Vn9n17kw+xEhqqu5a079o5MgwuR3NoD0j5sYO4tLbMmq61Y8NVUXipKAOlT1oINi0zZ8L4lsWbjB/3zlkKJ+KclSB0VYw5/S4if/yNKVdiECpeHp5vlOqe0HgSskXL0IrQmYH6JdzvO73eBvCtgDf14FTmcYgI3gAAAABJRU5ErkJggg=='
        },
        {
        name: 'Addons',
        root: 'ProfD',
        path: '\\extensions',
        subdir: 'Firefox Verzeichnisse',
        image: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAZdEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjbQg61aAAACkUlEQVQ4T43T60tTYRwH8HMQ9QQJRSBJ50xU8BL1QpJMsbxNc162edxcYlAoZdkFh6gZurF5WV6nc7M/oBdBb7q9DSPEVBDbZtN0c5tzNymolwXht2eDhVO0Dnx4Hn6/5/me8xx4KOqQR2rcYfjpIC81BpXiqWBnxUSgpWQ0kHrY+gN1xdOdu/XTQfDGIMSGAET6AMpG/TbhiD/uv0LqTYF7cmPgN2/wQzzhh2jMB+Gwz1I65I3/Z8A1o5eRTXqP85M+pVTv260Z86JieNtcMridXNjnZvI1Lia31xV7IIgf99AKg/e1wrAN+YQHtXoPJKNbqBrewlWdG6UDLlzRupCv3sTFns3vFx47SqJCFHoPoyAb5eNb4MlGyYgb1UNuiHQulPW7UKRx4rJqE5d6HMjpdiC7066mRFpHvFTnbCHuSJ84E+rIJumQExKdEzVE5YAT5RoHCnvsyO3aQHb7Os63rSHrwRoy76+qqErNBi/ut4PYrdFsKCWDDoj77CjvXUdu+yqyWleQcsuK5GYrBE0WcE0Wm6DZmsk1W7VEI1XRu6YUqb6gUh22W9BhQ8ZtCwQ3PoEjQuM+psi5SSBNCR/Zusq7bSju+IyMpmWwjUvgrh+hcWks6scVKs0tBQ/NSG5YBKtYNHOKRRxt4WUogKufTwmh8lqXU9MaFlY42UcLJ5tnOfk8yPwov0j/LfGNUIe/huXnYrm6uTiOn2UI7GEjcxMxTrwifu7rq6KOw0o+MAT2SI8sYGtnaVJ/s68fFUCfONd2jK2e+cFWv0dY1bu+mPiTocsTmyR8kU56X//2wmtmuiMvoMkkdEkEp3K0N08XPZsKScwzdNB0zFlSz0pIaxBG6mQ0JBU/1yXmm878AbFQoHrb98HyAAAAAElFTkSuQmCC'
        },
        {
        name: 'Programm',
        root: 'CurProcD',
        path: '\\',
        subdir: 'Firefox Verzeichnisse',
        image: 'data:image/x-icon;base64,AAABAAEAEBAAAAAAAABoBAAAFgAAACgAAAAQAAAAIAAAAAEAIAAAAAAAAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACQAAAB0AAAAzAAAAQgAAAEUAAAA4AAAAIwAAAA0AAAABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEAAAAKgQAIngOFHPPHiGf9hwnsv4aK7H+HCid9BYmiNoNEVGWAAAAOQAAAAkAAAAAAAAAAAAAAAAAAAAAAAAADhISZ4oiJaj4JTfD/yVDzf8lTNP/JU/X/yVT2f8lUNL/HDas/g4bbJsAAAAaAAAAAAAAAAAAAAAAAAAAACAmkVYeKLn+JT7I/yVL0/8lVNr/JVrd/yVf3/8lZuL/JW3k/yVk4P8bT9P+HkXBjAAAAAAAAAAAAAAAABoaaxMeMbXqJT/K/yVN1v8lWN3/JmDf/ytSr/81OWr/M0qL/yZ64/8jiez/JXXh/x9Msv4ITLo/AAAAAAAAAAAiN6B3JT7I/yVN1v8lWd3/JV3d/ytEnv81J1T/SiIe/04iFf9BISL/I6HV/xus7v8hhtn/JVCofAAAAAAAAAAAIEGw0SVL0/8lV9z/JVnb/yZn4P8oct7/Jnjg/ydjt/9RUE3/WCgR/zp3fv8axfb/EMj1/xmC0LQAAAAAAAAAABxKxv0lVNr/Jl/f/ydCyf84WaX/a0AX/3NMHP9lZEf/dUQT/2cyDf9ZNB//Q9j3/ybh/P8ap9X1AAAAAAAAAAAbWM/8JVve/yZm4P8mWNP/Nkh+/3JXLf+aWgv/mFkL/4tNBv+ARQf/bTcH/6Pw+v977v7/Opuz/gB/fwIAAAAAIWHV5SZf4P8ma+H/Jnfk/yOP5/9QZYT/qXAm/7NyHP+qaBX/mVkN/4xPCP+dtKv/lu3+/yOy1uUAAAAAAAAAAB1exJElZeL/Jm7i/yZ+5f8iheD/QHDX/2uAk//DiRP/vH4V/7V0GP+jZRn/rbKa/4js//8AyOONAAAAAAAAAAAdU7JGJVnY/yZw4/8kguX/IJLg/4p4N/+wjhv/0p0F/9GaCf/FiRD/sHkv/8Ts8P+L4/L/DcbnTQAAAAAAAAAAGVnYFB5m3P12eX39coBn/02bp/92i1H/1qYb/+GvIf/cqQz/yJId/8SlaP+539//Za/KtwAAAAAAAAAAAAAAAAAAAAAiguZSv5tRZMKXQPXBkiX/xKU3/+a2Qf/rvEj/5bQ4/9OpQP/XyZ7vkqmnegAAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADkwWkd5cBimOe/X+TswV7+7sNe/um/X+HivWeRzbBOGgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA=='
        },
        {
        name: 'Startup-Cache',
        root: 'ProfLD',
        path: '\\startupCache',
        subdir: 'Firefox Verzeichnisse',
        image: 'data:image/x-icon;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAB3RJTUUH1wcREBAg9OD7NAAAAAlwSFlzAAAewQAAHsEBw2lUUwAAAARnQU1BAACxjwv8YQUAAAH6SURBVHjaxVNBaxNBFP4mGRNp06bSaGu9qXhRLOSQX6Dg0d48SMWC4Mmbv8AfYA7Sgp6UgteCF29CKahBsKKWglgam4rRxGxiks3u7Mz6zZIlSVHRk7N8vLcz7/vemzczwP8eorSCgtLJJeXpUGtMBQHgK5RptxbuYJUx5o8CL5bx+OzCkyuZ2cLIwtPihbVW9a1GiCyFQyusFD4S2zfv4x5DtI2TAphOZk8zbXFE4NKt5ctInDmY8OLd6zNrtI+IlhURG0Xs55dezZXXF9Gq7CA9NQvNbAH19W/wo+6gWXeaN1aQkybEXLv2Bb36Z+SvfUAynYLgB9Y+GLEv6Sl4HTdcvX0yy4kZqdkit1nFWC4Pme4ydvMXxNiOwwTfIVP5OCBlK0Cv8Y4C5xnXYM+bB0ixTwjWHwpUdzbh+ijZSWlYQefrcxwrLJJcIZxRAWM33qP1KTCOwJ9ErbyLno8trvqRgOrsITV5ik6pT2IXvbZdINmjVr8CmYMx09h7/8wKMBtUtIWgu4/DE8e5lxob4pLsDkhhvxJrjYfE2Am065/Et1ZUQRAJTBxJIDQJZrgKZDiRwYA03AlxCF1Ho92oYGM7ElCS5/qmVjXzLx+cg71tMex5D/8Pw+ng4etd2GYpER0ucJRI26v9l2/Ivg82CI2YIP+BPCyifwI91AzKs/qQkQAAAABJRU5ErkJggg=='
        },


        /*    apps: [ /* files  */

        // Untermenü Firefox Profil-Dateien
        {
        name: 'userChrome.css',
        root: 'ProfD',
        path: '\\chrome\\userChrome.css',
        subdir: 'Firefox Profil-Dateien',
        image:'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAADFklEQVQ4jXXR3U9bdQDG8fMHbFcjLjFRE2PIEhsTTfTOK++8UmNc2JzeaIQ0GzFBnSxLUDvs1DnCRJSgvIjsFUYXNg/Ki8IKnfQFCm3T0xZq11Eobc/pK6ft+fXrxYyhMT7Jc/l8bh5J2heLZeKxmZlQdGU1oblXtjWXN6m5fBlt2ZfRFr2aKk/Hfzt84PAj0v/lwjcLjelkTvBP8gIeFAWr6Qq3lQLTgTIX+mZ+P7AfmYjSfS0o+q9E6B9yF8cmAyVjJlrlTrjCLaXMgLfEoCeDM17E5lZxx+BM38KCdPDgIUmSJOlnP7WLdsHQSpWh1QoDrj0653L0O3K8O7bDs71/0XIjSDRdYno9hyOgsxiBiz/MLTQ0NDwqjfrQupcENwNVuhb3sPl0+hx5bKt5Prid5LneKO9PBNnN6Tg3Svy6nuXassovCrSe7uqRBjcQX3lgJAwjCnzrrHD+bpEue573bCkaL8Uwjytki2UiqoE7UWZ2o4QtbGD97s6S9NTRsz1PvH5m9PFXP/rpyTfOTjYPOIzWy25ahpd550cHb35vp3tqjVTRYFM1WNup4IjrzCfB0ntrqe6Fl196q3Ezsq0blRJqrviw2QKpfJlEocb9nCCUruJNVnCp8FnPxGIdYLXOPq1Es/oesFuCnSIkCrCVrxHPGsQ0QSRtEEhV8Rfgk0s364GOjkmTP5LRCwK2C4KtvCCeE9zPCmJZQVQ1iKhVQqpAKUFH93g90N4+bvKGUrpWhQf7h5ogouko2Sz2eBRHPE9Yh/avx+qBtrYrJldwV09X+Xe4oQoiWo3lrTh3E2HkYIZR/xoezeDjL/8DDJuWAkk9WYZNTRBWBUrmYWeDGtfXfVz1xBj88x72ZIXTX1yvB06dGjbN+5J6ogwhtUYwLQikBYGMYH6zwohTYdC+zpgzgTsHbZ9frQdaWoee+SOQZxuI6hDZA6UE/iKs5cCegLkYONLg0qHt/A1PHXDkyAuHXjvx4eW3T1qmTpgt8nGzRT7Wck4+2nxObmrulJvMVvmY2So3NXfKx09ap55/8ZVP/waJWLfEOCt3rAAAAABJRU5ErkJggg=='
        },
        {
        name: 'userContent.css',
        root: 'ProfD',
        path: '\\chrome\\userContent.css',
        subdir: 'Firefox Profil-Dateien',
        image:'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAADFklEQVQ4jXXR3U9bdQDG8fMHbFcjLjFRE2PIEhsTTfTOK++8UmNc2JzeaIQ0GzFBnSxLUDvs1DnCRJSgvIjsFUYXNg/Ki8IKnfQFCm3T0xZq11Eobc/pK6ft+fXrxYyhMT7Jc/l8bh5J2heLZeKxmZlQdGU1oblXtjWXN6m5fBlt2ZfRFr2aKk/Hfzt84PAj0v/lwjcLjelkTvBP8gIeFAWr6Qq3lQLTgTIX+mZ+P7AfmYjSfS0o+q9E6B9yF8cmAyVjJlrlTrjCLaXMgLfEoCeDM17E5lZxx+BM38KCdPDgIUmSJOlnP7WLdsHQSpWh1QoDrj0653L0O3K8O7bDs71/0XIjSDRdYno9hyOgsxiBiz/MLTQ0NDwqjfrQupcENwNVuhb3sPl0+hx5bKt5Prid5LneKO9PBNnN6Tg3Svy6nuXassovCrSe7uqRBjcQX3lgJAwjCnzrrHD+bpEue573bCkaL8Uwjytki2UiqoE7UWZ2o4QtbGD97s6S9NTRsz1PvH5m9PFXP/rpyTfOTjYPOIzWy25ahpd550cHb35vp3tqjVTRYFM1WNup4IjrzCfB0ntrqe6Fl196q3Ezsq0blRJqrviw2QKpfJlEocb9nCCUruJNVnCp8FnPxGIdYLXOPq1Es/oesFuCnSIkCrCVrxHPGsQ0QSRtEEhV8Rfgk0s364GOjkmTP5LRCwK2C4KtvCCeE9zPCmJZQVQ1iKhVQqpAKUFH93g90N4+bvKGUrpWhQf7h5ogouko2Sz2eBRHPE9Yh/avx+qBtrYrJldwV09X+Xe4oQoiWo3lrTh3E2HkYIZR/xoezeDjL/8DDJuWAkk9WYZNTRBWBUrmYWeDGtfXfVz1xBj88x72ZIXTX1yvB06dGjbN+5J6ogwhtUYwLQikBYGMYH6zwohTYdC+zpgzgTsHbZ9frQdaWoee+SOQZxuI6hDZA6UE/iKs5cCegLkYONLg0qHt/A1PHXDkyAuHXjvx4eW3T1qmTpgt8nGzRT7Wck4+2nxObmrulJvMVvmY2So3NXfKx09ap55/8ZVP/waJWLfEOCt3rAAAAABJRU5ErkJggg=='
        },
        {
        name: 'userChrome.js',
        root: 'ProfD',
        path: '\\chrome\\userChrome.js',
        subdir: 'Firefox Profil-Dateien',
        image:'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAADFklEQVQ4jXXR3U9bdQDG8fMHbFcjLjFRE2PIEhsTTfTOK++8UmNc2JzeaIQ0GzFBnSxLUDvs1DnCRJSgvIjsFUYXNg/Ki8IKnfQFCm3T0xZq11Eobc/pK6ft+fXrxYyhMT7Jc/l8bh5J2heLZeKxmZlQdGU1oblXtjWXN6m5fBlt2ZfRFr2aKk/Hfzt84PAj0v/lwjcLjelkTvBP8gIeFAWr6Qq3lQLTgTIX+mZ+P7AfmYjSfS0o+q9E6B9yF8cmAyVjJlrlTrjCLaXMgLfEoCeDM17E5lZxx+BM38KCdPDgIUmSJOlnP7WLdsHQSpWh1QoDrj0653L0O3K8O7bDs71/0XIjSDRdYno9hyOgsxiBiz/MLTQ0NDwqjfrQupcENwNVuhb3sPl0+hx5bKt5Prid5LneKO9PBNnN6Tg3Svy6nuXassovCrSe7uqRBjcQX3lgJAwjCnzrrHD+bpEue573bCkaL8Uwjytki2UiqoE7UWZ2o4QtbGD97s6S9NTRsz1PvH5m9PFXP/rpyTfOTjYPOIzWy25ahpd550cHb35vp3tqjVTRYFM1WNup4IjrzCfB0ntrqe6Fl196q3Ezsq0blRJqrviw2QKpfJlEocb9nCCUruJNVnCp8FnPxGIdYLXOPq1Es/oesFuCnSIkCrCVrxHPGsQ0QSRtEEhV8Rfgk0s364GOjkmTP5LRCwK2C4KtvCCeE9zPCmJZQVQ1iKhVQqpAKUFH93g90N4+bvKGUrpWhQf7h5ogouko2Sz2eBRHPE9Yh/avx+qBtrYrJldwV09X+Xe4oQoiWo3lrTh3E2HkYIZR/xoezeDjL/8DDJuWAkk9WYZNTRBWBUrmYWeDGtfXfVz1xBj88x72ZIXTX1yvB06dGjbN+5J6ogwhtUYwLQikBYGMYH6zwohTYdC+zpgzgTsHbZ9frQdaWoee+SOQZxuI6hDZA6UE/iKs5cCegLkYONLg0qHt/A1PHXDkyAuHXjvx4eW3T1qmTpgt8nGzRT7Wck4+2nxObmrulJvMVvmY2So3NXfKx09ap55/8ZVP/waJWLfEOCt3rAAAAABJRU5ErkJggg=='
        },
        {
        name: 'prefs.js',
        root: 'ProfD',
        path: '\\prefs.js',
        subdir: 'Firefox Profil-Dateien',
        image:'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAsZJREFUeNqMU1tIFGEU/uafm+6urhKWt80UEUFzs10LkkhIsgyCeggrCLPwqadeIqIwQoSIHnrpQl4Qil6EXuqhLboQ5GUXDZYS0iV1uyCGru22u7Pzz/T/s7slUdGBb2bOmXPO/813zggVfT5wMxl0aiCm0cX6kvyifEXEckKHP7wCURCsHH4lRIAsMhACVSLVEjJmmiYSunH55sGGoo4tZfiX+d4vwpkjY3//6B2SDRqsQVxLdWWLdeZz0DUwM7l9z2aRZGw3rbO3SFn6zEdL9fpS7kc1ajVca5y+yOjbZBHPQ0s4ei8KRSKQsgKwExx5atpNUApeL/xG3UZEq7FK42/C5w+c5LGfDPRkonZrqdNK1FIGTC5cRjxk2NhVEROfIqzInC/vfRxwMD8jIvtGg+7ylDuZ8ikkeL4oApwRf9Z0K4uH3sa4FkaIMjbfWJhkDzAorS3MVbCapEiwcDxHQtRVjJhrA5KyZGGmpBi79zYgBkxFVDs4fo1RVLZ7ypyYWkmC2hRIrnK4Hw4jeKgbSSF9iKzmYOODfoSOnB5UZXGIiATEmgB767TnunijpKpCqnTBfasHuNEDVWCUU0BKY3edAtcvoPLaOXwVVHNZzgVJUcNk22dGqVlQezuAghp2cg8T2DeCd68iaO/1YSQwB0XXUBxewOSLZZiP7mPzmcNIGYJJkrqByKV9iFxsw3S3J70sS1/YzBxgq4Gr7TUY8i8wPUWEaHohBFsey/lsTYkQLTZx5eUs5lYTmInpEBbCCA0+YQ1sqOvwwu2twtm2Oqg2CYXVm9B4bBvgyMPU3ddwj496hfzWzlZlZ4ePfQoM1pHKCr7bnJgd7ETViRbMDzxFxfEBS8UPw12oOLWHFY+h0T/mDe5oDvBNURnq//TTTDc1+fP0OMomg17uf2ys96/IjNn4uDfY3BzAf5gng7/5+CHAAPUhK3nsRsW2AAAAAElFTkSuQmCC'
        },
        {
        name: 'user.js',
        root: 'ProfD',
        path: '\\user.js',
        subdir: 'Firefox Profil-Dateien',
        image:'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAArBJREFUeNqMU11IFFEU/vbO7Iyuums/GvmXhISBiOWWGFgGiyaC0UMkWRT11FNPQbEl9iNb0mtgUEQW+xjUQ5RrlClZ5IbaQ0bpw+paSGLGbrs7O3emc2d/kKjowBnm3HvnO9/5vju2Tb4ARJiUOjcQ1fhizUZnkVORsBzXMT7/HZLNZp0RT8ZssEuUjEGVWZWMdJimibhuXO4/UFvUWVeKf0Xg0yJcOXa03359i2UWDQKIackTmY91qkXyVWmmz/qezyBBbCvX5TXLGfpUo7mquETUEY1bgKtD0JeIvsMu4cXsNxz2R6DIDHJGAOqQX6CmyjjnEN/bfqPuYJIFrPLY5Ly346RYyzLQE/Hq7SUu66CWNFJd0+KZaTYFioxgeAV2mKH1vYPBfFVCWgOa0eB76stcpHwSmmFAQMiktkjxLpJUR2glBtlIzArsn9QoxYAaGJxXr8lVECHruGHSrEDxhccWfLinLcXozEM4cmTkJmITWVuzNkpKQ32pC1GuW1039DzB6OlWSCQaSUoacTCJYfiUB2ZRxR3RRAzGLAeIQmFeTrkAUumCVF4ZxMCR3bg0HLaU13UDMaJr0GjnhkLoP9gIjXNT1CxJUHT7zKhuFO68MYKqa8/g62jEgw/LePP5I3ZVroV/cgGin9m3HyPT0/BPLcHbskOMasoJQl+52Ja1ip19hIWoBofKLG2ut29Fp/8duraVIvwjBiGe2AtHEpYIjGnRt30vZxCizTnKJRLs7qsp5NOdONRQi703x9Dt2QInWbj56hC6GutQoNpxb+w9vpzf57Y5Pcc9SlNngEaxRJFpZoVEFN4fbarDwMhkyiXaFYofo7X7oxP42t3mrvAFgsIJlbLmTz9NWe/TcRvxnPO2uEVd3js4LrSY97a66S8O4j+iPp1/q/FLgAEAGto2bg8Nx1UAAAAASUVORK5CYII='
        }
    ],
        

    configs: [

        // Untermenü Firefox Funktionen
        {
        name: 'Anpassen',
        command: "gCustomizeMode.enter()",
        subdir: 'Firefox Funktionen',
        image:'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAAdhsAAHYbAfWG3pUAAAHbSURBVDhPY2QgA6jVnZD8958pmuH3zwXMUDGigVrjWZc/HMJ7f7MJBTD9/PSaJBeoNp5P+cMpPP0vAysL0/cP71m+vdJhgsoRBMq1p8t/sQnN+vufhYXx17f/zN/fJt/ptH9GlAFKFcfqfrMKdvz7y8D4/+d3Buavr1rvdtisB8kRNECxcH/lL2b+xr9//jP8//WDgeXLy8WMv3/UQaUZ8IaBWuGe3C8sQpP+M7MBFf5nYP31fiPLv5+hdye4/oYqYcAZCwsO3ArX1VScff7RD8bfv/8wsP58t4n597ewe5M94JpBAKsB3VuumnILSmzg5eVlkxXh+H/r7qNV/39+i7w/1QtFMwhgGFC26rIEB5/IXkYOPuGvP38x/PnyZrK6BGvaxhLrv1AlKAAlDM7n8vIttzmyjVNSzZrpz4/fvz+9ymsJUJ8BlcYK4C64XsQdK8z+c7fS22Oqpzmd3n758tm3J1RzDVQaJwC7YL2FAru+4au3ovzfuH98ZGS49YLP33r9x01gFQQAOB18estk8/46G/evtwwM79+wvGX4+28vWJYIwLhARUmA+8+//XyMvwx+szK+/cLCHBlx7dFuqDxBAHQBo9YPJqbVz5k4Q9/85VAgRTMDAwMDAIpDuk3/mjFSAAAAAElFTkSuQmCC'
        },

        {
        name: 'Neustart im abgesicherten Modus',
        command: "safeModeRestart();",
        subdir: 'Firefox Funktionen',
        image:'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAACh0lEQVQ4jY2SW0iTARzFz7cvRfqclA7Lpi51tjlnikukB3VKFzQC02UPmQaVRqlpRqiVLak0UUIxsVroTAsFTUzmJY1u0HUJ2YWCVg9RCWEPZauETk8+zJZ1ns/vxx/+B5gnmZlZuRZL23W5XK6Yr+c2OwsOhFg7Lz28Zx/n9pzdVQaDwWNeoKAgT9vQUJfX2Tuw2dpqbXxhM3+6032E7VcG2HI7jcdbiu2l+8pKy0vLTWtS1+coFIoAF0GgWmucsOb/mmyP43SPjt/bwJt1ETSf3sa6JwKrHCKzbkRS1x/FDcUb7RKkKNcTfPziu7MSf07lg9/OgzNN4Mdd4IkGsPYNWDYBqgZAtAqMSNHdAqB1FXh765tXJ315HwR+zQFn1oHOMLC6Hix3gPn3QekiiAYZdQmRQwCCXXhJqYw+m5DkfA3w83LQ6Q9Oi2BBBWgaB402EI2gUCNjVLJhGECQi8DDf1F0fVKy8wHAtwqBk34CJ0WBm/aAQTZQbgFRA4pVMuoTY0YAqOY+IjxtS+XUyoxhphfeZW7FU2YUPqO5MYHdI6ClF2zqBGvPiYyO1fYDCJgrUCSkFz2XbX1Jn8IPVB91MqDsB082p9I+DI72gYM9oOWMnEuXqZoBSH9sITY2rss3bYhIe0zP7FcUTA4erDZy9CrY0wX294JFxUoCC3e4HZOPl5i9am0FoRkkDNeIyDGWHIqjrQ/s6wFbL8io0QY7AGjcCgD4rlCrbCExlYRkJcQ2luyP5Ngw2GEFjSn+BBaY/wbPJj40NPCRWptDQTjGwr3hPFUN6nSLCXhcBrDkXwIAMEiS2BGm1k/p9BrKRK93AGoAKP8Hns1iACYAhwEkAvB0V/oNnDMV0lvYzsIAAAAASUVORK5CYII='
        },
        {
        name: 'Browser-Konsole',
        command: "var { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                var { BrowserConsoleManager } = require('resource://devtools/client/webconsole/browser-console-manager');\
                BrowserConsoleManager.openBrowserConsoleOrFocus();",
        subdir: 'Firefox Funktionen',
        image:'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAACwElEQVQ4jU2TS28SURiG5yf5G1xo1KqJd43aJkYTEzfGuNSdMV5jotVYG6vponipF3BKL7SAlrZWipbeLdABBsoMMMOAU+48LuaYuHhzvrP5zvs933mlOJAGNoVUIAPEbNBFvS2UAmLAOpAQdylQh8G4xf05hdvftrgzneLRnEbvQpnHP0rcnda4F9K5N5Pj4XeN++Ect2dTPFnM8j7bQLoShsPDCsfdCc5Naez/orJ3LM8+v8ku12/2+i12j+bYM5LlyGSe0+MZTni26JmyuL4C0sGxBodkk0v+PBeDObq8GQ74S5yKdDgabtIV+sMeX4F9vjzHfRrn5E3OuxMckwvsd5tI5ydtetPgM2BC3eGzDu90eJsFjwkjFnwRp1eHYMYiZEBfCi6M6UgnvTqfGg4wo9VC+w9ktgWaAKgBuQ7YjQplYNSGHjmB1OU3GKyBSoOF9VnkSJQVCyzABqpABSgBfwDYxqaC3IIT4zGkQ8Earg4Ugbga5albZnQ9gwEUOlAGtBYU/jVoK1Qp8cGGUxMq0pERGCo5LzRp415WuDu2wEINFBylhIoAdQ27WSXYhG6PiXR2uMWc6B5dWmPAF0HeqqIA3qRFX/AXDz3feOL9QSRVhB0LOjBThsvvS0hXXAbzFTBMUFYTLCXKaG2HQaIIkU2DUDTD9JKOVmjDTg2aECnCjY860vURg4AFZgeaODMXO46jShvMqgOzDNhtaLccsLMmXBuOI3VPKLytw6r434rIRk4oI1asiqykRBYGS3BGXka6GorzYKPEi5hB/3KGobUi8lYVn1JjKlEloNTxrJl44jZvYhYuxeJVssKtJY2by3mkmWIH12Kagfk4r8NxXoZWeT4V4dnkPP1ff9IfXKR3fJ6BmTWeBaI8DqzwNLTBQDjJnA2SBShVx3YaSAq7qqhTYiz1vwingWTLWetfmUuJaUgo1TsAAAAASUVORK5CYII='
        },
        {
        name: 'Browser-Werkzeuge',
        command: "var { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                var { BrowserToolboxLauncher } = require('resource://devtools/client/framework/browser-toolbox/Launcher.sys.mjs');\
                BrowserToolboxLauncher.init();",
        subdir: 'Firefox Funktionen',
        image:'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAIAAACQkWg2AAAACXBIWXMAAA7EAAAOxAGVKw4bAAAAdUlEQVQokZVSwRHAIAgLPYfoXs7RCTpG53Avt7APrhaFU8gLMEEJAkEQgFbc7IxkVjt0r6Sp7VIVITumBpKt00FA2ThmjXzkfMMWO8EZFSj8LrUyjsG9b9DaJXq+qAIVxEUxtLHpaXE95dj1NcK2rmbwaGJ4Af0tIg00j/6iAAAAAElFTkSuQmCC',
        },
        {
        name: 'Web-Entwickler',
        //    command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
        //        require('devtools/client/framework/devtools-browser');\
        //        document.getElementById('menu_devToolbox').click()",          
        //    command: "var { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
        //        var { gDevToolsBrowser } = require('devtools/client/framework/devtools-browser');\
        //        gDevToolsBrowser.toggleToolboxCommand(window.gBrowser, Cu.now());",
        command: "var { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                var { gDevToolsBrowser } = require('resource://devtools/client/framework/devtools-browser');\
                gDevToolsBrowser.toggleToolboxCommand(window.gBrowser, Cu.now());",    
        subdir: 'Firefox Funktionen',
        image: 'data:image/x-icon;base64,AAABAAEAEBAAAAAAAABoBAAAFgAAACgAAAAQAAAAIAAAAAEAIAAAAAAAAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACQAAAB0AAAAzAAAAQgAAAEUAAAA4AAAAIwAAAA0AAAABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEAAAAKgQAIngOFHPPHiGf9hwnsv4aK7H+HCid9BYmiNoNEVGWAAAAOQAAAAkAAAAAAAAAAAAAAAAAAAAAAAAADhISZ4oiJaj4JTfD/yVDzf8lTNP/JU/X/yVT2f8lUNL/HDas/g4bbJsAAAAaAAAAAAAAAAAAAAAAAAAAACAmkVYeKLn+JT7I/yVL0/8lVNr/JVrd/yVf3/8lZuL/JW3k/yVk4P8bT9P+HkXBjAAAAAAAAAAAAAAAABoaaxMeMbXqJT/K/yVN1v8lWN3/JmDf/ytSr/81OWr/M0qL/yZ64/8jiez/JXXh/x9Msv4ITLo/AAAAAAAAAAAiN6B3JT7I/yVN1v8lWd3/JV3d/ytEnv81J1T/SiIe/04iFf9BISL/I6HV/xus7v8hhtn/JVCofAAAAAAAAAAAIEGw0SVL0/8lV9z/JVnb/yZn4P8oct7/Jnjg/ydjt/9RUE3/WCgR/zp3fv8axfb/EMj1/xmC0LQAAAAAAAAAABxKxv0lVNr/Jl/f/ydCyf84WaX/a0AX/3NMHP9lZEf/dUQT/2cyDf9ZNB//Q9j3/ybh/P8ap9X1AAAAAAAAAAAbWM/8JVve/yZm4P8mWNP/Nkh+/3JXLf+aWgv/mFkL/4tNBv+ARQf/bTcH/6Pw+v977v7/Opuz/gB/fwIAAAAAIWHV5SZf4P8ma+H/Jnfk/yOP5/9QZYT/qXAm/7NyHP+qaBX/mVkN/4xPCP+dtKv/lu3+/yOy1uUAAAAAAAAAAB1exJElZeL/Jm7i/yZ+5f8iheD/QHDX/2uAk//DiRP/vH4V/7V0GP+jZRn/rbKa/4js//8AyOONAAAAAAAAAAAdU7JGJVnY/yZw4/8kguX/IJLg/4p4N/+wjhv/0p0F/9GaCf/FiRD/sHkv/8Ts8P+L4/L/DcbnTQAAAAAAAAAAGVnYFB5m3P12eX39coBn/02bp/92i1H/1qYb/+GvIf/cqQz/yJId/8SlaP+539//Za/KtwAAAAAAAAAAAAAAAAAAAAAiguZSv5tRZMKXQPXBkiX/xKU3/+a2Qf/rvEj/5bQ4/9OpQP/XyZ7vkqmnegAAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADkwWkd5cBimOe/X+TswV7+7sNe/um/X+HivWeRzbBOGgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA=='
        },
        {
        name: 'Firefox synchronisieren',
        command: "gSync.openPrefs('menubar');",
        subdir: 'Firefox Funktionen',
        image:'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAACXBIWXMAAA7DAAAOwwHHb6hkAAADcElEQVR4nHVTXWxTZRh+zzntOafn9Gdt3enoz8po2dauMLYat6iom5OpCwMGmswrLjRecAGBkDkTkCtCiDeQaGKCF7vQoBL0gpARJyFTxCDQwqA/6Nba/bU9Xdedru1pe3441Y2MGJ7kTb683/c835PvfT4E1jB66E2zQ2/4WG8wD+KUzmgwvsCwqYWSUC4VVSKXZsz6B6HH8c+OnPslBRuArS8yCzGqu9075vG2tkp8zhwLXieTM0HdcipmSubKlv1793Q1O5kjO1u08nfXo5P/Ezh/bOh0y9bNfdmFx8AmQiBUy4ChKFTxhspAfy9eb9ICRWCow2rqfcOjt34zEb3yVODCSM9Aq8t+vlLioLiSVjoIEFojqEmtfPt+5F5yOkgE7tymljJpqDfqwLmpzv+iiwpfmow/QmsCjYzxKzUiAggFIEkCArH83G+h9JiAGVJ3Zrh9uNpkUxH4udzyMvx6609IZ5Zg21b7F7WbsAuf9HXsaLYdl8QKIDLA71MJ9tufA+2hxeSP2z3t5MXxwJUbIVacCC6N7+5u7K7T0e4iXwUrU6exm/AfVEaafI8kcUVMBgRB4G5k/uzfSWBrzkY+v3hq44trCOKMXke/TRI4rBYqyA6P/SBKooJP2QCNYp3AcQhPZ6/Cc/Aono3ptBTUSo0TgKtU9agoVUVRFoE2bQKDmYF3X201P0+gKsrv6LQ0/FcUZLjSFJpcKl+ORKJA1VlBZ2uHXT0vndxIOjzUNliblt8P6ja3daRGpCgSaJqSI3H2Kpb/IxHydpo/RRAJtTZ3gaO5Y8vwK0z+y+9v3lKI6Ae97gkCFfS9Ps/Z9/v9XprSQKEkQI7jY/tGL5/E4gBSf5ezMfzwfudKJgFN23ZCQ9uu/pHhzuEOO/gseqxn4HXfa2+97LNqaQ1kuRJUBFEOhGc/unQjGkbWE/n10e7p2bk5Z21Em5tcYHe6gZ2bWTVoMK3DYYEtThtwRQHiC1lYzhXGDpz46SD8G7k1WCxAjw75g8nFRffKagkaLPW8BhXIRpsVXC4nJNJFKPIVKFeF8Idnrm1XKMIzf6FQAPnuP8I9iqI5bxNjL/CSSlKRMsej0oNpVszl+TxfFVO5QuVmdDExns9D9RkHa1AxDOOUZdmGYeBCAXHUzoiC9JcS9HklaPMsy8aUnrhOeALXrFu6bGkawwAAAABJRU5ErkJggg=='
        },
        {
        name: 'Zugangsdaten und Passwörter',
        command: "LoginHelper.openPasswordManager(window, { entryPoint: 'mainmenu' })",
        tooltiptext: 'about:logins',
        subdir: 'Firefox Funktionen',
        image:'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwACTowAAk6MAZI9dFgAAAFSSURBVDhPzVG9SgNBGPxmQ4qAZ7SRVKIIom+gIBbaWagIigg2iZVgkc4HER8jiL2dnaAgNqJGU4gaYsIR4w/J3Tq7dwb0vFOwcWCY/b7dmf2TvwKhxsI9zDqUBXKQvCL3s1PuC9UiMYDmSUqJzNlGgAo5z5BTU8QG0NxHOScHTI0mWtLEse7XE5LRt2yNM+RVmckYLJPWbNHCYu9KYxqeFFkNkXOmnRQwHKqFzvmzPNWI7tEzQUNGjcQH+JIJRx/YJi/JJVPgGR2j3wbY+yvJh2UUbQZUcWCGcSdYgwuHx4yC+6Kqdp31xokpIwHcfROP2OFCoMEnE6lTy6jBw4O6UDepIn9kK1j95Ru7ZtPvwKcx7495JX5XM1gRRTfgk1nkCDW16hTqZTuZABtAc5rmN965LWkp4E49ORv1PbviB9g3UNep4CQeUrhXZ781/weIvAOtoWn16DKkRwAAAABJRU5ErkJggg=='
        },
        {
        name: 'Task Manager',
        command: "switchToTabHavingURI('about:processes', true)",
        tooltiptext: 'about:processes',
        subdir: 'Firefox Funktionen',
        image:'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAMWSURBVDhPbZNPbNNWHMe/dprasR23zULGHDIEalnXVV3TFE4ITkiIG2LSxpU/F4TEASEEJ7QjTKBtB6QdBxoCtUg7QOGwCYSEAEFBFNYUUP8GktZJ7Th//Df23jMlbBJf6T372b/P9/l9/R6DTyiX3cclP9uUSaWSaUVJKXFZ+lyWpYQgcHGGgTUxcfu3setn52htB+127zohHTi494wkysMdHdEtHMelu3tkVhR5RKMsbNdEpVLCykoRmUwGenU4PnYdR9sG6XRqdNu20ePT+RnMLU5B01VUVpehEqBUKsCoarAsK2yHDh1BjFeSlKNiaVcolFTLtDH59C7u3BnHk8d/49XMUxTsN7BtMyz8IMOoguP4nrXhe4NafaWoaQZiQhye56HVasFv+XBHXQS+D3+tBUEAXdfJsjoTIU0UGjx6fE03jJopxmS4rhuasAoL8ZUERmLgd/nwFPJc8VD1NGrQ/YENO8+z/aZplUQxjqbcgLvOQRDx0cg3EBviEbABggVSuAhU31EDTiajML/QgKrZtIqC1AVP9WDN2tCmdDi2A40nAb612kvTdY1kEBMJ0km5tkGj0VyWxW44NZcEZ8NxHHJ1oJc1eO5aLiQHmoEgiDzDMALlws+gqhn1oiwnQpgWUoDOGjwks5Ddk83m8M3ACLr6eTKOsnEpJRq15Y8GpmkVeT4Gzw8QjUQwNJRF/1fDGPg6h97eQZTVejA7+6b0enr6/s9Xzt0m8BLl2gb1RrPYIjNe+Okyvlj/JVYrDTTNBhAwWFwo45dfz19UlMw9rlM0dd25TxCPchHaUW1QhmyybXfOzxWej4//ea9/IL15ONvHCYIEkbRs9tutvb2bvhsc7PshmYyPTNy6+jvl2gYv/rmr9vVtX0inld253MieZDLBOQ7579U62WgGeJ4luTit/MzUgyt/XPpxqZAPD1P7NO7Yflg6dfqYlujp6mAjLEhuJHEjqFRUdbWiPpucfP7XjZtjN94VX+ZJees99R8Dcsvs//7kvnWpno3lcqWWz88U5ucnX69qSwXy8v8Hoi3gX7e/eW+7FbGUAAAAAElFTkSuQmCC'
        },
        {
        name: 'Offline arbeiten',
        command: "BrowserOffline.toggleOfflineStatus();",
        subdir: 'Firefox Funktionen',
        image:'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAMUSURBVDhPXZPbS1RRFMa/vfeZ8TSXLiJZY5ZNMmhRBPVUSkUXinzIN+mhC0UvPkRID/UHFET04lOC9BAE0UtUUElXREy7l6Y5k4GXJqecu47OmXNWa5+MogU/9t7r7PXttdbeR+QMBW3CNKFsG0KqIBYHt8uqqiZj9Zo6+9u3uBgd7XqdST8/Ol8cG3Z3/zV1Xkp3IpSCIqo11tVeNXbuOq8aGraJSCQsly3bJIPB5gBhTyKXy/WUSh/cgAX7LUAE6fXuLFu/4Z5qbNwq6us9KCsDsllgfp53KZimWblLykOzuZyv17IeL8RDnRMCkKreXBu+q2prV6a5FBmNQnV3w+nthYjFYKfTSDoOAsWi2CxEw1ihYAza9hMtIAtCBopLl14wTHNFkjP5ePAg3tfU4MeLF0ix0NTQEB6EQuhpbcVYVRUMzqhl0aIzQeCAm8K417t3IhTKWuEwTe3YQZOxGCVtm3ra2mhIKbrd3EyfxsfJIaLJ48cpaprUv2QJNRvGHVdgwO9vH66ooERlJWX8foru3k2JiQmaYZGBri76nkgQOQ5NnjjhCr71+aibOe3xjLkC3X7/o75AgIaDQYqxwCdu6ZvGBppOcUFsNhNtaaF+9r9kgR6vlx4wZwwjo+NlwS6lsqUS0sUiZhjuO74vr+T2Gvo7iElWVyPP4xw3MsdvJc/MEnH3WcC0Sk84XSfDIhnLwtemJqxrb0e5z4f4tWuYS0yh7tIlWGfPIunxIMcieW52ghxLC+CyEOFOpT7f4sOu19XRh9FRt+aBkyfpLvue7dtHP+NxKnAp948coQ72XZSSqgXe63j1FEgFAGONEPutfB6rIhHEOzsx0tHhpp/98gXJwUEEKiowzP7p6Wn0sb+PcIOHh24dXK08KsT1LUSHtUNXr9Fzmykycwy/SYwwN4H+GeAYT4fcP8nhtN6xmhIiVA5s1ifrAM0sU1gY3/GrvQ284uA2Xr5m3EP+NbUWaN0oxKlyoogH8OhOpZgYkOArvsfiV3g5qDdr+1/gj61ktjI1DOu4tzvAvGF0RQsG/AKOw3K+vE21tQAAAABJRU5ErkJggg=='
        },


        // Untermenü Datei

        {
        name: 'Neuer Tab',
        command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                    document.getElementById('menu_newNavigatorTab').click()",                        
        subdir: 'Datei',
        image: "data:image/svg+xml;base64,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",
        },
        {
        name: 'Neues Fenster',
        command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                    document.getElementById('menu_newNavigator').click()",  
        subdir: 'Datei',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljCiAgIC0gTGljZW5zZSwgdi4gMi4wLiBJZiBhIGNvcHkgb2YgdGhlIE1QTCB3YXMgbm90IGRpc3RyaWJ1dGVkIHdpdGggdGhpcwogICAtIGZpbGUsIFlvdSBjYW4gb2J0YWluIG9uZSBhdCBodHRwOi8vbW96aWxsYS5vcmcvTVBMLzIuMC8uIC0tPgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjE2IiBoZWlnaHQ9IjE2IiB2aWV3Qm94PSIwIDAgMTYgMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+CiAgPHBhdGggZD0iTTE1LjUgMTJIMTNWOS41YS41LjUgMCAwIDAtMSAwVjEySDkuNWEuNS41IDAgMCAwIDAgMUgxMnYyLjVhLjUuNSAwIDAgMCAxIDBWMTNoMi41YS41LjUgMCAwIDAgMC0xeiIvPgogIDxwYXRoIGQ9Ik0xNiA0YTMgMyAwIDAgMC0zLTNIM2EzIDMgMCAwIDAtMyAzdjhhMyAzIDAgMCAwIDMgM2g0LjAzdi0uMDA2YS45OTQuOTk0IDAgMCAwIDAtMS45ODdWMTNIM2ExIDEgMCAwIDEtMS0xVjZoMTJ2MS45NTJoLjAxYzAgLjAxNy0uMDEuMDMxLS4wMS4wNDhhMSAxIDAgMCAwIDIgMGMwLS4wMTctLjAwOS0uMDMxLS4wMS0uMDQ4SDE2ek0yIDVWNGExIDEgMCAwIDEgMS0xaDEwYTEgMSAwIDAgMSAxIDF2MXoiLz4KPC9zdmc+Cg==",
        },
        {
        name: 'Neues privates Fenster',
        command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                    document.getElementById('menu_newNavigator').click()",  
        subdir: 'Datei',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmlld0JveD0iMCAwIDE2IDE2IiB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+DQogIDxwYXRoIGQ9Ik0xNS45MzEgNS40NzljLTEuNTI1LTIuMDAxLTQuNTE3LTIuMjU3LTYuMzgxLS41NDVsLTEuMDQzLjk1OC0xLjAyIDAtMS4wNDItLjk1OEM0LjU4MSAzLjIyMyAxLjU4OSAzLjQ3OC4wNjQgNS40NzljLS4xOTcuNzguMTA4IDMuNjYuMjggNC4xMTMuMzQ3IDEuODMgMS44NDIgMy4yMDYgMy42MzUgMy4yMDYuODk1IDAgMS43MDYtLjM1NyAyLjM0Ny0uOTI5bC4zOTEtLjMzNGExLjkzNiAxLjkzNiAwIDAgMSAyLjUxMS0uMDIxbC41ODYuNDg2IDAtLjAwM2MuNjE3LjQ5NyAxLjM3NS44MDEgMi4yMDMuODAxIDEuNzkyIDAgMy4yODgtMS4zNzYgMy42MzUtMy4yMDYuMTcyLS40NTMuNDg4LTMuMzIxLjI3OS00LjExM3pNNi4yMzIgOC40NTJjLS40MjcuNDgyLTEuMDg4Ljc5Mi0xLjgzMi43OTItLjc0NCAwLTEuNDA1LS4zMS0xLjgzMi0uNzkyYS42OTMuNjkzIDAgMCAxIDAtLjkwNWMuNDI3LS40ODIgMS4wODgtLjc5MiAxLjgzMi0uNzkyLjc0NCAwIDEuNDA1LjMxIDEuODMyLjc5MmEuNjkzLjY5MyAwIDAgMSAwIC45MDV6bTcuMiAwYy0uNDI3LjQ4Mi0xLjA4OC43OTItMS44MzIuNzkyLS43NDQgMC0xLjQwNS0uMzEtMS44MzItLjc5MmEuNjkzLjY5MyAwIDAgMSAwLS45MDVjLjQyNy0uNDgyIDEuMDg4LS43OTIgMS44MzItLjc5Mi43NDQgMCAxLjQwNS4zMSAxLjgzMi43OTJhLjY5My42OTMgMCAwIDEgMCAuOTA1eiIvPg0KPC9zdmc+",
        },
        {
        name: 'Datei öffnen…',
        command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                document.getElementById('menu_openFile').click()",  
        subdir: 'Datei',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjE2IiBoZWlnaHQ9IjE2IiB2aWV3Qm94PSIwIDAgMTYgMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+DQogIDxwYXRoIGQ9Ik0xNC44NTkgMy4yYTEuMzM1IDEuMzM1IDAgMCAxLTEuMjE3LjhIMTN2MWgxdjhIMlY1aDhWNGgtLjY0MmExLjM2NSAxLjM2NSAwIDAgMS0xLjMyNS0xLjExTDYuNTg0IDEuNTM4QTIgMiAwIDAgMCA1LjIxOSAxSDJhMiAyIDAgMCAwLTIgMnYxMGEyIDIgMCAwIDAgMiAyaDEyYTIgMiAwIDAgMCAyLTJWNWEyIDIgMCAwIDAtMS4xNDEtMS44ek0yIDNoMy4yMTlsMS4wNzIgMUgyem03Ljg1NC0uMTQ2TDExIDEuNzA3VjguNWEuNS41IDAgMCAwIDEgMFYxLjcwN2wxLjE0NiAxLjE0NmEuNS41IDAgMSAwIC43MDctLjcwN2wtMi0yYS41LjUgMCAwIDAtLjcwNyAwbC0yIDJhLjUuNSAwIDAgMCAuNzA3LjcwN3oiLz4NCjwvc3ZnPg==",
        },
        {
        name: 'separator',
        subdir: 'Datei'
        },   
        {
        name: 'Seite speichern unter…',
        command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                document.getElementById('menu_savePage').click()",                        
        subdir: 'Datei',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjE2IiBoZWlnaHQ9IjE2IiB2aWV3Qm94PSIwIDAgMTYgMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+DQogIDxwYXRoIGQ9Ik0xNCAzaC0ydjJoMnY4SDJWNWg3VjNoLS44NDlMNi41ODQgMS41MzhBMiAyIDAgMCAwIDUuMjE5IDFIMmEyIDIgMCAwIDAtMiAydjEwYTIgMiAwIDAgMCAyIDJoMTJhMiAyIDAgMCAwIDItMlY1YTIgMiAwIDAgMC0yLTJ6TTIgM2gzLjIxOWwxLjA3MiAxSDJ6Ii8+DQogIDxwYXRoIGQ9Ik04LjE0NiA2LjE0NmEuNS41IDAgMCAwIDAgLjcwN2wyIDJhLjUuNSAwIDAgMCAuNzA3IDBsMi0yYS41LjUgMCAxIDAtLjcwNy0uNzA3TDExIDcuMjkzVi41YS41LjUgMCAwIDAtMSAwdjYuNzkzTDguODU0IDYuMTQ2YS41LjUgMCAwIDAtLjcwOCAweiIvPg0KPC9zdmc+",
        },
        {
        name: 'Link per E-Mail senden…',
        command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                document.getElementById('menu_sendLink').click()",  
        subdir: 'Datei',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjE2IiBoZWlnaHQ9IjE2IiB2aWV3Qm94PSIwIDAgMTYgMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+DQogIDxwYXRoIGQ9Ik0xMyAySDNhMy4wMTMgMy4wMTMgMCAwIDAtMyAzdjZhMy4wMTMgMy4wMTMgMCAwIDAgMyAzaDEwYTMuMDEzIDMuMDEzIDAgMCAwIDMtM1Y1YTMuMDEzIDMuMDEzIDAgMCAwLTMtM3ptMSA5YTEgMSAwIDAgMS0xIDFIM2ExIDEgMCAwIDEtMS0xVjVhMSAxIDAgMCAxIDEtMWgxMGExIDEgMCAwIDEgMSAxeiIvPg0KICA8cGF0aCBkPSJNOCA5YS41LjUgMCAwIDEtLjI5NC0uMWwtNS41LTRhLjUuNSAwIDEgMSAuNTg4LS44TDggNy44ODIgMTMuMjA3IDQuMWEuNS41IDAgMCAxIC41ODguODA5bC01LjUgNEEuNS41IDAgMCAxIDggOXoiLz4NCjwvc3ZnPg==",
        },
        {
        name: 'separator',
        subdir: 'Datei'
        },          
        {
        name: 'Drucken…',
        command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                document.getElementById('menu_print').click()",  
        subdir: 'Datei',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljCiAgIC0gTGljZW5zZSwgdi4gMi4wLiBJZiBhIGNvcHkgb2YgdGhlIE1QTCB3YXMgbm90IGRpc3RyaWJ1dGVkIHdpdGggdGhpcwogICAtIGZpbGUsIFlvdSBjYW4gb2J0YWluIG9uZSBhdCBodHRwOi8vbW96aWxsYS5vcmcvTVBMLzIuMC8uIC0tPgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjE2IiBoZWlnaHQ9IjE2IiB2aWV3Qm94PSIwIDAgMTYgMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+CjxwYXRoIGQ9Ik0xNCA1aC0xVjFhMSAxIDAgMCAwLTEtMUg0YTEgMSAwIDAgMC0xIDF2NEgyYTIgMiAwIDAgMC0yIDJ2NWgzdjNhMSAxIDAgMCAwIDEgMWg4YTEgMSAwIDAgMCAxLTF2LTNoM1Y3YTIgMiAwIDAgMC0yLTJ6TTIuNSA4YS41LjUgMCAxIDEgLjUtLjUuNS41IDAgMCAxLS41LjV6bTkuNSA3SDR2LTVoOHptMC0xMEg0VjFoOHptLTYuNSA3aDRhLjUuNSAwIDAgMCAwLTFoLTRhLjUuNSAwIDEgMCAwIDF6bTAgMmg1YS41LjUgMCAwIDAgMC0xaC01YS41LjUgMCAxIDAgMCAxeiI+PC9wYXRoPjwvc3ZnPg==",
        },
        {
        name: 'separator',
        subdir: 'Datei'
        },  
        {
        name: 'Daten aus einem anderen Browser importieren…',
        command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                document.getElementById('menu_importFromAnotherBrowser').click()",  
        subdir: 'Datei',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmlld0JveD0iMCAwIDE2IDE2IiB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+DQogIDxwYXRoIGQ9Ik00Ljc1IDEyYTIgMiAwIDAgMCAyIDJMMTMgMTRhMiAyIDAgMCAwIDItMmwwLThhMiAyIDAgMCAwLTItMkw2Ljc1IDJhMiAyIDAgMCAwLTIgMmwwIDEuMzc1YS42MjUuNjI1IDAgMCAwIDEuMjUgMEw2IDMuODVsLjYtLjYgNi41NSAwIC42LjYgMCA4LjMtLjYuNi02LjU1IDAtLjYtLjYgMC0xLjIxMmEuNjI1LjYyNSAwIDAgMC0xLjI1IDBsMCAxLjA2MnoiLz4NCiAgPHBhdGggZD0iTTEuMjczIDguOGEuNjI1LjYyNSAwIDAgMSAwLTEuMjVsNi43MjUtLjAwNSAwLTIuMDU2YS41LjUgMCAwIDEgLjg1NC0uMzU0bDIuODIzIDIuODIzIDAgLjQyNC0yLjgyMyAyLjgyM2EuNS41IDAgMCAxLS44NTQtLjM1NGwwLTIuMDU2LTYuNzI1LjAwNXoiLz4NCjwvc3ZnPg==",
        },
        {
        name: 'separator',
        subdir: 'Datei'
        },  
        {
        name: 'Offline arbeiten',
        command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                document.getElementById('goOfflineMenuitem').click()",  
        subdir: 'Datei',
        image: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxNiIgaGVpZ2h0PSIxNiIgdmlld0JveD0iMCAwIDE2IDE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPgogIDxwYXRoIGQ9Ik0xNS44NTQuMTQ2YS41LjUgMCAwIDEgMCAuNzA4bC0xLjY2OCAxLjY2OGE0LjAzOSA0LjAzOSAwIDAgMS0uMzMyIDUuMzMxbC0uMy4zLS4wMDMuMDAzLS4zMDguMzA5YTEuMDUgMS4wNSAwIDAgMS0xLjQ4NSAwTDcuNTM1IDQuMjQyYTEuMDUgMS4wNSAwIDAgMSAwLTEuNDg1bC42MTItLjYxYTQuMDM2IDQuMDM2IDAgMCAxIDUuMzMxLS4zMzJMMTUuMTQ2LjE0NmEuNS41IDAgMCAxIC43MDggMHpNMTMuMTQgMi44NDdhMy4wMzcgMy4wMzcgMCAwIDAtNC4yODYuMDA2bC0uMy4zYS40OS40OSAwIDAgMCAwIC42OTNsMy42IDMuNmMuMTkuMTkxLjUuMTkyLjY5MS4wMDJsLjAwMi0uMDAyLjMtLjNhMy4wMzYgMy4wMzYgMCAwIDAgLjAwNi00LjI4NmwtLjAwNy0uMDA2em0tNS43ODYgMy44YS41LjUgMCAwIDEgMCAuNzA3TDUuNzA3IDkgNyAxMC4yOTNsMS42NDYtMS42NDdhLjUuNSAwIDAgMSAuNzA4LjcwOEw3LjcwNyAxMWwuNDQ3LjQ0N2ExLjQ5IDEuNDkgMCAwIDEgMCAyLjEwN2wtLjMuM2E0LjAzNiA0LjAzNiAwIDAgMS01LjMzMi4zMzJMLjg1NCAxNS44NTRhLjUuNSAwIDAgMS0uNzA4LS43MDhsMS42NjktMS42NjhhNC4wMzYgNC4wMzYgMCAwIDEgLjMzMS01LjMzMWwuMy0uM2ExLjQ5IDEuNDkgMCAwIDEgMi4xMDggMEw1IDguMjkzbDEuNjQ2LTEuNjQ3YS41LjUgMCAwIDEgLjcwOCAwem0tNC40OTUgNi41MDVhMy4wMzYgMy4wMzYgMCAwIDAgNC4yODctLjAwNWwuMy0uM2EuNDkuNDkgMCAwIDAgMC0uNjkzbC0zLjYtMy42YS40OS40OSAwIDAgMC0uNjkyIDBsLS4zLjNhMy4wMzYgMy4wMzYgMCAwIDAgMCA0LjI5MmwuMDA1LjAwNnoiLz4KPC9zdmc+Cg==",
        },
        {
        name: 'Beenden',
        command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                document.getElementById('menu_FileQuitItem').click()",  
        subdir: 'Datei',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljCiAgIC0gTGljZW5zZSwgdi4gMi4wLiBJZiBhIGNvcHkgb2YgdGhlIE1QTCB3YXMgbm90IGRpc3RyaWJ1dGVkIHdpdGggdGhpcwogICAtIGZpbGUsIFlvdSBjYW4gb2J0YWluIG9uZSBhdCBodHRwOi8vbW96aWxsYS5vcmcvTVBMLzIuMC8uIC0tPgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjE2IiBoZWlnaHQ9IjE2IiB2aWV3Qm94PSIwIDAgMTYgMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+CiAgPHBhdGggZD0iTTggNmExIDEgMCAwIDAgMS0xVjFhMSAxIDAgMCAwLTIgMHY0YTEgMSAwIDAgMCAxIDF6bTMuNS00LjAzMmExIDEgMCAwIDAtMSAxLjczMkE0Ljk0NiA0Ljk0NiAwIDAgMSAxMyA4IDUgNSAwIDAgMSAzIDhhNC45NDYgNC45NDYgMCAwIDEgMi41LTQuMyAxIDEgMCAwIDAtMS0xLjczMiA3IDcgMCAxIDAgNy4wMDYgMHoiLz4KPC9zdmc+Cg==",
        },

        // Untermenü Bearbeiten

        {
        name: 'Rückgängig',
        command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                document.getElementById('menu_undo').click()",                        
        subdir: 'Bearbeiten',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmlld0JveD0iMCAwIDE2IDE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KICA8cGF0aCBkPSJNMTYsMTEgQzE2LDExLjU1MjI4NDcgMTUuNTUyMjg0NywxMiAxNSwxMiBDMTQuNDQ3NzE1MywxMiAxNCwxMS41NTIyODQ3IDE0LDExIEMxNCw4LjIzODU3NjI1IDExLjc2MTQyMzcsNiA5LDYgQzYuOTQ5NjgwOTYsNiA1LjE4NzYwMDMxLDcuMjM0MDk1MjIgNC40MTYwNDM2OSw5IEw3LjAwNDMzMjYsOSBDNy41NTY2MTczNCw5IDguMDA0MzMyNiw5LjQ0NzcxNTI1IDguMDA0MzMyNiwxMCBDOC4wMDQzMzI2LDEwLjU1MjI4NDcgNy41NTY2MTczNCwxMSA3LjAwNDMzMjYsMTEgTDIsMTEgQzEuNDQ3NzE1MjUsMTEgMSwxMC41NTIyODQ3IDEsMTAgTDEsNSBDMSw0LjQ0NzcxNTI1IDEuNDQ3NzE1MjUsNCAyLDQgQzIuNTUyMjg0NzUsNCAzLDQuNDQ3NzE1MjUgMyw1IEwzLDcuMzkyNDEzMzkgQzQuMjI0ODk3MTUsNS4zNTk1ODIxNyA2LjQ1MzY3NDg2LDQgOSw0IEMxMi44NjU5OTMyLDQgMTYsNy4xMzQwMDY3NSAxNiwxMSBaIi8+DQo8L3N2Zz4=",
        },
        {
        name: 'Wiederherstellen',
        command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                document.getElementById('menu_redo').click()",  
        subdir: 'Bearbeiten',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljCiAgIC0gTGljZW5zZSwgdi4gMi4wLiBJZiBhIGNvcHkgb2YgdGhlIE1QTCB3YXMgbm90IGRpc3RyaWJ1dGVkIHdpdGggdGhpcwogICAtIGZpbGUsIFlvdSBjYW4gb2J0YWluIG9uZSBhdCBodHRwOi8vbW96aWxsYS5vcmcvTVBMLzIuMC8uIC0tPgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjE2IiBoZWlnaHQ9IjE2IiB2aWV3Qm94PSIwIDAgMTYgMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+CiAgPHBhdGggZD0iTTE0IDFhMSAxIDAgMCAwLTEgMXYxLjE0NkE2Ljk0OCA2Ljk0OCAwIDAgMCAxLjIyNyA2LjMwN2ExIDEgMCAxIDAgMS45NC40ODRBNC45ODMgNC45ODMgMCAwIDEgOCAzYTQuOTE5IDQuOTE5IDAgMCAxIDMuOTY3IDJIMTBhMSAxIDAgMCAwIDAgMmg0YTEgMSAwIDAgMCAxLTFWMmExIDEgMCAwIDAtMS0xem0uMDQ2IDcuNDgxYTEgMSAwIDAgMC0xLjIxMy43MjhBNC45ODMgNC45ODMgMCAwIDEgOCAxM2E0LjkxOSA0LjkxOSAwIDAgMS0zLjk2Ny0ySDZhMSAxIDAgMCAwIDAtMkgyYTEgMSAwIDAgMC0xIDF2NGExIDEgMCAwIDAgMiAwdi0xLjE0NmE2Ljk0OCA2Ljk0OCAwIDAgMCAxMS43NzMtMy4xNjEgMSAxIDAgMCAwLS43MjctMS4yMTJ6Ii8+Cjwvc3ZnPgo=",
        },
        {
        name: 'separator',
        subdir: 'Bearbeiten'
        },
        {
        name: 'Ausschneiden',
        command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                document.getElementById('menu_cut').click()",  
        subdir: 'Bearbeiten',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjE2IiBoZWlnaHQ9IjE2IiB2aWV3Qm94PSIwIDAgMTYgMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+DQogIDxwYXRoIGQ9Ik0xMS41IDEwYTIuNDgxIDIuNDgxIDAgMCAwLS4zNzkuMDM4TDMuOTc3IDEuMjE0YTIuNSAyLjUgMCAwIDAtLjM3MSAzLjUxNWwyLjc4OSAzLjQ0NC0xLjUxIDEuODY2QTIuNDg2IDIuNDg2IDAgMCAwIDQuNSAxMGEyLjUyMiAyLjUyMiAwIDEgMCAyLjMyOSAxLjYwOUw4IDEwLjE1OSA5LjE3MiAxMS42QTIuNSAyLjUgMCAxIDAgMTEuNSAxMHptLTcgMy43NWExLjI1IDEuMjUgMCAxIDEgMS4yNS0xLjI1IDEuMjUxIDEuMjUxIDAgMCAxLTEuMjUgMS4yNXptNyAwYTEuMjUgMS4yNSAwIDEgMSAxLjI1LTEuMjUgMS4yNTEgMS4yNTEgMCAwIDEtMS4yNSAxLjI1em0uOS05LjAyMWEyLjUgMi41IDAgMCAwLS4zNzEtMy41MTVMOC41IDUuNTY5bDEuNjA4IDEuOTg2eiIvPg0KPC9zdmc+",
        },   
        {
        name: 'Kopieren',
        command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                document.getElementById('menu_copy').click()",                        
        subdir: 'Bearbeiten',
        image: "data:image/svg+xml;base64,PCEtLSEgRm9udCBBd2Vzb21lIEZyZWUgNi4zLjAgYnkgQGZvbnRhd2Vzb21lIA0KICAgLSBodHRwczovL2ZvbnRhd2Vzb21lLmNvbSBMaWNlbnNlIA0KICAgLSBodHRwczovL2ZvbnRhd2Vzb21lLmNvbS9saWNlbnNlL2ZyZWUgKEljb25zOiBDQyBCWSA0LjAsIEZvbnRzOiBTSUwgT0ZMIDEuMSwgQ29kZTogTUlUIExpY2Vuc2UpIA0KICAgICBDb3B5cmlnaHQgMjAyMyBGb250aWNvbnMsIEluYy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmlld0JveD0iMCAwIDUxMiA1MTIiIGZpbGw9ImNvbnRleHQtZmlsbCI+DQo8cGF0aCBkPSJNMjI0IDBjLTM1LjMgMC02NCAyOC43LTY0IDY0VjI4OGMwIDM1LjMgMjguNyA2NCA2NCA2NEg0NDhjMzUuMyAwIDY0LTI4LjcgNjQtNjRWNjRjMC0zNS4zLTI4LjctNjQtNjQtNjRIMjI0ek02NCAxNjBjLTM1LjMgMC02NCAyOC43LTY0IDY0VjQ0OGMwIDM1LjMgMjguNyA2NCA2NCA2NEgyODhjMzUuMyAwIDY0LTI4LjcgNjQtNjRWMzg0SDI4OHY2NEg2NFYyMjRoNjRWMTYwSDY0eiIvPg0KPC9zdmc+",
        },
        {
        name: 'Einfügen',
        command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                document.getElementById('key_paste').click()",  
        subdir: 'Bearbeiten',
        image: "data:image/svg+xml;base64,PCEtLSEgRm9udCBBd2Vzb21lIEZyZWUgNi4zLjAgYnkgQGZvbnRhd2Vzb21lIA0KICAgLSBodHRwczovL2ZvbnRhd2Vzb21lLmNvbSBMaWNlbnNlIA0KICAgLSBodHRwczovL2ZvbnRhd2Vzb21lLmNvbS9saWNlbnNlL2ZyZWUgKEljb25zOiBDQyBCWSA0LjAsIEZvbnRzOiBTSUwgT0ZMIDEuMSwgQ29kZTogTUlUIExpY2Vuc2UpIA0KICAgICBDb3B5cmlnaHQgMjAyMyBGb250aWNvbnMsIEluYy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmlld0JveD0iMCAwIDUxMiA1MTIiIGZpbGw9ImNvbnRleHQtZmlsbCI+DQo8cGF0aCBkPSJNODAgOTZ2MTZjMCAxNy43IDE0LjMgMzIgMzIgMzJoNjAuOGMxNi42LTI4LjcgNDcuNi00OCA4My4yLTQ4aDYyYy03LjEtMjcuNi0zMi4yLTQ4LTYyLTQ4SDIxNS40QzIxMS42IDIwLjkgMTg4LjIgMCAxNjAgMHMtNTEuNiAyMC45LTU1LjQgNDhINjRDMjguNyA0OCAwIDc2LjcgMCAxMTJWMzg0YzAgMzUuMyAyOC43IDY0IDY0IDY0aDk2VjQwMEg2NGMtOC44IDAtMTYtNy4yLTE2LTE2VjExMmMwLTguOCA3LjItMTYgMTYtMTZIODB6bTY0LTQwYTE2IDE2IDAgMSAxIDMyIDAgMTYgMTYgMCAxIDEgLTMyIDB6TTI1NiA0NjRjLTguOCAwLTE2LTcuMi0xNi0xNlYxOTJjMC04LjggNy4yLTE2IDE2LTE2SDM4NHY0OGMwIDE3LjcgMTQuMyAzMiAzMiAzMmg0OFY0NDhjMCA4LjgtNy4yIDE2LTE2IDE2SDI1NnptMTkyIDQ4YzM1LjMgMCA2NC0yOC43IDY0LTY0VjIyNy45YzAtMTIuNy01LjEtMjQuOS0xNC4xLTMzLjlsLTUxLjktNTEuOWMtOS05LTIxLjItMTQuMS0zMy45LTE0LjFIMjU2Yy0zNS4zIDAtNjQgMjguNy02NCA2NFY0NDhjMCAzNS4zIDI4LjcgNjQgNjQgNjRINDQ4eiIvPjwvc3ZnPg0K",
        },        
        {
        name: 'Löschen',
        command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                document.getElementById('menu_delete').click()",                        
        subdir: 'Bearbeiten',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljCiAgIC0gTGljZW5zZSwgdi4gMi4wLiBJZiBhIGNvcHkgb2YgdGhlIE1QTCB3YXMgbm90IGRpc3RyaWJ1dGVkIHdpdGggdGhpcwogICAtIGZpbGUsIFlvdSBjYW4gb2J0YWluIG9uZSBhdCBodHRwOi8vbW96aWxsYS5vcmcvTVBMLzIuMC8uIC0tPgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjE2IiBoZWlnaHQ9IjE2IiB2aWV3Qm94PSIwIDAgMTYgMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+CiAgPHBhdGggZD0iTTUuNSAxMmEuNS41IDAgMCAwIC41LS41di02YS41LjUgMCAxIDAtMSAwdjZhLjUuNSAwIDAgMCAuNS41em0yIDBhLjUuNSAwIDAgMCAuNS0uNXYtNmEuNS41IDAgMSAwLTEgMHY2YS41LjUgMCAwIDAgLjUuNXptMiAwYS41LjUgMCAwIDAgLjUtLjV2LTZhLjUuNSAwIDEgMC0xIDB2NmEuNS41IDAgMCAwIC41LjV6TTEzIDJIOS45NWEyLjUgMi41IDAgMCAwLTQuOSAwSDJhMSAxIDAgMCAwIDAgMnY5YTMgMyAwIDAgMCAzIDNoNWEzIDMgMCAwIDAgMy0zVjRhMSAxIDAgMSAwIDAtMnpNNy41IDFhMS40OSAxLjQ5IDAgMCAxIDEuNCAxSDYuMWExLjQ5IDEuNDkgMCAwIDEgMS40LTF6TTExIDEzYTEgMSAwIDAgMS0xIDFINWExIDEgMCAwIDEtMS0xVjRoN3Y5eiIvPgo8L3N2Zz4K",
        },
        {
        name: 'separator',
        subdir: 'Bearbeiten'
        }, 
        {
        name: 'Alles auswählen',
        command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                document.getElementById('menu_selectAll').click()",  
        subdir: 'Bearbeiten',
        image: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxNiIgaGVpZ2h0PSIxNiIgdmlld0JveD0iMCAwIDE2IDE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPgogIDxwYXRoIGQ9Ik0xNC4zNzIgMy4yMkExLjY4OSAxLjY4OSAwIDAgMSAxNS41IDQuODEzdjcuNWEzLjE4NyAzLjE4NyAwIDAgMS0zLjE4NyAzLjE4N2gtNy41YTEuNjg5IDEuNjg5IDAgMCAxLTEuNTkzLTEuMTI4bDEuNTczLjAwM2g3LjUyYTIuMDYyIDIuMDYyIDAgMCAwIDIuMDYyLTIuMDYyVjQuODEybC0uMDAzLS4wMzhWMy4yMlpNMTEuOTM1LjVjLjkzMiAwIDEuNjg4Ljc1NiAxLjY4OCAxLjY4OHY5Ljc0N2MwIC45MzItLjc1NiAxLjY4OC0xLjY4OCAxLjY4OEgyLjE4OEExLjY4OCAxLjY4OCAwIDAgMSAuNSAxMS45MzVWMi4xODhDLjUgMS4yNTYgMS4yNTYuNSAyLjE4OC41aDkuNzQ3Wm0wIDEuMTI1SDIuMTg4YS41NjMuNTYzIDAgMCAwLS41NjMuNTYzdjkuNzQ3YzAgLjMxMS4yNTIuNTYzLjU2My41NjNoOS43NDdhLjU2My41NjMgMCAwIDAgLjU2My0uNTYzVjIuMTg4YS41NjMuNTYzIDAgMCAwLS41NjMtLjU2M1pNNi4xODYgNy41MTlsMi45MTYtMi45MTdhLjU2My41NjMgMCAwIDEgLjg1LjczM2wtLjA1NC4wNjMtMy4zNzUgMy4zNzVhLjU2My41NjMgMCAwIDEtLjc5My4wMDNsLS4wNTUtLjA2My0xLjEyNS0xLjVhLjU2My41NjMgMCAwIDEgLjg0NS0uNzM4bC4wNTUuMDYzLjczNi45ODEgMi45MTYtMi45MTctMi45MTYgMi45MTdaIi8+Cjwvc3ZnPg==",
        },
        {
        name: 'separator',
        subdir: 'Bearbeiten'
        }, 
        {
        name: 'Seite durchsuchen…',
        command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                document.getElementById('menu_find').click()",  
            subdir: 'Bearbeiten',
            image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljCiAgIC0gTGljZW5zZSwgdi4gMi4wLiBJZiBhIGNvcHkgb2YgdGhlIE1QTCB3YXMgbm90IGRpc3RyaWJ1dGVkIHdpdGggdGhpcwogICAtIGZpbGUsIFlvdSBjYW4gb2J0YWluIG9uZSBhdCBodHRwOi8vbW96aWxsYS5vcmcvTVBMLzIuMC8uIC0tPgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmlld0JveD0iMCAwIDE2IDE2IiB3aWR0aD0iMTYiIGhlaWdodD0iMTYiPgogIDxwYXRoIGZpbGw9ImNvbnRleHQtZmlsbCIgZD0iTTE1LjcwNyAxNC4yOTNsLTUtNS0xLjQxNCAxLjQxNCA1IDVhMSAxIDAgMCAwIDEuNDE0LTEuNDE0eiIvPgogIDxwYXRoIGZpbGw9ImNvbnRleHQtZmlsbCIgZmlsbC1ydWxlPSJldmVub2RkIiBkPSJNNiAxMGE0IDQgMCAxIDAgMC04IDQgNCAwIDAgMCAwIDh6bTAgMkE2IDYgMCAxIDAgNiAwYTYgNiAwIDAgMCAwIDEyeiIvPgo8L3N2Zz4K",
        },
        {
        name: 'Weitersuchen',
        command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                document.getElementById('menu_findAgain').click()",  
        subdir: 'Bearbeiten',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljCiAgIC0gTGljZW5zZSwgdi4gMi4wLiBJZiBhIGNvcHkgb2YgdGhlIE1QTCB3YXMgbm90IGRpc3RyaWJ1dGVkIHdpdGggdGhpcwogICAtIGZpbGUsIFlvdSBjYW4gb2J0YWluIG9uZSBhdCBodHRwOi8vbW96aWxsYS5vcmcvTVBMLzIuMC8uIC0tPgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmlld0JveD0iMCAwIDE2IDE2IiB3aWR0aD0iMTYiIGhlaWdodD0iMTYiPgogIDxwYXRoIGZpbGw9ImNvbnRleHQtZmlsbCIgZD0iTTE1LjcwNyAxNC4yOTNsLTUtNS0xLjQxNCAxLjQxNCA1IDVhMSAxIDAgMCAwIDEuNDE0LTEuNDE0eiIvPgogIDxwYXRoIGZpbGw9ImNvbnRleHQtZmlsbCIgZmlsbC1ydWxlPSJldmVub2RkIiBkPSJNNiAxMGE0IDQgMCAxIDAgMC04IDQgNCAwIDAgMCAwIDh6bTAgMkE2IDYgMCAxIDAgNiAwYTYgNiAwIDAgMCAwIDEyeiIvPgo8L3N2Zz4K",
        },


        // Untermenü Extras
        {
        name: 'Downloads',
        command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                document.getElementById('menu_openDownloads').click()",                        
        subdir: 'Extras',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmlld0JveD0iMCAwIDE2IDE2IiB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+DQogIDxwYXRoIGQ9Ik04LjI1LjYyNWEuNjI1LjYyNSAwIDAgMC0xLjI1IDBsMCA4LjMyMy0zLjMwOC0zLjMwOWEuNjI2LjYyNiAwIDAgMC0uODg1Ljg4NUw3LjI4NSAxMWwuNjgxIDAgNC40NzctNC40NzZhLjYyNi42MjYgMCAwIDAtLjg4NS0uODg1TDguMjUgOC45NDdsMC04LjMyMnoiLz4NCiAgPHBhdGggZD0iTTEyLjI1IDE1YTIgMiAwIDAgMCAyLTJsMC0xLjM3NWEuNjI1LjYyNSAwIDAgMC0xLjI1IDBsMCAxLjUyNS0uNi42LTkuNTUgMC0uNi0uNiAwLTEuNTI1YS42MjUuNjI1IDAgMCAwLTEuMjUgMEwxIDEzYTIgMiAwIDAgMCAyIDJsOS4yNSAweiIvPg0KPC9zdmc+",
        },
        {
        name: 'Add-ons und Themes',
        command: "BrowserAddonUI.openAddonsMgr();",
        subdir: 'Extras',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjE2IiBoZWlnaHQ9IjE2IiB2aWV3Qm94PSIwIDAgMTYgMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+DQogIDxwYXRoIGQ9Ik0xNC41IDhjLS45NzEgMC0xIDEtMS43NSAxYS43NjUuNzY1IDAgMCAxLS43NS0uNzVWNWExIDEgMCAwIDAtMS0xSDcuNzVBLjc2NS43NjUgMCAwIDEgNyAzLjI1YzAtLjc1IDEtLjc3OSAxLTEuNzVDOCAuNjM1IDcuMSAwIDYgMFM0IC42MzUgNCAxLjVjMCAuOTcxIDEgMSAxIDEuNzVhLjc2NS43NjUgMCAwIDEtLjc1Ljc1SDFhMSAxIDAgMCAwLTEgMXYyLjI1QS43NjUuNzY1IDAgMCAwIC43NSA4Yy43NSAwIC43NzktMSAxLjc1LTFDMy4zNjUgNyA0IDcuOSA0IDlzLS42MzUgMi0xLjUgMmMtLjk3MSAwLTEtMS0xLjc1LTFhLjc2NS43NjUgMCAwIDAtLjc1Ljc1VjE1YTEgMSAwIDAgMCAxIDFoMy4yNWEuNzY1Ljc2NSAwIDAgMCAuNzUtLjc1YzAtLjc1LTEtLjc3OS0xLTEuNzUgMC0uODY1LjktMS41IDItMS41czIgLjYzNSAyIDEuNWMwIC45NzEtMSAxLTEgMS43NWEuNzY1Ljc2NSAwIDAgMCAuNzUuNzVIMTFhMSAxIDAgMCAwIDEtMXYtMy4yNWEuNzY1Ljc2NSAwIDAgMSAuNzUtLjc1Yy43NSAwIC43NzkgMSAxLjc1IDEgLjg2NSAwIDEuNS0uOSAxLjUtMnMtLjYzNS0yLTEuNS0yeiIvPg0KPC9zdmc+",
        },
        {
        name: 'Anmelden',
        command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                document.getElementById('sync-setup').click()",
        subdir: 'Extras',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmlld0JveD0iMCAwIDE2IDE2IiB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+DQogIDxwYXRoIGQ9Ik04LjUgMTMuMjVjMS45MTIgMCAzLjU3MS0xLjAzOCA0LjQ4OS0yLjU2OUExLjk5MyAxLjk5MyAwIDAgMCAxMS40OTUgMTBsLTUuOTkgMGMtLjU5NiAwLTEuMTI2LjI2Ny0xLjQ5NC42ODEuOTE4IDEuNTMxIDIuNTc3IDIuNTY5IDQuNDg5IDIuNTY5eiIvPg0KICA8cGF0aCBkPSJNOC41IDRhMi41IDIuNSAwIDEgMCAwIDUgMi41IDIuNSAwIDAgMCAwLTV6Ii8+DQogIDxwYXRoIGQ9Ik04LjUgMi4yNWMzLjQ0NiAwIDYuMjUgMi44MDQgNi4yNSA2LjI1cy0yLjgwNCA2LjI1LTYuMjUgNi4yNS02LjI1LTIuODA0LTYuMjUtNi4yNVM1LjA1NCAyLjI1IDguNSAyLjI1TTguNSAxYTcuNSA3LjUgMCAxIDAgMCAxNSA3LjUgNy41IDAgMCAwIDAtMTV6Ii8+DQo8L3N2Zz4=",
        },
        {
        name: 'separator',
        subdir: 'Extras',
        },
        {
        name: 'Weitere Werkzeuge',
        subdir: 'Extras',
        image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg==',
        submenu: [
                {
                name: 'Web-Entwickler',
                command: "var { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                        var { gDevToolsBrowser } = require('resource://devtools/client/framework/devtools-browser');\
                        gDevToolsBrowser.toggleToolboxCommand(window.gBrowser, Cu.now());",    
                subdir: 'Weitere Werkzeuge',
                image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljCiAgIC0gTGljZW5zZSwgdi4gMi4wLiBJZiBhIGNvcHkgb2YgdGhlIE1QTCB3YXMgbm90IGRpc3RyaWJ1dGVkIHdpdGggdGhpcwogICAtIGZpbGUsIFlvdSBjYW4gb2J0YWluIG9uZSBhdCBodHRwOi8vbW96aWxsYS5vcmcvTVBMLzIuMC8uIC0tPgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjE2IiBoZWlnaHQ9IjE2IiB2aWV3Qm94PSIwIDAgMTYgMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+CiAgPHBhdGggZD0iTTE0LjU1NSAzLjJsLTIuNDM0IDIuNDM2YTEuMjQzIDEuMjQzIDAgMSAxLTEuNzU3LTEuNzU3TDEyLjggMS40NDVBMy45NTYgMy45NTYgMCAwIDAgMTEgMWEzLjk3NiAzLjk3NiAwIDAgMC0zLjQzNCA2LjAybC02LjI3MyA2LjI3M2ExIDEgMCAxIDAgMS40MTQgMS40MTRMOC45OCA4LjQzNEEzLjk2IDMuOTYgMCAwIDAgMTEgOWE0IDQgMCAwIDAgNC00IDMuOTU2IDMuOTU2IDAgMCAwLS40NDUtMS44eiIvPgo8L3N2Zz4=",
                },                
                {
                name: 'Task-Manager',
                command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                        document.getElementById('menu_taskManager').click()",                        
                subdir: 'Weitere Werkzeuge',
                image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljCiAgIC0gTGljZW5zZSwgdi4gMi4wLiBJZiBhIGNvcHkgb2YgdGhlIE1QTCB3YXMgbm90IGRpc3RyaWJ1dGVkIHdpdGggdGhpcwogICAtIGZpbGUsIFlvdSBjYW4gb2J0YWluIG9uZSBhdCBodHRwOi8vbW96aWxsYS5vcmcvTVBMLzIuMC8uIC0tPgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjE2IiBoZWlnaHQ9IjE2IiB2aWV3Qm94PSIwIDAgMTYgMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+CiAgPHBhdGggZD0iTTggMWE4IDggMCAwIDAtOCA4IDcuODkgNy44OSAwIDAgMCAuNzggMy40MyAxIDEgMCAwIDAgLjkuNTcuOTQuOTQgMCAwIDAgLjQzLS4xIDEgMSAwIDAgMCAuNDctMS4zM0E2LjA3IDYuMDcgMCAwIDEgMiA5YTYgNiAwIDAgMSAxMiAwIDUuOTMgNS45MyAwIDAgMS0uNTkgMi41NyAxIDEgMCAwIDAgMS44MS44NkE3Ljg5IDcuODkgMCAwIDAgMTYgOWE4IDggMCAwIDAtOC04eiIvPgogIDxwYXRoIGQ9Ik0xMS43NyA3LjA4YS41LjUgMCAwIDAtLjY5LjE1TDguNjIgMTEuMUEyLjEyIDIuMTIgMCAwIDAgOCAxMWEyIDIgMCAwIDAgMCA0IDIuMDUgMi4wNSAwIDAgMCAxLjEyLS4zNCAyLjMxIDIuMzEgMCAwIDAgLjU0LS41NCAyIDIgMCAwIDAgMC0yLjI0IDIuMzEgMi4zMSAwIDAgMC0uMi0uMjRsMi40Ni0zLjg3YS41LjUgMCAwIDAtLjE1LS42OXoiLz4KPC9zdmc+Cg==",
                },
                {
                name: 'Externes Debugging',
                command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                       document.getElementById('menu_devtools_remotedebugging').click()",                        
                subdir: 'Weitere Werkzeuge',
                image: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIgdmlld0JveD0iMCAwIDUxMiA1MTIiPg0KPCEtLSEgRm9udCBBd2Vzb21lIEZyZWUgNi4zLjAgYnkgQGZvbnRhd2Vzb21lIC0gaHR0cHM6Ly9mb250YXdlc29tZS5jb20gTGljZW5zZSAtIGh0dHBzOi8vZm9udGF3ZXNvbWUuY29tL2xpY2Vuc2UvZnJlZSAoSWNvbnM6IENDIEJZIDQuMCwgRm9udHM6IFNJTCBPRkwgMS4xLCBDb2RlOiBNSVQgTGljZW5zZSkgQ29weXJpZ2h0IDIwMjMgRm9udGljb25zLCBJbmMuIC0tPg0KICA8cGF0aCBmaWxsPSJjb250ZXh0LWZpbGwiIGQ9Ik0yNTYgMGM1MyAwIDk2IDQzIDk2IDk2djMuNmMwIDE1LjctMTIuNyAyOC40LTI4LjQgMjguNEgxODguNGMtMTUuNyAwLTI4LjQtMTIuNy0yOC40LTI4LjRWOTZjMC01MyA0My05NiA5Ni05NnpNNDEuNCAxMDUuNGMxMi41LTEyLjUgMzIuOC0xMi41IDQ1LjMgMGw2NCA2NGMuNyAuNyAxLjMgMS40IDEuOSAyLjFjMTQuMi03LjMgMzAuNC0xMS40IDQ3LjUtMTEuNEgzMTJjMTcuMSAwIDMzLjIgNC4xIDQ3LjUgMTEuNGMuNi0uNyAxLjItMS40IDEuOS0yLjFsNjQtNjRjMTIuNS0xMi41IDMyLjgtMTIuNSA0NS4zIDBzMTIuNSAzMi44IDAgNDUuM2wtNjQgNjRjLS43IC43LTEuNCAxLjMtMi4xIDEuOWM2LjIgMTIgMTAuMSAyNS4zIDExLjEgMzkuNUg0ODBjMTcuNyAwIDMyIDE0LjMgMzIgMzJzLTE0LjMgMzItMzIgMzJINDE2YzAgMjQuNi01LjUgNDcuOC0xNS40IDY4LjZjMi4yIDEuMyA0LjIgMi45IDYgNC44bDY0IDY0YzEyLjUgMTIuNSAxMi41IDMyLjggMCA0NS4zcy0zMi44IDEyLjUtNDUuMyAwbC02My4xLTYzLjFjLTI0LjUgMjEuOC01NS44IDM2LjItOTAuMyAzOS42VjI0MGMwLTguOC03LjItMTYtMTYtMTZzLTE2IDcuMi0xNiAxNlY0NzkuMmMtMzQuNS0zLjQtNjUuOC0xNy44LTkwLjMtMzkuNkw4Ni42IDUwMi42Yy0xMi41IDEyLjUtMzIuOCAxMi41LTQ1LjMgMHMtMTIuNS0zMi44IDAtNDUuM2w2NC02NGMxLjktMS45IDMuOS0zLjQgNi00LjhDMTAxLjUgMzY3LjggOTYgMzQ0LjYgOTYgMzIwSDMyYy0xNy43IDAtMzItMTQuMy0zMi0zMnMxNC4zLTMyIDMyLTMySDk2LjNjMS4xLTE0LjEgNS0yNy41IDExLjEtMzkuNWMtLjctLjYtMS40LTEuMi0yLjEtMS45bC02NC02NGMtMTIuNS0xMi41LTEyLjUtMzIuOCAwLTQ1LjN6Ii8+PC9zdmc+",
                },
                {
                name: 'Browser-Werkzeuge',
                command: "var { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                        var { BrowserToolboxLauncher } = require('resource://devtools/client/framework/browser-toolbox/Launcher.sys.mjs');\
                        BrowserToolboxLauncher.init();",
                subdir: 'Weitere Werkzeuge',
                image: "data:image/svg+xml;base64,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",
                },
                {
                name: 'Browser-Konsole',
                command: "var { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                        var { BrowserConsoleManager } = require('resource://devtools/client/webconsole/browser-console-manager');\
                        BrowserConsoleManager.openBrowserConsoleOrFocus();",
                subdir: 'Weitere Werkzeuge',
                image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjE2IiBoZWlnaHQ9IjE2IiB2aWV3Qm94PSIwIDAgMTYgMTYiIGZpbGw9ImNvbnRleHQtZmlsbCAjMGMwYzBkIj4NCiAgPHBhdGggZD0iTTEzIDFhMyAzIDAgMCAxIDMgM3Y4YTMgMyAwIDAgMS0zIDNIM2EzIDMgMCAwIDEtMy0zVjRhMyAzIDAgMCAxIDMtM2gxMHptMCAySDNjLS41NCAwLTEgLjQ2LTEgMXYxaDEyVjRjMC0uNTQtLjQ2LTEtMS0xem0xIDNIMnY2YzAgLjU0LjQ2IDEgMSAxaDEwYy41NCAwIDEtLjQ2IDEtMVY2eiIvPg0KICA8cGF0aCBkPSJNNC4xNSA3LjE1Yy4yLS4yLjUtLjIuNyAwbDIgMmMuMi4yLjIuNSAwIC43bC0yIDJhLjUuNSAwIDAgMS0uNy0uN0w1Ljc5IDkuNSA0LjE1IDcuODVhLjUuNSAwIDAgMSAwLS43eiIvPg0KPC9zdmc+",
                },
                {
                name: 'Bildschirmgrößen testen',
                command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                           document.getElementById('menu_responsiveUI').click()",                        
                subdir: 'Weitere Werkzeuge',
                image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljCiAgIC0gTGljZW5zZSwgdi4gMi4wLiBJZiBhIGNvcHkgb2YgdGhlIE1QTCB3YXMgbm90IGRpc3RyaWJ1dGVkIHdpdGggdGhpcwogICAtIGZpbGUsIFlvdSBjYW4gb2J0YWluIG9uZSBhdCBodHRwOi8vbW96aWxsYS5vcmcvTVBMLzIuMC8uIC0tPgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjE2IiBoZWlnaHQ9IjE2IiB2aWV3Qm94PSIwIDAgMTYgMTYiIGZpbGw9ImNvbnRleHQtZmlsbCAjMGMwYzBkIj4KICA8cGF0aCBkPSJNMSA0aDVhMSAxIDAgMCAxIDEgMXYxMGExIDEgMCAwIDEtMSAxSDFhMSAxIDAgMCAxLTEtMVY1YTEgMSAwIDAgMSAxLTF6bTAgMnY4aDVWNkgxeiIvPgogIDxwYXRoIGQ9Ik01IDBhMiAyIDAgMCAwLTIgMnYxaDJWMmg4djEySDh2Mmg1YTIgMiAwIDAgMCAyLTJWMmEyIDIgMCAwIDAtMi0ySDV6Ii8+Cjwvc3ZnPgo=",
                },
                {
                name: 'Farbpipette',
                command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                           document.getElementById('menu_eyedropper').click()",                        
                subdir: 'Weitere Werkzeuge',
                image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmlld0JveD0iMCAwIDE2IDE2IiB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+DQogIDxwYXRoIGZpbGwtcnVsZT0iZXZlbm9kZCIgZD0iTTEuMTQ2IDE0Ljg1NGMuNzQ4Ljc0NyAxLjk2Ljc0NyAyLjcwOCAwbDYuNTQyLTYuNTQzLjg5Ny44OTZhMSAxIDAgMSAwIDEuNDE0LTEuNDE0bC0uOS0uOSAzLjA0Ny0zLjA0YTEuOTE0IDEuOTE0IDAgMCAwLTIuNzA4LTIuNzA3TDkuMTA3IDQuMTkzbC0uOS0uOWExIDEgMCAwIDAtMS40MTQgMS40MTRsLjg5Ni44OTctNi41NDMgNi41NDJhMS45MTQgMS45MTQgMCAwIDAgMCAyLjcwOHptLjcwOC0yYS45MTQuOTE0IDAgMSAwIDEuMjkyIDEuMjkyTDkuNjkgNy42MDQgOC4zOTYgNi4zMWwtNi41NDIgNi41NDN6Ii8+DQo8L3N2Zz4=",
                },
                {
                name: 'Seitenquelltext anzeigen',
                command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                       document.getElementById('menu_pageSource').click()",                        
                subdir: 'Weitere Werkzeuge',
                image: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxNiIgaGVpZ2h0PSIxNiIgdmlld0JveD0iMCAwIDE2IDE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPgogICA8cGF0aCBkPSJNIDMuNSAwIEMgMi42NzE1NyAwIDIgMC42NzE1NyAyIDEuNSBMIDIgNS40MTYwMTU2IEMgMi4zMTc1IDUuMjc3Mjk1NiAyLjY1MjIgNS4xNzAyMDk0IDMgNS4wOTk2MDk0IEwgMyAxLjUgQyAzIDEuMjIzODYgMy4yMjM4NiAxIDMuNSAxIEwgOCAxIEwgOCA0LjUgQyA4IDUuMzI4NDMgOC42NzE2IDYgOS41IDYgTCAxMyA2IEwgMTMgMTQuNSBDIDEzIDE0Ljc3NjEgMTIuOTEwODYxIDE1IDEyLjYzNDc2NiAxNSBMIDExLjA3NjE3MiAxNSBDIDExLjEzOTk4MiAxNS4zODA4MDUgMTEuMTIzNjE2IDE1LjY5ODYyNyAxMS4xMDM1MTYgMTYgTCAxMi41IDE2IEMgMTMuMzI4NCAxNiAxNCAxNS4zMjg0IDE0IDE0LjUgTCAxNCA1LjQxNDA2MjUgQyAxNCA1LjAxNjI0MjUgMTMuODQxODQ3IDQuNjM0ODI1NiAxMy41NjA1NDcgNC4zNTM1MTU2IEwgOS42NDY0ODQ0IDAuNDM5NDUzMTIgQyA5LjM2NTE4NDQgMC4xNTgxNTMxMyA4Ljk4MzczNzUgMCA4LjU4NTkzNzUgMCBMIDMuNSAwIHogTSA5IDEuMjA3MDMxMiBMIDEyLjc5Mjk2OSA1IEwgOS41IDUgQyA5LjIyMzkgNSA5IDQuNzc2MTQgOSA0LjUgTCA5IDEuMjA3MDMxMiB6IE0gNCA2IEMgMS43OTA4NiA2IDAgNy43OTA4NiAwIDEwIEMgMCAxMi4yMDkxIDEuNzkwODYgMTQgNCAxNCBDIDQuOTI0MzIgMTQgNS43NzU3OTUgMTMuNjg2NjU2IDYuNDUzMTI1IDEzLjE2MDE1NiBMIDkuMTQ0NTMxMiAxNS44NTE1NjIgQyA5LjMzOTgzMTIgMTYuMDQ2ODYzIDkuNjU2MjYyNSAxNi4wNDY4NjIgOS44NTE1NjI1IDE1Ljg1MTU2MiBDIDEwLjA0Njg2MiAxNS42NTYzNjMgMTAuMDQ2ODYyIDE1LjMzOTgzMSA5Ljg1MTU2MjUgMTUuMTQ0NTMxIEwgNy4xNjAxNTYyIDEyLjQ1MzEyNSBDIDcuNjg2NzI2MiAxMS43NzU3MjUgOCAxMC45MjQ0IDggMTAgQyA4IDcuNzkwODYgNi4yMDkxNCA2IDQgNiB6IE0gNCA3IEMgNS42NTY4NSA3IDcgOC4zNDMxIDcgMTAgQyA3IDExLjY1NjkgNS42NTY4NSAxMyA0IDEzIEMgMi4zNDMxNSAxMyAxIDExLjY1NjkgMSAxMCBDIDEgOC4zNDMxIDIuMzQzMTUgNyA0IDcgeiAiIC8+Cjwvc3ZnPgo=",
                },
                {
                name: 'Erweiterungen für Entwickler',
                command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                        document.getElementById('extensionsForDevelopers').click()",                        
                subdir: 'Weitere Werkzeuge',
                image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjE2IiBoZWlnaHQ9IjE2IiB2aWV3Qm94PSIwIDAgMTYgMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+DQogIDxwYXRoIGQ9Ik0xNC41IDhjLS45NzEgMC0xIDEtMS43NSAxYS43NjUuNzY1IDAgMCAxLS43NS0uNzVWNWExIDEgMCAwIDAtMS0xSDcuNzVBLjc2NS43NjUgMCAwIDEgNyAzLjI1YzAtLjc1IDEtLjc3OSAxLTEuNzVDOCAuNjM1IDcuMSAwIDYgMFM0IC42MzUgNCAxLjVjMCAuOTcxIDEgMSAxIDEuNzVhLjc2NS43NjUgMCAwIDEtLjc1Ljc1SDFhMSAxIDAgMCAwLTEgMXYyLjI1QS43NjUuNzY1IDAgMCAwIC43NSA4Yy43NSAwIC43NzktMSAxLjc1LTFDMy4zNjUgNyA0IDcuOSA0IDlzLS42MzUgMi0xLjUgMmMtLjk3MSAwLTEtMS0xLjc1LTFhLjc2NS43NjUgMCAwIDAtLjc1Ljc1VjE1YTEgMSAwIDAgMCAxIDFoMy4yNWEuNzY1Ljc2NSAwIDAgMCAuNzUtLjc1YzAtLjc1LTEtLjc3OS0xLTEuNzUgMC0uODY1LjktMS41IDItMS41czIgLjYzNSAyIDEuNWMwIC45NzEtMSAxLTEgMS43NWEuNzY1Ljc2NSAwIDAgMCAuNzUuNzVIMTFhMSAxIDAgMCAwIDEtMXYtMy4yNWEuNzY1Ljc2NSAwIDAgMSAuNzUtLjc1Yy43NSAwIC43NzkgMSAxLjc1IDEgLjg2NSAwIDEuNS0uOSAxLjUtMnMtLjYzNS0yLTEuNS0yeiIvPg0KPC9zdmc+",
                },

            ]
        },
        {
        name: 'Seiteninformationen',
        command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                document.getElementById('menu_pageInfo').click()",
        subdir: 'Extras',
        image: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxNiIgaGVpZ2h0PSIxNiIgdmlld0JveD0iMCAwIDE2IDE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPgogIDxwYXRoIGQ9Ik00LjE4NCAxLjcxNGMwLS4zMTUuMjU2LS41NzEuNTczLS41NzFoNC4zODh2My40MjhjMCAuODQyLjY4MyAxLjUyNCAxLjUyNiAxLjUyNGgzLjQzNHY3LjQyOWEuNTcyLjU3MiAwIDAgMS0uNTcyLjU3MUg5LjkwOHYxLjE0M2gzLjYyNWMuOTQ4IDAgMS43MTctLjc2NyAxLjcxNy0xLjcxNFY1LjgzOWMwLS4zNTMtLjE0MS0uNjkyLS4zOTEtLjk0MkwxMC4zNDUuMzkxQTEuMzMyIDEuMzMyIDAgMCAwIDkuNDAxIDBINC43NTdjLS45NDkgMC0xLjcxOC43NjgtMS43MTggMS43MTR2NS45MDVoMS4xNDVWMS43MTRabTYuMTA1IDIuODU3di0yLjYybDMuMDA3IDMuMDAxaC0yLjYyNWEuMzgxLjM4MSAwIDAgMS0uMzgyLS4zODFaTTMuNDIxIDguOTUyYS41NzIuNTcyIDAgMCAxLS41NzIuNTcyaC0uOTU0djUuMzMzaC45NTRhLjU3Mi41NzIgMCAxIDEgMCAxLjE0M2gtLjk1NEExLjE0NCAxLjE0NCAwIDAgMSAuNzUgMTQuODU3VjkuNTI0YzAtLjYzMS41MTMtMS4xNDMgMS4xNDUtMS4xNDNoLjk1NGMuMzE2IDAgLjU3Mi4yNTYuNTcyLjU3MVoiLz4KICA8cGF0aCBkPSJNNy4wNDYgOS41MjRhLjU3Mi41NzIgMCAxIDEgMC0xLjE0M0g4Yy42MzIgMCAxLjE0NS41MTIgMS4xNDUgMS4xNDN2NS4zMzNDOS4xNDUgMTUuNDg4IDguNjMyIDE2IDggMTZoLS45NTRhLjU3Mi41NzIgMCAxIDEgMC0xLjE0M0g4VjkuNTI0aC0uOTU0Wk00Ljk0NyAxMS4yMzhjLjMxNiAwIC41NzMuMjU2LjU3My41NzJ2Mi42NjZhLjU3My41NzMgMCAwIDEtMS4xNDUgMFYxMS44MWMwLS4zMTYuMjU2LS41NzIuNTcyLS41NzJaTTQuOTQ3IDEwLjY2N2EuNTczLjU3MyAwIDEgMCAwLTEuMTQ1LjU3My41NzMgMCAwIDAgMCAxLjE0NVoiLz4KPC9zdmc+Cg==",
        },
        {
        name: 'separator',
        subdir: 'Extras',
        },
        {
        name: 'Einstellungen',
        command: "openPreferences();",
        subdir: 'Extras',
        image: "data:image/svg+xml;base64,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",
        },



       // Untermenü Hilfe
        {
		name: 'Hilfe erhalten',
		command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
		        openHelpLink('firefox-help')", 
		//command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
		//        document.getElementById('menu_openHelp').click()",                        
        subdir: 'Hilfe',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmlld0JveD0iMCAwIDE2IDE2IiB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+DQogIDxwYXRoIGQ9Ik03LjYyNSAxLjc1YzMuNDQ2IDAgNi4yNSAyLjgwNCA2LjI1IDYuMjVzLTIuODA0IDYuMjUtNi4yNSA2LjI1LTYuMjUtMi44MDQtNi4yNS02LjI1IDIuODA0LTYuMjUgNi4yNS02LjI1bTAtMS4yNWE3LjUgNy41IDAgMSAwIDAgMTUgNy41IDcuNSAwIDAgMCAwLTE1eiIvPg0KICA8cGF0aCBkPSJNNy42MjUgOS43MDlBLjYyNS42MjUgMCAwIDEgNyA5LjA4NGwwLS43NjdjMC0uNTI3LjM3LS45ODcuODc5LTEuMDkyLjU3Ny0uMTIuOTk2LS42MzUuOTk2LTEuMjI1YTEuMjUyIDEuMjUyIDAgMCAwLTIuNDMyLS40MDkuNjI2LjYyNiAwIDAgMS0xLjE4MS0uNDA4QTIuNSAyLjUgMCAxIDEgOC4yNSA4LjQyMWwwIC42NjNjMCAuMzQ1LS4yOC42MjUtLjYyNS42MjV6Ii8+DQogIDxwYXRoIGQ9Im04IDEyLS43NSAwLS4yNS0uMjVMNyAxMWwuMjUtLjI1Ljc1IDAgLjI1LjI1IDAgLjc1eiIvPg0KPC9zdmc+",
		},
		{
		name: 'Problem mit Website melden',
		command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                document.getElementById('help_reportBrokenSite').click()",
        subdir: 'Hilfe',
        image: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxNiIgaGVpZ2h0PSIxNiIgdmlld0JveD0iMCAwIDQ5NS4wMDMgNDk1LjAwMyIgZmlsbD0iY29udGV4dC1maWxsIj4NCgk8cGF0aCBkPSJNMTY0LjcxMSw0NTYuNjg3YzAsMi45NjYsMS42NDcsNS42ODYsNC4yNjYsNy4wNzJjMi42MTcsMS4zODUsNS43OTksMS4yMDcsOC4yNDUtMC40NjhsNTUuMDktMzcuNjE2IGwtNjcuNi0zMi4yMlY0NTYuNjg3eiIvPg0KCTxwYXRoIGQ9Ik00OTIuNDMxLDMyLjQ0M2MtMS41MTMtMS4zOTUtMy40NjYtMi4xMjUtNS40NC0yLjEyNWMtMS4xOSwwLTIuMzc3LDAuMjY0LTMuNSwwLjgxNkw3LjkwNSwyNjQuNDIyIGMtNC44NjEsMi4zODktNy45MzcsNy4zNTMtNy45MDQsMTIuNzgzYzAuMDMzLDUuNDIzLDMuMTYxLDEwLjM1Myw4LjA1NywxMi42ODlsMTI1LjM0Miw1OS43MjRsMjUwLjYyLTIwNS45OUwxNjQuNDU1LDM2NC40MTQgbDE1Ni4xNDUsNzQuNGMxLjkxOCwwLjkxOSw0LjAxMiwxLjM3Niw2LjA4NCwxLjM3NmMxLjc2OCwwLDMuNTE5LTAuMzIyLDUuMTg2LTAuOTc3YzMuNjM3LTEuNDM4LDYuNTI3LTQuMzE4LDcuOTctNy45NTYgTDQ5NC40MzYsNDEuMjU3QzQ5NS42NiwzOC4xODgsNDk0Ljg2MiwzNC42NzksNDkyLjQzMSwzMi40NDN6Ii8+DQo8L3N2Zz4NCg==",
		},
		{
		name: 'Ideen und Feedback teilen…',
        command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                openFeedbackPage()",
		//command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
        //        document.getElementById('feedbackPage').click()",
         subdir: 'Hilfe',
         image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg==",
		},
		{
		name: 'Fehlerbehebungsmodus…',
        command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                safeModeRestart()",
		//command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
        //        document.getElementById('helpSafeMode').click()",
        subdir: 'Hilfe',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjE2IiBoZWlnaHQ9IjE2IiB2aWV3Qm94PSIwIDAgMTYgMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+DQogIDxwYXRoIGQ9Im0xNC44NzUgMTIuMDM3LTUuNDk3LTEwQzguOTk3IDEuMzQ2IDguMzExIDEgNy42MjUgMXMtMS4zNzIuMzQ2LTEuNzUyIDEuMDM3bC01LjQ5NyAxMEMtLjM1OCAxMy4zNy42MDcgMTUgMi4xMjggMTVsMTAuOTk1IDBjMS41MiAwIDIuNDg1LTEuNjMgMS43NTItMi45NjN6TTguMjUgMTEuNzUgOCAxMmwtLjc1IDAtLjI1LS4yNUw3IDExbC4yNS0uMjUuNzUgMCAuMjUuMjUgMCAuNzV6bTAtMi42ODhhLjYyNS42MjUgMCAwIDEtMS4yNSAwbDAtMy40MzdhLjYyNS42MjUgMCAwIDEgMS4yNSAwbDAgMy40Mzd6Ii8+DQo8L3N2Zz4=",
		},
		{
		name: 'Weitere Informationen zur Fehlerbehebung',
        command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                openTroubleshootingPage()",
		//command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
        //        document.getElementById('troubleShooting').click()",
        subdir: 'Hilfe',
        image: "XXX",
		},
		{
		name: 'Betrügerische Website melden…',
		command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                openUILink(gSafeBrowsing.getReportURL('Phish'), event, { \
                triggeringPrincipal: \
                Services.scriptSecurityManager.createNullPrincipal({}),\
                })",
        //command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
        //        document.getElementById('menu_HelpPopup_reportPhishingtoolmenu').click()",          
        subdir: 'Hilfe',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmlld0JveD0iMCAwIDE2IDE2IiB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+DQogIDxwYXRoIGQ9Ik0zIDcgMS41IDdsLS41LjVMMSA5bC41LjUgMS41IDAgLjUtLjUgMC0xLjV6Ii8+DQogIDxwYXRoIGQ9Im04Ljc1IDctMS41IDAtLjUuNSAwIDEuNS41LjUgMS41IDAgLjUtLjUgMC0xLjV6Ii8+DQogIDxwYXRoIGQ9Ik0xNC41IDcgMTMgN2wtLjUuNSAwIDEuNS41LjUgMS41IDBMMTUgOWwwLTEuNXoiLz4NCjwvc3ZnPg==",
		},
		{
		name: 'Zu einem neuen Gerät wechseln',
		command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                document.getElementById('helpSwitchDevice').click()",
        //command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
        //        document.getElementById('helpSwitchDevice').click()",
        subdir: 'Hilfe',
        image: "XXX",
		},
        {
        name: 'separator',
        subdir: 'Hilfe',
        },
        {
		name: 'Über Firefox',
		command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
                openAboutDialog()",
        //command: "let { require } = ChromeUtils.importESModule('resource://devtools/shared/loader/Loader.sys.mjs', {});\
        //        document.getElementById('aboutName').click()",
        subdir: 'Hilfe',
        image: "data:image/svg+xml;base64,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",
		},



        // Untermenü about:
        {
        name: 'about:about',
        command: "openTrustedLinkIn('about:about', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
        subdir: 'about:',
        image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
        name: 'about:cache',
        command: "openTrustedLinkIn('about:cache', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
        subdir: 'about:',
        image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
        name: 'about:certificate',
        command: "openTrustedLinkIn('about:certificate', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
        subdir: 'about:',
        image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
        name: 'about:checkerboard',
        command: "openTrustedLinkIn('about:checkerboard', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
        subdir: 'about:',
        image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
        name: 'about:compat',
        command: "openTrustedLinkIn('about:compat', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
        subdir: 'about:',
        image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
        name: 'about:config',
        command: "openTrustedLinkIn('about:config', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
        subdir: 'about:',
        image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
        name: 'about:crashes',
        command: "openTrustedLinkIn('about:crashes', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
        subdir: 'about:',
        image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
        name: 'about:debugging',
        command: "openTrustedLinkIn('about:debugging', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
        subdir: 'about:',
        image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
        name: 'about:downloads',
        command: "openTrustedLinkIn('about:downloads', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
        subdir: 'about:',
        image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
        name: 'about:logging',
        command: "openTrustedLinkIn('about:logging', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
        subdir: 'about:',
        image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
        name: 'about:logins',
        command: "openTrustedLinkIn('about:logins', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
        subdir: 'about:',
        image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
        name: 'about:memory',
        command: "openTrustedLinkIn('about:memory', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
        subdir: 'about:',
        image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
        name: 'about:networking',
        command: "openTrustedLinkIn('about:networking', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
        subdir: 'about:',
        image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
        name: 'about:processes',
        command: "openTrustedLinkIn('about:processes', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
        tooltiptext: 'Task Manager',
        subdir: 'about:',
        image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
        name: 'about:policies',
        command: "openTrustedLinkIn('about:policies', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
        subdir: 'about:',
        image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
        name: 'about:profiles',
        command: "openTrustedLinkIn('about:profiles', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
        subdir: 'about:',
        image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
        name: 'about:profiling',
        command: "openTrustedLinkIn('about:profiling', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
        subdir: 'about:',
        image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
        name: 'about:protections',
        command: "openTrustedLinkIn('about:protections', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
        subdir: 'about:',
        image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
            name: 'about:rights',
            command: "openTrustedLinkIn('about:rights', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
            subdir: 'about:',
            image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },{
            name: 'about:serviceworkers',
            command: "openTrustedLinkIn('about:serviceworkers', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
            subdir: 'about:',
            image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
            name: 'about:studies',
            command: "openTrustedLinkIn('about:studies', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
            subdir: 'about:',
            image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
            name: 'about:support',
            command: "openTrustedLinkIn('about:support', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
            subdir: 'about:',
            image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
            name: 'about:sync-log',
            command: "openTrustedLinkIn('about:sync-log', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
            subdir: 'about:',
            image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
            name: 'about:telemetry',
            command: "openTrustedLinkIn('about:telemetry', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
            subdir: 'about:',
            image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
            name: 'about:third-party',
            command: "openTrustedLinkIn('about:third-party', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
            subdir: 'about:',
            image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
            name: 'about:unloads',
            command: "openTrustedLinkIn('about:unloads', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
            tooltiptext: 'Tabs entladen',
            subdir: 'about:',
            image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
            name: 'about:url-classifier',
            command: "openTrustedLinkIn('about:url-classifier', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
            subdir: 'about:',
            image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
            name: 'about:webrtc',
            command: "openTrustedLinkIn('about:webrtc', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
            subdir: 'about:',
            image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },
        {
        name: 'about:windows-messages',
        command: "openTrustedLinkIn('about:windows-messages', gBrowser.selectedTab.isEmpty ? 'current' : 'tab')",
        subdir: 'about:',
        image:'data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgaGVpZ2h0PSIxNiIgd2lkdGg9IjE2IiBmaWxsPSJjb250ZXh0LWZpbGwiPg0KPHBhdGggZD0iTTE0LjYsNi4xTDEzLjUsNWwwLDBjMC4xLTAuMSwwLjItMC40LDAuMi0wLjZjMC0wLjItMC4xLTAuNC0wLjItMC42bC0wLjQtMC40Yy0wLjMtMC4zLTAuOC0wLjMtMS4xLDBsMCwwICBMMTAuNSwyYy0wLjItMC4yLTAuMy0wLjItMC41LTAuMmMtMC4yLDAtMC4zLDAuMS0wLjUsMC4yTDguMywzLjJDOC4xLDMuMyw4LjEsMy40LDguMSwzLjZTOC4yLDQsOC4zLDQuMWwxLjYsMS42TDcuOCw3LjhMNS42LDUuNyAgbDEuNS0xLjVDNy4zLDQsNy40LDMuOCw3LjQsMy42YzAtMC4yLTAuMS0wLjQtMC4yLTAuNmwtMS0xQzUuOCwxLjcsNS4zLDEuNyw1LDJMMC45LDYuMUMwLjcsNi4zLDAuNiw2LjUsMC42LDYuNyAgYzAsMC4yLDAuMSwwLjQsMC4yLDAuNmwxLDFjMC4zLDAuMywwLjksMC4zLDEuMiwwbDEuNC0xLjRsMiwyLjFsLTMuNCwzLjNjLTAuMywwLjMtMC4zLDAuOCwwLDEuMWwwLjMsMC4zYzAuMywwLjMsMC44LDAuMywxLjEsMCAgbDMuMy0zLjRsMy4zLDMuNGMwLjEsMC4xLDAuMywwLjIsMC42LDAuMmMwLjIsMCwwLjQtMC4xLDAuNi0wLjJsMC4zLTAuM2MwLjMtMC4zLDAuMy0wLjgsMC0xLjFMOSw5bDItMi4xbDEuNCwxLjQgIGMwLjEsMC4xLDIuMywxLjEsMi43LDAuN0MxNS41LDguNiwxNC44LDYuMywxNC42LDYuMXoiLz4NCjwvc3ZnPg=='
        },


        // Hauptmenü  Einträge
        {
        name: 'Neues privates Fenster',
        command: "OpenBrowserWindow({private: true});",
        id: 'AMprivate',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmlld0JveD0iMCAwIDE2IDE2IiB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+DQogIDxwYXRoIGQ9Ik0xNS45MzEgNS40NzljLTEuNTI1LTIuMDAxLTQuNTE3LTIuMjU3LTYuMzgxLS41NDVsLTEuMDQzLjk1OC0xLjAyIDAtMS4wNDItLjk1OEM0LjU4MSAzLjIyMyAxLjU4OSAzLjQ3OC4wNjQgNS40NzljLS4xOTcuNzguMTA4IDMuNjYuMjggNC4xMTMuMzQ3IDEuODMgMS44NDIgMy4yMDYgMy42MzUgMy4yMDYuODk1IDAgMS43MDYtLjM1NyAyLjM0Ny0uOTI5bC4zOTEtLjMzNGExLjkzNiAxLjkzNiAwIDAgMSAyLjUxMS0uMDIxbC41ODYuNDg2IDAtLjAwM2MuNjE3LjQ5NyAxLjM3NS44MDEgMi4yMDMuODAxIDEuNzkyIDAgMy4yODgtMS4zNzYgMy42MzUtMy4yMDYuMTcyLS40NTMuNDg4LTMuMzIxLjI3OS00LjExM3pNNi4yMzIgOC40NTJjLS40MjcuNDgyLTEuMDg4Ljc5Mi0xLjgzMi43OTItLjc0NCAwLTEuNDA1LS4zMS0xLjgzMi0uNzkyYS42OTMuNjkzIDAgMCAxIDAtLjkwNWMuNDI3LS40ODIgMS4wODgtLjc5MiAxLjgzMi0uNzkyLjc0NCAwIDEuNDA1LjMxIDEuODMyLjc5MmEuNjkzLjY5MyAwIDAgMSAwIC45MDV6bTcuMiAwYy0uNDI3LjQ4Mi0xLjA4OC43OTItMS44MzIuNzkyLS43NDQgMC0xLjQwNS0uMzEtMS44MzItLjc5MmEuNjkzLjY5MyAwIDAgMSAwLS45MDVjLjQyNy0uNDgyIDEuMDg4LS43OTIgMS44MzItLjc5Mi43NDQgMCAxLjQwNS4zMSAxLjgzMi43OTJhLjY5My42OTMgMCAwIDEgMCAuOTA1eiIvPg0KPC9zdmc+"
        },
        {
        name: 'separator',
        },
        {
        name: 'Einstellungen',
        command: "openPreferences();",
        id: 'AMsettings',
        image: "data:image/svg+xml;base64,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",
        },
        {
        name: 'Add-ons und Themes',
        command: "BrowserAddonUI.openAddonsMgr();",
        id: 'AMaddons',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjE2IiBoZWlnaHQ9IjE2IiB2aWV3Qm94PSIwIDAgMTYgMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+DQogIDxwYXRoIGQ9Ik0xNC41IDhjLS45NzEgMC0xIDEtMS43NSAxYS43NjUuNzY1IDAgMCAxLS43NS0uNzVWNWExIDEgMCAwIDAtMS0xSDcuNzVBLjc2NS43NjUgMCAwIDEgNyAzLjI1YzAtLjc1IDEtLjc3OSAxLTEuNzVDOCAuNjM1IDcuMSAwIDYgMFM0IC42MzUgNCAxLjVjMCAuOTcxIDEgMSAxIDEuNzVhLjc2NS43NjUgMCAwIDEtLjc1Ljc1SDFhMSAxIDAgMCAwLTEgMXYyLjI1QS43NjUuNzY1IDAgMCAwIC43NSA4Yy43NSAwIC43NzktMSAxLjc1LTFDMy4zNjUgNyA0IDcuOSA0IDlzLS42MzUgMi0xLjUgMmMtLjk3MSAwLTEtMS0xLjc1LTFhLjc2NS43NjUgMCAwIDAtLjc1Ljc1VjE1YTEgMSAwIDAgMCAxIDFoMy4yNWEuNzY1Ljc2NSAwIDAgMCAuNzUtLjc1YzAtLjc1LTEtLjc3OS0xLTEuNzUgMC0uODY1LjktMS41IDItMS41czIgLjYzNSAyIDEuNWMwIC45NzEtMSAxLTEgMS43NWEuNzY1Ljc2NSAwIDAgMCAuNzUuNzVIMTFhMSAxIDAgMCAwIDEtMXYtMy4yNWEuNzY1Ljc2NSAwIDAgMSAuNzUtLjc1Yy43NSAwIC43NzkgMSAxLjc1IDEgLjg2NSAwIDEuNS0uOSAxLjUtMnMtLjYzNS0yLTEuNS0yeiIvPg0KPC9zdmc+"
        },
        {
        name: 'separator'
        },
        {
        name: 'Lesezeichen-Verwaltung',
        command: "PlacesCommandHook.showPlacesOrganizer('AllBookmarks');",
        id: 'AMbookmarks',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjE2IiBoZWlnaHQ9IjE2IiB2aWV3Qm94PSIwIDAgMTYgMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+DQogIDxwYXRoIGQ9Ik0xNCAxNkgyYTEgMSAwIDAgMS0xLTF2LTJhMSAxIDAgMCAxIDIgMHYxaDEwdi0xYTEgMSAwIDAgMSAyIDB2MmExIDEgMCAwIDEtMSAxek0xMy45NjEgNC4yODJhLjkuOSAwIDAgMC0uNzIzLS42MDlsLTMuMDYzLS40NDVMOC44MDUuNDU2YS45MzQuOTM0IDAgMCAwLTEuNjA1IDBMNS44MyAzLjIyOGwtMy4wNjMuNDQ1QS44OTMuODkzIDAgMCAwIDIuMjcgNS4ybDIuMjE3IDIuMTU2LS41MjMgMy4wNDRhLjg5NC44OTQgMCAwIDAgMS4zLjk0Mkw4IDkuOTA3bDIuNzQgMS40MzlhLjg4OC44ODggMCAwIDAgLjQxNi4xLjkuOSAwIDAgMCAuNTI2LS4xNzIuODkzLjg5MyAwIDAgMCAuMzU1LS44NzRsLS41MjItMy4wNDcgMi4yMi0yLjE1M2EuODkzLjg5MyAwIDAgMCAuMjI2LS45MTh6bS00LjM2NyAyLjQ1bC4zNzYgMi4xODlMOCA3Ljg4OCA2LjAzNSA4LjkyMWwuMzc2LTIuMTg5LTEuNTkyLTEuNTUgMi4yLS4zMTlMOCAyLjg3MmwuOTgzIDEuOTkxIDIuMi4zMTl6Ii8+DQo8L3N2Zz4="
        },
        {
        name: 'Chronik',
        command: "PlacesCommandHook.showPlacesOrganizer('History');",
        id: 'AMhistory',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljCiAgIC0gTGljZW5zZSwgdi4gMi4wLiBJZiBhIGNvcHkgb2YgdGhlIE1QTCB3YXMgbm90IGRpc3RyaWJ1dGVkIHdpdGggdGhpcwogICAtIGZpbGUsIFlvdSBjYW4gb2J0YWluIG9uZSBhdCBodHRwOi8vbW96aWxsYS5vcmcvTVBMLzIuMC8uIC0tPgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjE2IiBoZWlnaHQ9IjE2IiB2aWV3Qm94PSIwIDAgMTYgMTYiIGZpbGw9ImNvbnRleHQtZmlsbCIgPgogIDxwYXRoIGQ9Ik04IDBhOCA4IDAgMSAwIDggOCA4LjAwOSA4LjAwOSAwIDAgMC04LTh6bTAgMTRhNiA2IDAgMSAxIDYtNiA2LjAwNyA2LjAwNyAwIDAgMS02IDZ6bTMuNS02SDhWNC41YS41LjUgMCAwIDAtMSAwdjRhLjUuNSAwIDAgMCAuNS41aDRhLjUuNSAwIDAgMCAwLTF6Ii8+Cjwvc3ZnPgo="
        },
        {
        name: 'Downloads',
        command: "BrowserCommands.downloadsUI()",
        id: 'AMdownloads',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmlld0JveD0iMCAwIDE2IDE2IiB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+DQogIDxwYXRoIGQ9Ik04LjI1LjYyNWEuNjI1LjYyNSAwIDAgMC0xLjI1IDBsMCA4LjMyMy0zLjMwOC0zLjMwOWEuNjI2LjYyNiAwIDAgMC0uODg1Ljg4NUw3LjI4NSAxMWwuNjgxIDAgNC40NzctNC40NzZhLjYyNi42MjYgMCAwIDAtLjg4NS0uODg1TDguMjUgOC45NDdsMC04LjMyMnoiLz4NCiAgPHBhdGggZD0iTTEyLjI1IDE1YTIgMiAwIDAgMCAyLTJsMC0xLjM3NWEuNjI1LjYyNSAwIDAgMC0xLjI1IDBsMCAxLjUyNS0uNi42LTkuNTUgMC0uNi0uNiAwLTEuNTI1YS42MjUuNjI1IDAgMCAwLTEuMjUgMEwxIDEzYTIgMiAwIDAgMCAyIDJsOS4yNSAweiIvPg0KPC9zdmc+"
        },
        {
        name: 'Seite speichern unter...',
        command: "saveBrowser(gBrowser.selectedBrowser)",
        id: 'AMsave',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjE2IiBoZWlnaHQ9IjE2IiB2aWV3Qm94PSIwIDAgMTYgMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+DQogIDxwYXRoIGQ9Ik0xNCAzaC0ydjJoMnY4SDJWNWg3VjNoLS44NDlMNi41ODQgMS41MzhBMiAyIDAgMCAwIDUuMjE5IDFIMmEyIDIgMCAwIDAtMiAydjEwYTIgMiAwIDAgMCAyIDJoMTJhMiAyIDAgMCAwIDItMlY1YTIgMiAwIDAgMC0yLTJ6TTIgM2gzLjIxOWwxLjA3MiAxSDJ6Ii8+DQogIDxwYXRoIGQ9Ik04LjE0NiA2LjE0NmEuNS41IDAgMCAwIDAgLjcwN2wyIDJhLjUuNSAwIDAgMCAuNzA3IDBsMi0yYS41LjUgMCAxIDAtLjcwNy0uNzA3TDExIDcuMjkzVi41YS41LjUgMCAwIDAtMSAwdjYuNzkzTDguODU0IDYuMTQ2YS41LjUgMCAwIDAtLjcwOCAweiIvPg0KPC9zdmc+"
        },
        {
        name: 'Chronik löschen',
        command: "Sanitizer.showUI(window);",
        id: 'AMsanitize',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljDQogICAtIExpY2Vuc2UsIHYuIDIuMC4gSWYgYSBjb3B5IG9mIHRoZSBNUEwgd2FzIG5vdCBkaXN0cmlidXRlZCB3aXRoIHRoaXMNCiAgIC0gZmlsZSwgWW91IGNhbiBvYnRhaW4gb25lIGF0IGh0dHA6Ly9tb3ppbGxhLm9yZy9NUEwvMi4wLy4gLS0+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjE2IiBoZWlnaHQ9IjE2IiB2aWV3Qm94PSIwIDAgMTYgMTYiIGZpbGw9ImNvbnRleHQtZmlsbCI+DQogIDxwYXRoIGQ9Ik02Ljg1NCAxMC44NTRsMi0yQS41LjUgMCAwIDAgOSA4LjV2LTRhLjUuNSAwIDAgMC0xIDB2My43OTNsLTEuODU0IDEuODUzYS41LjUgMCAxIDAgLjcwNy43MDd6TTggMGE4LjAxMSA4LjAxMSAwIDAgMC03IDQuMTg0VjEuNWEuNS41IDAgMCAwLTEgMHY1YS41LjUgMCAwIDAgLjUuNWg1YS41LjUgMCAwIDAgMC0xSDIuMzQ0YS45MzguOTM4IDAgMCAwIC4wNTYtLjA4NSA2IDYgMCAxIDEgMCA0LjE4NCAxIDEgMCAwIDAtMS44NzMuN0E3Ljk5MSA3Ljk5MSAwIDEgMCA4IDB6Ii8+DQo8L3N2Zz4="
        },
        {
        name: 'separator',
        },
        {
        name: 'Neustart',
        tooltiptext: 'userChrome.js-Cache wird geleert',
		command: 'Services.appinfo.invalidateCachesOnRestart(); \
                Services.startup.quit(Ci.nsIAppStartup.eRestart | Ci.nsIAppStartup.eAttemptQuit);',
        id: 'AMreboot',
        image: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCA0NDggNTEyIj48IS0tISBGb250IEF3ZXNvbWUgRnJlZSA2LjMuMCBieSBAZm9udGF3ZXNvbWUgLSBodHRwczovL2ZvbnRhd2Vzb21lLmNvbSBMaWNlbnNlIC0gaHR0cHM6Ly9mb250YXdlc29tZS5jb20vbGljZW5zZS9mcmVlIChJY29uczogQ0MgQlkgNC4wLCBGb250czogU0lMIE9GTCAxLjEsIENvZGU6IE1JVCBMaWNlbnNlKSBDb3B5cmlnaHQgMjAyMyBGb250aWNvbnMsIEluYy4gLS0+PHBhdGggZD0iTTIyNCA5NmMzOC40IDAgNzMuNyAxMy41IDEwMS4zIDM2LjFsLTMyLjYgMzIuNmMtNC42IDQuNi01LjkgMTEuNS0zLjUgMTcuNHM4LjMgOS45IDE0LjggOS45SDQxNmM4LjggMCAxNi03LjIgMTYtMTZWNjRjMC02LjUtMy45LTEyLjMtOS45LTE0LjhzLTEyLjktMS4xLTE3LjQgMy41bC0zNCAzNEMzMzEuNCA1Mi42IDI4MC4xIDMyIDIyNCAzMmMtMTAuOSAwLTIxLjUgLjgtMzIgMi4zVjk5LjJjMTAuMy0yLjEgMjEtMy4yIDMyLTMuMnpNMTAwLjEgMTU0LjdsMzIuNiAzMi42YzQuNiA0LjYgMTEuNSA1LjkgMTcuNCAzLjVzOS45LTguMyA5LjktMTQuOFY2NGMwLTguOC03LjItMTYtMTYtMTZIMzJjLTYuNSAwLTEyLjMgMy45LTE0LjggOS45cy0xLjEgMTIuOSAzLjUgMTcuNGwzNCAzNEMyMC42IDE0OC42IDAgMTk5LjkgMCAyNTZjMCAxMC45IC44IDIxLjUgMi4zIDMySDY3LjJjLTIuMS0xMC4zLTMuMi0yMS0zLjItMzJjMC0zOC40IDEzLjUtNzMuNyAzNi4xLTEwMS4zek00NDUuNyAyMjRIMzgwLjhjMi4xIDEwLjMgMy4yIDIxIDMuMiAzMmMwIDM4LjQtMTMuNSA3My43LTM2LjEgMTAxLjNsLTMyLjYtMzIuNmMtNC42LTQuNi0xMS41LTUuOS0xNy40LTMuNXMtOS45IDguMy05LjkgMTQuOFY0NDhjMCA4LjggNy4yIDE2IDE2IDE2SDQxNmM2LjUgMCAxMi4zLTMuOSAxNC44LTkuOXMxLjEtMTIuOS0zLjUtMTcuNGwtMzQtMzRDNDI3LjQgMzYzLjQgNDQ4IDMxMi4xIDQ0OCAyNTZjMC0xMC45LS44LTIxLjUtMi4zLTMyek0yMjQgNDE2Yy0zOC40IDAtNzMuNy0xMy41LTEwMS4zLTM2LjFsMzIuNi0zMi42YzQuNi00LjYgNS45LTExLjUgMy41LTE3LjRzLTguMy05LjktMTQuOC05LjlIMzJjLTguOCAwLTE2IDcuMi0xNiAxNmwwIDExMmMwIDYuNSAzLjkgMTIuMyA5LjkgMTQuOHMxMi45IDEuMSAxNy40LTMuNWwzNC0zNEMxMTYuNiA0NTkuNCAxNjcuOSA0ODAgMjI0IDQ4MGMxMC45IDAgMjEuNS0uOCAzMi0yLjNWNDEyLjhjLTEwLjMgMi4xLTIxIDMuMi0zMiAzLjJ6Ii8+PC9zdmc+"
        },
        {
        name: 'Beenden',
        command: "goQuitApplication(event);",
        id: 'AMquit',
        image: "data:image/svg+xml;base64,PCEtLSBUaGlzIFNvdXJjZSBDb2RlIEZvcm0gaXMgc3ViamVjdCB0byB0aGUgdGVybXMgb2YgdGhlIE1vemlsbGEgUHVibGljCiAgIC0gTGljZW5zZSwgdi4gMi4wLiBJZiBhIGNvcHkgb2YgdGhlIE1QTCB3YXMgbm90IGRpc3RyaWJ1dGVkIHdpdGggdGhpcwogICAtIGZpbGUsIFlvdSBjYW4gb2J0YWluIG9uZSBhdCBodHRwOi8vbW96aWxsYS5vcmcvTVBMLzIuMC8uIC0tPgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjE2IiBoZWlnaHQ9IjE2IiB2aWV3Qm94PSIwIDAgMTYgMTYiIGZpbGw9InJlZCI+CiAgPHBhdGggZD0iTTggNmExIDEgMCAwIDAgMS0xVjFhMSAxIDAgMCAwLTIgMHY0YTEgMSAwIDAgMCAxIDF6bTMuNS00LjAzMmExIDEgMCAwIDAtMSAxLjczMkE0Ljk0NiA0Ljk0NiAwIDAgMSAxMyA4IDUgNSAwIDAgMSAzIDhhNC45NDYgNC45NDYgMCAwIDEgMi41LTQuMyAxIDEgMCAwIDAtMS0xLjczMiA3IDcgMCAxIDAgNy4wMDYgMHoiLz4KPC9zdmc+Cg=="
        },
    ]
},

    _externalAppPopup: null,
    _isready: false,


    // Methode zum Generieren von verschachtelten Menüs
    generateSubmenu: function(parentMenu, submenuItems) {
        submenuItems.forEach(item => {
            var menuItem = document.createElement('menuitem');
            menuItem.setAttribute('label', item.name);

            if (item.command) {
                menuItem.setAttribute('oncommand', item.command);
            }

            if (item.submenu) {
                var subMenuPopup = document.createElement('menupopup');
                this.generateSubmenu(subMenuPopup, item.submenu);
                var subMenu = document.createElement('menu');
                subMenu.setAttribute('label', item.name);
                subMenu.appendChild(subMenuPopup);
                parentMenu.appendChild(subMenu);
            } else {
                parentMenu.appendChild(menuItem);
            }
        });
    },


    init: function() {
        this.handleRelativePath(this.toolbar.apps);
        const XULNS = 'http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul';

        var ExternalAppBtn = document.createElementNS(XULNS, 'toolbarbutton');
        ExternalAppBtn.id = "AppMenuButton";
        ExternalAppBtn.setAttribute("label", "AppButton");
        ExternalAppBtn.setAttribute("onclick", "event.preventDefault();event.stopPropagation();");
        ExternalAppBtn.setAttribute("tooltiptext", "Firefox Menü");
        ExternalAppBtn.setAttribute("type", "menu");
        ExternalAppBtn.setAttribute("removable", "true");

		  
		  if (Appmenu.isButton) {
              ExternalAppBtn.style.listStyleImage = "url(data:image/png;base64,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)";
              ExternalAppBtn.style.width = "6%";
              ExternalAppBtn.style.height = "1%";
              ExternalAppBtn.style.backgroundSize = "cover"; // Sorgt dafür, dass das Bild die gesamte Fläche des Buttons einnimmt.
            } else {
		      ExternalAppBtn.style.listStyleImage = "url(data:image/png;base64,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)";
              ExternalAppBtn.style.width = "3%";
              ExternalAppBtn.style.height = "1%";
              ExternalAppBtn.style.backgroundSize = "cover"; // Sorgt dafür, dass das Bild die gesamte Fläche des Buttons einnimmt.
              
            }

        if (Appmenu.isUrlbar === 1) {
            var navBar = document.getElementById("nav-bar-customization-target");
            navBar.insertBefore(ExternalAppBtn, navBar.firstChild);
        } else if (Appmenu.isUrlbar === 2) {
            var menubar = document.getElementById("toolbar-menubar");
            menubar.insertBefore(ExternalAppBtn, menubar.firstChild);
        } else {
            var TabsToolbar = document.getElementById("TabsToolbar");
            TabsToolbar.insertBefore(ExternalAppBtn, TabsToolbar.firstChild);
        }

        var ExternalAppPopup = document.createElementNS(XULNS, 'menupopup');
        ExternalAppPopup.setAttribute('id', 'AMpopup');
        this._externalAppPopup = ExternalAppPopup;
        ExternalAppBtn.appendChild(ExternalAppPopup);
        Appmenu.onpopupshowing();
        
		// Menü mit Tastaturkürzel öffnen

        if (Appmenu.hotkey) {
            let key = document.createXULElement('key');
            key.id = 'key_AppMenuPopup';
            key.setAttribute('key', Appmenu.hotkey);
                if (Appmenu.hotkeyModifier)
            key.setAttribute('modifiers', Appmenu.hotkeyModifier);
            key.setAttribute('oncommand', 'document.getElementById("AMpopup").openPopup();');
            document.getElementById('mainKeyset').appendChild(key);
        }

    },

        /* ****** NEU ****** */     

onpopupshowing: function() {
    if (this._isready)
        return;
    if (this._externalAppPopup === null)
        return;
    var ExternalAppPopup = this._externalAppPopup;

    // Funktion zum Erstellen eines Menüs mit Untermenüs
    function createMenuItem(parentPopup, item) {
        var menuItem;
        if (item.name == 'separator') {
            menuItem = document.createXULElement('menuseparator');
            parentPopup.appendChild(menuItem);
        } else if (item.submenu && item.submenu.length > 0) {
            menuItem = document.createXULElement('menu');
            var subMenuPopup = document.createXULElement('menupopup');
            menuItem.appendChild(subMenuPopup);
            menuItem.setAttribute('class', 'menu-iconic');
            menuItem.setAttribute('label', item.name);
            menuItem.setAttribute('image', item.image);
            parentPopup.appendChild(menuItem);
            for (let subItem of item.submenu) {
                createMenuItem(subMenuPopup, subItem);
            }
        } else {
            menuItem = document.createXULElement('menuitem');
            menuItem.setAttribute('class', 'menuitem-iconic');
            menuItem.setAttribute('label', item.name);
            menuItem.setAttribute('image', item.image);
            if (item.command) {
                menuItem.setAttribute('oncommand', item.command);
            } else if (item.path) {
                menuItem.setAttribute('oncommand', "Appmenu.exec(this.path, this.args);");
                menuItem.path = item.path;
                menuItem.args = item.args;
            }
            menuItem.setAttribute('tooltiptext', item.tooltiptext || item.name);
            menuItem.setAttribute('id', item.id || "");
            parentPopup.appendChild(menuItem);
        }
    }

    // Verarbeitung der Subdirs
    for (let subdir of this.toolbar.subdirs) {
        if (subdir.name == 'separator') {
            ExternalAppPopup.appendChild(document.createXULElement('menuseparator'));
        } else {
            var subdirItem = ExternalAppPopup.appendChild(document.createXULElement('menu'));
            var subdirItemPopup = subdirItem.appendChild(document.createXULElement('menupopup'));
            subdirItem.setAttribute('class', 'menu-iconic');
            subdirItem.setAttribute('label', subdir.name);
            subdirItem.setAttribute('image', subdir.image);
            Appmenu.subdirPopupHash[subdir.name] = subdirItemPopup;
            Appmenu.subdirMenuHash[subdir.name] = subdirItem;
        }
    }

    // Verarbeitung der Apps
    for (let app of this.toolbar.apps) {
        if (app.subdir && Appmenu.subdirPopupHash[app.subdir]) {
            createMenuItem(Appmenu.subdirPopupHash[app.subdir], app);
        } else {
            createMenuItem(ExternalAppPopup, app);
        }
    }

    // Verarbeitung der Configs
    for (let config of this.toolbar.configs) {
        if (config.subdir && Appmenu.subdirPopupHash[config.subdir]) {
            createMenuItem(Appmenu.subdirPopupHash[config.subdir], config);
        } else {
            createMenuItem(ExternalAppPopup, config);
        }
    }

    if (this.autohideEmptySubDirs) {
        for (let key in Appmenu.subdirPopupHash) {
            if (Appmenu.subdirPopupHash[key].hasChildNodes()) {
                continue;
            } else {
                Appmenu.subdirMenuHash[key].setAttribute("hidden", "true");
            }
        }
    }

    if (this.moveSubDirstoBottom) {
        let i = ExternalAppPopup.childNodes.length;
        while (ExternalAppPopup.firstChild.getAttribute('class') != 'menuitem-iconic' && i-- != 0) {
            ExternalAppPopup.appendChild(ExternalAppPopup.firstChild);
        }
    }

    this._isready = true;
},


    handleRelativePath: function(apps) {
        for (let app of apps) {
            if (app.path) {
                app.path = app.path.replace(/\//g, '\\');
                var ffdir = Cc['@mozilla.org/file/directory_service;1'].getService(Ci.nsIProperties).get(app.root, Ci.nsIFile).path;
                if (/^(\\)/.test(app.path)) {
                    app.path = ffdir + app.path;
                }
            }
        }
    },

    exec: function(path, args) {
        args = args || [];
        var args_t = args.slice(0);
        for (let arg of args_t) {
            arg = arg.replace(/%u/g, gBrowser.currentURI.spec);
        }
        var file = Cc['@mozilla.org/file/local;1'].createInstance(Ci.nsIFile);
        file.initWithPath(path);
        if (!file.exists()) {
            alert('Datei nicht gefunden: ' + path);
            return;
        }
        if (file.isExecutable() && !path.endsWith('.js')) {
            var process = Cc['@mozilla.org/process/util;1'].createInstance(Ci.nsIProcess);
            process.init(file);
            process.run(false, args_t, args_t.length);
        } else if (file.isFile()) {
            if (this.editor) {
                let UI = Cc["@mozilla.org/intl/scriptableunicodeconverter"].createInstance(Ci.nsIScriptableUnicodeConverter);
                UI.charset = window.navigator.platform.toLowerCase().includes('win') ? 'Shift_JIS' : 'UTF-8';
                let path = UI.ConvertFromUnicode(file.path);
                let app = Cc['@mozilla.org/file/local;1'].createInstance(Ci.nsIFile);
                app.initWithPath(this.editor);
                let process = Cc['@mozilla.org/process/util;1'].createInstance(Ci.nsIProcess);
                process.init(app);
                process.run(false, [path], 1);
            } else {
                file.launch();
            }
        } else if (file.isDirectory()) {
            if (this.fileManager) {
                let args=[this.FMParameter,path];
                let app = Cc['@mozilla.org/file/local;1'].createInstance(Ci.nsIFile);
                app.initWithPath(this.fileManager);
                let process = Cc['@mozilla.org/process/util;1'].createInstance(Ci.nsIProcess);
                process.init(app);
                process.run(false, args, args.length);
            } else {
                file.launch();
            }
        }
    },
};

    (function() {
        //    if (location.href !== 'chrome://browser/content/browser.xhtml') return;
        
            let ProfilePath = PathUtils.toFileURI(PathUtils.join(PathUtils.profileDir, 'chrome', 'icons'));
        
        //    var css =`
        
        let sss = Components.classes["@mozilla.org/content/style-sheet-service;1"].getService(Components.interfaces.nsIStyleSheetService);       
        let uri = Services.io.newURI("data:text/css;charset=utf-8," + encodeURIComponent(`

            #file-menu { display: none !important; }
            #edit-menu { display: none !important; }
            #tools-menu { display: none !important; }
            #helpMenu { display: none !important; }

        `), null, null);
    sss.loadAndRegisterSheet(uri, sss.AUTHOR_SHEET);
    })();

if (window.gBrowser)
Appmenu.init();