'use strict';

const tabsList = document.getElementById( 'tabs-list' );
const tabsHistory = document.getElementById( 'tabs-history' );
const createTab = document.getElementById( 'create-tab' );
const openOptions = document.getElementById( 'options' );
const hideAllTabs = document.getElementById( 'hide-all-tabs' );

const options = { 
	localeMatcher: 'best fit',
	weekday: 'short', 
	year: 'numeric', 
	month: '2-digit', 
	day: 'numeric', 
	hour: '2-digit', 
	minute: '2-digit'
};

const locale = window.navigator.languages[0];

/*******************************************************************************/

const extension = {

/**/settings: {},

/**/init() {
		extension.getStorage();
		extension.listTabs();
		extension.sessionList();
	},

/**/getStorage() {
		const getSettings = {
			async load() {
				const option = await browser.storage.local.get({
					maxHistory : 10
				});
				extension.settings.maxHistory = +option.maxHistory;
			}
		};
		let o = getSettings.load();
		/*
		o.then( () => {
			console.log( extension.settings.maxHistory );
		} );
		*/
	},

/**/getCurrentWindowTabs() {
		return browser.tabs.query( { currentWindow: true } );
	},

/**/listTabs() {
		extension.getStorage();
		extension.getCurrentWindowTabs().then( ( tabs ) => {
			let currentTabs = document.createDocumentFragment();
			tabsList.textContent = '';
			for(let tab of tabs) {
				let tabLink = document.createElement( 'a' );
				tabLink.textContent = tab.title || tab.id;
				tabLink.setAttribute( 'href' , tab.id );
				tabLink.classList.add( 'switch-tabs' );

				let favIconURL = tab.favIconUrl;
				if( favIconURL && favIconURL != '' && favIconURL.indexOf('chrome://') == -1 ) {
					tabLink.style.backgroundImage = 'url("' + favIconURL + '")';
				} else {
					tabLink.classList.add( 'default' );
				}
				if( tab.active ) {
					tabLink.classList.add( 'active' );
				}
				if( tab.discarded ) {
					tabLink.classList.add( 'discarded' );
				}	
				if( tab.hidden ) {
					tabLink.classList.add( 'hidden' );
				}
				currentTabs.appendChild( tabLink );
			}
			tabsList.appendChild( currentTabs );
		}).then( () => { extension.sessionList(); } );
	},

/**/updateList() {
		// https://bugzilla.mozilla.org/show_bug.cgi?id=1396758
		setTimeout( extension.listTabs , 200 );
		//extension.listTabs();
	},

/**/sessionList() {
		var gettingSessions = browser.sessions.getRecentlyClosed({
			maxResults: extension.settings.maxHistory
		});
		gettingSessions.then( extension.listMostRecent );
	},

/**/listMostRecent( sessionInfos ) {
		if( !sessionInfos.length ) {
			return;
		}
		tabsHistory.textContent = '';
		let currentHistory = document.createDocumentFragment();
		for( let sessionInfo of sessionInfos ) {
			
			let history = document.createElement( 'a' );

			var timestr = new Date( sessionInfo.tab.lastAccessed ).toLocaleDateString( locale , options );
			
			history.innerHTML = (sessionInfo.tab.title || browser.i18n.getMessage('Untitled')) + '<span class="timestamp">(' + browser.i18n.getMessage('LastVisit') + ': ' + timestr + ')</span>';
			history.setAttribute( 'href' , sessionInfo.tab.url );
			
			let favIconURL = sessionInfo.tab.favIconUrl;
					if( favIconURL && favIconURL != '' ) {
						history.style.backgroundImage = 'url("' + favIconURL + '")';
					} else {
						history.style.backgroundImage = 'url("../icons/icon-default.png")';
					}
			
			history.classList.add( 'switch-history' );
			currentHistory.appendChild( history );
			
		}
		tabsHistory.appendChild( currentHistory );
	}
};

/*******************************************************************************/

window.addEventListener( 'DOMContentLoaded' , extension.init );

browser.tabs.onRemoved.addListener( extension.updateList );
browser.tabs.onCreated.addListener( extension.updateList );
browser.tabs.onActivated.addListener( extension.updateList );
browser.tabs.onMoved.addListener( extension.updateList );
browser.tabs.onUpdated.addListener( extension.updateList );

document.addEventListener( 'click' , (e) => {
	if( e.target.classList.contains( 'switch-tabs' ) ) {
		var tabId = +e.target.getAttribute( 'href' );
		browser.tabs.query({
			currentWindow: true
		}).then( ( tabs ) => {
			for( var tab of tabs ) {
				if( tab.id === tabId ) {
					if(e.button === 0) {
						browser.tabs.update( tabId , {
							active: true
						});
					}
					if(e.button === 1) {
						browser.tabs.remove( tabId );
					}
					if(e.button === 2) {
						/* Hidden tabs are not automatically discarded: the code 
						running in them continues to run. However, it's 
						recommended that you should also discard hidden tabs, to 
						help manage memory and resource usage.
						https://developer.mozilla.org/en-US/Add-ons/WebExtensions/API/tabs/hide
						https://developer.mozilla.org/en-US/Add-ons/WebExtensions/API/tabs/discard
						*/
						browser.tabs.discard( tabId );
						/*
						It is only supported in Firefox and is disabled by default. 
						To enable it, visit about:config and set 
						"extensions.webextensions.tabhide.enabled" 
						to true.
						*/
						browser.tabs.hide( tabId );
					}
				}
			}
		});
	}
	if( e.target.classList.contains( 'switch-history' ) ) {
		var historyURL = e.target.getAttribute( 'href' );
		browser.tabs.create({
			url: historyURL
		});
	}
	e.preventDefault();
});

document.addEventListener( 'contextmenu' , (e) => {
	e.preventDefault();
});

createTab.addEventListener( 'click' , (e) => {
	browser.tabs.create({});
});

openOptions.addEventListener( 'click' , (e) => {
	browser.tabs.create({
		url: '../options/options.html'
	});
});

hideAllTabs.addEventListener( 'click' , (e) => {
	browser.tabs.query({
		currentWindow: true
	}).then( ( tabs ) => {
		for( var tab of tabs ) {
			browser.tabs.discard( tab.id );
			browser.tabs.hide( tab.id );
		}
	});
});

/*******************************************************************************/
/*
tabsList.classList.toggle('toggle');
var nIntervId;
 
    function changeColor() {
      nIntervId = setInterval(flashText, 1000);
    }
 
    function flashText() {
      var oElem = document.getElementById("my_box");
      oElem.style.color = oElem.style.color == "red" ? "blue" : "red";
    }
 
    function stopTextColor() {
      clearInterval(nIntervId);
    }
*/
//console.log(  );


