'use strict';

const optionMaxHistory = document.getElementById( 'option-maxHistory' );

const options = {
	async load() {
		const option = await browser.storage.local.get({
			maxHistory : 10
		});
		optionMaxHistory.value = option.maxHistory;
	}
};

document.addEventListener( 'DOMContentLoaded' , options.load );

optionMaxHistory.addEventListener( 'change' , (e) => {
	browser.storage.local.set( { maxHistory : e.target.value } );
});
