'use strict';

const options = { 
	localeMatcher: 'best fit',
	weekday: 'short', 
	year: 'numeric', 
	month: '2-digit', 
	day: 'numeric', 
	hour: '2-digit', 
	minute: '2-digit'
};

const locale = window.navigator.languages[0];

const tabsList = document.getElementById( 'tabs-list' );
const tabsHistory = document.getElementById( 'tabs-history' );
const openOptions = document.getElementById( 'options' );
const hideAllTabs = document.getElementById( 'hide-all-tabs' );
const deleteHistory = document.getElementById( 'delete-history' );
const createTab = document.getElementById( 'create-tab' );

/*******************************************************************************/

const extension = {

/**/settings: {},

/**/init() {
		extension.getStorage();
		extension.listTabs();
		extension.sessionList();
	},

/**/getStorage() {
		const getSettings = {
			async load() {
				const option = await browser.storage.local.get({
					maxHistory : 10
				});
				extension.settings.maxHistory = +option.maxHistory;
			}
		};
		let o = getSettings.load();
		/*
		o.then( () => {
			console.log( extension.settings.maxHistory );
		} );
		*/
	},

/**/getCurrentWindowTabs() {
		return browser.tabs.query( { currentWindow: true } );
	},

/**/listTabs() {
		extension.getStorage();
		extension.getCurrentWindowTabs().then( ( tabs ) => {
			
			
			tabs.sort( function( a , b ) { return (a.hidden > b.hidden) ? 1 : ( (b.hidden > a.hidden) ? -1 : 0 ); } );
			tabs.sort( function( a , b ) { return (a.discarded > b.discarded) ? 1 : ( (b.discarded > a.discarded) ? -1 : 0 ); } );
			tabs.sort( function( a , b ) { return (a.pinned < b.pinned) ? 1 : ( (b.pinned < a.pinned) ? -1 : 0 ); } );
			//console.clear();console.log(tabs);
/*
active: false
​​audible: false
​​discarded: true
​​height: 0
​​hidden: false
​​highlighted: false
​​id: 2
​​incognito: false
​​index: 0
​​isArticle: false
​​isInReaderMode: false
​​lastAccessed: 1526804894543
​​mutedInfo: Object { muted: false }
​​pinned: true
​​sharingState: Object { camera: false, microphone: false, screen: undefined }
​​status: "complete"
​​title: "Notifications | DeviantArt"
​​url: "https://www.deviantart.com/notifications/"
​​width: 0
​​windowId: 1
*/
			document.getElementById( 'tabs-count' ).textContent = ' (' + tabs.length + ' Tabs)';
			let currentTabs = document.createDocumentFragment();
			tabsList.textContent = '';
			for(let tab of tabs) {				
				let fragment_LI = document.createDocumentFragment();
				let li = document.createElement('li');
				
				let tabLink = document.createElement( 'span' );
				tabLink.innerHTML = tab.title || tab.id;
				tabLink.setAttribute( 'data-id' , tab.id );
				tabLink.classList.add( 'switch-tabs' );

				let favIconURL = tab.favIconUrl;
				if( favIconURL && favIconURL != '' && favIconURL.indexOf('chrome://') == -1 ) {
					tabLink.style.backgroundImage = 'url("' + favIconURL + '")';
				} else {
					tabLink.classList.add( 'default' );
				}
				
				if( tab.active ) {
					tabLink.classList.add( 'active' );
				}
				if( tab.discarded ) {
					tabLink.classList.add( 'discarded' );
				}	
				if( tab.hidden ) {
					tabLink.classList.add( 'hidden' );
				}
				
				if( tab.pinned ) {
					li.classList.add( 'pinned' );
				}

				let fragment_popup = document.createDocumentFragment();				

				let fragment_popupWrap = document.createDocumentFragment();
				let popupWrap = document.createElement('div');
				popupWrap.classList.add( 'popupWrap' );
				
				let btnHide = document.createElement( 'span' );
				btnHide.classList.add( 'btn' , 'button-hide' );
				btnHide.setAttribute( 'data-id' , tab.id );
				btnHide.setAttribute( 'title' , browser.i18n.getMessage('hideTab') );
				
				let btnClose = document.createElement( 'span' );
				btnClose.classList.add( 'btn' , 'button-close' );
				btnClose.setAttribute( 'data-id' , tab.id );
				btnClose.setAttribute( 'title' , browser.i18n.getMessage('closeTab') );
				
				let btnPin = document.createElement( 'span' );
				btnPin.classList.add( 'btn' , 'button-pin' );
				btnPin.setAttribute( 'data-id' , tab.id );
				btnPin.setAttribute( 'title' , browser.i18n.getMessage('pinTab') );
				
				let btnReload = document.createElement( 'span' );
				btnReload.classList.add( 'btn' , 'button-reload' );
				btnReload.setAttribute( 'data-id' , tab.id );
				btnReload.setAttribute( 'title' , browser.i18n.getMessage('reloadTab') );
				
				fragment_popup.appendChild( btnClose );
				fragment_popup.appendChild( btnPin );
				
				if( !tab.active && !tab.hidden ) {					
					fragment_popup.appendChild( btnHide );
				}
				if( tab.active ) {
					fragment_popup.appendChild( btnReload );
				}
				
				fragment_popup.appendChild( btnClose );
				
				popupWrap.appendChild( fragment_popup );
				fragment_popupWrap.appendChild( popupWrap );

				fragment_LI.appendChild( li ).appendChild( tabLink ).appendChild( fragment_popupWrap );

				currentTabs.appendChild( fragment_LI );

			}
			tabsList.appendChild( currentTabs );
		}).then( () => {
			extension.sessionList();
			window.top.scrollTo( 0 , 0 );
		});
	},

/**/updateList() {
		// https://bugzilla.mozilla.org/show_bug.cgi?id=1396758
		setTimeout( extension.listTabs , 200 );
		//extension.listTabs();
	},

/**/sessionList() {
		var gettingSessions = browser.sessions.getRecentlyClosed({
			maxResults: extension.settings.maxHistory
		});
		gettingSessions.then( extension.listMostRecent );
	},

/**/listMostRecent( sessionInfos ) {
		if( !sessionInfos.length ) {
			tabsHistory.textContent = '';
			return;
		}
		tabsHistory.textContent = '';
		let currentHistory = document.createDocumentFragment();
		for( let sessionInfo of sessionInfos ) {
			let fragment_LI = document.createDocumentFragment();
			let li = document.createElement('li');

			let history = document.createElement( 'span' );			

			history.textContent = sessionInfo.tab.title || browser.i18n.getMessage('Untitled');
			history.setAttribute( 'data-id' , sessionInfo.tab.sessionId );

			let favIconURL = sessionInfo.tab.favIconUrl;
			if( favIconURL && favIconURL != '' && favIconURL.indexOf('chrome://') == -1 ) {
				history.style.backgroundImage = 'url("' + favIconURL + '")';
			} else {
				history.classList.add( 'default' );
			}

			history.classList.add( 'switch-history' );

			let timestr = new Date( sessionInfo.tab.lastAccessed ).toLocaleDateString( locale , options );
			let timestamp = document.createElement( 'span' );
			timestamp.classList.add( 'timestamp' );
			timestamp.textContent = '(' + browser.i18n.getMessage('LastVisit') + ': ' + timestr + ')';

			history.appendChild( timestamp );

			let fragment_popup = document.createDocumentFragment();				

			let fragment_popupWrap = document.createDocumentFragment();
			let popupWrap = document.createElement('div');
			popupWrap.classList.add( 'popupWrap' );

			let btnClose = document.createElement( 'span' );
			btnClose.classList.add( 'btn' , 'button-close-session' );
			btnClose.setAttribute( 'data-id' , sessionInfo.tab.sessionId );
			btnClose.setAttribute( 'title' , browser.i18n.getMessage('closeSession') );

			fragment_popup.appendChild( btnClose );

			popupWrap.appendChild( fragment_popup );
			fragment_popupWrap.appendChild( popupWrap );

			fragment_LI.appendChild( li ).appendChild( history ).appendChild( fragment_popupWrap );

			currentHistory.appendChild( fragment_LI );

		}
		tabsHistory.appendChild( currentHistory );
	}

};

/*******************************************************************************/

window.addEventListener( 'DOMContentLoaded' , extension.init );

browser.tabs.onRemoved.addListener( extension.updateList );
browser.tabs.onCreated.addListener( extension.updateList );
browser.tabs.onActivated.addListener( extension.updateList );
browser.tabs.onMoved.addListener( extension.updateList );
browser.tabs.onUpdated.addListener( extension.updateList );

document.addEventListener( 'click' , (e) => {
	if( e.target.classList.contains( 'switch-tabs' ) ) {
		var tabId = +e.target.getAttribute( 'data-id' );
		extension.getCurrentWindowTabs().then( ( tabs ) => {
			for( var tab of tabs ) {
				if( tab.id === tabId ) {
					if(e.button === 0) {
						browser.tabs.update( tabId , {
							active: true
						});						
					}
					if(e.button === 1) {
						browser.tabs.remove( tabId );
					}
					if(e.button === 2) {
						/* Hidden tabs are not automatically discarded: the code 
						running in them continues to run. However, it's 
						recommended that you should also discard hidden tabs, to 
						help manage memory and resource usage.
						https://developer.mozilla.org/en-US/Add-ons/WebExtensions/API/tabs/hide
						https://developer.mozilla.org/en-US/Add-ons/WebExtensions/API/tabs/discard
						*/
						browser.tabs.discard( tabId );
						/*
						It is only supported in Firefox and is disabled by default. 
						To enable it, visit about:config and set 
						"extensions.webextensions.tabhide.enabled" 
						to true.
						*/
						browser.tabs.hide( tabId );
					}
				}
			}
		});
	}
	
	// Close Button
	if( e.target.classList.contains( 'button-close' ) ) {
		var tabId = +e.target.getAttribute( 'data-id' );
		browser.tabs.remove( tabId );
	}
	// Reload Button
	if( e.target.classList.contains( 'button-reload' ) ) {
		var tabId = +e.target.getAttribute( 'data-id' );
		browser.tabs.reload( tabId , { bypassCache: true } );
		browser.tabs.update( tabId, { pinned: true } );
	}
	// Hide Button
	if( e.target.classList.contains( 'button-hide' ) ) {
		var tabId = +e.target.getAttribute( 'data-id' );
		browser.tabs.discard( tabId );
		browser.tabs.hide( tabId );
	}
	// Pin Button
	if( e.target.classList.contains( 'button-pin' ) ) {
		var tabId = +e.target.getAttribute( 'data-id' );
		var querying = browser.tabs.query( { currentWindow: true } );
		querying.then( ( tabs ) => {
			var gettingInfo = browser.tabs.get( tabId );
			gettingInfo.then( ( info ) => {				
				if( info.pinned ) {
					browser.tabs.update( tabId, { pinned: false } );
				} else {
					browser.tabs.update( tabId, { pinned: true } );
				}
				
			});
		});
	}
	// Restore Button
	if( e.target.classList.contains( 'switch-history' ) ) {
		var historyID = e.target.getAttribute( 'data-id' );
		browser.sessions.restore( historyID );
	}
	
	// Close a session ID 
	if( e.target.classList.contains( 'button-close-session' ) ) {
		var historyID = e.target.getAttribute( 'data-id' );
		browser.sessions.getRecentlyClosed( {} )
		.then( (sessionInfos) => {
			for( let sessionTab of sessionInfos ) {
				if( sessionTab.tab.sessionId == historyID ) {
					browser.sessions.forgetClosedTab( sessionTab.tab.windowId, sessionTab.tab.sessionId );
				}				
			}
		}).then( () => { extension.sessionList(); } );
	}
	
	e.preventDefault();
});

document.addEventListener( 'contextmenu' , (e) => {
	e.preventDefault();
});

createTab.addEventListener( 'click' , (e) => {
	browser.tabs.create({});
});

openOptions.addEventListener( 'click' , (e) => {
	browser.tabs.create({
		url: '../options/options.html'
	});
});

hideAllTabs.addEventListener( 'click' , (e) => {
	extension.getCurrentWindowTabs().then( ( tabs ) => {
		for( var tab of tabs ) {
			if ( !tab.audible ) {
				browser.tabs.discard( tab.id );
				browser.tabs.hide( tab.id );
			}
		}
	});
});

deleteHistory.addEventListener( 'click' , (e) => {
	browser.sessions.getRecentlyClosed( {} )
	.then( (sessionInfos) => {
		for( let sessionTab of sessionInfos ) {
			browser.sessions.forgetClosedTab( sessionTab.tab.windowId, sessionTab.tab.sessionId );
		}		
	}).then( () => { extension.sessionList(); } );
});

/*******************************************************************************/

document.querySelectorAll( '.list-tab' ).forEach(
	function(currentValue, currentIndex) { 
		currentValue.addEventListener( 'click' , (e) => {
			document.querySelectorAll( '.list-tab' ).forEach(
				function(cv, ci) {
					cv.classList.remove( 'list-tab-active' );
				}
			);
			e.target.classList.add( 'list-tab-active' );
			let showTab = e.target.getAttribute( 'data' );
			document.querySelectorAll( '.list' ).forEach(
				function(cv, ci) {
					cv.classList.add( 'list-hide' );
				}
			);
			document.getElementById(showTab).classList.remove( 'list-hide' );
		});
	}
);

/*******************************************************************************/
//console.log(  );



