//vertical_addonbar.uc.js
//Right + Single column only
(function() {
    if (location != "chrome://browser/content/browser.xul") return;

    var toolbar = document.createElement("toolbar");
    toolbar.id = "vertical-toolbar";
    toolbar.setAttribute("customizable", "true");
    toolbar.setAttribute("mode", "icons");
    toolbar.setAttribute("context", "toolbar-context-menu");

    var toolbox = document.createElement("toolbox");
    toolbox.id = "vertical-toolbar-toolbox";
    var navToolBox = document.getElementById("navigator-toolbox");
    navToolBox.parentNode.insertBefore(toolbox, navToolBox.nextSibling);
    toolbox.appendChild(toolbar);
    CustomizableUI.registerArea("vertical-toolbar", {
        legacy: true
    });

    var contentDeck = document.getElementById("content-deck");

    toolbox.addEventListener("DOMMouseScroll", function(e) {
        var delta = Math.max(-1, Math.min(1, e.detail));
        toolbox.scrollLeft -= (delta*20); //Change this value if you find the vertical scrolling is too fast or too slow
        if (toolbox.style.width != contentDeck.clientHeight + "px") {
            toolbox.style.width = contentDeck.clientHeight + "px";
        }
        e.preventDefault();
    }, false);

    window.addEventListener("resize", function() {
        toolbox.style.width = contentDeck.clientHeight + "px";
    });

})();
