  
  //  Z_HideAndShow.uc.js
  
  //  Einfach die ein- bzw auszublendenden UI-IDs in das entsprechende Array eintragen.

 
  var HideAndShow_Status = 0;    // 0 = die Elemente sind unsichtbar, 1 = die Elemente sind sichtbar  
  var HideAndShow_Ids = ["bottom-toolbar", "vertical-toolbar-toolbox"];  

  (function() {

  if (location != 'chrome://browser/content/browser.xul') return;
	
		CustomizableUI.createWidget({
			id: 'HideAndShow-ToolBarButton',
			type: 'custom',
			defaultArea: CustomizableUI.AREA_NAVBAR,
			onBuild: function(aDocument) {			
				var toolbaritem = aDocument.createElementNS('http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul', 'toolbarbutton');
				var props = {
					id: 'HideAndShow-ToolBarButton',
					class: 'toolbarbutton-1 chromeclass-toolbar-additional',
					label: 'HideAndShow',
					tooltiptext: 'HideAndShow',
					style: 'list-style-image:  url(\'data:image/png;base64,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\')',
					onclick: 'HideAndShow_Func()'            
				};
				for (var p in props)
					toolbaritem.setAttribute(p, props[p]);
				return toolbaritem;
			}
		});
    
  HideAndShow_Func(); 
})();

function HideAndShow_Func() {
  
  if (HideAndShow_Status == 0) {
    if (document.getElementById("vertical-toolbar-toolbox")) {HideAndShow_FuncVertTabbarHelper(0)};  
    var c = HideAndShow_Ids.length;
    while ( c > 0) {
      c--;
      document.getElementById(HideAndShow_Ids[c]).hidden = true;
    }        
    document.getElementById("HideAndShow-ToolBarButton").style.listStyleImage = "url(\'data:image/png;base64,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\')";
    HideAndShow_Status = 1;
    return;  
  };

  if (HideAndShow_Status == 1) {
    if (document.getElementById("vertical-toolbar-toolbox")) {HideAndShow_FuncVertTabbarHelper(1)};  
    var c = HideAndShow_Ids.length;    
    while ( c > 0 ) {
      c--;
      document.getElementById(HideAndShow_Ids[c]).hidden = false;
    }
    document.getElementById("HideAndShow-ToolBarButton").style.listStyleImage = "url(\'data:image/png;base64,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\')";
    HideAndShow_Status = 0;
    return;
  };    
}


function HideAndShow_FuncVertTabbarHelper(onoff) {
  if (onoff == 1) {
    var sss = Cc['@mozilla.org/content/style-sheet-service;1'].getService(Ci.nsIStyleSheetService);
    var uri = makeURI('data:text/css;charset=UTF=8,' + encodeURIComponent(cssan));
    sss.loadAndRegisterSheet(uri, sss.AGENT_SHEET);
  };

  if (onoff == 0) {
    var sss = Cc['@mozilla.org/content/style-sheet-service;1'].getService(Ci.nsIStyleSheetService);
    var uri = makeURI('data:text/css;charset=UTF=8,' + encodeURIComponent(cssaus));
    sss.loadAndRegisterSheet(uri, sss.AGENT_SHEET);
  };
  
  
};


 //
 // dieses CSS wird benutzt um die vertikale Toolbar einzublenden
 // Quelle: https://github.com/tkhquang/userChrome.js/tree/master/Vertical%20Add-on%20Bar
 //

var cssan = `
:root {
  --vertical-toolbar-width: 34px;
  --vertical-toolbar-color: gray;
  --vertical-toolbar-space-height: 10px;
  --vertical-toolbar-icon-max-width: 24px; 
}

#content-deck {
  border-right: var(--vertical-toolbar-width) solid var(--vertical-toolbar-color) !important;
}
#main-window[inFullscreen="true"] #content-deck {
  border-right: 0 !important;
}

#main-window[inFullscreen="true"] #vertical-toolbar-toolbox {
  visibility: collapse !important;
}

#vertical-toolbar-toolbox  {
  direction: rtl !important;
  position: fixed !important;
  right: var(--vertical-toolbar-width) !important;
  height: var(--vertical-toolbar-width)!important;
  transform-origin: top right !important;
  transform: rotate(-90deg) !important;
  background-color: var(--vertical-toolbar-color) !important;
}

#vertical-toolbar {
  -moz-appearance: toolbar!important;
  display: inline-flex;
  padding-inline-start: var(--vertical-toolbar-space-height);
  height: var(--vertical-toolbar-width) !important;
}

#vertical-toolbar toolbarbutton {
  -moz-appearance: toolbarbutton!important;
  --toolbarbutton-inner-padding: 2px !important;
  transform: rotate(90deg) !important;
  transform-origin: 50% 50% !important;
  width: var(--vertical-toolbar-width) !important;
  margin-left: var(--vertical-toolbar-space-height) !important;
}

#vertical-toolbar toolbarbutton .toolbarbutton-icon {
  width: var(--vertical-toolbar-icon-max-width) !important;
  height: var(--vertical-toolbar-icon-max-width) !important;
  background-color: transparent !important;
}


#vertical-toolbar-toolbox {
  overflow: scroll!important;
}

#vertical-toolbar-toolbox scrollbar {
  display: none!important;
}`;

 
 //
 // dieses CSS wird benutzt um die vertikale Toolbar auszublenden
 // Quelle: https://github.com/tkhquang/userChrome.js/tree/master/Vertical%20Add-on%20Bar
 // Dieser Teil setzt einfach nur die Werte fr das Browser-Fenster zurck!
 //                     

var cssaus = `

#content-deck {
  border-right: initial !important;
}
#main-window[inFullscreen="true"] #content-deck {
  border-right: initial !important;
}

#main-window[inFullscreen="true"] #vertical-toolbar-toolbox {
  visibility: initial !important;
}
}`;