'use strict';

/* Options for date */
const options = { 
	localeMatcher: 'best fit',
	weekday: 'short', 
	year: 'numeric', 
	month: '2-digit', 
	day: 'numeric', 
	hour: '2-digit', 
	minute: '2-digit'
};

/* Locale for date */
const locale = window.navigator.languages[0];

/* HTML Elements */
const tabsList = document.getElementById( 'tabs-list' );
const tabsHistory = document.getElementById( 'tabs-history' );
const openOptions = document.getElementById( 'options' );
const hideAllTabs = document.getElementById( 'hide-all-tabs' );
const deleteHistory = document.getElementById( 'delete-history' );
const createTab = document.getElementById( 'create-tab' );
const exportList = document.getElementById( 'export-list' );
const autoHideBtn = document.getElementById( 'auto-hide' );

/* Vars for Auto Hide Function */
var setAutoHide;
var autoHideActive = 0;

/*******************************************************************************/

const extension = {

/* Init */
/**/init() {
		extension.getStorage();		
		extension.listTabs();
		extension.sessionList();		
	},

/* Get Options */
/**/getStorage() {
		const getSettings = {
			async load() {
				const option = await browser.storage.local.get({
					maxHistory : 10,
					theme: 'light-theme',
					noWrap: false,
					autoInterval: 5
				});
				extension.maxHistory = +option.maxHistory;
				extension.CSS = option.theme + '.css';
				extension.noWrap = option.noWrap;
				extension.autoInterval = +option.autoInterval;
			}
		};
		let o = getSettings.load();
		o.then( () => {
			extension.setCSS();
		} );
	},

/* Set href to themes */	
/**/setCSS() {
		const linkCSS = document.getElementsByTagName( 'link' );
		linkCSS[0].setAttribute( 'href' , extension.CSS );
	},

/* Helper function to replace HTML chars in tab titles */
/**/html_encode(string) {
		return string.replace(/&/g, "&amp;").replace(/>/g, "&gt;").replace(/</g, "&lt;").replace(/"/g, "&quot;");
	},

/* Helper function to create tab list */
/**/getCurrentWindowTabs() {
		return browser.tabs.query( { currentWindow: true } );
	},
	
/* Create tab list */
/**/listTabs() {
		extension.getStorage();
		extension.getCurrentWindowTabs().then( ( tabs ) => {
			tabs.sort( function( a , b ) { return (a.discarded > b.discarded) ? 1 : ( (b.discarded > a.discarded) ? -1 : 0 ); } );
			tabs.sort( function( a , b ) { return (a.hidden > b.hidden) ? 1 : ( (b.hidden > a.hidden) ? -1 : 0 ); } );
			tabs.sort( function( a , b ) { return (a.pinned < b.pinned) ? 1 : ( (b.pinned < a.pinned) ? -1 : 0 ); } );

			document.getElementById( 'tabs-count' ).textContent = ' (' + tabs.length + ' Tabs)';
			let currentTabs = document.createDocumentFragment();
			tabsList.textContent = '';
			for(let tab of tabs) {
				let fragment_LI = document.createDocumentFragment();
				let li = document.createElement('li');
				
				let tabLink = document.createElement( 'div' );
				tabLink.innerHTML = extension.html_encode(tab.title) || tab.id;
				tabLink.setAttribute( 'data-id' , tab.id );
				tabLink.setAttribute( 'title' , tab.url );
				tabLink.classList.add( 'switch-tabs' );
				
				if( extension.noWrap == true ) {
					tabLink.classList.add( 'no-wrap' );
				}

				let favIconURL = tab.favIconUrl;
				if( favIconURL && favIconURL != '' && favIconURL.indexOf('chrome://') == -1 ) {
					tabLink.style.backgroundImage = 'url("' + favIconURL + '")';
				} else {
					tabLink.classList.add( 'default' );
				}
				
				if( tab.active ) { 
					tabLink.classList.add( 'active' );
				}
				if( tab.discarded ) {
					tabLink.classList.add( 'discarded' );
				}	
				if( tab.hidden ) {
					tabLink.classList.add( 'hidden' );
				}				
				if( tab.pinned ) {
					li.classList.add( 'pinned' );
				}

				let fragment_popup = document.createDocumentFragment();				

				let fragment_popupWrap = document.createDocumentFragment();
				let popupWrap = document.createElement('div');
				popupWrap.classList.add( 'popupWrap' );
				
				let btnHide = document.createElement( 'span' );
				btnHide.classList.add( 'btn' , 'button-hide' );
				btnHide.setAttribute( 'data-id' , tab.id );
				btnHide.setAttribute( 'title' , browser.i18n.getMessage('hideTab') );
				
				let btnClose = document.createElement( 'span' );
				btnClose.classList.add( 'btn' , 'button-close' );
				btnClose.setAttribute( 'data-id' , tab.id );
				btnClose.setAttribute( 'title' , browser.i18n.getMessage('closeTab') );
				
				let btnPin = document.createElement( 'span' );
				btnPin.classList.add( 'btn' , 'button-pin' );
				btnPin.setAttribute( 'data-id' , tab.id );
				btnPin.setAttribute( 'title' , browser.i18n.getMessage('pinTab') );
				
				let btnReload = document.createElement( 'span' );
				btnReload.classList.add( 'btn' , 'button-reload' );
				btnReload.setAttribute( 'data-id' , tab.id );
				btnReload.setAttribute( 'title' , browser.i18n.getMessage('reloadTab') );
				
				fragment_popup.appendChild( btnClose );
				fragment_popup.appendChild( btnPin );
				
				if( !tab.active && !tab.hidden ) {					
					fragment_popup.appendChild( btnHide );
				}
				if( tab.active ) {
					fragment_popup.appendChild( btnReload );
				}
				
				fragment_popup.appendChild( btnClose );
				
				popupWrap.appendChild( fragment_popup );
				fragment_popupWrap.appendChild( popupWrap );

				fragment_LI.appendChild( li ).appendChild( tabLink ).appendChild( fragment_popupWrap );

				currentTabs.appendChild( fragment_LI );
			}
			tabsList.appendChild( currentTabs );
		}).then( () => {
			extension.sessionList();
			window.top.scrollTo( 0 , 0 );
		});
	},

/* Update tab list */
/**/updateList() {
		// https://bugzilla.mozilla.org/show_bug.cgi?id=1396758
		setTimeout( extension.listTabs , 200 );
		//extension.listTabs();
	},

/* Helper function to create chronicle list */
/**/sessionList() {
		var gettingSessions = browser.sessions.getRecentlyClosed({
			maxResults: extension.maxHistory
		});
		gettingSessions.then( extension.listMostRecent );
	},

/* Create chronicle list */
/**/listMostRecent( sessionInfos ) {
		if( !sessionInfos.length ) {
			tabsHistory.textContent = '';
			return;
		}
		tabsHistory.textContent = '';
		let currentHistory = document.createDocumentFragment();
		for( let sessionInfo of sessionInfos ) {
			let fragment_LI = document.createDocumentFragment();
			let li = document.createElement('li');

			let history = document.createElement( 'span' );			

			history.textContent = sessionInfo.tab.title || browser.i18n.getMessage('Untitled');
			history.setAttribute( 'data-id' , sessionInfo.tab.sessionId );
			history.setAttribute( 'title' , sessionInfo.tab.url );

			let favIconURL = sessionInfo.tab.favIconUrl;
			if( favIconURL && favIconURL != '' && favIconURL.indexOf('chrome://') == -1 ) {
				history.style.backgroundImage = 'url("' + favIconURL + '")';
			} else {
				history.classList.add( 'default' );
			}

			history.classList.add( 'switch-history' , 'restore-history' ); 
			if( extension.noWrap == true ) {
				history.classList.add( 'no-wrap' );
			}

			let timestr = new Date( sessionInfo.tab.lastAccessed ).toLocaleDateString( locale , options );
			let timestamp = document.createElement( 'span' );
			timestamp.classList.add( 'timestamp' , 'restore-history' );
			timestamp.textContent = '(' + browser.i18n.getMessage('LastVisit') + ': ' + timestr + ')';

			history.appendChild( timestamp );

			let fragment_popup = document.createDocumentFragment();				

			let fragment_popupWrap = document.createDocumentFragment();
			let popupWrap = document.createElement('div');
			popupWrap.classList.add( 'popupWrap' );

			let btnClose = document.createElement( 'span' );
			btnClose.classList.add( 'btn' , 'button-close-session' );
			btnClose.setAttribute( 'data-id' , sessionInfo.tab.sessionId );
			btnClose.setAttribute( 'title' , browser.i18n.getMessage('closeSession') );

			fragment_popup.appendChild( btnClose );

			popupWrap.appendChild( fragment_popup );
			fragment_popupWrap.appendChild( popupWrap );

			fragment_LI.appendChild( li ).appendChild( history ).appendChild( fragment_popupWrap );

			currentHistory.appendChild( fragment_LI );
		}
		tabsHistory.appendChild( currentHistory );
	},
	
/* Auto-Hide function */
/**/autoHide() {
		extension.getCurrentWindowTabs().then( ( tabs ) => {
			let autoInterval = extension.autoInterval * 60000;
			let currentTime = Date.now();
			for( var tab of tabs ) {
				let dif = currentTime - tab.lastAccessed;
				if ( (dif > autoInterval) && !tab.active && !tab.hidden && !tab.audible ) {
					browser.tabs.discard( tab.id );
					browser.tabs.hide( tab.id );
				}
			}
		});
	}
};

/*******************************************************************************/
/* Tab listener */
browser.tabs.onRemoved.addListener( extension.updateList );
browser.tabs.onCreated.addListener( extension.updateList );
browser.tabs.onActivated.addListener( extension.updateList );
browser.tabs.onMoved.addListener( extension.updateList );
browser.tabs.onUpdated.addListener( extension.updateList );

/* Click event */
document.addEventListener( 'click' , (e) => {
/* Tabs */
	var dataID = +e.target.getAttribute( 'data-id' );
	if( e.target.classList.contains( 'switch-tabs' ) ) {
		extension.getCurrentWindowTabs().then( ( tabs ) => {
			for( var tab of tabs ) {
				if( tab.id === dataID ) {
					if(e.button === 0) {
						browser.tabs.update( dataID , {
							active: true
						});//.then( () => { window.close(); });					
					}
					if(e.button === 1) {
						browser.tabs.remove( dataID );
					}
					if(e.button === 2) {
						browser.tabs.discard( dataID );
						browser.tabs.hide( dataID );
					}
				}
			}
		});		
	}
	// Close Button
	if( e.target.classList.contains( 'button-close' ) ) {
		browser.tabs.remove( dataID );
	}
	// Reload Button
	if( e.target.classList.contains( 'button-reload' ) ) {
		browser.tabs.reload( dataID , { bypassCache: true } );
		browser.tabs.update( dataID, { pinned: true } );
	}
	// Hide Button
	if( e.target.classList.contains( 'button-hide' ) ) {
		browser.tabs.discard( dataID );
		browser.tabs.hide( dataID );
	}
	// Pin Button
	if( e.target.classList.contains( 'button-pin' ) ) {
		var querying = browser.tabs.query( { currentWindow: true } );
		querying.then( ( tabs ) => {
			var gettingInfo = browser.tabs.get( dataID );
			gettingInfo.then( ( tab ) => {				
				if( tab.pinned ) {
					browser.tabs.update( dataID, { pinned: false } );
				} else {
					browser.tabs.update( dataID, { pinned: true } );
				}
				
			});
		});
	}
	
/* Chronicle */
	var historyID = e.target.getAttribute( 'data-id' );
	
	// Restore Button
	if( e.target.classList.contains( 'restore-history' ) ) {		
		browser.sessions.restore( historyID );
	}	
	// Close a session ID 
	if( e.target.classList.contains( 'button-close-session' ) ) {
		browser.sessions.getRecentlyClosed( {} )
		.then( (sessionInfos) => {
			for( let sessionTab of sessionInfos ) {
				if( sessionTab.tab.sessionId == historyID ) {
					browser.sessions.forgetClosedTab( sessionTab.tab.windowId, sessionTab.tab.sessionId );
				}				
			}
		}).then( () => { extension.sessionList(); } );
	}
	
	e.preventDefault();
});

/* Prevent right click event */
document.addEventListener( 'contextmenu' , (e) => {
	e.preventDefault();
});

// New Tab
createTab.addEventListener( 'click' , (e) => {
	browser.tabs.create({});
});

// Extension > Options
openOptions.addEventListener( 'click' , (e) => {
	browser.tabs.create({
		url: '../options/options.html'
	});
});

// Extension > Export HTML/CSV List
exportList.addEventListener( 'click' , (e) => {
	browser.tabs.create({
		url: '../content/content.html'
	});
});

// Hide all tabs (if possible)
hideAllTabs.addEventListener( 'click' , (e) => {
	extension.getCurrentWindowTabs().then( ( tabs ) => {
		for( var tab of tabs ) {
			if ( !tab.audible ) {
				browser.tabs.discard( tab.id );
				browser.tabs.hide( tab.id );
			}
		}
	});
});

// Delete chronic, complete
deleteHistory.addEventListener( 'click' , (e) => {
	browser.sessions.getRecentlyClosed( {} )
	.then( (sessionInfos) => {
		for( let sessionTab of sessionInfos ) {
			browser.sessions.forgetClosedTab( sessionTab.tab.windowId, sessionTab.tab.sessionId );
		}		
	}).then( () => { extension.sessionList(); } );
});

// Toggle Auto-Hide
autoHideBtn.addEventListener( 'click' , (e) => {
	if( autoHideActive == 0 ) {
		setAutoHide = setInterval( extension.autoHide , 60000 );
		autoHideActive = 1;
		e.target.classList.add( 'auto-hide-active' );
	} else {
		clearInterval( setAutoHide );
		autoHideActive = 0;
		e.target.classList.remove( 'auto-hide-active' );
	}
});

/*******************************************************************************/
// Toggle Tabs/Chronic
document.querySelectorAll( '.list-tab' ).forEach(
	function(currentValue, currentIndex) { 
		currentValue.addEventListener( 'click' , (e) => {
			document.querySelectorAll( '.list-tab' ).forEach(
				function(cv, ci) {
					cv.classList.remove( 'list-tab-active' );
				}
			);
			e.target.classList.add( 'list-tab-active' );
			let showTab = e.target.getAttribute( 'data' );
			document.querySelectorAll( '.list' ).forEach(
				function(cv, ci) {
					cv.classList.add( 'list-hide' );
				}
			);
			document.getElementById(showTab).classList.remove( 'list-hide' );
		});
	}
);

/*******************************************************************************/

window.addEventListener( 'DOMContentLoaded' , extension.init );

/*******************************************************************************/
//console.log(  );
/*

*/