﻿
document.addEventListener('DOMContentLoaded', init);    

var PopupIconWarn = {
  24: "../../icons/icon_r_24.png",
  32: "../../icons/icon_r_32.png",
  48: "../../icons/icon_r_48.png",
  64: "../../icons/icon_r_64.png"
}
var PopupIconNorm = {
  24: "../../icons/icon_b_24.png",
  32: "../../icons/icon_b_32.png",
  48: "../../icons/icon_b_48.png",
  64: "../../icons/icon_b_64.png"
}
var PopupIconOk = {
  24: "../../icons/icon_g_24.png",
  32: "../../icons/icon_g_32.png",
  48: "../../icons/icon_g_48.png",
  64: "../../icons/icon_g_64.png"
}

  function init(){
    function logTabs(tabs) {
    let tab = tabs[0]; // Safe to assume there will only be one result
      console.log(tab);
      console.log(tab.url);
      var url = new URL(tab.url);
      getID("PWGenPoupFormTableDomain").value = url.hostname;
    }
    
    function onError(err){
      console.error(err);
    }
    browser.tabs.query({currentWindow: true, active: true}).then(logTabs, onError);    


    getID("PWGenPoupFormTableErzeugen").addEventListener("click", createPw);
    getID("PWGenPoupFormTableMasterPW").addEventListener("change", createPw);       // egal ob per Mausklick auf Erzeugen oder per Enter in den Input-Feldern,
    getID("PWGenPoupFormTableDomain").addEventListener("change", createPw);         // immer versuchen das PW zu erzeugen; Vorteil: Enter führt automatisch zum 
    getID("PWGenPoupFormTableBenutzer").addEventListener("change", createPw);       // nächsten Input-Feld das noch leer ist oder erzeugt das PW, welches direkt per
    getID("PWGenPoupFormTablePWKopieren").addEventListener("click", copyPw);        // Enter in die Zwischenablage übernommen werden kann                                                                                        
    };

  function createPw() {
  var Master = getID("PWGenPoupFormTableMasterPW").value;
  if (Master == "") {
    getID("PWGenPoupFormTableMasterPW").style.background = "red"; 
    getID("PWGenPopupHinweis").innerHTML = "-- Masterpasswort fehlt! --";
    browser.browserAction.setIcon({path: PopupIconWarn});
    getID("PWGenPoupFormTableMasterPW").focus(); 
    return
  }
  else {
    getID("PWGenPoupFormTableMasterPW").style.background = "";
    getID("PWGenPopupHinweis").innerHTML = "";
    browser.browserAction.setIcon({path: PopupIconNorm});
  }; 
  var Domain = getID("PWGenPoupFormTableDomain").value;
  if (Domain == "") {
    getID("PWGenPoupFormTableDomain").style.background = "red";
    getID("PWGenPopupHinweis").innerHTML = "-- Domain fehlt! --";
    browser.browserAction.setIcon({path: PopupIconWarn});
    getID("PWGenPoupFormTableDomain").focus(); 
    return
  }
  else {
    getID("PWGenPoupFormTableDomain").style.background = "";
    getID("PWGenPopupHinweis").innerHTML = "";
    browser.browserAction.setIcon({path: PopupIconNorm});
  };
  var Benutzer = getID("PWGenPoupFormTableBenutzer").value;
  if (Benutzer == "") {
    getID("PWGenPoupFormTableBenutzer").style.background = "red";
    browser.browserAction.setIcon({path: PopupIconWarn});
    getID("PWGenPopupHinweis").innerHTML = "-- Benutzer fehlt! --"; 
    getID("PWGenPoupFormTableBenutzer").focus(); 
    return
  }
  else {
    getID("PWGenPoupFormTableBenutzer").style.background = "";
    getID("PWGenPopupHinweis").innerHTML = "";
    browser.browserAction.setIcon({path: PopupIconNorm});
  };
  var Nummer = getID("PWGenPoupFormTableNummer").value; 
  var Laenge = getID("PWGenPoupFormTablePWLaenge").value; 
  var pw = Hash(Master+Domain+Benutzer+Nummer);   
  document.getElementById("PWGenPoupFormTableAusgabe").value = pw.substring(0,Laenge);
  browser.browserAction.setIcon({path: PopupIconOk});
  getID("PWGenPoupFormTablePWKopieren").focus();                  // PW erzeugt, also focus auf den Kopier-Button
  };

  function copyPw() {
    if (getID("PWGenPoupFormTableAusgabe").value == "") {
      browser.browserAction.setIcon({path: PopupIconWarn});
      getID("PWGenPoupFormTableAusgabe").style.background = "red";
      getID("PWGenPopupHinweis").innerHTML = "-- kein Passwort zum Kopieren vorhanden! --"
      return;;
    }
    else {
      browser.browserAction.setIcon({path: PopupIconNorm});
      getID("PWGenPoupFormTableAusgabe").style.background = "";
      getID("PWGenPopupHinweis").innerHTML = "";    
    };
    getID("PWGenPoupFormTableAusgabe").select();                // Ausgabe markieren,
    document.execCommand("copy");                               // in die Zwischenablage kopieren,
    browser.browserAction.setIcon({path: PopupIconOk});         // Icon Modus "OK",                                             
    window.close();                                             // Popup schliessen...      
  }