'use strict';

/* HTML Element */
const optionColor = document.getElementById( 'option-color' );

/* Get Options */
const options = {
	async load() {
		const option = await browser.storage.local.get({
			optColor : '#00ff00'
		});
		/* Set Value to HTML Element */
		optionColor.value = option.optColor;
	}
};

/* Element Listener > if color changed in option.html set value to storage */
optionColor.addEventListener( 'change' , (e) => {
	browser.storage.local.set( { optColor : e.target.value } );
});


document.addEventListener( 'DOMContentLoaded' , options.load );