'use strict';

var defaultSign = '✨';

/* HTML Element */
const optionSign = document.getElementById( 'option-sign' );

/* Get Options */
const options = {
	async load() {
		const option = await browser.storage.local.get({
			sign : defaultSign
		});
		if( option.sign == '' ) { option.sign = defaultSign; }
		optionSign.value = option.sign;
	}
};

optionSign.addEventListener( 'change' , (e) => {
	browser.storage.local.set( { sign : e.target.value } );
});


document.addEventListener( 'DOMContentLoaded' , options.load );