'use strict';

var defaultSign = '✨';

/* HTML Element */
const optionSign = document.getElementById( 'option-sign' );
const selectSign = document.getElementById( 'select-sign' );

/* Get Options */
const options = {
	async load() {
		const option = await browser.storage.local.get({
			sign : defaultSign
		});
		if( option.sign == '' ) { option.sign = defaultSign; }
		optionSign.value = option.sign;
	}
};

optionSign.addEventListener( 'change' , (e) => {
	browser.storage.local.set( { sign : e.target.value } );
});


selectSign.addEventListener( 'change' , (e) => {
	optionSign.value = e.target.value;
	browser.storage.local.set( { sign : e.target.value } );
	e.target.size = 1;
	e.target.blur();
});

selectSign.addEventListener( 'focus' , (e) => {
	e.target.size = 7;
});

selectSign.addEventListener( 'blur' , (e) => {
	e.target.size = 1;
});

document.addEventListener( 'DOMContentLoaded' , options.load );