/* ***** BEGIN LICENSE BLOCK *****
 *
 * This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
 * If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.
 *
 * ***** END LICENSE BLOCK ***** */

const Ci = Components.interfaces;
Components.utils.import("resource://gre/modules/Services.jsm");
Components.utils.import("resource:///modules/sessionstore/SessionStore.jsm");
Components.utils.import("resource://gre/modules/osfile.jsm");
Components.utils.import("chrome://verticaltabsreloaded/content/NewTabURL.jsm");
// Components.utils.import("resource:///modules/OpenInTabsUtils.jsm"); // for quantum new tab button etc.
// Components.utils.import("resource:///modules/UrlbarUtils.jsm");  // for quantum new tab button etc.
sss = Components.classes["@mozilla.org/content/style-sheet-service;1"].getService(Ci.nsIStyleSheetService);
Components.utils.import('resource://gre/modules/PageThumbUtils.jsm');

var wait = ms => new Promise((r, j) => setTimeout(r, ms));
// Modules
//var { VerticalTabsReloaded } = require("./lib/verticaltabs.js");


var WindowListener = {
	setupBrowserUI: function (window) {

		// Take any steps to add UI or anything to the browser window
		// document.getElementById() etc. will work here
	},

	tearDownBrowserUI: function (window) {
		let document = window.document;

		// Take any steps to remove UI or anything from the browser window
		// document.getElementById() etc. will work here
	},

	// nsIWindowMediatorListener functions
	onOpenWindow: function (xulWindow) {
		console.log(xulWindow);

		// A new window has opened
		let domWindow = xulWindow.QueryInterface(Ci.nsIInterfaceRequestor)
			.getInterface(Ci.nsIDOMWindow);

		// Wait for it to finish loading
		domWindow.addEventListener("load", function listener() {
			domWindow.removeEventListener("load", listener, false);

			// If this is a browser window then setup its UI
			if (domWindow.document.documentElement.getAttribute("windowtype") == "navigator:browser")
				Services.obs.addObserver(function observe_BrowserWindow_startup(win, topic) {
					if (win != domWindow) {
						return;
					}
					console.log("browser-delayed-startup-finished");
					Services.obs.removeObserver(observe_BrowserWindow_startup, topic);
					initialize_window(domWindow);
				}, "browser-delayed-startup-finished");
		}, false);
	},

	onCloseWindow: function (xulWindow) {
		let domWindow = xulWindow.QueryInterface(Ci.nsIInterfaceRequestor)
			.getInterface(Ci.nsIDOMWindow);
		deinitialize_window(domWindow);

	},

	onWindowTitleChange: function (xulWindow, newTitle) {}
};

function startup(data, reason) {
	// Initialize VerticalTabsReloaded object for each window.
	let enumerator = Services.wm.getEnumerator("navigator:browser");
	while (enumerator.hasMoreElements()) {
		let win = enumerator.getNext();
		initialize_window(win);
	};
	Services.wm.addListener(WindowListener);
}
function shutdown(data, reason) {
	// When the application is shutting down we normally don't have to clean
	// up any UI changes made
	if (reason == APP_SHUTDOWN)
		return;

	// Get the list of browser windows already open
	let enumerator = Services.wm.getEnumerator("navigator:browser");
	while (enumerator.hasMoreElements()) {
		let win = enumerator.getNext();
		deinitialize_window(win);

	}

	// Stop listening for any new browser windows to open
	Services.wm.removeListener(WindowListener);
}

//------------------------------------------------------------------------------------------


var GLOBAL_SCOPE = {};

var webextPreferences = {
	"width": 252,
	"left": false,
	"compact": false,
	"style.tab.status": true,
	"theme": "light",
	"showHiddenSettings": true,
	"meta.options.time.lastsaved": 1542626170,
	"runtime.vtr.installedVersion": "0.11.0",
	"toggleDisplayHotkey": "Ctrl+Shift+V",
	"hideInFullscreen": true
}
function initialize_window(window) {
	
	
	
	window.BrowserOpenTab    = function (event)  {
	
	console.log("BLIDDDDDD");
	console.log(event);
  // A notification intended to be useful for modular peformance tracking
  // starting as close as is reasonably possible to the time when the user
  // expressed the intent to open a new tab.  Since there are a lot of
  // entry points, this won't catch every single tab created, but most
  // initiated by the user should go through here.
  Services.obs.notifyObservers(null, "browser-open-newtab-start");

  let where = "tab";
  let relatedToCurrent = false;

  if (event) {
    where = window.whereToOpenLink(event, false, true);

    switch (where) {
      case "tab":
      case "tabshifted":
        // When accel-click or middle-click are used, open the new tab as
        // related to the current tab.
        relatedToCurrent = true;
        break;
      case "current":
        where = "tab";
        break;
    }
  }

  window.openUILinkIn(BROWSER_NEW_TAB_URL, where, { relatedToCurrent });
}
	
	
	
	
	
	
	
	//let windowID = window.QueryInterface(Ci.nsIInterfaceRequestor).getInterface(Ci.nsIDOMWindowUtils).outerWindowID;
	new VerticalTabsReloaded(window, webextPreferences);
}

function deinitialize_window(window) {
	//let windowID = window.QueryInterface(Ci.nsIInterfaceRequestor).getInterface(Ci.nsIDOMWindowUtils).outerWindowID;
	window.VerticalTabsReloaded.unload();
}

const NS_XUL = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";
const TAB_DROP_TYPE = "application/x-moz-tabbrowser-tab";

/* Object injected for every window */

class VerticalTabsReloaded {
	constructor(window, webExtPreferences) {
		this.window = window;
		this.document = window.document;
		this.webExtPreferences = webExtPreferences;
		this.changedDisplayState = false;
		this.unloaders = [];
		this.init();
	}

	init() {
		this.window.VerticalTabsReloaded = this;
		this.unloaders.push(function () {
			delete this.window.VerticalTabsReloaded;
		});

		this.rearrangeUI();
		this.initEventListeners();
		this.window.messageManager.loadFrameScript('chrome://verticaltabsreloaded/content/framescript.js', true);
		this.window.messageManager.addMessageListener("tabCenterUltimate@Ulf3000:my-e10s-extension-message", this.listener);
		//remove smoothscroll
		
		
		
	}
	
	async listener(message) {
		console.log(message);
		let win =  message.target.ownerGlobal;
		let tab = win.gBrowser.getTabForBrowser(message.target);
		let img = await win.document.getAnonymousElementByAttribute(tab, 'anonid', 'tab-meta-image');
		//console.log(tab.__tabThumbnailRR);
		//img.src = "";
		img.src = message.data;
		//console.log(tab.__tabThumbnailRR);
		SessionStore.setTabValue(tab, "ThumbNail_HT", message.data);
	}
	
	
	
	
	
	preferences(settingName) {
		// this.debugOutput(settingName + " (sdk lib): " + this.webExtPreferences[settingName]);
		return this.webExtPreferences[settingName];
	}

	installStylesheet(uri) {
		var uriN = Services.io.newURI(uri, null, null);
		sss.loadAndRegisterSheet(uriN, sss.USER_SHEET);
		// this.debugOutput(uri);
	}

	removeStylesheet(uri) {
		let uriN = Services.io.newURI(uri, null, null);
		sss.unregisterSheet(uriN, sss.USER_SHEET);
		// this.debugOutput(uri);
	}
	
	setTabValue(aTab, attr, value){
		try{
			SessionStore.setTabValue(aTab, attr, value);
		}catch(err){
			console.log("SessionSTore  FF QUANTUM");
		}
		try{
			SessionStore.setCustomTabValue(aTab, attr, value);
		}catch(err){
			console.log("SessionSTore  FF WATERFOX");
		}
	}
	
	setTabAttribs(aTab, attr, value){
		aTab.setAttribute(attr, value);
		aTab[attr] = value;
		this.setTabValue(aTab, attr, value.toString());
	}
	rearrangeUI() {
		
		const window = this.window;
		const document = this.document;
		let mainWindow = document.getElementById('main-window');
		// Ugly workaround: save the label of the first tab for later…
		let tabs = document.getElementById("tabbrowser-tabs");
		let label = tabs.firstChild.label;

		// Injecting CSS and init gruesome XBL binding
		this.installStylesheet("chrome://verticaltabsreloaded/content/skin/index.css");
		// Move the bottom stuff (findbar, addonbar, etc.) in with the
		// tabbrowser.  That way it will share the same (horizontal)
		// space as the browser.  In other words, the bottom stuff no
		// longer extends across the whole bottom of the window.
		let contentbox = document.getElementById("appcontent");
		let bottom = document.getElementById("browser-bottombox");
		contentbox.appendChild(bottom);

		// Create a box next to the app content. It will hold the tab
		// bar and the tab toolbar.
		let browserbox = document.getElementById("browser");
		let leftbox = document.createElementNS(NS_XUL, "vbox");
		leftbox.setAttribute("ordinal", "6");
		leftbox.id = "verticaltabs-box";

		browserbox.insertBefore(leftbox, contentbox.nextSibling);

		let splitter = document.createElementNS(NS_XUL, "splitter");
		splitter.id = "verticaltabs-splitter";
		splitter.className = "chromeclass-extrachrome";
		splitter.setAttribute("ordinal", "5");
		browserbox.insertBefore(splitter, leftbox);
		// Hook up event handler for splitter so that the width of the
		// tab bar is persisted.
		splitter.addEventListener("mouseup", this, false);

		// Move the tabs next to the app content, make them vertical,

		if (this.preferences("left")) {
			browserbox.dir = "reverse";
		}

		tabs.setAttribute("data-vertical", true);
		leftbox.insertBefore(tabs, leftbox.firstChild);
		tabs.orient = "vertical";
		let arrowScrollbox;
		
		try{
			arrowScrollbox = window.gBrowser.tabContainer.arrowScrollbox //ff65
		}catch(err){ 
			
		}
		if (!arrowScrollbox)
		try{
			arrowScrollbox = window.gBrowser.tabContainer.mTabstrip; //ff56
		}catch(err){ 
			
		}
		
		arrowScrollbox.orient = "vertical"
		tabs.tabbox.orient = "horizontal"; // probably not necessary
		
		arrowScrollbox._smoothScroll = false;
		//this.window.gBrowser.animationsEnabled = false;
		
		// Move the tabs toolbar into the tab strip
		let toolbar = document.getElementById("TabsToolbar");
		toolbar.setAttribute("collapsed", "false"); // no more vanishing new tab toolbar
		toolbar._toolbox = null; // reset value set by constructor
		toolbar.setAttribute("toolboxid", "navigator-toolbox");

		if (this.preferences("tabtoolbarPosition") == "top") {
			leftbox.insertBefore(toolbar, leftbox.firstChild);
		} else {
			leftbox.appendChild(toolbar);
		}

		//------------ FILTERBOX -------------

		let filterBox = document.createElement("textbox");
		filterBox.setAttribute("id", "filterBox");
		filterBox.setAttribute("type", "search");
		filterBox.setAttribute("timeout", "500");
		filterBox.setAttribute("enablehistory", true);
		filterBox.addEventListener("command", this.filterAddons, false);
		toolbar.appendChild(filterBox);

		//------------NEW TAB BUTTON--CLICK-------------
		let new_tab_button = document.getElementById("new-tab-button");
		new_tab_button.removeAttribute("command");
		new_tab_button.removeAttribute("oncommand");
		new_tab_button.removeAttribute("removable");
		new_tab_button.removeAttribute("onclick");
		new_tab_button.removeAttribute("onmouseover");
		new_tab_button.removeAttribute("onmouseout");
		new_tab_button.setAttribute("context", "");
		new_tab_button.setAttribute("tooltiptext", "LeftClick = New Tab at the End; MiddleClick = New Child Tab; RightClick = New Sibling Tab");
		//new_tab_button.setAttribute("oncommand", 'VerticalTabsReloaded.openNewTab();');
		new_tab_button.addEventListener("click", this.openNewTab, false);

		//------------NEW TAB BUTTON--DRAG OVER-------------
		// let origButtonObserver = this.window.newWindowButtonObserver; for unloader!!!!
		let newTabButtonObserver = {
			onDragOver(aEvent) {
				window.browserDragAndDrop.dragOver(aEvent);
			},
			onDragExit(aEvent) {},
			async onDrop(aEvent) {
				let shiftKey = aEvent.shiftKey;
				let altKey = aEvent.altKey;
				let links = window.browserDragAndDrop.dropLinks(aEvent);
				let triggeringPrincipal = window.browserDragAndDrop.getTriggeringPrincipal(aEvent);

				/* 				if (links.length >= Services.prefs.getIntPref("browser.tabs.maxOpenBeforeWarn")) {
				// Sync dialog cannot be used inside drop event handler.
				let answer = await OpenInTabsUtils.promiseConfirmOpenInTabs(links.length,
				window);
				if (!answer) {
				return;
				}
				}
				 */
				let selectedIndentFactor = window.gBrowser.selectedTab.__indentFactor;
				let indentFactor = selectedIndentFactor + 1 || 0;
				if (indentFactor > 10) // max indent factor
					indentFactor = 10;
				if (indentFactor == "NaN")
					indentFactor = 0;

				let i = 0;
				let moveTo = window.gBrowser.selectedTab._tPos + i;
				if (altKey) {
					let newTab = window.gBrowser.addTab("about:blank");
					newTab.newTab = true;
					newTab.setAttribute("indentFactor", 0);
					newTab.__indentFactor = 0;

					SessionStore.setTabValue(newTab, "indentFactor", "0");
					moveTo = newTab._tPos + 1;
					indentFactor = 1;
					newTab.click();
					newTab.setAttribute("label", "📥📥📥"); // TODO too early , put later
				}

				for (let link of links) {
					if (link.url) {
						i++;
						let data = await window.getShortcutOrURIAndPostData(link.url);
						// Allow third-party services to fixup this URL.
						console.log(data.url);
						//let newTab = window.openNewTabWith(data.url, null, data.postData, aEvent, true);
						let newTab = window.gBrowser.addTab(data.url, {
								// TODO fix allowInheritPrincipal
								// (this is required by javascript: drop to the new window) Bug 1475201
								allowInheritPrincipal: true,
								postData: data.postData,
								allowThirdPartyFixup: true,
								triggeringPrincipal,
								createLazyBrowser: true,
								skipAnimation: true,
							});
						newTab.setAttribute("indentFactor", indentFactor);
						newTab.__indentFactor = indentFactor;
						newTab.newTab = true;
						SessionStore.setTabValue(newTab, "indentFactor", indentFactor.toString());
						window.gBrowser.moveTabTo(newTab, moveTo)
						moveTo++;
					}
				}
			}
		};
		this.window.newTabButtonObserver = newTabButtonObserver;

		
		
		
		//------------------PIN BUTTON !!!----------------------------------
		
		mainWindow.tabspinned = true;
		mainWindow.setAttribute('tabspinned', mainWindow.tabspinned);
		let pin_button = document.createElement("toolbarbutton");
		pin_button.setAttribute("id", "pin-button");
		pin_button.onclick = function (event) {
			mainWindow.tabspinned = mainWindow.tabspinned == 'true' ? 'false' : 'true';
			mainWindow.setAttribute('tabspinned', mainWindow.tabspinned);
		}
		toolbar.appendChild(pin_button);

		//-------------- CONTEXT MENU -------------------------

		let tabContextMenu = window.document.getElementById("tabContextMenu");

		let sanitizeTreeItem = window.document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "menuitem");
		sanitizeTreeItem.setAttribute("id", "contexttab-sanitizeTree");
		sanitizeTreeItem.setAttribute("label", "Sanitize Tree");
		tabContextMenu.appendChild(sanitizeTreeItem);
		sanitizeTreeItem.setAttribute("oncommand", "VerticalTabsReloaded.sanitizeTree();");

		//---------KEYSETS----------//

		let mainKeyset = window.document.getElementById("mainKeyset");
		let moveTabLeftKey = window.document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "key");
		moveTabLeftKey.setAttribute("id", "moveTabLeftKey");
		moveTabLeftKey.setAttribute("modifiers", "accel,alt");
		moveTabLeftKey.setAttribute("keycode", "VK_LEFT");
		//moveTabLeftKey.setAttribute("key", "a")
		mainKeyset.appendChild(moveTabLeftKey);
		moveTabLeftKey.setAttribute("oncommand", 'VerticalTabsReloaded.moveTabLeft();');

		let moveTabRightKey = window.document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "key");
		moveTabRightKey.setAttribute("id", "moveTabRightKey");
		moveTabRightKey.setAttribute("modifiers", "accel,alt");
		moveTabRightKey.setAttribute("keycode", "VK_RIGHT");
		//moveTabLeftKey.setAttribute("key", "d")
		mainKeyset.appendChild(moveTabRightKey);
		moveTabRightKey.setAttribute("oncommand", 'VerticalTabsReloaded.moveTabRight();');

		let moveSingleTabLeftKey = window.document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "key");
		moveSingleTabLeftKey.setAttribute("id", "moveSingleTabLeftKey");
		moveSingleTabLeftKey.setAttribute("modifiers", "control,alt");
		moveSingleTabLeftKey.setAttribute("keycode", "VK_LEFT");
		mainKeyset.appendChild(moveSingleTabLeftKey);
		moveSingleTabLeftKey.setAttribute("oncommand", 'VerticalTabsReloaded.moveSingleTabLeft();');

		let moveSingleTabRightKey = window.document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "key");
		moveSingleTabRightKey.setAttribute("id", "moveSingleTabRightKey");
		moveSingleTabRightKey.setAttribute("modifiers", "control,alt");
		moveSingleTabRightKey.setAttribute("keycode", "VK_RIGHT");
		mainKeyset.appendChild(moveSingleTabRightKey);
		moveSingleTabRightKey.setAttribute("oncommand", 'VerticalTabsReloaded.moveSingleTabRight();');

		let moveUpKey = window.document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "key");
		moveUpKey.setAttribute("id", "moveUpKey");
		moveUpKey.setAttribute("modifiers", "accel,alt");
		moveUpKey.setAttribute("keycode", "VK_UP");
		// moveTabLeftKey.setAttribute("key", "w")
		mainKeyset.appendChild(moveUpKey);
		moveUpKey.setAttribute("oncommand", 'VerticalTabsReloaded.moveTabUp();');

		let moveDownKey = window.document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "key");
		moveDownKey.setAttribute("id", "moveDownKey");
		moveDownKey.setAttribute("modifiers", "accel,alt");
		moveDownKey.setAttribute("keycode", "VK_DOWN");
		// moveTabLeftKey.setAttribute("key", "s")
		mainKeyset.appendChild(moveDownKey);
		moveDownKey.setAttribute("oncommand", 'VerticalTabsReloaded.moveTabDown();');

		// Restore width of tab bar from previous session
		//tabs.setAttribute("width", this.preferences("width"));

		// Init every tab
		//tabs.addEventListener("TabOpen", this, false);
		for (let i = 0; i < tabs.childNodes.length; i++) {
			this.initTab(tabs.childNodes[i]);
		}

		// And restore the label here.
		//tabs.firstChild.label = label;
		
		this.lastActiveTab = this.window.gBrowser.selectedTab;
		this.activeTab = this.lastActiveTab;
		
		
		
		this.unloaders.push(() => {
			toolbar.removeChild(filterBox);
			// Move the bottom back to being the next sibling of contentbox.
			browserbox.insertBefore(bottom, contentbox.nextSibling);

			// Move the tabs toolbar back to where it was
			toolbar._toolbox = null; // reset value set by constructor
			toolbar.removeAttribute("toolboxid");
			let toolbox = document.getElementById("navigator-toolbox");
			let navbar = document.getElementById("nav-bar");
			//toolbox.appendChild(toolbar);

			// Restore the tab strip.
			toolbox.insertBefore(toolbar, navbar);

			// Put the tabs back up
			toolbar.insertBefore(tabs, new_tab_button);
			tabs.removeAttribute("data-vertical");
			tabs.orient = "horizontal";
			tabs.mTabstrip.orient = "horizontal";
			tabs.tabbox.orient = "vertical"; // probably not necessary
			tabs.removeAttribute("width");

			// Restore all individual tabs.
			tabs.removeEventListener("TabOpen", this, false);
			for (let i = 0; i < tabs.childNodes.length; i++) {
				let tab = tabs.childNodes[i];
				tab.removeAttribute("align");
				tab.maxWidth = tab.minWidth = "";
			}

			// Remove everything we added.
			splitter.removeEventListener("mouseup", this, false);
			browserbox.removeChild(leftbox);
			browserbox.removeChild(splitter);
			browserbox.dir = "normal";
			leftbox = splitter = null;

			this.removeStylesheet("chrome://verticaltabsreloaded/content/skin/index.css");

		});
	}

	//-------------NEW TAB BUTTON!!!! ----------------------
	openNewTab(e) {
		e.preventDefault();

		let options = {
			// TODO fix allowInheritPrincipal
			// (this is required by javascript: drop to the new window) Bug 1475201
			allowInheritPrincipal: true,
			//allowThirdPartyFixup: true,
			triggeringPrincipal: Services.scriptSecurityManager.getSystemPrincipal(),
			//createLazyBrowser: true,
			skipAnimation: true
		};

		let window = Services.wm.getMostRecentWindow("navigator:browser"); //TODO    this. scope
		let newTab;
		if (e.button == 0) { // BUTTON 0  add new tab at the end on treelevel 1
			console.log("button0 !!!!!!!!!!");

			newTab = window.gBrowser.addTab(NewTabURL.get(),options); //openUILinkIn("about:newtab", "tab", params);
			newTab.newTab = true;
			
			newTab.setAttribute("indentFactor", 0);
			newTab.__indentFactor = 0;
			window.VerticalTabsReloaded.setTabValue(newTab, "indentFactor", "0");
			
			//window.VerticalTabsReloaded.setTabAttribs(newTab, "indentFactor", 0)

		}

		if (e.button == 1) { // BUTTON 1  add new child
			console.log("button1 !!!!!!!!!!");

			let selectedIndentFactor = window.gBrowser.selectedTab.__indentFactor;
			let new_tPos = window.gBrowser.selectedTab._tPos + 1;
			let indentFactor = selectedIndentFactor + 1 || 0;
			if (indentFactor > 10) // max indent factor
				indentFactor = 10;
			if (indentFactor == "NaN")
				indentFactor = 0;

			newTab = window.gBrowser.addTab(NewTabURL.get(),options); //openUILinkIn("about:newtab", "tab", params);
			newTab.newTab = true;
			
			newTab.setAttribute("indentFactor", indentFactor);
			newTab.__indentFactor = indentFactor;
			window.VerticalTabsReloaded.setTabValue(newTab, "indentFactor", indentFactor.toString());
			
			//window.VerticalTabsReloaded.setTabAttribs(newTab, "indentFactor", indentFactor);
			
			
			window.gBrowser.moveTabTo(newTab, new_tPos)
		}

		if (e.button == 2) { //BUTTON 2   add new sibling
			console.log("button2 !!!!!!!!!!");

			let selectedIndentFactor = window.gBrowser.selectedTab.__indentFactor;

			// check  TODO implement variable for the max indent factor
			let indentFactor = selectedIndentFactor || 0;
			if (indentFactor > 10)
				indentFactor = 10;
			if (indentFactor == "NaN")
				indentFactor = 0;

			// setup tab
			newTab = window.gBrowser.addTab(NewTabURL.get(),options); //openUILinkIn("about:newtab", "tab", params);
			newTab.newTab = true;
			
			
			newTab.setAttribute("indentFactor", indentFactor);
			newTab.__indentFactor = indentFactor;
			window.VerticalTabsReloaded.setTabValue(newTab, "indentFactor", indentFactor.toString());

			//window.VerticalTabsReloaded.setTabAttribs(newTab, "indentFactor", indentFactor);
			
			// subtree detection ... works !!!
			let yyy = window.gBrowser.selectedTab.__indentFactor;
			let xxx = window.gBrowser.selectedTab._tPos;
			let tabs = window.gBrowser.tabs;
			let subTreeLength = 1; // number of tabs in subtree, start at 1 instead of 0
			for (let i = xxx; i < tabs.length; i++) {
				if (tabs[xxx + subTreeLength].__indentFactor > yyy) { //travel down the tree , break at subtree end
					subTreeLength++;
				} else {
					break;
				}
			}

			window.gBrowser.moveTabTo(newTab, window.gBrowser.selectedTab._tPos + subTreeLength) // move tab under selectedTab_subTree

			// TODO implement acsending descending swicth ... compare its position to a ...
			//window.gBrowser.moveTabTo(newTab, window.gBrowser.selectedTab._tPos + 1) // move tab under selectedTab
		}

		if (!e.altKey) // should new tab be selected or not ?
			window.gBrowser.selectedTab = newTab; // ??? .click() ??
		e.stopPropagation();
	}

	// --------------- DETECT SUBTREE LENGTH -------------------------
	subTreeLength(aTab) {
		// subtree detection ... works !!!
		let yyy = aTab.__indentFactor;
		let xxx = aTab._tPos;
		let tabs = window.gBrowser.tabs;
		let subTreeLength = 1; // number of tabs in subtree, start at 1 instead of 0
		for (let i = xxx; i < tabs.length; i++) {
			if (tabs[xxx + subTreeLength].__indentFactor > yyy) { //travel down the tree , break at subtree end
				subTreeLength++;
			} else {
				break;
			}
		}
	}

	setTabAttributes(aTab, newIndentFactor) {
		aTab.setAttribute("indentFactor", newIndentFactor);
		aTab.__indentFactor = newIndentFactor;
		SessionStore.setTabValue(aTab, "indentFactor", newIndentFactor.toString());
	}
	//----------------- MOVETABS AROUND WITH BUTTONS-------------------------------

	moveTabLeft() {
		console.log("MOVETABS LEFT");

		let aTab = this.window.gBrowser.selectedTab;

		if (aTab == this.window.gBrowser._visibleTabs[0])
			return console.log("firstVisibleTab LEFT");

		let yyy = aTab.__indentFactor;
		let xxx = aTab._tPos;
		if (yyy == 0)
			return; // no more left left lol

		// selected Tab first , individually
		let newIndentFactor = aTab.__indentFactor - 1;
		aTab.setAttribute("indentFactor", newIndentFactor);
		aTab.__indentFactor = newIndentFactor;
		this.setTabValue(aTab, "indentFactor", newIndentFactor.toString());

		if (aTab == this.window.gBrowser._visibleTabs[this.window.gBrowser._visibleTabs.length - 1])
			return console.log("lastVisibleTab LEFT");

		// following tabs
		aTab = aTab.nextSibling;
		for (let i = 0; i < 1; i = i) { //unlimited loop
			if (aTab.__indentFactor > yyy) {
				if (aTab.__indentFactor > 0) {
					let newIndentFactor = aTab.__indentFactor - 1;
					aTab.setAttribute("indentFactor", newIndentFactor);
					aTab.__indentFactor = newIndentFactor;
					console.log(aTab.__indentFactor);

					this.setTabValue(aTab, "indentFactor", newIndentFactor.toString());
				}
				if (aTab == this.window.gBrowser._visibleTabs[this.window.gBrowser._visibleTabs.length - 1])
					return;
				aTab = aTab.nextSibling;
			} else {
				return;
			}
		}
	}

	moveTabRight() {
		console.log("MOVETABS RIGHT");
		let aTab = this.window.gBrowser.selectedTab;
		if (aTab._tPos == 10)
			return;
		if (aTab.attributes.pinned || aTab.previousSibling.attributes.pinned) {

			return;

		}
		if (aTab == this.window.gBrowser._visibleTabs[0])
			return console.log("firstVisibleTab RIGHT");
		let xxx = aTab.previousSibling.__indentFactor;
		let yyy = aTab.__indentFactor;
		if (yyy - xxx > 0)
			return;
		console.log(yyy - xxx);

		// selected Tab first , individually
		let newIndentFactor = aTab.__indentFactor + 1;
		aTab.__indentFactor =
			aTab.setAttribute("indentFactor", newIndentFactor);
		aTab.__indentFactor = newIndentFactor;
		this.setTabValue(aTab, "indentFactor", newIndentFactor.toString());

		if (aTab == this.window.gBrowser._visibleTabs[this.window.gBrowser._visibleTabs.length - 1])
			return console.log("lastVisibleTab RIGHT");

		// following tabs
		aTab = aTab.nextSibling;
		for (let i = 0; i < 1; i = i) { //unlimited loop
			if (aTab.__indentFactor > yyy) {
				if (aTab.__indentFactor < 10) {

					newIndentFactor = aTab.__indentFactor + 1;
					aTab.setAttribute("indentFactor", newIndentFactor);
					aTab.__indentFactor = newIndentFactor;
					console.log(aTab.__indentFactor);
					this.setTabValue(aTab, "indentFactor", newIndentFactor.toString());
				}
				if (aTab == this.window.gBrowser._visibleTabs[this.window.gBrowser._visibleTabs.length - 1])
					return;
				aTab = aTab.nextSibling;
			} else {
				break;
			}
		}
	}

	moveSingleTabLeft() {
		console.log("MOVE SINGLE TAB LEFT");
		let aTab = this.window.gBrowser.selectedTab;
		if (aTab.__indentFactor == 0)
			return;
		aTab.__indentFactor = aTab.__indentFactor - 1;
	}

	moveSingleTabRight() {
		console.log("MOVE SINGLE TAB RIGHT");
		if (aTab.__indentFactor == 10)
			return;
		let aTab = this.window.gBrowser.selectedTab;
		aTab.__indentFactor = aTab.__indentFactor + 1;
	}

	moveTabUp() {
		this.window.gBrowser.selectedTab.previousSibling.click();
	}

	moveTabDown() {
		this.window.gBrowser.selectedTab.nextSibling.click();
	}
	// ---------SANITIZE TREE --------------------------------------- TODO implement moveTabLeft()

	sanitizeTree(e) {
		console.log("sanitizeTree");
		console.log(e);

		let window = Services.wm.getMostRecentWindow("navigator:browser"); //TODO    this. scope

		window.gBrowser.tabContainer._firstTab.setAttribute("indentFactor", 0);
		window.gBrowser.tabContainer._firstTab.__indentFactor = 0;
		window.VerticalTabsReloaded.setTabValue(window.gBrowser.tabContainer._firstTab, "indentFactor", "0");

		// window.gBrowser._visibleTabs[0].setAttribute("indentFactor", 0);
		// window.gBrowser._visibleTabs[0].__indentFactor = 0;
		// SessionStore.setTabValue(window.gBrowser._visibleTabs[0], "indentFactor", "0");

		for (let i = 0; i < window.gBrowser._visibleTabs.length; i++) {
			let a1 = window.gBrowser._visibleTabs[i].__indentFactor;
			let a2 = window.gBrowser._visibleTabs[i + 1].__indentFactor;
			let delta = a1 - a2;
			console.log(a1 + "     " + a2 + "    " + delta);
			if (delta > 1) {
				this.moveTabLeft2(window.gBrowser._visibleTabs[i + 1], delta)
			}
			if (delta < 0) {}
		}
	}
	moveTabLeft2(parentTab, aTab, delta) {
		console.log("MOVETABS LEFT 2!!!!!!");
		//let aTab = this.window.gBrowser.selectedTab;
		let yyy = parentTab.__indentFactor;
		if (yyy == 0)
			return;

		for (let i = 0; i < 1; i = i) { //unlimited loop
			if (aTab.__indentFactor >= yyy) {

				let newIndentFactor = aTab.__indentFactor + delta;
				aTab.setAttribute("indentFactor", newIndentFactor);
				aTab.__indentFactor = newIndentFactor;
				console.log(aTab.__indentFactor);

				SessionStore.setTabValue(aTab, "indentFactor", newIndentFactor.toString());

				aTab = aTab.nextSibling;
			} else {
				return;
			}
		}
	}
	// filter box functions -------------------------------------------
	filterAddons(e) {
		let win = Services.wm.getMostRecentWindow("navigator:browser");
		let doc = win.document
			let value = new RegExp(e.target.value, "ig");
		console.log(value);

		let list = win.gBrowser._visibleTabs;

		for (let xxx of list) {
			if (doc.getAnonymousElementByAttribute(xxx, 'class', 'tab-text tab-label').getAttribute("text").match(value)) {
				xxx.style.visibility = "initial";
				xxx.style.transform = "translate(0px) !important";
			} else {
				xxx.style.visibility = "collapse";
				xxx.style.transform = "unset";
			}
		}
	}

	initTab(e) {
		console.log("TabOpen");
		let previousIndentFactor = -1;
		try {
			previousIndentFactor = this.activeTab.__SS_extdata.indentFactor;
		} catch (err) {}
		
		if (previousIndentFactor == NaN)  previousIndentFactor = -1;
		console.log(previousIndentFactor);

		let window = this.window;
		let aTab = e.target;
		if (!aTab)
			return;
		aTab.setAttribute("align", "stretch");
		aTab.maxWidth = 65000;
		aTab.minWidth = 0;

		window.setTimeout(function () {
			// check if its a new tab and if true return
			let xxx = false;
			try {
				xxx = e.target.newTab;
			} catch (err) {
				console.log(err);
			}
			if (xxx == true) {

				delete e.target.newTab;
				return;
			}
			// check if its a tab at the end or a tab in the middle

			/* if (aTab._tPos == window.gBrowser.tabContainer._lastTab._tPos) {
			console.log("LAAAAASSSSSSST TAB!!!!!");

			}else{
			// move tab up under selected tab
			let yyy = window.gBrowser.selectedTab.__indentFactor;
			let a = 0;
			let previousSibling = window.gBrowser.selectedTab.previousSibling;
			for (let i = 0; i < 1; i = i) { //unlimited loop
			if (previousSibling.__indentFactor < yyy) {
			a++;
			previousSibling = previousSibling.previousSibling;
			} else {
			break;
			}
			}
			window.gBrowser.moveTabTo(newTab, window.gBrowser.selectedTab._tPos + 1 - a)
			} */

			//------------------------------------
			let indentFactor = 0;
			try {
				indentFactor = aTab.__SS_extdata.indentFactor;
			} catch (error) {
				console.log("error")
			};
			if (indentFactor == NaN)  indentFactor = 0;
			console.log(indentFactor);
			if (indentFactor != false) {
				indentFactor = parseInt(indentFactor);
				console.log(indentFactor);
				aTab.__indentFactor = indentFactor;
				aTab.setAttribute("indentFactor", indentFactor);
				window.VerticalTabsReloaded.setTabValue(aTab, "indentFactor", indentFactor.toString());
			} else {
				//let previousIndentFactor = window.gBrowser.selectedTab.__indentFactor ;
				console.log(previousIndentFactor);
				indentFactor = parseInt(previousIndentFactor) + 1 || 0;
				if (indentFactor > 10)
					indentFactor = 10;
				if (indentFactor == "NaN")
					indentFactor = 0;
				aTab.setAttribute("indentFactor", indentFactor);
				aTab.__indentFactor = indentFactor;
				console.log(aTab.__indentFactor);

				window.VerticalTabsReloaded.setTabValue(aTab, "indentFactor", indentFactor.toString());
			}
			aTab.dontMove = true;
			
			
			
			// restore Thumbnail Image 
			
			let img =  this.document.getAnonymousElementByAttribute(aTab, 'anonid', 'tab-meta-image');
			let TN_URI = aTab.__SS_extdata.ThumbNail_HT;
			console.log(TN_URI);
			img.src = TN_URI;
		}, 200)
	}

	onTabSelect(e) {
		//console.log(e.target.__indentFactor);
		//console.log("TabSelect");
		//console.log(e.target.__indentFactor);
		// this.lastActiveTab = this.window.activeTab || e.target;
		// this.activeTab = e.target;
		
		
		console.log("TabSelect");
		this.lastActiveTab = this.activeTab;
		this.activeTab = e.target;
		let lastBrowser = this.lastActiveTab.linkedBrowser;
		if (lastBrowser.isRemoteBrowser) {
			console.log(lastBrowser);
			lastBrowser.messageManager.sendAsyncMessage("tabCenterUltimate@Ulf3000:message-from-chrome");
		} else {
		console.log(lastBrowser);
		let img = this.document.getAnonymousElementByAttribute(this.lastActiveTab, 'anonid', 'tab-meta-image');
		let CNVS = this.document.createElementNS("http://www.w3.org/1999/xhtml",'canvas');
		CNVS.width = 54;
		CNVS.height = 36
		PageThumbUtils.createSnapshotThumbnail(lastBrowser.contentWindow, CNVS);
		img.src = CNVS.toDataURL();
		SessionStore.setTabValue(this.lastActiveTab, "ThumbNail_HT", img.src);
	}
		
		
		
		
		

	}

	onTabClose(e) {
		console.log("TabClose");
		console.log(e);

		let aTab = e.target;
		let nextTab = this.window.gBrowser.tabs[aTab._tPos + 1] || false;
		let nextNextTab = this.window.gBrowser.tabs[aTab._tPos + 2] || false;

		let aTabIndent = e.target.__indentFactor;
		let nextTabIndent = nextTab.__indentFactor;
		let nextNextTabIndent = nextNextTab.__indentFactor;

		console.log(aTab.__indentFactor);
		console.log(nextTab.__indentFactor);

		// A
		//if (!nextTabIndent) return;
		// next tab is sibling
		if (aTabIndent == nextTabIndent)
			return;

		// B
		//if (!nextNextTabIndent) return;
		// next tab is child , next next tab is sibling of child

		if (aTabIndent < nextTabIndent && nextTabIndent >= nextNextTabIndent) {
			console.log("KKKKKK 1");
			nextTab.setAttribute("indentFactor", aTab.__indentFactor);
			nextTab.__indentFactor = aTab.__indentFactor;
			this.setTabValue(nextTab, "indentFactor", aTab.__indentFactor.toString());
			return;
		}

		// C
		// next tab is child, next next tab is child of child

		if (aTabIndent < nextTabIndent && nextTabIndent < nextNextTabIndent) {
			console.log("KKKKKK 2");
			this.moveTabLeft2(aTab, nextTab, -1)

			return;
		}

	}

	onTabMove(e) {
		//return;

		let aTab = e.target;
		console.log("TabMove");
		console.log(e);
		if (aTab.attributes.pinned) {

			aTab.__indentFactor = 0;
			aTab.setAttribute("indentFactor", 0);
			this.setTabValue(aTab, "indentFactor", "0");

			return;

		}

		if (aTab.newTab) {
			//delete aTab.dontMove;
			return;

		}

		let nextTab = aTab.nextSibling;
		console.log(nextTab);

		let nextIndentFactor = nextTab.__indentFactor;
		let indentFactor = nextIndentFactor; // + 1;
		if (indentFactor > 10)
			indentFactor = 10;
		if (indentFactor == "NaN")
			indentFactor = 0;
		aTab.__indentFactor = indentFactor;
		aTab.setAttribute("indentFactor", indentFactor);
		this.setTabValue(aTab, "indentFactor", indentFactor.toString());
		
		
		
		let TN_URI = e.target.__SS_extdata.ThumbNail_HT;
		if (TN_URI) {
			let img = document.getAnonymousElementByAttribute(e.target, 'anonid', 'tab-meta-image');
			img.src = TN_URI;
		}
	}
	
	// change thumbnail image
	
	updatePageload(e) {
		console.log(e.detail.changed);
		if (e.detail.changed[0] == "busy") {
			console.log("BUSY!!!!!!!!!!!!!!!!!!");
			this.window.setTimeout(function () {
				e.target.linkedBrowser.messageManager.sendAsyncMessage("tabCenterUltimate@Ulf3000:message-from-chrome");
			}, 200);
		}
	}
	
	
	

	onSessionRestored(e) {
		this.window.setTimeout(function () {
			/*
			for (let tab of this.document.getElementsByClassName("tabbrowser-tab")) {

			let indentFactor = "0";
			try {
			indentFactor = tab.__SS_extdata.indentFactor;
			} catch (error) {
			console.log(error)
			};
			indentFactor = parseInt(indentFactor);
			console.log(indentFactor);
			tab.__indentFactor = indentFactor;
			tab.setAttribute("indentFactor", indentFactor);
			if (indentFactor == 0)
			SessionStore.setTabValue(aTab, "indentFactor", indentFactor.toString());
			} */
			//alreadyRestored = true;
		}, 1000)
	}

	/*     onPreferenceChange(prefName, newValue){
	switch (prefName){
	case "right":
	this.webExtPreferences = newValue;
	let browserbox = this.document.getElementById("browser");
	if (this.preferences("right")){
	browserbox.dir = "reverse";
	}
	else{
	browserbox.dir = "normal";
	}
	break;

	case "width":
	this.webExtPreferences = newValue;
	this.document.getElementById("tabbrowser-tabs").setAttribute("width", this.preferences("width"));
	break;

	case "theme":
	this.removeThemeStylesheet();
	this.webExtPreferences = newValue;
	this.applyThemeStylesheet();
	break;

	case "compact":
	this.webExtPreferences = newValue;
	if (this.preferences("compact") == true){
	this.installStylesheet(this.preferences("dataPath") + "compact.css");
	}
	else{
	this.removeStylesheet(this.preferences("dataPath") + "compact.css");
	}
	break;

	case "style.tab.status":
	this.webExtPreferences = newValue;
	if (this.preferences("style.tab.status") == true){
	this.installStylesheet(this.preferences("dataPath") + "status.css");
	}
	else{
	this.removeStylesheet(this.preferences("dataPath") + "status.css");
	}
	break;

	case "tabtoolbarPosition":
	this.webExtPreferences = newValue;
	// Position toggle/move of the tabtoolbar
	let toolbar = this.document.getElementById("TabsToolbar");
	let leftbox = this.document.getElementById("verticaltabs-box");
	if (this.preferences("tabtoolbarPosition") == "top"){
	leftbox.insertBefore(toolbar, leftbox.firstChild);
	}
	else{
	leftbox.appendChild(toolbar);
	}
	break;

	default:
	this.webExtPreferences = newValue;
	break;
	}
	}
	 */
	initEventListeners() {
		// Note: Not all eventsListener are set up here

		this.window.addEventListener("SSWindowRestored", this, false);
		this.window.addEventListener("TabAttrModified", this.updatePageload, false);
		this.window.addEventListener("TabSelect", this, false);
		this.window.addEventListener("TabMove", this, false);
		this.window.addEventListener("TabOpen", this, false);
		this.window.addEventListener("TabClose", this, false);
		
		
		
		
		this.unloaders.push(function () {
			this.window.removeEventListener("SSWindowRestored", this, false);
			this.window.removeEventListener("TabSelect", this, false);
			this.window.removeEventListener("TabMove", this, false);
			this.window.removeEventListener("TabOpen", this, false);
			this.window.removeEventListener("TabClose", this, false);
		});
	}

	// Event handlers
	handleEvent(aEvent) {
		//debugOutput("aEvent.type: "+aEvent.type);
		switch (aEvent.type) {
		case "SSWindowRestored":
			this.onSessionRestored(aEvent);
			return;
		case "TabOpen":
			this.initTab(aEvent);
			return;
		case "TabMove":
			this.onTabMove(aEvent);
			return;
		case "TabClose":
			this.onTabClose(aEvent);
			return;
		case "TabSelect":
			this.onTabSelect(aEvent);
			return;
		case "TabAttrModified":
			this.updatePageload(aEvent);
			return;
		}
	}

	toggleDisplayState() {}

	unload() {
		this.unloaders.forEach(function (func) {
			func.call(this);
		}, this);

		this.unloaders = [];
	}

}
