const Ci = Components.interfaces;
Components.utils.import("resource://gre/modules/Services.jsm");
Components.utils.import("resource:///modules/sessionstore/SessionStore.jsm");
Components.utils.import("resource://gre/modules/osfile.jsm");
//Components.utils.import("chrome://verticaltabsreloaded/content/NewTabURL.jsm");
// Components.utils.import("resource:///modules/OpenInTabsUtils.jsm"); // for quantum new tab button etc.
// Components.utils.import("resource:///modules/UrlbarUtils.jsm");  // for quantum new tab button etc.
sss = Components.classes["@mozilla.org/content/style-sheet-service;1"].getService(Ci.nsIStyleSheetService);
Components.utils.import('resource://gre/modules/PageThumbUtils.jsm');
const { setTimeout } = ChromeUtils.import("resource://gre/modules/Timer.jsm");

var WindowListener = {
	setupBrowserUI: function (window) {

		// Take any steps to add UI or anything to the browser window
		// document.getElementById() etc. will work here
	},

	tearDownBrowserUI: function (window) {
		let document = window.document;

		// Take any steps to remove UI or anything from the browser window
		// document.getElementById() etc. will work here
	},

	// nsIWindowMediatorListener functions
	onOpenWindow: function (xulWindow) {
		console.log(xulWindow);

		// A new window has opened
		let domWindow = xulWindow.QueryInterface(Ci.nsIInterfaceRequestor)
			.getInterface(Ci.nsIDOMWindow);

		// Wait for it to finish loading
		domWindow.addEventListener("load", function listener() {
			domWindow.removeEventListener("load", listener, false);

			// If this is a browser window then setup its UI
			if (domWindow.document.documentElement.getAttribute("windowtype") == "navigator:browser")
				Services.obs.addObserver(function observe_BrowserWindow_startup(win, topic) {
					if (win != domWindow) {
						return;
					}
					console.log("browser-delayed-startup-finished");
					Services.obs.removeObserver(observe_BrowserWindow_startup, topic);
					initialize_window(domWindow);
				}, "browser-delayed-startup-finished");
		}, false);
	},


	onCloseWindow: function (xulWindow) { },

	onWindowTitleChange: function (xulWindow, newTitle) { }
};

async function startup(data, reason) {

	console.log('start timer');
  	await new Promise(resolve => setTimeout(resolve, 2000));
  	console.log('after 1 second');

	

	// ---------- START UP --------------
	let enumerator = Services.wm.getEnumerator("navigator:browser");
	while (enumerator.hasMoreElements()) {
		let win = enumerator.getNext();
		initialize_window(win);
	};
	Services.wm.addListener(WindowListener);

}

function initialize_window(window) {

	
	console.log("Tabcenter Utimate - starting up")

	installStylesheet("chrome://verticaltabsreloaded/content/skin/index.css");

	
	//----------- Move Tabbrowser into location / rearrange UI --------------------

	let tabbrowserArrowscrollbox = window.document.getElementById("tabbrowser-arrowscrollbox");
	tabbrowserArrowscrollbox.setAttribute("orient","vertical");
	tabbrowserArrowscrollbox._smoothScroll = false;
	tabbrowserArrowscrollbox.hasVisibleScrollbars = true;
	console.log(tabbrowserArrowscrollbox);

	let tabs = window.document.getElementById("tabbrowser-tabs");
	tabs.setAttribute("orient","vertical");
	tabs.setAttribute("data-vertical", true);
	tabs.tabbox.orient = "horizontal"; // probably not necessary
	console.log(tabs);

	let browserEl = window.document.getElementById("browser"); // website content container

	
	//------------- Duplicate sidebar and sidebarsplitter

	let ordinals = [4,5] // [2,1]  4 and 5 for right side, 2 and 1 for left side

	let splitter = window.document.getElementById("sidebar-splitter");
	let splitter2 = splitter.cloneNode(false);
	//splitter2.id = "sidebar-splitter2";
	splitter2.style["-moz-box-ordinal-group"] = ordinals[0]; //oridnal group defines the 
	splitter.parentElement.appendChild(splitter2);

	let sidebar = window.document.getElementById("sidebar-box");
	let sidebar2 = sidebar.cloneNode(false);
	//sidebar2.id = "sidebar-box2";
	sidebar2.style["-moz-box-ordinal-group"] = ordinals[1];
	sidebar.parentElement.appendChild(sidebar2);


	sidebar2.append(tabs.parentElement)


	// Move the tabs toolbar into the tab strip
	let toolbar = window.document.getElementById("TabsToolbar");
	toolbar.setAttribute("collapsed", "false"); // no more vanishing new tab toolbar
	toolbar._toolbox = null; // reset value set by constructor
	toolbar.setAttribute("toolboxid", "navigator-toolbox");

	sidebar2.append(toolbar);








}

//startup();

function installStylesheet(uri) {
	console.error("install STYLLLLLLLLLLLESSHHHEEEET")
	var uriN = Services.io.newURI(uri, null, null);
	sss.loadAndRegisterSheet(uriN, sss.USER_SHEET);
	// this.debugOutput(uri);
}

function removeStylesheet(uri) {
	let uriN = Services.io.newURI(uri, null, null);
	sss.unregisterSheet(uriN, sss.USER_SHEET);
	// this.debugOutput(uri);
}