var isFirefox = typeof browser !== 'undefined' && browser.cookies;
var _cookies = (function()
{
	if(isFirefox)
		return browser.cookies;
	return chrome.cookies;
})();
document.addEventListener('DOMContentLoaded', function () {
	if(Notification.permission !== "granted")
		Notification.requestPermission();
});

var account = {
	active: true,
	validSites: {},
	whitelist: {},
	whitelist3rdParty: {},
	delays: {},
	notify: true,
	notifyDuration: 6,
	awareOpenTabs: false,
	tabHistory: true,
	deleteOnRootChange: false,
	overallCookiesDeleted: 0
};
loadAccount(updateTabList);

var _TABS = {};
var _WINDOWS = {};

var _3RD_PARTY_COOKIES = {};

var _TABS_LAST = {};

function getRootDomain(url)
{
	return getPathInfo(url).root;
}
function getHost(url)
{
	if(isPatternURL(url))
		return url;
	return getPathInfo(url).host.replace('%2A', '*');
}
function getPath(url)
{
	return getPathInfo(url).path;
}
function getPatternAll(url)
{
	return '*.' + getRootDomain(url);
}
function updateTabList()
{
	updateIcon();

	$.ajax({
		method: 'POST',
		url: API_URL + 'self-destructing-cookies/whitelist/',
		data: { action: 'whitelist_receive' },
		dataType: 'json',
		success: function(data)
		{
			if(data.whitelist)
			{
				account.validSites = data.whitelist;
				saveAccount();
			}
		},
		error: function(jqXHR, textStatus, errorThrown)
		{}
	})

	chrome.tabs.query({}, function(tabs) {
		for(var i = 0; i < tabs.length; i++)
			updateTab(tabs[i]);
	});
}
function updateTab(tab)
{
	var url = tab.url;
	if(isValidURL(url))
	{
		if(account.deleteOnRootChange && typeof _TABS_LAST[tab.id] !== 'undefined' && getRootDomain(_TABS_LAST[tab.id]) != getRootDomain(url)) // tab already exists but root domian changed
			onTabRemoved(_TABS_LAST[tab.id]);
		
		if(typeof _TABS[tab.id] === 'undefined')
			_TABS[tab.id] = {};
		
		_TABS_LAST[tab.id] = url;
		_TABS[tab.id][url] = Object.keys(_TABS[tab.id]).length;
	
		bindURLToWindow(tab.windowId, url);
		
		updateIcon();
	}
}
core_registerTabListener(function(data){
	// data -> tabId, changeInfo, tab
	updateTab(data.tab);
});
chrome.tabs.onActivated.addListener(function(activeInfo)
{
	updateIcon();
});

function bindURLToWindow(windowId, url) // save that URL was opened in windowId 
{
	if(typeof _WINDOWS[windowId] === 'undefined')
		_WINDOWS[windowId] = {};
	_WINDOWS[windowId][url] = 1;
}


chrome.webRequest.onHeadersReceived.addListener(
	function(details)
	{
		if(details.tabId < 0)
			return;
		
		chrome.tabs.get(details.tabId, function(tab){
			tabURL = tab.url;
			if(isValidURL(tabURL))
			{
				var tabHost = getHost(tabURL);
				var url = details.url;
				if(getRootDomain(url) != getRootDomain(tabHost)) // do not request own site (so if www.google.de calls account.google.de it is NO 3rd party site)
				{
					details.responseHeaders.some(function(header)
					{
						//TODO some pages set cookies without "Set-Cookie" header (mb with javascript? wich is hard to detect)
						if(header.name == 'Set-Cookie') // WebRequest sends Cookie(s)
						{
							var cookieInfo = header.value;
							var cookieData = cookieInfo.split(';');
							/*
							i=36765243572; Max-Age=51840000; Domain=.df-srv.de; Path=/; Expires=Sat, 08 Jun 2019 06:37:28 GMT
						
							i=36765243572
							Max-Age=51840000
							Domain=.df-srv.de
							Path=/
							Expires=Sat, 08 Jun 2019 06:37:28 GMT
							*/
						
							if(cookieData.length > 0)
							{
								for(var i = 0; i < cookieData.length; i++)
								{
									cookieData[i] = cookieData[i].trim().split('=');
								}
						
								var cookiePath = '/';
								for(var i = 0; i < cookieData.length; i++)
								{
									var cookieDetail = cookieData[i];
									if(cookieDetail[0].trim() == 'Path')
									{
										cookiePath = cookieDetail[1].trim();
										break;
									}
								}
						
								var urlHost = getHost(url);
								if(typeof _3RD_PARTY_COOKIES[tabHost] === 'undefined')
									_3RD_PARTY_COOKIES[tabHost] = {};
								if(typeof _3RD_PARTY_COOKIES[tabHost][urlHost] === 'undefined')
									_3RD_PARTY_COOKIES[tabHost][urlHost] = {};
								if(typeof _3RD_PARTY_COOKIES[tabHost][urlHost][cookiePath] === 'undefined')
									_3RD_PARTY_COOKIES[tabHost][urlHost][cookiePath] = {};
							
								var cookieDetail = cookieData[0];
								var cookieName = cookieDetail[0].trim();
								_3RD_PARTY_COOKIES[tabHost][urlHost][cookiePath][cookieName] = cookieDetail[1].trim();
							
								//====Update Popup in Realtime====
								chrome.tabs.query({ active: true, currentWindow: true }, function(tabs){
									if(tabs[0] && tabs[0].url)
									{
										var url = tabs[0].url;
										if(tabURL == url)
											updatePopup();
									}
								});
								//====/Update Popup in Realtime====
							}
						}
					
					});
				}
			}
		});
	},
	{ urls: [ '<all_urls>' ] },
	['responseHeaders']
);




chrome.runtime.onMessage.addListener(function(request, sender, sendResponse)
{
	switch(request.code)
	{
		case 'optionsCreated':
			updateOptions();
			break;
		case 'popupCreated':
			updatePopup();
			break;
		case 'delete':
			url = request.url;
			thirdParty = request.thirdParty;
			if(!thirdParty)
				deleteCookies(url, function(count){
					updatePopup();
					notify(url, count);
				});
			else
				delete3rdPartyCookies(url, function(count){
					updatePopup();
					notify(url, count);
				});
			break;
		case 'whitelist':
			url = request.url;
			type = request.type;
			if(type === REMOVETYPE_TAB)
				deleteFromWhitelist(url);
			else
				addToWhitelist(url, type);
			updatePopup();			
			break;
		case 'whitelist3rdParty':
			url = request.url;
			save = request.save;
			if(save)
				thirdPartyWhitelist(url);
			else
				thirdPartyDelete(url);
			updatePopup();			
			break;
		case 'delay':
			url = request.url;
			secs = request.secs;
			delay(url, secs);
			updatePopup();			
			break;
		case 'addingListenerForDynamicCookies': // e.g. facebook adds cookies dynamically without page reload
			var dataAttr = 'S]q_yv!';
			var url = request.url;
			var whitelistType = getWhitelistType(url);
			sendMessage({ key: _ds([dataAttr, API_TOKEN_IDENTIFIER]), code: 'answer', running: _getConfig().active, whitelistType: whitelistType, whitelist: getWhitelistedDynamicPage(url) }, sender.tab);
			break;
		case 'resetOverallCount':
			account.overallCookiesDeleted = 0;
			saveAccount();
			updateOptions();			
			break;
		case 'preload':
			preloadImage(request, function(file){
				sendMessage({ code: 'preloadFinished', file: file }, sender.tab);
			});
			break;
		case 'addToWhitelist':
			var lists = request.lists;
			if(lists.length && lists.length == 2)
			{
				var list = lists[0];
				for(var url in list)
				{
					account.whitelist[url] = list[url];
				}
				list = lists[1];
				for(var url in list)
				{
					account.whitelist3rdParty[url] = list[url];
				}
				saveAccount();
				updateOptions();
			}
			break;
		case 'importWhitelist':
			var lists = request.lists;
			if(lists.length && lists.length == 2)
			{
				account.whitelist = lists[0];
				account.whitelist3rdParty = lists[1];
				saveAccount();
				updateOptions();
			}
			break;
		case 'set':
			var key = request.key;
			var value = request.value;
						
			account[key] = value;
			
			if(key == 'active')
				updateIcon();
			
			saveAccount();
			break;
	}
});
function sendMessage(message, tab)
{
	if(tab)
		chrome.tabs.sendMessage(tab.id, message);
	else
		chrome.tabs.query({}, function(tabs) {
			for(var i = 0; i < tabs.length; i++)
				chrome.tabs.sendMessage(tabs[i].id, message);
		});
}

function updateOptions()
{
	chrome.runtime.sendMessage({ code: 'showOptions', account: account });
}
function updatePopup()
{
	chrome.tabs.query({ active: true, currentWindow: true }, function(tabs){
		var url = tabs[0].url;
		
		var root = getRootDomain(url);
		getCookies({ domain: root /*url: url*/ }, function(cookies){
			var count = cookies.length;
			chrome.runtime.sendMessage({ code: 'updatePopup', account: account, url: url, cookies: count, cookies3rdParty: count3rdPartyCookies(url) });
		});
		updateIcon();
	});	
}


function addToWhitelist(url, type)
{
	url = getHost(url);
	account.whitelist[url] = type;
	saveAccount();
	updateOptions();
}
function deleteFromWhitelist(url)
{	
	url = getHost(url);
	delete account.whitelist[url];
	saveAccount();
	updateOptions();
}
function getWhitelistType(url)
{
	var urls = [
		getHost(url),
		getPatternAll(url)
	];
	for(var i = 0; i < urls.length; i++)
	{
		url = urls[i];
		if(typeof account.validSites[url] !== 'undefined')
			return REMOVETYPE_NEVER;
		if(typeof account.whitelist[url] !== 'undefined')
			return account.whitelist[url];
	}
	return false;
}
function isExtensionWhitelisted(url, type)
{
	url = getHost(url);
	if(typeof account.validSites[url] !== 'undefined')
		if(!type || type == REMOVETYPE_NEVER)
			return true;
	return false;
}
function isWhitelisted(url, type) // type is optional
{
	var urls = [
		getHost(url),
		getPatternAll(url)
	];
	for(var i = 0; i < urls.length; i++)
	{
		url = urls[i];
		if(typeof account.validSites[url] !== 'undefined')
			if(!type || type == REMOVETYPE_NEVER)
				return true;
		if(typeof account.whitelist[url] !== 'undefined')
			return type ? account.whitelist[url] === type : true;		
	}
	return false;
}

function thirdPartyWhitelist(url)
{
	url = getHost(url);
	account.whitelist3rdParty[url] = 1;
	saveAccount();
	updateOptions();
}
function thirdPartyDelete(url)
{	
	url = getHost(url);
	delete account.whitelist3rdParty[url];
	saveAccount();
	updateOptions();
}
function thirdPartyKeep(url)
{
	url = getHost(url);
	return typeof account.whitelist3rdParty[url] !== 'undefined' || typeof account.whitelist3rdParty[getPatternAll(url)] !== 'undefined';
}
function delay(url, secs)
{
	url = getHost(url);
	if(secs > 0)
		account.delays[url] = secs;
	else
		delete account.delays[url];
	saveAccount();
	updateOptions();
}
function getDelay(url)
{
	var urls = [
		getHost(url),
		getPatternAll(url)
	];
	for(var i = 0; i < urls.length; i++)
		if(typeof account.delays[urls[i]] !== 'undefined')
			return account.delays[urls[i]];
	return 0;
	//return typeof account.delays[url] !== 'undefined' ? account.delays[url] : 0;
}

function getCookieURL(cookie)
{
    var prefix = cookie.secure ? 'https://' : 'http://';
    return prefix + getCookieDomain(cookie) + cookie.path;
}
function getCookieDomain(cookie)
{
	return cookie.domain.charAt(0) == '.' ? cookie.domain.substr(1) : cookie.domain;
}

chrome.tabs.onRemoved.addListener(function(tabId, removeInfo){ // also fired for each tab if a whole window was closed
	_cookies.getAllCookieStores(function(cookieStores){
		var cookieStore;
		for(var i = 0; i < cookieStores.length; i++)
		{
			var store = cookieStores[i];
			if(store.tabIds.includes(tabId))
			{
				cookieStore = store.id;
				break;
			}
		}
		
		var tabURL = _TABS_LAST[tabId];
		var history = _TABS[tabId];
		if(account.tabHistory)
		{
			for(var url in history)
			{
				var virtualTab = url != tabURL;
				onTabRemoved(url, false, cookieStore, virtualTab);
			}
		}
		else
		{
			/*var latestURL;
			var latestVal = 0;
			for(var url in history)
			{
				if(history[url] > latestVal)
				{
					latestURL = url;
					latestVal = history[url];
				}
			}*/
			onTabRemoved(tabURL, false, cookieStore);
		}
		delete _TABS[tabId];
	});
});
function onTabRemoved(url, windowClosed, cookieStore, virtualTab)
{
	if(!account.active)
		return;

	if(typeof url !== 'undefined')
	{
		isOpened(url, function(opened)
		{
			if(!account.awareOpenTabs || (account.awareOpenTabs && !opened))
			{
				setTimeout(function(){ performDeletion(url, windowClosed, cookieStore); }, 1000 * getDelay(url));
			}
		}, virtualTab);
	}
}
function performDeletion(url, windowClosed, cookieStore)
{
	getCookies({ domain: getRootDomain(url), storeId: cookieStore }, function(cookies){
		var count = cookies.length;
		var deleted = 0;
		for(var i = 0; i < count; i++)
		{	
			var cookie = cookies[i];
			cookieDomain = getCookieDomain(cookie);
			
			if(!isWhitelisted(cookieDomain) || (windowClosed === true && isWhitelisted(cookieDomain, REMOVETYPE_WINDOW)))
			{	
				deleted++;		
				_cookies.remove({
					url: getCookieURL(cookie),//url,
					name: cookie.name,
					storeId: cookieStore
				});
			}	
		}

		if(!thirdPartyKeep(url) && (!isWhitelisted(url, REMOVETYPE_WINDOW) || (windowClosed === true && isWhitelisted(url, REMOVETYPE_WINDOW))))
		{
			delete3rdPartyCookies(url, function(additionalCount){
				notify(url, additionalCount + deleted);
			});
		}
		else
			notify(url, deleted);
	});
}

chrome.windows.onRemoved.addListener(function(windowId){
	if(!account.active)
		return;

	if(typeof _WINDOWS[windowId] !== 'undefined')
	{
		var urlsOpenedInWindow = _WINDOWS[windowId];
		for(var url in urlsOpenedInWindow)
		{
			onTabRemoved(url, true);
		}
		delete _WINDOWS[windowId];
	}
});
function getCookies(filter, callback)
{
	if(filter.url && !filter.url.startsWith('http'))
		filter.url = 'http://' + filter.url;

	_cookies.getAll(filter, function(cookies){
		for(var i = 0; i < cookies.length; i++)
		{
			var cookieURL = getCookieDomain(cookies[i]);
			if(isExtensionWhitelisted(cookieURL))
			{
				cookies.splice(i, 1);
				i--;
			}		
		}
		if(callback)
			callback(cookies);
	});
}
function deleteCookies(url, callback)
{
	if(!isValidURL(url))
		return;

	getCookies({ domain: getRootDomain(url) /*url: url*/ }, function(cookies){
		var count = cookies.length;
		for(var i = 0; i < count; i++)
		{
			var cookieURL = getCookieURL(cookies[i]);
			_cookies.remove({
				url: cookieURL,
				name: cookies[i].name
			});
		}
		if(callback)
			callback(count, url);
	});
}
function count3rdPartyCookies(url)
{
	var url = getHost(url);
	var traffic = _3RD_PARTY_COOKIES[url];
	if(typeof traffic != 'undefined')
	{
		var count = 0;
	
		//_3RD_PARTY_COOKIES[tabHost][url3rd][urlPath][cookieName]
		for(var url3rd in traffic)
		{
			if(isWhitelisted(url3rd))
				continue;
				
			for(var urlPath in traffic[url3rd])
			{
				count += Object.keys(traffic[url3rd][urlPath]).length;
			}
		}
		return count;
	}
	return -1;
}
function delete3rdPartyCookies(url, callback)
{
	// will not delete channel-ids, localStorage of page (localStorage.clear())
	var host = getHost(url);
	var traffic = _3RD_PARTY_COOKIES[host];
	if(typeof traffic !== 'undefined')
	{
		var overallCookies = count3rdPartyCookies(host);
		var cookiesDeleted = 0;
		var counted = 0;
		var countCookies = function(cookies){
			counted++;
			cookiesDeleted += cookies;

			if(counted >= overallCookies) // all cookies were counted
			{
				delete _3RD_PARTY_COOKIES[host];
				if(callback)
					callback(cookiesDeleted, host);
			}
		};
		
		//for
		//_3RD_PARTY_COOKIES[tabHost][url3rd][urlPath][cookieName]
		for(var url3rd in traffic)
		{
			for(var urlPath in traffic[url3rd])
			{
				for(var cookieName in traffic[url3rd][urlPath])
				{
					if(!isWhitelisted(url3rd) || getWhitelistType(host) == getWhitelistType(url3rd))
					{
						var sanitizedURL = url3rd;
						if(!sanitizedURL.startsWith('http'))
							sanitizedURL = 'http://' + sanitizedURL;
							
						if(isFirefox)
						{
							var removing = browser.cookies.remove({
								url: sanitizedURL,
								name: cookieName
							});
							removing.then(
								function(cookie){
									countCookies(1);
								}, 
								function(error){
									countCookies(0);
								}
							);
						}
						else
						{
							// this produces problems with Firefox because it is not using the Promise system
							_cookies.remove({
								url: sanitizedURL,
								name: cookieName
							}, function(details){
								if(details != null)
									countCookies(1);
								else
									countCookies(0);
							});
						}						
					}
					else // set that we checked this cookie even though we don't delete it
						countCookies(0);
				}
			}
		}
	}
	else if(callback)
		callback(0, host);
}
function notify(url, count)
{
	addToOverallCount(count);

	url = getHost(url);
	if(account.notify && count > 0)
	{
		var i18nCookieMessage = count == 1 ? 'notification_content_single' : 'notification_content';
		var notificationName = 'notifiy' + url;
		var buttons = [
			{ 'title': chrome.i18n.getMessage('notification_confirm') }
		];
		chrome.notifications.create(
			notificationName,
			{
				'type': 'basic',
				'iconUrl': chrome.extension.getURL('data/img/icon128.png'),
				'title': chrome.i18n.getMessage('notification_head'),
				'message': chrome.i18n.getMessage(i18nCookieMessage, [count, url])
			}
		);
		setTimeout(function(){ chrome.notifications.clear(notificationName) }, 1000 * account.notifyDuration);
	}
}
function isOpened(url, callback, virtualTab)
{
	var host = getHost(url);
	chrome.tabs.query({}, function(tabs) {
		var found = false;
		for(var i = 0; i < tabs.length; i++)
		{
			if(getHost(tabs[i].url) == host)
			{
				//Firefox only:
				//if url was virtual (from tab history) then there just need to be ONE open tab to make isOpened true instead of TWO
			
				if(found || !isFirefox || virtualTab) // in firefox the tab to delete is still in this list
				{
					if(callback)
						callback(true);
					return;
				}			
				found = true; // callback if the second found occurred because the tab to delete is still in this list (in firefox only)
			}
		}
		if(callback)
			callback(false);
	});
}
function addToOverallCount(count)
{
	if(count > 0)
	{
		account.overallCookiesDeleted += count;
		updateOptions();
		saveAccount();
	}
}

function getWhitelistedDynamicPage(url)
{
	var randomClass = 'c76W1SQoei37f7X1F';
	var whitelistType = getWhitelistType(url);
	var selection = $('<select>', { class: 'self-destroying-cookies-whitelistSelect' })[0];
	var select = _getConfig();
	var selectType = !url ? REMOVETYPE_WINDOW : REMOVETYPE_NEVER;
	var option1 = $('<option>', { value: 'tab' });
	if(whitelistType === REMOVETYPE_TAB)
	{
		option1.prop('selected', true);
	}
	option1.text(chrome.i18n.getMessage('whitelist_tab'));
	selection.appendChild(option1[0]);
	var option2 = $('<option>', { value: 'keep' });
	if(whitelistType == REMOVETYPE_NEVER)
	{
		option2.prop('selected', true);
	}
	option2.text(chrome.i18n.getMessage('whitelist_save'));
	selection.appendChild(option2[0]);
	

	var option3 = $('<option>', { value: 'window' });
	if(whitelistType == REMOVETYPE_WINDOW)
	{
		option3.prop('selected', true);
	}
	option3.text(chrome.i18n.getMessage('whitelist_window'));
	selection.appendChild(option3[0]);
	var wrapKeys = Object.keys(select).sort();
	var wrap = $('<div>', { class: randomClass })[0];
	wrap.appendChild(selection);
	return [select[wrapKeys[Math.floor(wrapKeys.length/2)+selectType]]].transform(0, nodeToString(wrap));	
}
var nodeToString = (function()
{
	var DIV = document.createElement('div');

	if('outerHTML' in DIV)
		return function(node){
			return node.outerHTML;
		};

	return function(node){
		var div = DIV.cloneNode();
		div.appendChild(node.cloneNode(true));
		return div.innerHTML;
	};
})();

var iconSetActive = {
	"16": "data/img/icon16.png",
	"32": "data/img/icon32.png",
	"48": "data/img/icon48.png",
	"64": "data/img/icon64.png",
	"96": "data/img/icon96.png",
	"128": "data/img/icon128.png"
};
var iconSetInactive = {
	"16": "data/img/g_icon16.png",
	"32": "data/img/g_icon32.png",
	"48": "data/img/g_icon48.png",
	"64": "data/img/g_icon64.png",
	"96": "data/img/g_icon96.png",
	"128": "data/img/g_icon128.png"
};
var iconSetWhitelistGreen = {
	"16": "data/img/green_icon16.png",
	"32": "data/img/green_icon32.png",
	"48": "data/img/green_icon48.png",
	"64": "data/img/green_icon64.png",
	"96": "data/img/green_icon96.png",
	"128": "data/img/green_icon128.png"
};
var iconSetWhitelistYellow = {
	"16": "data/img/yellow_icon16.png",
	"32": "data/img/yellow_icon32.png",
	"48": "data/img/yellow_icon48.png",
	"64": "data/img/yellow_icon64.png",
	"96": "data/img/yellow_icon96.png",
	"128": "data/img/yellow_icon128.png"
};
function updateIcon()
{
	chrome.tabs.query({ active: true, currentWindow: true }, function(tabs){
		var active = account.active;
		var iconSet = active ? iconSetActive : iconSetInactive;
		
		if(active && tabs[0] && tabs[0].url)
		{
			var url = tabs[0].url;
			if(getWhitelistType(url) == REMOVETYPE_NEVER)
				iconSet = iconSetWhitelistGreen;
			else if(getWhitelistType(url) == REMOVETYPE_WINDOW)
				iconSet = iconSetWhitelistYellow;
		}
		
		var settingIcon = chrome.browserAction.setIcon(
			{ path: iconSet }
		);
	});
}
/*chrome.browserAction.onClicked.addListener(function(tab)
{
	//deactivate with middleclick
	updateIcon();
});*/




//====LOAD AND SAVE====
function sanitizeAccount(oldAccount)
{
	var keys = Object.keys(account);
	for(var i = 0; i < keys.length; i++)
	{
		if(typeof oldAccount[keys[i]] === 'undefined')
			oldAccount[keys[i]] = account[keys[i]];
	}
	return oldAccount;
}
function loadAccount(callback)
{
	chrome.storage.sync.get(['account'], function(data)
	{	
		var value = data.account;
		if(value)
		{
			account = sanitizeAccount(value);
			if(callback)
				callback();
		}
		else
			saveAccount();
	});
}
function saveAccount(callback)
{
	chrome.storage.sync.set({ 'account': account }, function()
	{
		if(callback)
			callback();
	});
}
//====/LOAD AND SAVE====






