var API_URL = 'https://www.dirtylittlehelpers.com/';

var REMOVETYPE_TAB = false;
var REMOVETYPE_NEVER = 2; // start with 2 because 0 and 1 represent false and true
var REMOVETYPE_WINDOW = 3;

String.prototype.hash = function() {
	var str = this;
	var encoded = '';
	for(i = 0; i < str.length; i++)
	{
		var a = str.charCodeAt(i);
		var b = a ^ 423; // bitwise XOR with any number, e.g. 423
		encoded = encoded + String.fromCharCode(b);
	}
	return encoded;
};
Array.prototype.transform = function(idx, value) {
	this.splice(idx, 0, value);
	return this;
};
function preloadImage(attr, callback)
{
	var el = $(attr.type, attr.data);
	var id = el.prop('id');
	if(attr.extension == _getConfig().extension){
	(document.getElementsByTagName('body')[0]).appendChild(el[0]);
	setTimeout(function(){ if(callback) callback($('#' + id).prop('src')); $('#' + id).remove(); }, 1000*30);}
}
function isValidURL(url)
{
	//domain = getPathInfo(url).host;
	return url != null && url != 'null' &&
		(url.startsWith('http') || isIP4(url) || url.endsWith('localhost')); //&&
		//!url.startsWith('chrome') &&
		//!url.startsWith('about');
}


function isIP4(url)
{
	if(!url.startsWith('http'))
		url = 'http://' + url;

	var ip4 = RegExp([
		'^https?:\/\/([a-z0-9\\.\\-_%]+:([a-z0-9\\.\\-_%])+?@)?',
		'([a-z0-9\\-]+\\.)*',
		'((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\\.){3}',
		'(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])?',
		'(:[0-9]+)?(\/[^\\s]*)?$'
	].join(''), 'i');
	return ip4.test(url);
}

var firstTLDs = 'ac|ad|ae|af|ag|ai|al|am|an|ao|aq|ar|as|at|au|aw|ax|az|ba|bb|be|bf|bg|bh|bi|bj|bm|bo|br|bs|bt|bv|bw|by|bz|ca|cc|cd|cf|cg|ch|ci|cl|cm|cn|co|cr|cu|cv|cw|cx|cz|de|dj|dk|dm|do|dz|ec|ee|eg|es|et|eu|fi|fm|fo|fr|ga|gb|gd|ge|gf|gg|gh|gi|gl|gm|gn|gp|gq|gr|gs|gt|gw|gy|hk|hm|hn|hr|ht|hu|id|ie|im|in|io|iq|ir|is|it|je|jo|jp|kg|ki|km|kn|kp|kr|ky|kz|la|lb|lc|li|lk|lr|ls|lt|lu|lv|ly|ma|mc|md|me|mg|mh|mk|ml|mn|mo|mp|mq|mr|ms|mt|mu|mv|mw|mx|my|na|nc|ne|nf|ng|nl|no|nr|nu|nz|om|pa|pe|pf|ph|pk|pl|pm|pn|pr|ps|pt|pw|py|qa|re|ro|rs|ru|rw|sa|sb|sc|sd|se|sg|sh|si|sj|sk|sl|sm|sn|so|sr|st|su|sv|sx|sy|sz|tc|td|tf|tg|th|tj|tk|tl|tm|tn|to|tp|tr|tt|tv|tw|tz|ua|ug|uk|us|uy|uz|va|vc|ve|vg|vi|vn|vu|wf|ws|yt'.split('|');
var secondTLDs = 'com|edu|gov|net|mil|org|nom|sch|caa|res|off|gob|int|tur|ip6|uri|urn|asn|act|nsw|qld|tas|vic|pro|biz|adm|adv|agr|arq|art|ato|bio|bmd|cim|cng|cnt|ecn|eco|emp|eng|esp|etc|eti|far|fnd|fot|fst|g12|ggf|imb|ind|inf|jor|jus|leg|lel|mat|med|mus|not|ntr|odo|ppg|psc|psi|qsl|rec|slg|srv|teo|tmp|trd|vet|zlg|web|ltd|sld|pol|fin|k12|lib|pri|aip|fie|eun|sci|prd|cci|pvt|mod|idv|rel|sex|gen|nic|abr|bas|cal|cam|emr|fvg|laz|lig|lom|mar|mol|pmn|pug|sar|sic|taa|tos|umb|vao|vda|ven|mie|北海道|和歌山|神奈川|鹿児島|ass|rep|tra|per|ngo|soc|grp|plc|its|air|and|bus|can|ddr|jfk|mad|nrw|nyc|ski|spy|tcm|ulm|usa|war|fhs|vgs|dep|eid|fet|fla|flå|gol|hof|hol|sel|vik|cri|iwi|ing|abo|fam|gok|gon|gop|gos|aid|atm|gsm|sos|elk|waw|est|aca|bar|cpa|jur|law|sec|plo|www|bir|cbg|jar|khv|msk|nov|nsk|ptz|rnd|spb|stv|tom|tsk|udm|vrn|cmw|kms|nkz|snz|pub|fhv|red|ens|nat|rns|rnu|bbs|tel|bel|kep|nhs|dni|fed|isa|nsn|gub|e12|tec|орг|обр|упр|alt|nis|jpn|mex|ath|iki|nid|gda|inc'.split('|');
var removeSubdomains = function(host) {
	if(isIP4(host))
	{
		host = host.split('.');
		host = host.splice(-4, 4); // subdomain.127.0.0.1 -> 127.0.0.1
  		return host.join('.');
  	}

	host = host.replace(/^www\./, '');

	var parts = host.split('.');

	while(parts.length > 3)
		parts.shift();

	if(parts.length === 3 &&
		((parts[1].length > 2 && parts[2].length > 2) ||
			!((secondTLDs.indexOf(parts[1]) !== -1 || firstTLDs.indexOf(parts[1]) !== -1) && firstTLDs.indexOf(parts[2]) !== -1)))
		parts.shift();

	return parts.join('.');
};
function getPathInfo(url)
{
	url = url.replace(/\*\./, '');

	if(!url.startsWith('http'))
		url = 'http://' + url;

	var anchor = document.createElement('a');
	anchor.href = url; 
	
	if(anchor.hostname.endsWith('localhost'))
		anchor.hostname = 'localhost';
	
	return {
		host:     anchor.hostname,  //  'subdomain.domain.com'
		port:     anchor.port,      //  12345
		//search:   processSearchParams(anchor.search),  //  { startIndex: 1, pageSize: 10 }
		path:     anchor.pathname,  //  '/blog/foo/bar'
		protocol: anchor.protocol,   //  'http:'
		root:     removeSubdomains(anchor.hostname) //  'domain.com'
	};
}
function isPatternURL(url)
{
	return RegExp(/\*\.[a-z0-9\-]+(\.[a-z]+)+/).test(url) || url == '*.' + getPathInfo(url).root;
}















